<?php

/**
 * Description of Bank_branch_model
 *
 * @author MD Jaherul Islam
 */
class Bank_branch_model extends CI_Model {

    const tbl_name = 'tbl_bank_branch';
    const primary_key = 'bank_branch_id';

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Description         : set bank information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 11:13 AM      
     * */
    private $data = [];

    public function __set($name, $value) {
        $this->data[$name] = $value;
        return $this;
    }

    /**
     * @Description         : set bank ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 12:13 PM      
     * */
    private $bank_branch_id;

    function set_bank_branch_id($bank_branch_id) {
        $this->bank_branch_id = $bank_branch_id;
        return $this;
    }

    /**
     * @Description         : set bank ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 12:13 PM      
     * */
    private $bank_id_value;

    function set_bank_id($bank_id) {
        $this->bank_id_value = $bank_id;
        return $this;
    }

    /**
     * @Description         : set field name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-12-2016 10:24 AM      
     * */
    private $field_name;

    function set_field_name($field_name) {
        $this->field_name = $field_name;
        return $this;
    }

    /**
     * @Description         : set bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-12-2016 03:01 PM      
     * */
    private $branch_name;

    function set_branch_name($bank_name) {
        $this->branch_name = $bank_name;
        return $this;
    }

    /**
     * @Description         : set bank branch status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 03:13 PM      
     * */
    private $bank_branch_status;

    function set_bank_branch_status($bank_branch_status) {
        $this->bank_branch_status = $bank_branch_status;
        return $this;
    }

    /**
     * @Description         : set account number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-12-2016 12:13 PM      
     * */
    private $account_number;

    function set_account_number($account_number) {
        $this->account_number = $account_number;
        return $this;
    }

    /**
     * @Description         : set limit
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 04:42 PM      
     * */
    private $limit;

    function set_limit($limit) {
        $this->limit = $limit;
        return $this;
    }

    /**
     * @Description         : select all bank branch information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-12-2016 03:06 PM      
     * */
    function select_all_bank_branch_info() {
        $this->db->select('*')->from(self::tbl_name);
        if (!empty($this->bank_id_value)) {
            $this->db->where('bank_id', $this->bank_id_value);
        }
        $this->result = $this->db->limit(10, $this->limit)->get()->result();
        return $this;
    }

    /**
     * @Description         : total bank branch
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-12-2016 04:45 PM      
     * */
    function total_bank_branch() {
        $this->db->select('*')->from(self::tbl_name);
        if (!empty($this->bank_id_value)) {
            $this->db->where('bank_id', $this->bank_id_value);
        }
        $this->result = $this->db->count_all_results();
        return $this;
    }

    /**
     * @Description         : check bank branch name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-12-2016 02:56 PM      
     * */
    function check_bank_branch_name() {
        $this->result = $this->db->select('*')->from(self::tbl_name)
                        ->where(['bank_id' => $this->bank_id_value, 'bank_branch_name' => $this->branch_name])
                        ->where_not_in(self::primary_key, $this->bank_branch_id)->get()->row();
        return $this;
    }

    /**
     * @Description         : set baranch name by bank ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 12:46 PM      
     * */
    function set_branch_name_by_bank_id() {
        $this->db->select('*')->from(self::tbl_name)
                ->where('bank_id', $this->bank_id_value);
        if (!empty($this->bank_branch_status)) {
            $this->db->where('bank_branch_status', $this->bank_branch_status);
        }
        $this->result = $this->db->get()->result();
        return $this;
    }

    /**
     * @Description         : set all baranch info by multiple bank ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 11:08 AM      
     * */
    function set_all_branch_info_by_multiple_bank_id() {
        $this->result = $this->db->select('*')->from(self::tbl_name)
                        ->where_in('bank_id', $this->bank_id_value)->get()->result();
        return $this;
    }

    /**
     * @Description         : set all bank baranch id by bank ID and bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-12-2016 10:54 AM      
     * */
    function set_bank_branch_id_by_branch_name() {
        $this->result = $this->db->select('GROUP_CONCAT(bank_branch_id) AS id')->from(self::tbl_name)
                        ->where(['bank_id' => $this->bank_id_value, 'bank_branch_name' => $this->branch_name])
                        ->where_not_in(self::primary_key, $this->bank_branch_id)->get()->row();
        return $this;
    }

    /**
     * @Description         : set check payment info by multiple branch ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-12-2016 11:25 AM      
     * */
    function set_check_payment_info_by_all_branch_id() {
        $this->result = $this->db->select($this->field_name)->from('tbl_person_check_payment_info')
                        ->where_in('bank_branch_id', $this->bank_branch_id)->get()->result();
        return $this;
    }

    /**
     * @Description         : set check payment account number by multiple branch ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-12-2016 11:25 AM      
     * */
    function set_check_payment_account_number_by_all_branch_id() {
        $this->result = $this->db->select($this->field_name)->from('tbl_person_check_payment_info')
                        ->where_in('bank_branch_id', $this->bank_branch_id)
                        ->where('person_account_number', $this->account_number)->get()->result();
        return $this;
    }

    /**
     * @Description         : set check payment id by multiple branch ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-12-2016 11:25 AM      
     * */
    function set_check_payment_id_by_all_branch_id() {
        $this->result = $this->db->select('GROUP_CONCAT(person_check_payment_info_id) AS id')->from('tbl_person_check_payment_info')
                        ->where_in('bank_branch_id', $this->bank_branch_id)->get()->row();
        return $this;
    }

    /**
     * @Description         : set all bank branch ID by bank ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-12-2016 10:11 AM      
     * */
    function set_all_bank_branch_id_by_bank_id() {
        $this->result = $this->db->select('GROUP_CONCAT(bank_branch_id) AS id')
                        ->from('tbl_bank_branch')->where('bank_id', $this->bank_id_value)->get()->row();
        return $this;
    }

    /**
     * @Description         : set insert ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 04:29 PM      
     * */
    function set_insert_id() {
        $this->set_bank_branch_id($this->db->insert_id());
        return $this;
    }

    /**
     * @Description         : get bank branch ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 04:55 PM      
     * */
    function get_bank_branch_id() {
        return $this->bank_branch_id;
    }

    /**
     * @Description         : get result
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 02:14 PM      
     * */
    private $result;

    function get_result() {
        return $this->result;
    }

    /**
     * @Description         : save data into database
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 11:19 AM      
     * */
    function save() {
        $this->db->insert(self::tbl_name, $this->data);
        return $this;
    }

    /**
     * @Description         : Update data into database
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 12:25 PM      
     * */
    function update() {
        $this->db->where(self::primary_key, $this->bank_branch_id)->update(self::tbl_name, $this->data);
    }

    /**
     * @Description         : delete data into database
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 12:35 PM      
     * */
    function delete() {
        $this->db->where(self::primary_key, $this->bank_branch_id)->delete(self::tbl_name);
    }

    public function __destruct() {
        if (!empty($this->bank_branch_status)) {
            unset($this->bank_branch_status);
        }
    }

}
