<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of application_model
 *
 * @author MD Jaherul Islam
 */
class Application_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    function selecet_person_role_for_logged_in_user($person_id) {
        $sql = "SELECT * FROM tbl_person WHERE person_id = '$person_id'";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    /**
     * @Function            : update_person_time_zone 
     * @Used IN             : @function-'check_login'        Application[@Controller]
     * @                    : @function-'login_admin_user'   Babbamamma[@Controller]
     * @Description         : update person time zone
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 18-04-2016 04:19 PM  
     * @Parameter           : $person_id[INTEGER], $person_time_zone[STRING]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function update_person_time_zone($person_id, $person_time_zone) {
        $tData['person_time_zone'] = $person_time_zone;
        $this->utility_model->update_information_in_database('tbl_person', 'person_id', $person_id, $tData);
    }
    

    /**
     * @Function            : save_login_person_pc_information 
     * @Used IN             : @function-'check_login'        Application[@Controller]
     * @Used IN             : @function-'check_login'        babbamamma[@Controller]
     * @Description         : save login person PC information
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 18-04-2016 04:19 PM  
     * @Parameter           : $person_info[ARRAY]
     * @Return              : pc_peson_info_id    
     * @Status              : Available        
     * */
    function save_login_person_pc_information($person_info) {
        $pc_data['person_id'] = $person_info->person_id;
        $pc_data['person_pc_mac_address'] = '';
        $pc_data['person_pc_ip_address'] = $_SERVER['REMOTE_ADDR'];
        $pc_data['person_pc_name'] = '';
        $pc_data['person_pc_browser'] = $this->utility_model->get_browser_name();
        $pc_data['person_site_visit_start_time'] = date('Y-m-d h:i A');
        $pc_data['person_login_status'] = 1;
        return $this->utility_model->save_information_in_database('tbl_person_pc_info', $pc_data);
    }

    /**
     * @Function            : select_captcha_word_check
     * @Used IN             : function[captcha_check_contact] controller[application]
     * @Description         : This function is used to  contact form validation 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 30/05/2016  
     * @Status              : available      
     * */
    /*function select_captcha_word_check($give_text, $captcha_time) {
        $expiration = time() - 1800; // Two hour limit
        $this->db->query("DELETE FROM tbl_captcha WHERE time < " . $expiration);

        $sql = "SELECT * FROM tbl_captcha WHERE word = '$give_text' AND time = '$captcha_time'";
        $result = $this->db->query($sql)->row();
        return $result;
    }*/

//sign in
    /**  31-05-2016
     * @Function            : update_invalid_authetication 
     * @Used IN             : @function-'save_cash_payment'    user_payment[@controller],
      function[invalid_password_submitted_by_user] controller[sign_in]
     * @Description         : update invalid authentication
     * @parameter           : $person_id, $type (1=payment, 2=sign_in)
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 28-03-2016 06:46 AM      
     * @Status              : available      
     * */
    function update_invalid_authetication($person_id, $type) {
        $result = $this->get_invalid_authentication_by_person_id($person_id);
        if (!$result) {
            $autData['person_id'] = $person_id;
            $autData['total_invalid_access'] = 1;
            $autData['authentication_type'] = $type;
            $this->save_invalid_authetication_in_database('tbl_invalid_authentication', $autData);
        } else {
            $autData['total_invalid_access'] = ++$result->total_invalid_access;
            $this->update_invalid_authetication_in_database('tbl_invalid_authentication', 'invalid_authentication_id', $result->invalid_authentication_id, $autData);
        }
    }

    /**
     * @Function            : get_invalid_authentication_by_person_id 
     * @Used IN             : function-'update_invalid_authetication'    model[application_model],
     * @Description         : get all invalid authentication
     * @Parameter           : $person_id
     * @Return              : invalid authentication info
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 28-03-2016 11:34 AM      
     * @Status              : available      
     * */
    function get_invalid_authentication_by_person_id($person_id) {
        $sql = "SELECT *
                FROM 
                    tbl_invalid_authentication AS ia
                WHERE ia.person_id = '$person_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_invalid_authentication_by_person_id 
     * @Used IN             : function-'update_invalid_authetication'    model[application_model],
     * @Description         : save invalid authentication
     * @Parameter           : $table_name, $data
     * @Return              : invalid_authentication_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 28-03-2016 11:34 AM      
     * @Status              : available      
     * */
    function save_invalid_authetication_in_database($table_name, $data) {
        $this->db->insert($table_name, $data);
        return $this->db->insert_id();
    }

    /**
     * @Function            : get_invalid_authentication_by_person_id 
     * @Used IN             : function-'update_invalid_authetication'    model[application_model],
     * @Description         : update invalid authentication
     * @Parameter           : $table_name, $table_id, $id, $data
     * @Return              : none
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 28-03-2016 11:34 AM      
     * @Status              : available      
     * */
    function update_invalid_authetication_in_database($table_name, $table_id, $id, $data) {
        $this->db->where($table_id, $id);
        $this->db->update($table_name, $data);
    }

    /**
     * @Function            : select_invalid_authetication
     * @Used IN             : function[invalid_password_submitted_by_user] controller[sign_in]
     * @Description         : used to get invalid authentication 
     * @Parameter           : $person_id
     * @Return              : invalid authetication info
     * @Developed By        : Tania Akter
     * @Start DateTime      : 01-06-2016
     * @Status              : available      
     * */
    function select_invalid_authetication($person_id) {
        $sql = "SELECT *
                FROM 
                    tbl_invalid_authentication AS ia
                WHERE 
                ia.authentication_type='2'
                AND ia.person_id= '$person_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : delete_invalid_authentication
     * @Used IN             : function[invalid_password_submitted_by_user] controller[sign_in]
     * @Description         : used to delete invalid authentication 
     * @Parameter           : $invalid_authentication_id
     * @Return              : None
     * @Developed By        : Tania Akter
     * @Start DateTime      : 01-06-2016
     * @Status              : available      
     * */
    function delete_invalid_authentication($invalid_authentication_id) {
        $this->db->where('invalid_authentication_id', $invalid_authentication_id);
        $this->db->delete('tbl_invalid_authentication');
    }


}