<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description => all notification query about notification
 *
 * @author Md Jaherul Islam
 */
class Admin_notification_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Description         : view course notification data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-01-2017 12:14 PM   
     * */
    function get_course_notification_data() {
        $data['all_notification'] = $this->create_date()->set_notification_data()->get_result();
        foreach ($data['all_notification'] as $notification_value) {
            $data['notify_by_info'][$notification_value->notification_id] = $this->person_model
                    ->set_person_id($notification_value->notify_by)
                    ->set_field_name('*')
                    ->set_info_with_url_by_id()
                    ->get_info();

            $data['notification_message'][$notification_value->notification_id] = $this->notification_model
                    ->set_person_id(1)
                    ->set_notification_description($notification_value->notification_description)
                    ->get_notification_message();

            $data['notification_seen_info'][$notification_value->notification_id] = $this->tt_notification
                    ->get_notification_seen_info(1, $notification_value->notification_view_by);

            $data['notification_date_time'][$notification_value->notification_id] = $this->tt_notification
                    ->calculate_notification_date_time($notification_value->notification_date_time, $this->session->time_offset);
        }
        return $data;
    }

    /**
     * @Description         : view payment notification data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-01-2017 10:25 AM   
     * */
    function get_payment_notification_data($data) {
        $data['all_notification'] = $this->create_date()->set_notification_data()->get_result();
        foreach ($data['all_notification'] as $notification_value) {
            $data['notify_by_info'][$notification_value->notification_id] = $this->person_model
                            ->set_person_id($notification_value->notify_by)
                            ->set_field_name('*')
                            ->set_info_with_url_by_id()->get_info();
            
            $data['notification_message'][$notification_value->notification_id] = $this->notification_model
                    ->set_person_id(1)
                    ->set_notification_description($notification_value->notification_description)
                    ->get_notification_message();

            $data['notification_seen_info'][$notification_value->notification_id] = $this->tt_notification
                    ->get_notification_seen_info(1, $notification_value->notification_view_by);
            $data['notification_date_time'][$notification_value->notification_id] = $this->tt_notification
                    ->calculate_notification_date_time($notification_value->notification_date_time, $this->session->time_offset);
        }
        return $data;
    }

    /**
     * @Description         : process notification date
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 26-09-2016 09:51 AM
     * @Update DateTime     : 03-01-2016 10:16 AM  
     * @Updated By          : MD Jaherul Islam 
     * */
    function set_notification_info() {
        $this->db->select('*')->from('tbl_notification')->where_in('notification_type', $this->notification_type);
        if ($this->notification_date != '') {
            $this->db->where("date(notification_date_time)", $this->notification_date);
        }
        $this->result = $this->db->get()->result();
        return $this;
    }

    /**
     * @Description         : set notification type
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 22-12-2016 03:26 PM 
     * */
    private $notification_type;

    function set_notification_type($notification_type) {
        $this->notification_type = $notification_type;
        return $this;
    }

    /**
     * @Description         : set notification date
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-01-2017 11:09 AM 
     * */
    private $notification_date;

    function set_date($notification_date) {
        $this->notification_date = $notification_date;
        return $this;
    }

    /**
     * @Description         : set limit
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-01-2017 11:11 AM 
     * */
    private $limit;

    function set_limit($limit) {
        $this->limit = $limit;
        return $this;
    }

    /**
     * @Description         : set today's and previous date
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-01-2017 11:11 AM 
     * */
    private $todays_date;
    private $previous_date;

    function create_date() {
        $this->todays_date = date("Y-m-d", (strtotime(date("Y-m-d h:i:s a")) - $this->session->time_offset));
        $this->previous_date = date("Y-m-d", ((strtotime($this->todays_date . "-1 months"))));
        return $this;
    }

    /**
     * @Description         : view payment notification data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-01-2017 10:25 AM   
     * */
    function set_notification_data() {
        $this->db->select('*')->from('tbl_notification AS n')
                ->join('tbl_notification_type_info AS nti', 'n.notification_id = nti.notification_id')
                ->where_in('n.notification_type', $this->notification_type);
        if (empty($this->notification_date)) {
            $this->db->where("date(n.notification_date_time) BETWEEN '$this->previous_date' AND '$this->todays_date'");
        } else {
            $this->db->where("date(n.notification_date_time)", $this->notification_date);
        }
        $this->result = $this->db->order_by('n.notification_id', 'desc')->limit(5, $this->limit)->get()->result();
        return $this;
    }

    /**
     * @Description         : view payment notification data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-01-2017 10:25 AM   
     * */
    private $result;

    function get_result() {
        return $this->result;
    }

}
