<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Admin_forbidden_model extends CI_Model{
    public function __construct() {
            parent::__construct();
}
/**
     * @Function            : save_add_forbidden_info 
     * @Used IN             : @function-'add_forbidden'  admin_forbidden[@controller],
     * @Description         : This function is used to save forbidden info in database 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 17-04-2016 
     * @Updated Date Time   :       
     * @Parameter           : data(array)   
     * @Status              : Available       
     **/    
    function save_add_forbidden_info()
    {   
        $data = array();  //Here, $data=array is a data storage method(memory location) , by this method i have stored like $data['forbidden_type'], $data['forbidden_name'].     
        $data['forbidden_type'] = $this->input->post('forbidden_type', TRUE);
        $data['forbidden_name'] = $this->input->post('forbidden_name', TRUE);
        $this->db->insert('tbl_forbidden', $data);
    }
/**
     * @Function            : all_forbidden 
     * @Used IN             : @function-'forbidden'  admin_forbidden[@controller],
     * @Description         : This function is used to get all forbidden information 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 17-04-2016 
     * @Updated Date Time   :       
     * @Parameter           : data(array)   
     * @Status              : Available       
     **/     
   function all_forbidden()
    {
        $this->db->select('*');
        $this->db->from('tbl_forbidden');
        $query_result=$this->db->get();
        $result=$query_result->result();
        return $result;
    } 
 /**
     * @Function            : check_forbidden_exist 
     * @Used IN             : @function-'check_forbidden'  admin_forbidden[@controller],
     * @Description         : This function allows to select forbidden info that are exist in database
     * @Developed By        : Tania Akter
     * @Start DateTime      : 17-04-2016 
     * @Updated Date Time   :       
     * @Parameter           : forbidden_name, forbidden_type 
     * @Status              : Available       
     **/    
    function check_forbidden_exist()
    {   
        $forbidden_name = $this->input->post('forbiddenName', true);
        $forbidden_type = $this->input->post('forbiddenType', true);
         $this->db->select('*');
        $this->db->from('tbl_forbidden');
        $this->db->where('forbidden_type', $forbidden_type);
        $this->db->where('forbidden_name', $forbidden_name);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }
/**
     * @Function            : select_forbidden_info_by_id 
     * @Used IN             : @function-'forbidden_info_by_id'  admin_forbidden[@controller],
     * @Description         : to get available forbidden information by using forbidden_id
     * @Developed By        : Tania Akter
     * @Start DateTime      : 17-04-2016 
     * @Updated Date Time   :       
     * @Parameter           : forbidden_id  
     * @Status              : Available       
     **/ 
    function select_forbidden_info_by_id()
    {   
        $forbidden_id = $this->input->post('forbidden_id', true);
        $this->db->select('*');
        $this->db->from('tbl_forbidden');
        $this->db->where('forbidden_id', $forbidden_id);
        $query_result=$this->db->get();
        $result=$query_result->row();
        return $result;
    }
/**
     * @Function            : get_forbidden_manage_info 
     * @Used IN             : @function-'get_forbidden_edit_manage'  admin_forbidden[@controller],
     * @Description         : get all forbidden info without selected forbidden_id info
     * @Developed By        : Tania Akter
     * @Start DateTime      : 17-04-2016 
     * @Updated Date Time   :       
     * @Parameter           : data(array),forbidden_id  
     * @Status              : Available       
     **/     
    function get_forbidden_manage_info()
    {   
         $forbidden_id = $this->input->post('forbiddenId', true);
         $sql="SELECT * FROM tbl_forbidden WHERE forbidden_id != '$forbidden_id'";
         $sql.=" LIMIT 10";          
         return $this->db->query($sql)->result();                
    }
    /**
     * @Function            : get_total_forbidden_manage_info 
     * @Used IN             : @function-'get_forbidden_edit_manage'  admin_forbidden[@controller],
     * @Description         : get total number of forbidden without selected id.
     * @Developed By        : Tania Akter
     * @Start DateTime      : 17-04-2016 
     * @Updated Date Time   :       
     * @Parameter           : data(array),forbidden_id  
     * @Status              : Available       
     **/ 
    function get_total_forbidden_manage_info(){
         $forbidden_id = $this->input->post('forbiddenId', true);
         $sql="SELECT count(*) AS total_forbidden FROM tbl_forbidden WHERE forbidden_id != '$forbidden_id'";
         return $this->db->query($sql)->row();   
    }
/**
     * @Function            : update_forbidden_info 
     * @Used IN             : @function-'update_forbidden'  admin_forbidden[@controller],
     * @Description         : used to receive and update forbidden information
     * @Developed By        : Tania Akter
     * @Start DateTime      : 17-04-2016 
     * @Updated Date Time   :       
     * @Parameter           : data(array),forbidden_id  
     * @Status              : Available       
     **/ 
    function update_forbidden_info()
    {   $forbidden_id = $this->input->post('forbidden_id', true);
        $data = array();
        $data['forbidden_type'] = $this->input->post('forbidden_type', TRUE);
        $data['forbidden_name'] = $this->input->post('forbidden_name1', TRUE);
        $this->db->where('forbidden_id', $forbidden_id);
        $this->db->update('tbl_forbidden', $data);
    }
 /**
     * @Function            : update_forbidden_exist_info 
     * @Used IN             : @function-'update_forbidden_exist'  admin_forbidden[@controller],
     * @Description         : To check forbidden URL/Name/Organization exists in database before updating these to a database.
     * @Developed By        : Tania Akter
     * @Start DateTime      : 17-04-2016 
     * @Updated Date Time   :       
     * @Parameter           : forbidden_name,forbidden_type  
     * @Status              : Available       
     **/   
    function update_forbidden_exist_info()
    {   $forbidden_name = $this->input->post('forbiddenName', true);
        $forbidden_type = $this->input->post('forbiddenType', true);  
       $this->db->select('*');
        $this->db->from('tbl_forbidden');
        $this->db->where('forbidden_type', $forbidden_type);
        $this->db->where('forbidden_name', $forbidden_name);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }
/**
     * @Function            : delete_forbidden_info_by_id 
     * @Used IN             : @function-'delete_forbidden_by_id'  admin_forbidden[@controller],
     * @Description         : To check forbidden URL/Name/Organization exists in database before updating these to a database.
     * @Developed By        : Tania Akter
     * @Start DateTime      : 17-04-2016 
     * @Updated Date Time   :       
     * @Parameter           : forbidden_id  
     * @Status              : Available       
     **/ 
    function delete_forbidden_info_by_id(){
       $forbidden_id = $this->input->post('forbiddenId', true);
        $this->db->where('forbidden_id', $forbidden_id);
        $this->db->delete('tbl_forbidden');
    }
    /**
     * @Function            : get_total_forbidden 
     * @Used IN             : @function-'forbidden','get_forbidden_value_by_type','search_forbidden'  admin_forbidden[@controller],
     * @Description         : get total number of forbidden(return total row number)
     * @Developed By        : Tania Akter
     * @Start DateTime      : 20-04-2016 
     * @Updated Date Time   :       
     * @Parameter           : forbidden_type , search_value  
     * @Status              : Available       
     **/   
    function get_total_forbidden($type, $search_value){    
            $sql = "SELECT 
                    count(*) AS total_forbidden
                FROM 
                    tbl_forbidden
                WHERE forbidden_name != ''";
        if ($type != '') {
            $sql.=" AND forbidden_type = '$type'";
        }
        if ($search_value != '') {
            $sql.=" AND (forbidden_name LIKE '%$search_value%')";
        }
        return $this->db->query($sql)->row();   
    }
      /**
     * @Function            : select_all_forbidden_for_manage_forbidden 
     * @Used IN             : @function-'forbidden'  admin_forbidden[@controller],
     * @Description         : This function is used to get and arrange all forbidden information according to search type, search value, shorting type and pagination numer.
     * @Developed By        : Tania Akter
     * @Start DateTime      : 20-04-2016 
     * @Updated Date Time   :       
     * @Parameter           : forbidden_id  
     * @Status              : Available       
     **/
    function select_all_forbidden_for_manage_forbidden($type, $search_value, $sort, $number){
        
       $sql = "SELECT *
                FROM tbl_forbidden AS f
                WHERE f.forbidden_name != ''";
        if ($type != '') {
            $sql.=" AND forbidden_type = '$type'";
        }
        if ($search_value != '') {
            $sql.=" AND (forbidden_name LIKE '%$search_value%')";
        }
        if ($sort != '') {
            $sql.=" ORDER BY forbidden_name $sort";
        }
        if ($sort == '' && $type == '' && $search_value == '') {
            $sql.=" ORDER BY forbidden_id ASC";
        }
        $sql.=" LIMIT $number,10";
        return $this->db->query($sql)->result();
      
    }
    
    
 
}
