<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Tbl_course extends TT_migration {

    const table_name = 'tbl_course';

    public function up() {
        $this->field_name('course_id')->type('INT')->size(11)->set_null()->auto_increment()->generate();
        $this->field_name('topic_id')->type('INT')->size(5)->set_null()->generate();
        //'To_select_created_by',
        $this->field_name('person_id')->type('INT')->size(11)->set_null()->generate();
        $this->field_name('resource_person_id')->type('INT')->size(11)->set_null()->generate();
        $this->field_name('url_id')->type('INT')->size(11)->set_null()->generate();
        $this->field_name('course_name')->type('TEXT')->generate();
        // Free or Paid
        $this->field_name('course_type')->type('TINYINT')->size(1)->set_null()->generate();
        $this->field_name('number_of_classes')->type('INT')->size(3)->generate();
        $this->field_name('class_hour_per_day')->type('INT')->size(3)->generate();
        $this->field_name('course_start_date')->type('DATE')->generate();
        $this->field_name('course_finished_date')->type('DATE')->generate();
        $this->field_name('last_date_of_registration')->type('DATE')->generate();
        $this->field_name('course_days')->type('VARCHAR')->size(50)->generate();
        $this->field_name('class_time')->type('TIME')->generate();
        $this->field_name('course_training_objectives')->type('TEXT')->generate();
        $this->field_name('course_training_outline')->type('TEXT')->generate();
        $this->field_name('course_meta_title')->type('TEXT')->generate();
        $this->field_name('course_meta_keywords')->type('TEXT')->generate();
        $this->field_name('course_meta_description')->type('TEXT')->generate();
        $this->field_name('course_author')->type('TEXT')->generate();
        $this->field_name('course_rating')->type('FLOAT')->generate();
        //'number_of_times_course_view',
        $this->field_name('course_view')->type('INT')->size(11)->generate();
        //'Bangla=1;English=2',
        $this->field_name('course_language')->type('TINYINT')->size(1)->generate();
        //'public=1;tt_user=2;link=3;group=4;special_user=5;only_me=6;When the access level
        // is Special then we need to set permission by selecting some users',
        $this->field_name('course_access_level')->type('TINYINT')->size(1)->generate();
        //'no=2;yes=1',
        $this->field_name('course_work_files')->type('TINYINT')->size(1)->generate();
        //'no=2;yes=1',
        $this->field_name('upcoming_course')->type('TINYINT')->size(1)->generate();
        $this->field_name('course_level')->type('TINYINT')->size(1)->generate();
        //'unpublished=6;published=1;archived=2;pending=3;approved=4;draft=5',
        $this->field_name('course_status')->type('TINYINT')->size(1)->generate();
        //'yes=1;no=2',
        $this->field_name('course_resource_person_edit')->type('TINYINT')->size(1)->generate();
        //'yes=1;no=2',
        $this->field_name('course_resource_person_view_invoice')->type('TINYINT')->size(1)->generate();
        //'yes=1;no=2',
        $this->field_name('course_resource_person_pay_invoice')->type('TINYINT')->size(1)->generate();
        $this->set_primary_key('course_id')->set_table_name(self::table_name)->create();
    }

    public function down() {
        
    }

}
