<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Tbl_payment extends TT_migration {

    const table_name = 'tbl_payment';

    public function up() {
        $this->field_name('payment_id')->type('INT')->size(7)->auto_increment()->generate();
        $this->field_name('person_id')->type('INT')->size(11)->generate();
        $this->field_name('payment_type')->type('TINYINT')->size(1)->generate();
        $this->field_name('payment_type_id')->type('INT')->size(11)->generate();
        $this->field_name('payment_currency')->type('TINYINT')->size(1)->generate();
        $this->field_name('unit_price')->type('DECIMAL')->size('8.2')->set_null()->generate();
        $this->field_name('discounted_price')->type('DECIMAL')->size('5.2')->set_null()->generate();
        $this->field_name('total_price')->type('DECIMAL')->size('8.2')->generate();
        
        // 'Paid => 1', 'Partial Paid => 2', 'Unpaid => 3', 'Droped => 4', 'Cancel => 5', 'Pending =>6 ',
        // 'Refund request' => 7, 'Refund' => 8
        $this->field_name('payment_status')->type('TINYINT')->size(1)->generate();
        $this->set_primary_key('payment_id')->set_table_name(self::table_name)->create();
    }

    public function down() {
        
    }

}
