<?php

/**
 * Description of TT_utility
 *
 * @author User
 */
class TT_storage {

    /**
     * @Function            : set_size
     * @Description         : set file size
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 02:37 PM
     * @Parameter           : $file_size
     * @Return              : NULL    
     * @Status              : Available        
     * */
    private $size;

    function set_size($size) {
        $this->size = $size;
        return $this;
    }

    /**
     * @Function            : calculate_disk_storage
     * @Description         : calculate formated disk storage
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 01:01 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    private $unit_size;

    function calculate_disk_storage() {
        switch ($this->size) {
            case ($this->size >= 1073741824):
                $this->unit_size = round(($this->size / 1024 / 1024 / 1024), 2) . ' GB';
                break;
            case ($this->size >= 1048576):
                $this->unit_size = round(($this->size / 1024 / 1024), 2) . ' MB';
                break;

            default:
                $this->unit_size = round(($this->size / 1024), 3) . ' KB';
                break;
        }
        return $this;
    }

    /**
     * @Description         : calculate formated disk storage
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-11-2016 06:23 PM    
     * */
    function get_unit_size() {
        return $this->unit_size;
    }

    /**
     * @Function            : get_designed_file_size
     * @Description         : get file size with design format
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 02:27 PM
     * @Parameter           : Null
     * @Return              : $filesize_with_design    
     * @Status              : Available        
     * */
    function get_designed_file_size() {
        return 'Your file size is <span style="color: red;">' . $this->unit_size . '</span>';
    }

    /**
     * @Function            : set_directory
     * @Description         : set directory 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 01:02 PM
     * @Parameter           : $directory
     * @Return              : NULL    
     * @Status              : Available        
     * */
    private $directory;

    function set_directory($directory) {
        $this->directory = $directory;
        return $this;
    }

    /**
     * @Function            : set_storage
     * @Description         : set storage
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 01:02 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function set_storage() {
        $this->size = $this->get_total_disk_space($this->directory);
        return $this;
    }

    /**
     * @Function            : get_total_disk_space
     * @Description         : get total disk space using directory
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 12:50 PM
     * @Parameter           : $directory
     * @Return              : NULL    
     * @Status              : Available        
     * */
    public function get_total_disk_space($dir) {
        $size = 0;
        foreach (glob(rtrim($dir, '/') . '/*', GLOB_NOSORT) as $each) {
            $size += is_file($each) ? filesize($each) : $this->get_total_disk_space($each);
        }
        return $size;
    }

    /**
     * @Function            : get_designed_storage
     * @Description         : get storage with design format
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 02:24 PM
     * @Parameter           : Null
     * @Return              : $storage_with_design    
     * @Status              : Available        
     * */
    function get_designed_storage() {
        return 'You have used <span style="color: red;">' . $this->unit_size . '</span>';
    }

    //-----------------------------------------------------

    /**
     * @Function            : get_storage
     * @Description         : get total used storage
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 01:02 PM
     * @Parameter           : Null
     * @Return              : $storage    
     * @Status              : Available        
     * */
    function get_storage() {
        return $this->formated_disk_storage;
    }

    /**
     * @Function            : __destruct
     * @Description         : destruct all variable
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 01:01 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    public function __destruct() {
        if (!empty($this->size)) {
            unset($this->size);
        }
        if (!empty($this->unit_size)) {
            unset($this->unit_size);
        }
        if (!empty($this->directory)) {
            unset($this->directory);
        }
        if (!empty($this->disk_storage)) {
            unset($this->disk_storage);
        }
        if (!empty($this->formated_disk_storage)) {
            unset($this->formated_disk_storage);
        }
    }

}
