<?php

/**
 * Description of TT_random_number
 *
 * @author Ripon
 */
class TT_random_number {

    private $random_type;
    private $random_type_id;

    /*
     * @Function            : update_random_value
     * @Description         : update random information
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 29-10-2016 11:32 AM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    function save_random_value() {
        $CI = & get_instance();

        $data = $this->get_random_data();
        if (!$CI->db->insert('tbl_random', $data)) {
            $this->save_random_value();
        }
    }

    /*
     * @Function            : set_random_data
     * @Description         : set random information
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 29-10-2016 11:28 AM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    function set_random_data($random_type, $random_type_id) {
        $this->random_type = $random_type;
        $this->random_type_id = $random_type_id;
        return $this;
    }

    /*
     * @Function            : get_random_data
     * @Description         : get random information
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 29-10-2016 11:28 AM    
     * @Parameter           : Null
     * @Return              : $data[Randon table information]   
     * @Status              : available      
     */

    function get_random_data() {
        $data['random_type'] = $this->random_type;
        $data['random_type_id'] = $this->random_type_id;
        $data['random_number'] = $this->random_number = $this->generate_random_number() . 'TT' . $this->generate_random_number();
        return $data;
    }

    /*
     * @Function            : set_random_number 
     * @Description         : set random file name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-10-2016 02:39 PM
     * @Parameter           : $random_number
     * @Return              : Null    
     * @Status              : Available        
     */

    private $random_number;

    function set_random_number($random_number) {
        $this->random_number = $random_number;
        return $this;
    }

    /*
     * @Function            : get_random_file_name 
     * @Description         : get random file name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-10-2016 03:15 PM
     * @Parameter           : Null
     * @Return              : $random file name    
     * @Status              : Available        
     */

    function get_rand_number() {
        return $this->random_number;
    }

    /*
     * @Function            : filter_number 
     * @Description         : filter random number to replace "TT"
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-10-2016 04:49 PM
     * @Parameter           : $arg=>replace Number
     * @Return              : Null   
     * @Status              : Available        
     */

    private $filter_number;

    function filter_number($arg) {
        $number = $this->random_number;
        $number[9] = $arg[0];
        $number[10] = $arg[1];
        $this->filter_number = $number;
        return $this;
    }

    /*
     * @Function            : get_filter_number 
     * @Description         : filter random number to replace "TT"
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-10-2016 04:49 PM
     * @Parameter           : Null
     * @Return              : $filter_random_number   
     * @Status              : Available        
     */

    function get_filter_number() {
        return $this->filter_number;
    }

    /*
     * @Function            : get_random_number
     * @Description         : get generate random number
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 29-10-2016 12:17 AM    
     * @Parameter           : Null
     * @Return              : $random_number   
     * @Status              : available      
     */

    function get_random_number() {
        $CI = & get_instance();
        $random_number = $this->generate_random_number() . 'TT' . $this->generate_random_number();
        $random_value = $CI->utility_model->get_single_table_information('random_number', 'tbl_random', 'random_number', $random_number);

        if ($random_value) {
            $this->get_random_number();
        } else {
            return $random_number;
        }
    }

    /*
     * @Function            : generate_random_number
     * @Description         : generate random number
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 29-10-2016 11:26 AM    
     * @Parameter           : Null
     * @Return              : $random_number   
     * @Status              : available      
     */

    function generate_random_number() {
        $random_value = '';
        for ($i = 0; $i < 9; $i++) {
            $random_value.=rand(0, 9);
        }
        return $random_value;
    }

    /*
     * @Function            : __destruct
     * @Description         : unser all variable
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 29-10-2016 11:26 AM    
     * @Parameter           : Null
     * @Return              : $random_number   
     * @Status              : available      
     */

    public function __destruct() {
        if (!empty($this->random_type)) {
            unset($this->random_type);
        }
        if (!empty($this->random_type_id)) {
            unset($this->random_type_id);
        }
        if (!empty($this->random_number)) {
            unset($this->random_number);
        }
        if (!empty($this->filter_number)) {
            unset($this->filter_number);
        }
    }

}
