<?php

/**
 * Description => Paginzation for Ajax and normal
 *
 * @author User
 */
class Tt_pagination {

    private $url;
    private $div_id;
    private $total_row;
    private $total_page;
    private $per_page;
    private $current_page;
    private $total_link;
    private $open_tag = "<nav class='course-pagination'><ul class='pagination'>";
    private $close_tag = "</ul></nav>";
    private $output = '';

    /**
     * @Function            : view_pagination_link 
     * @Description         : view all pagination link
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 20-08-2016 01:02 PM   
     * @Parameter           : $pram[Array] => all Pagination information
     * @Return              : $pagination_link    
     * @Status              : available      
     * */
    public function view_pagination_link($pram = '') {
        if ($pram) {
            $this->url = ($pram['url'] != '') ? (base_url() . $pram['url']) : '';
            $this->div_id = (isset($pram['div_id'])) ? $pram['div_id'] : '';
            $this->total_row = $pram['total_row'];
            $this->per_page = $pram['per_page'];
            $this->current_page = $pram['current_page'];
            $this->total_link = $pram['total_link'];
            $this->output = '';
            return $this->create_pagination_link();
        }
    }

    /**
     * @Function            : create_pagination_link 
     * @Description         : Create pagination link with required information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 20-08-2016 02:31 PM   
     * @Parameter           : Null
     * @Return              : $pagination_link_design    
     * @Status              : available      
     * */
    private function create_pagination_link() {
        $this->total_page = ceil($this->total_row / $this->per_page);
        if ($this->total_page > 1) {
            $this->output.= $this->open_tag;
            if ($this->current_page > 2) {
                $this->output.= $this->first_tag();
                $this->output.= $this->previous_tag();
            } elseif ($this->current_page > 1) {
                $this->output.= $this->previous_tag();
            }
            if ($this->total_page <= $this->total_link) {
                for ($i = 1; $i <= $this->total_page; $i++) {
                    $this->output.= $this->link_tag($i);
                }
            } else {
                $total_link = floor($this->total_link / 2);
                if ($this->current_page > ($total_link + 1)) {
                    if (($this->current_page + $total_link) < $this->total_page) {
                        for ($i = ($this->current_page - $total_link); $i <= ($this->current_page + $total_link); $i++) {
                            $this->output.= $this->link_tag($i);
                        }
                    }
                    if (($this->current_page + $total_link) >= $this->total_page) {
                        $rmn_link = ($this->current_page + $total_link) - $this->total_page;
                        for ($i = (($this->current_page - $total_link) - $rmn_link); $i <= ($this->total_page); $i++) {
                            $this->output.= $this->link_tag($i);
                        }
                    }
                } else {
                    if ($this->current_page == $this->total_link) {
                        for ($i = 1; $i <= ($this->total_link + $total_link); $i++) {
                            $this->output.= $this->link_tag($i);
                        }
                    } else {
                        for ($i = 1; $i <= $this->total_link; $i++) {
                            $this->output.= $this->link_tag($i);
                        }
                    }
                }
            }
            if ($this->total_page != $this->current_page) {
                $this->output.= $this->next_tag();
                $this->output.= $this->last_tag();
            }
            $this->output.= $this->close_tag;
        }
        return $this->output;
    }

    /**
     * @Function            : first_tag 
     * @Description         : first tag design for pagination link   
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 20-08-2016 03:00 PM   
     * @Parameter           : Null
     * @Return              : $first_tag 
     * @Status              : available      
     * */
    private function first_tag() {
        $div_id = $this->div_id . '1';
        $new_url = ($this->url != '') ? "$this->url" : "javascript:void(0)";
        return "<li><a href='$new_url' id='$div_id' aria-label='Previous'>"
                . "<span aria-hidden='true' title='First Page'>&laquo;&laquo;</span>"
                . "</a></li>";
    }

    /**
     * @Function            : previous_tag 
     * @Description         : Previous tag design for pagination link   
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 20-08-2016 03:20 PM   
     * @Parameter           : Null
     * @Return              : $previous_tag
     * @Status              : available      
     * */
    private function previous_tag() {
        $page_num = ($this->current_page - 1);
        $div_id = $this->div_id . $page_num;
        $new_url = ($this->url != '') ? "$this->url$page_num" : "javascript:void(0)";
        return "<li><a href='$new_url' id='$div_id' aria-label='Previous'>
                        <span aria-hidden='true' title='Previous Page'>&laquo;</span>
                    </a>
                </li>";
    }

    /**
     * @Function            : previous_tag 
     * @Description         : Next tag design for pagination link   
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 20-08-2016 03:40 PM   
     * @Parameter           : Null
     * @Return              : $next_tag
     * @Status              : available      
     * */
    private function next_tag() {
        $page_num = ($this->current_page + 1);
        $div_id = $this->div_id . $page_num;
        $new_url = ($this->url != '') ? "$this->url$page_num" : "javascript:void(0)";
        return "<li><a href='$new_url' id='$div_id' aria-label='Next'>
                        <span aria-hidden='true' title='Next Page'>&raquo;</span>
                    </a>
                </li>";
    }

    /**
     * @Function            : last_tag 
     * @Description         : Last tag design for pagination link   
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 20-08-2016 04:12 PM   
     * @Parameter           : Null
     * @Return              : $last_tag
     * @Status              : available      
     * */
    private function last_tag() {
        $div_id = $this->div_id . $this->total_page;
        $new_url = ($this->url != '') ? "$this->url$this->total_page" : "javascript:void(0)";
        return "<li><a href='$new_url' id='$div_id' aria-label='Next'>
                        <span aria-hidden='true' title='Last Page'>&raquo;&raquo;</span>
                    </a>
                </li>";
    }

    /**
     * @Function            : link_tag 
     * @Description         : Link tag design for pagination link   
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 20-08-2016 05:12 PM   
     * @Parameter           : Null
     * @Return              : $link_tag
     * @Status              : available      
     * */
    private function link_tag($page_num) {
        $link_output = '';
        $div_id = $this->div_id . $page_num;
        $new_url = ($this->url != '') ? "$this->url$page_num" : "javascript:void(0)";
        $link_output.="<li><a ";
        $link_output.=($this->current_page == $page_num) ? "style='background-color:#80c12c; color:#fff;'" : '';
        $link_output.=" href='$new_url' id='$div_id' > $page_num </a></li>";
        return $link_output;
    }

}
