<?php

//Message for which are managed from Session

class Tt_message {

    public function course_registration_error($url) {
        $type = 'error';
        $message = '<span style="color:red">You have already registered in this course!</span>';
        set_message($type, $message);
        redirect($url);
    }

    public function course_registration_invalid_access($url) {
        $type = 'error';
        $message = '<span style="color:red">You can not register on your own course!</span>';
        set_message($type, $message);
        redirect($url);
    }

    public function course_registration_invalid_access_by_backend_user($url) {
        $type = 'error';
        $message = '<span style="color:red">Back end user are not allowed to register any course!</span>';
        set_message($type, $message);
        redirect($url);
    }

    private $payment_status;
    private $payment_status_array = [1 => 'Paid', 2 => 'Partial Paid', 3 => 'Unpaid', 4 => 'Droped',
        5 => 'Cancel', 6 => 'Pending', 7 => 'Refund Request', 8 => 'Refund', 9 => 'Payment Requested'];

    function set_payment_status($payment_status) {
        $this->payment_status = $this->payment_status_array[$payment_status];
        return $this;
    }

    function get_payment_status_message() {
        return $this->payment_status;
    }

}
