<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Video_course extends CI_Controller {

    public function __construct() {
        parent::__construct();
    }

    /*
      -----------@@@RIPON@ Start View public Video Course Part----------------------------------
     */

    /**
     * @Function            : index 
     * @Used IN             : @function-'video_course.php'    
     * @Description         : view all public video course
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 24-03-2016 12:00 PM    
     * @Status              : available      
     * */
    public function view_video_course($arg = NULL) {
        $data = $this->welcome_model->generate_menu();
        $data['right_content_variation'] = 1;
        $data['content_variable']='video_course_view_content'; 
        $data['course_value_for_search'] = 2;
        $data['video_course_category'] = $this->user_video_model->select_all_published_video_course_category(5);
        $data['total_video_course_category'] = count($this->user_video_model->select_total_published_video_course_category());
        $data['technology_list'] = $this->super_admin_video_model->select_all_topic(5);
        $data['total_technology_list'] = $this->super_admin_video_model->get_total_topic();
        $person_id = $this->session->userdata('person_id');

        if ($arg == NULL) {
            $data['page'] = 0;
            $number = 0;
            $sData['session_video_course_category_id'] = $category_id = '';
            $sData['session_video_management_level'] = $video_management_level = '';
            $sData['session_video_course_topic_array'] = $video_course_topic_array = '';
            $sData['session_video_priority_level'] = $video_priority_level = '';
            $sData['session_video_free_course_value'] = $free_video_course_value = '';
            $this->session->set_userdata($sData);
        } else {
            $data['page'] = $arg;
            $number = $arg * 10 - 10;
            $category_id = $this->session->userdata('session_video_course_category_id');
            $video_management_level = $this->session->userdata('session_video_management_level');
            $video_course_topic_array = $this->session->userdata('session_video_course_topic_array');
            $video_priority_level = $this->session->userdata('session_video_priority_level');
            $free_video_course_value = $this->session->userdata('session_video_free_course_value');
        }

        $search_input = '';
        $data['video_courses'] = $this->user_video_model->get_all_video_courses($category_id, $video_management_level, $video_course_topic_array, $free_video_course_value, $video_priority_level, $search_input, $number);
        foreach ($data['video_courses'] as $course_value) {
            if ($course_value->person_role == 4) {
                $data['organization_value'][$course_value->person_id] = $this->organization_model->orgnization_info_with_resource_person_by_person_id($course_value->person_id);
            } else if ($course_value->person_role == 3) {
                $data['individual_teacher_value'][$course_value->person_id] = $this->resource_person_model->select_resource_person_information_by_person_id($course_value->person_id);
            }
        }

        $data['total_video_course'] = $this->user_video_model->get_total_video_courses($category_id, $video_management_level, $video_course_topic_array, $free_video_course_value);
        $data['main_content'] = $this->load->view('front_end/video_course', $data, TRUE);
        if ($person_id) {
            $this->load->view('user/master', $data);
        } else if (!$person_id) {
            $this->load->view('front_end/master', $data);
        }
    }

    /**
     * @Function            : view_category_video_courses 
     * @Used IN             : @function-'video_course.php'    
     * @Description         : get all video course by category ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 24-03-2016 05:12 PM    
     * @Status              : available      
     * */
    function view_category_video_courses() {
        $category_id = $this->input->post('category_id', TRUE);
//        if ($category_id1 == '') {
//            redirect();
//        }
        
        if ($category_id != 'all') {
            $category_id_array = $this->video_model->get_video_course_category_id($category_id);
            $sData['session_video_course_category_id'] = implode(',', $category_id_array);
            $this->session->set_userdata($sData);
        } else {
            $sData['session_video_course_category_id'] = '';
            $this->session->set_userdata($sData);
        }
        $search_input = '';
        $this->view_all_video_course($search_input);
    }

    /**
     * @Function            : view_skill_level_video_course 
     * @Used IN             : @function-'video_course.php'    
     * @Description         : get all video course by skill level
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 24-03-2016 05:12 PM    
     * @Status              : available      
     * */
    function view_skill_level_video_course() {
        $video_management_level1 = $this->input->post('all_skill_level', TRUE);
//        if ($video_management_level1 == '') {
//            redirect();
//        }
        if ($video_management_level1 != '') {
            $sData['session_video_management_level'] = $video_management_level1;
            $this->session->set_userdata($sData);
        } else {
            $sData['session_video_management_level'] = '';
            $this->session->set_userdata($sData);
        }
        $search_input = '';
        $this->view_all_video_course($search_input);
    }

    /**
     * @Function            : view_video_course_by_technology 
     * @Used IN             : @function-'video_course.php'    
     * @Description         : get all video course by topic
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 25-03-2016 06:36 PM    
     * @Status              : available      
     * */
    function view_video_course_by_technology() {
        $selected_topic = $this->input->post('selected_topic', TRUE);
        if ($selected_topic != '') {
            $topic_array = Array();
            $topic_result = $this->course_model->select_all_selected_topic($selected_topic);
            foreach ($topic_result as $value) {
                $topic_array[] = $value->course_topic_name;
            }
            $sData['session_video_course_topic_array'] = $topic_array;
            $this->session->set_userdata($sData);
        } else {
            $sData['session_video_course_topic_array'] = '';
            $this->session->set_userdata($sData);
        }
        $search_input = '';
        $this->view_all_video_course($search_input);
    }

    /**
     * @Function            : view_video_course_priority 
     * @Used IN             : @function-'video_course.php'    
     * @Description         : get all video course by priority level
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 24-03-2016 06:24 PM    
     * @Status              : available      
     * */
    function view_video_course_priority() {
        $priority_level = $this->input->post('priority_level', TRUE);
        if ($priority_level != 'null') {
            $sData['session_video_priority_level'] = $priority_level;
            $this->session->set_userdata($sData);
        } else {
            $sData['session_video_priority_level'] = '';
            $this->session->set_userdata($sData);
        }
        $search_input = '';
        $this->view_all_video_course($search_input);
    }

    /**
     * @Function            : view_free_video_course 
     * @Used IN             : @function-'video_course.php'    
     * @Description         : get all free video course
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 24-03-2016 06:40 PM    
     * @Status              : available      
     * */
    function view_free_video_course() {
        $free_course_value = $this->input->post('free_course_value', TRUE);

        if ($free_course_value != 'null') {
            $sData['session_video_free_course_value'] = $free_course_value;
            $this->session->set_userdata($sData);
        } else {
            $sData['session_video_free_course_value'] = '';
            $this->session->set_userdata($sData);
        }
        $search_input = '';
        $this->view_all_video_course($search_input);
    }

    /**
     * @Function            : view_searched_video_courses 
     * @Used IN             : @function-'video_course.php'    
     * @Description         : view searched video course
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 25-03-2016 06:59 PM    
     * @Status              : available      
     * */
    function view_searched_video_courses() {
        $search_value1 = preg_replace('/\s+/', ' ', trim($this->input->post('search_value', TRUE)));
        if ($search_value1 != '') {
            $search_value = $search_value1;
        } else {
            $search_value = '';
        }
        $this->view_all_video_course($search_value);
    }

    /**
     * @Function            : view_category_video_courses 
     * @Used IN             : @function-'video_course.php'    
     * @Description         : get all video course by category ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 24-03-2016 05:12 PM    
     * @Status              : available      
     * */
    function view_all_video_course($search_input) {
        $category_id = $this->session->userdata('session_video_course_category_id');
        $video_management_level = $this->session->userdata('session_video_management_level');
        $video_course_topic_array = $this->session->userdata('session_video_course_topic_array');
        $video_priority_level = $this->session->userdata('session_video_priority_level');
        $free_video_course_value = $this->session->userdata('session_video_free_course_value');
        $data['page'] = 0;
        $number = 0;

        $data['video_courses'] = $this->user_video_model->get_all_video_courses($category_id, $video_management_level, $video_course_topic_array, $free_video_course_value, $video_priority_level, $search_input, $number);
        foreach ($data['video_courses'] as $course_value) {
            if ($course_value->person_role == 4) {
                $data['organization_value'][$course_value->person_id] = $this->course_model->get_organization_information($course_value->person_id);
            } else if ($course_value->person_role == 3) {
                $data['individual_teacher_value'][$course_value->person_id] = $this->course_model->get_individual_teacher_information($course_value->person_id);
            }
        }

        $data['total_video_course'] = $this->user_video_model->get_total_video_courses($category_id, $video_management_level, $video_course_topic_array, $free_video_course_value);
        echo $this->load->view('front_end/ajax_page/view_video_course', $data, TRUE);
    }

    /**
     * @Function            : get_video_course_more_technology 
     * @Used IN             : @function-'video_course.php'    
     * @Description         : get all video course by technology
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 24-03-2016 12:00 PM    
     * @Status              : available      
     * */
    function get_video_course_more_technology() {
        $selected_topic = $this->input->post('selected_topic', TRUE);
        if ($selected_topic == '') {
            redirect();
        }
        $counter = $this->input->post('counter', TRUE);
        if ($selected_topic != 'null') {
            $data['selected_technology'] = explode(',', $selected_topic);
        } else {
            $data['selected_technology'] = '';
        }
        $data['technology_list'] = $this->course_model->select_all_topic($counter + 3);
        $data['total_technology_list'] = $this->course_model->get_total_topic();
        echo $this->load->view('front_end/ajax_page/video_course_topic_sidebar', $data, TRUE);
    }

    /**
     * @Function            : view_more_category_video_courses 
     * @Used IN             : @function-'video_course.php'    
     * @Description         : get more video course category
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 24-03-2016 05:02 PM    
     * @Status              : available      
     * */
    function view_more_category_video_courses() {
        $counter = $this->input->post('counter', TRUE);
//        if($counter==''){
//            redirect();
//        }
        $data['video_course_category'] = $this->user_video_model->select_all_published_video_course_category($counter + 3);
        $data['total_video_course_category'] = count($this->user_video_model->select_total_published_video_course_category());
        echo $this->load->view('front_end/ajax_page/video_course_category_sidebar', $data, TRUE);
    }

    /*
      -----------@@@RIPON@ End View public Video Course Part----------------------------------
     */




    /*
      -----------@@@RIPON@ Start Video Course Registration Part----------------------------------
     */

    /**
     * @Function            : enroll_video_course 
     * @Used IN             : @function-'front_end/video_course_details.php, [54]
     * @Description         : register video course
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 13-04-2016 01:05 PM 
     * @Parameter           : $video_course_url[STRING]
     * @View                : video/learner,view-invoice-set-id,view_video_course
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function enroll_video_course($video_course_url) {
        $person_id = $this->session->userdata('person_id');
        if (!$person_id) {
            $sdata ['url'] = base_url() . 'video/' . $video_course_url . '/registration';
            $this->session->set_userdata($sdata);
            redirect('sign-in');
        }

        $data['video_course_info'] = $this->user_video_model->get_single_video_course_information_by_url($video_course_url);
        if (!$data['video_course_info']) {
            redirect('sign-in');
        }
        $video_access_permission = $this->user_video_model->check_video_course_access_level($person_id, $data);
        if ($video_access_permission == 1) {
            $sData['error_message'] = '<span style="color:red">You can not enroll your own course<span>';
            $this->session->set_userdata($sData);
            redirect($video_course_url);
        }
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $this->video_course_registration($data, $person_id);
    }

    function video_course_registration($data) {
        if ($data['video_course_info']->video_course_type == 1) {
            //$payment_id = $this->payment_model->save_video_course_payment_information($data);

            $sdata['video_learner_tab_session'] = 'registration';
            $this->session->set_userdata($sdata);
            redirect('video/learner');
//            $payment_id1 = $this->utility_model->encode_id($payment_id, '/', '%F2');
//            redirect('view-invoice/' . $payment_id1);
        }
        if ($data['video_course_info']->video_course_type == 2) {
            $this->registration_model->save_student_registration_info($data['video_course_info']->video_management_id, $data['person_info']->person_id, $data['video_course_info']->video_course_type, 2);
            redirect('video/learner');
        }
    }

}
