<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Super_admin_virtual_classroom extends TT_admin_login {

    public function __construct() {
        parent::__construct();
        
        $this->load->model('super_admin_feature_model', 'vc_model');
    }

    /**
     * @Function            : index
     * @Developed By        : Suddam Hossain Rana | 
     * @parameter           : NONE
     * */
    public function index() {
        $data = array();
        $data['active_menu'] = 'Add_Virtual_Classroom';
        $data['main_content'] = $this->load->view('admin/virtual_classroom/add_virtual_classroom_feature_page', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function feature_price_management() {
        $data = array();
        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $data['active_tab'] = 'virtual_classroom_feature';
        $data['all_virtual_classroom_feature'] = $this->vc_model->select_virtual_classroom_feature_info();
        foreach ($data['all_virtual_classroom_feature'] as $value) {
            $data['feature_holding_user'][$value->feature_price_id] = $this->vc_model->select_feature_holder($value->feature_price_id);
        }
        $data['all_online_exam_feature'] = $this->vc_model->select_online_exam_feature_info();
        $data['all_explore_expert_resume_feature'] = $this->vc_model->select_explore_expert_resume_feature_info();
        $data['main_content'] = $this->load->view('admin/virtual_classroom/feature_price_management', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function virtual_classroom_management() {
        $data = array();
        $data['active'] = 'feature_price_management';
        $data['active_tab'] = 'virtual_classroom_feature';
        $data['all_virtual_classroom_feature'] = $this->vc_model->select_virtual_classroom_feature_info();

        $data['main_content'] = $this->load->view('admin/virtual_classroom/manage_virtual_classroom_feature_page', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function select_free_virtual_classroom_feature() {
        $result = $this->vc_model->select_free_virtual_classroom_feature();
        if ($result) {
            echo 1;
        } else {
            echo 2;
        }
        return;
    }

    public function select_free_virtual_classroom_feature_for_edit($feature_id) {

        $feature_id = str_replace("%F2", "/", $feature_id);
        $feature_id = $this->encrypt->decode($feature_id);

        $result = $this->vc_model->select_free_virtual_classroom_feature();
        if ($feature_id == $result->feature_price_id) {
            echo 2;
            return;
        } else if ($result) {
            echo 1;
        } else {
            echo 2;
        }
        return;
    }

    public function select_free_online_exam_feature_for_edit($feature_id) {

        $feature_id = str_replace("%F2", "/", $feature_id);
        $feature_id = $this->encrypt->decode($feature_id);

        $result = $this->vc_model->select_free_online_exam_feature();

        if ($feature_id == $result->feature_price_id) {
            echo 2;
            return;
        } else if ($result) {
            echo 1;
        } else {
            echo 2;
        }
        return;
    }

    public function select_free_explore_expert_resume_feature_for_edit($feature_id) {

        $feature_id = str_replace("%F2", "/", $feature_id);
        $feature_id = $this->encrypt->decode($feature_id);

        $result = $this->vc_model->select_free_explore_expert_resume_feature();
        if ($feature_id == $result->feature_price_id) {
            echo 2;
            return;
        } else if ($result) {
            echo 1;
        } else {
            echo 2;
        }
        return;
    }

    public function select_free_online_exam_feature() {
        $result = $this->vc_model->select_free_online_exam_feature();
        if ($result) {
            echo 1;
        } else {
            echo 2;
        }
        return;
    }

    public function select_free_explore_expert_resume_feature() {
        $result = $this->vc_model->select_free_explore_expert_resume_feature();
        if ($result) {
            echo 1;
        } else {
            echo 2;
        }
        return;
    }

    /**
     * @Function            : add_virtual_classroom_feature 
     * @Used IN             : @function-'self'  
     * @Description         : save feature price  
     * @                    : @Update1 - remove function 'update_free_virtual_classroom_feature_user' if add free feature  
     * @Developed By        : Mahabub- A Mawla
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 02-03-2016 03:48 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function add_virtual_classroom_feature() {
        $data = array();
        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $data['active_tab'] = 'virtual_classroom_feature';
        $person_id = $this->session->userdata('person_id');
        $data['tt_resource_person'] = $this->vc_model->select_talhatraining_resource_person();
        $resource_person_list = '';
        foreach ($data['tt_resource_person'] as $v_resource_person) {
            if ($v_resource_person->person_id != $person_id) {
                $resource_person_id[] = $v_resource_person->person_id;
                $feature_price_id = $v_resource_person->feature_price_id;
                $feature_price_id = explode(',', $feature_price_id);
                if ($feature_price_id[0] != '') {
                    $feature_info = $this->vc_model->select_virtual_classroom_feature_info_by_id($feature_price_id[0]);
                    $talhatraining_feature_payment_info = $this->vc_model->select_virtual_classroom_feature_payment_info($v_resource_person->person_id);
                    $now = date('Y-m-d H:i:s', strtotime(gmdate('Y-m-d H:i:s')));
                    if ($feature_info->feature_price_talhatraining == 2 && $talhatraining_feature_payment_info->expire_date < $now) {
                        $resource_person_list .= $v_resource_person->person_id . ', ';
                    }
                } else {
                    $resource_person_list .= $v_resource_person->person_id . ', ';
                }
            }
        }

        $data['tt_resource_person'] = $this->vc_model->select_talhatraining_resource_person_by_person_list($resource_person_list);

        $this->load->library('form_validation');
        $this->form_validation->set_rules('classroom_number', 'classroom_number', 'required|trim|xss_clean|callback_validate_virtual_classroom_number');
        $this->form_validation->set_rules('virtual_classroom_per_day', 'virtual classroom per day', 'required|callback_validate_virtual_classroom_per_day');
        $this->form_validation->set_rules('attendees_number', 'Attendees number', 'required');
        $this->form_validation->set_rules('class_type', 'class type', 'required');
        $this->form_validation->set_rules('storage_capacity', 'storage capacity', 'required');
        $this->form_validation->set_rules('price', 'price', 'numeric|callback_check_price_field');
        $this->form_validation->set_rules('currency', 'currency', 'numeric|callback_check_price_field');
        $this->form_validation->set_rules('feature_price_status', 'feature price status', 'required');
        $this->form_validation->set_rules('feature_price_talhatraining', 'feature price talhatraining', 'required|callback_check_feature_price_talhatraining_field');

        if ($this->form_validation->run() == FALSE) {
            $data['active_menu'] = '';
            $data['active_sub_menu'] = '';
            $data['active_tab'] = 'virtual_classroom_feature';
            $data['all_virtual_classroom_feature'] = $this->vc_model->select_virtual_classroom_feature_info();
            foreach ($data['all_virtual_classroom_feature'] as $value) {
                $data['feature_holding_user'][$value->feature_price_id] = $this->vc_model->select_feature_holder($value->feature_price_id);
            }
            $data['all_online_exam_feature'] = $this->vc_model->select_online_exam_feature_info();
            $data['all_explore_expert_resume_feature'] = $this->vc_model->select_explore_expert_resume_feature_info();
            $data['add_virtual_classroom_feature'] = $this->load->view('admin/virtual_classroom/add_virtual_classroom_feature', $data, TRUE);
            $data['main_content'] = $this->load->view('admin/virtual_classroom/feature_price_management', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $data = array();
            $data['virtual_classroom_number'] = $this->input->post('classroom_number', TRUE);
            $data['virtual_classroom_per_day'] = $this->input->post('virtual_classroom_per_day', TRUE);
            $data['virtual_classroom_attendees_number'] = $this->input->post('attendees_number', TRUE);
            $data['virtual_classroom_type'] = $this->input->post('class_type', TRUE);
            $data['feature_price_storage'] = $this->input->post('storage_capacity', TRUE);
            $data['feature_price_talhatraining'] = $this->input->post('feature_price_talhatraining', TRUE);
            $data['feature_price_status'] = $this->input->post('feature_price_status', TRUE);
            if ($data['feature_price_status'] != 3) {  //free feature
                if ($data['feature_price_talhatraining'] == 2) { // not talhatraining feature
                    //$this->load->library('ForeignExchange');
                    //$fx = new ForeignExchange('USD', 'BDT');
                    $data['feature_price_currency'] = $currency_type = $this->input->post('currency', TRUE);
                    if ($currency_type == 2) {
                        //$data['virtual_classroom_price'] = fmtMoney($fx->toForeign($this->input->post('price', TRUE)));
                        $data['virtual_classroom_price'] = $this->tt_currency->set($this->input->post('price', TRUE), 'BDT', 'USD')->convert_currency()->get();
                    } else if ($currency_type == 1) {
                        $data['virtual_classroom_price'] = $this->input->post('price', TRUE);
                    }
                } else { ///talhatraining feature
                    $data['feature_price_currency'] = 'NULL';
                    $data['virtual_classroom_price'] = 'NULL';
                }
            } else {
                $data['feature_price_currency'] = 'NULL';
                $data['virtual_classroom_price'] = 'NULL';
            }

            $feature_id = $this->vc_model->save_virtual_classroom_feature_info($data);

            if ($data['feature_price_talhatraining'] == 1) {
                $to_address = $this->input->post('to_address', true);
                $to_address = explode(',', $to_address);
                if ($to_address[count($to_address) - 1] == '') {
                    array_pop($to_address);
                }
                $resource_person_array = array();
                $this->vc_model->update_talhatraining_resource_person_virtual_feature($to_address, $feature_id, $resource_person_array);
            }
            redirect('feature_price_management');
        }
    }

    public function virtual_classroom_number($classroom_number) {
        $function = 'virtual_classroom_number';
        $virtual_classroom_per_day = $this->input->post('virtual_classroom_per_day');
        if ($classroom_number) {
            if ($classroom_number > $virtual_classroom_per_day) {
                $this->form_validation->set_message($function, "<p style='color:red;'>Virtual classroom in a time can not be greater then Virtual classroom per day</p>");
                return FALSE;
            }
        }
    }

    public function validate_virtual_classroom_per_day($virtual_classroom_per_day) {
        $function = 'validate_virtual_classroom_per_day';
        $classroom_number = $this->input->post('classroom_number');
        if ($virtual_classroom_per_day) {
            if ($classroom_number > $virtual_classroom_per_day) {
                $this->form_validation->set_message($function, "<p style='color:red;'>Virtual classroom per day can not be less then Virtual classroom in a time</p>");
                return FALSE;
            }
        }
    }

    public function check_resource_person_virtual_classroom_feature() {
        $free_virtual_classroom_feature = $this->vc_model->select_tt_virtual_classroom_feature();

        $person_id = $this->session->userdata('person_id');
        $to_address = $this->input->post('to_address', true);
        $to_address = explode(',', $to_address);
        if ($to_address[count($to_address) - 1] == '') {
            array_pop($to_address);
        }
        $person_id = $this->session->userdata('user_id');
        $data['tt_resource_person'] = $this->vc_model->select_talhatraining_resource_person();
        $resource_person_id = array();
        $feature_holding_person = '';
        foreach ($data['tt_resource_person'] as $v_resource_person) {
            if ($v_resource_person->person_id != $person_id) {
                $resource_person_id[] = $v_resource_person->person_id;

                $feature_price_id = $v_resource_person->feature_price_id;
                $feature_price_id = explode(',', $feature_price_id);
                if (in_array($feature_price_id[0], $free_virtual_classroom_feature) && in_array($v_resource_person->person_id, $to_address)) {
                    $feature_holding_person .= $v_resource_person->person_email . ', ';
                }
            }
        }
        $validate = TRUE;
        if ($to_address) {
            foreach ($to_address as $value) {
                if (!in_array($value, $resource_person_id)) {
                    $validate = FALSE;
                } else {
                    
                }
            }
        } else {
            echo 3;
            return;
        }

        if ($feature_holding_person) {
            $feature_holding_person = explode(',', $feature_holding_person);
            array_pop($feature_holding_person);
            $person = implode(',', $feature_holding_person);
            if (count($feature_holding_person) > 1) {
                echo '<span style=color:grey>' . $person . '</span>' . ' <p> are selected another virtual classroom feature ';
            } else {
                echo '<span style=color:grey>' . $person . '</span>' . '<p> is selected another virtual classroom feature ';
            }
            return;
        }

        if ($validate == TRUE) {
            echo 1;
            return;
        } else {
            echo 2;
            return;
        }
    }

    /**
     * @Function            :   check_paid_feature_combination
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-18 12:00 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   select_virtual_cls_info by classroom_number, attendees_number, class_type
     *
     * @parameter           :   $v_classroom_number, $v_attendees_number, $v_class_type
     * @Return              :   $result
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   $this->validate_paid_feature_combination()
     *
     * */
    public function check_paid_feature_combination() {
        $classroom_number = $this->input->post('classroom_number', TRUE);
        $virtual_classroom_per_day = $this->input->post('virtual_classroom_per_day', TRUE);
        $attendees_number = $this->input->post('attendees_number', TRUE);
        $class_type = $this->input->post('class_type', TRUE);
        $feature_id = $this->input->post('feature_price_id', TRUE);
        $feature_id = str_replace("%F2", "/", $feature_id);
        $feature_id = $this->encrypt->decode($feature_id);

        $result = $this->vc_model->select_virtual_classroom_feature_info_by_combination($classroom_number, $virtual_classroom_per_day, $attendees_number, $class_type);
        if ($result) {
            if ($result->feature_price_id == $feature_id) {
                return 1; // feature self combination
            } else {
                return 2; // feature combination not unique
            }
        } else {
            return 1; // feature combination unique
        }
    }

    /**
     * @Function            :   ajax_check_paid_feature_combination
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-18 12:00 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   ajax_check_paid_feature_combination by classroom_number, attendees_number, class_type
     *
     * @parameter           :   $classroom_number, $attendees_number, $class_type
     * @Return              :   NO but echo as responce text
     * @Redirect            :   no
     * 
     * @External call       :   
     * @Internal call       :   $this->validate_paid_feature_combination()
     *
     * */
    public function ajax_check_paid_feature_combination() {
        echo $this->check_paid_feature_combination();
    }

    /**
     * @Function            :   ajax_check_paid_feature_edit_combination
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-18 12:00 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   ajax_check_paid_feature_edit_combination by classroom_number, attendees_number, class_type
     *
     * @parameter           :   NO but POST
     * @Return              :   NO but echo as responce text
     * @Redirect            :   no
     * 
     * @External call       :   
     * @Internal call       :   $this->validate_paid_feature_combination()
     *
     * */
    public function ajax_check_paid_feature_edit_combination() {
        echo $this->check_paid_feature_combination();
    }

    public function edit_virtual_classroom_feature_set_id($feature_id) {
        $sdata['feature_id'] = $feature_id;
        $this->session->set_userdata($sdata);
        redirect('super_admin_virtual_classroom/edit-virtual-classroom-feature');
    }

    public function edit_virtual_classroom_feature() {
        $feature_id = $this->input->post('feature_price_id');
        $feature_id = str_replace("%F2", "/", $feature_id);
        $feature_id = $this->encrypt->decode($feature_id);
        if (!$feature_id) {
            $feature_id = $this->session->userdata('feature_id');
            $feature_id = str_replace("%F2", "/", $feature_id);
            $feature_id = $this->encrypt->decode($feature_id);
        }
        $data = array();
        $data['active'] = 'feature_price_management';
        $data['active_tab'] = 'virtual_classroom_feature';
        $this->session->set_userdata($data);
        $data['tt_resource_person'] = $this->vc_model->select_talhatraining_resource_person();
        foreach ($data['tt_resource_person'] as $v_person) {
            $person_feature = $v_person->feature_price_id;
            $person_feature = explode(',', $person_feature);
            $data['tt_resource_person_feature_info'][$v_person->person_id] = $this->vc_model->select_feature_info_by_id($person_feature[0]);
        }

        $data['feature_info'] = $this->vc_model->select_virtual_classroom_feature_info_by_id($feature_id);
        $data['feature_selected_user'] = $this->vc_model->select_feature_holder($data['feature_info']->feature_price_id);
        if (!$data['feature_info']) {
            redirect('feature_price_management');
        }
        $data['feature_selected_user_array'] = $resource_person_array = $this->make_resource_person_array($data['feature_selected_user']);

        $this->load->library('form_validation');
        $this->form_validation->set_rules('classroom_number', 'classroom_number', 'required|trim|xss_clean|callback_validate_virtual_classroom_number');
        $this->form_validation->set_rules('virtual_classroom_per_day', 'virtual classroom per day', 'required|callback_validate_virtual_classroom_per_day');
        $this->form_validation->set_rules('attendees_number', 'Attendees number', 'required');
        $this->form_validation->set_rules('class_type', 'class type', 'required');
        $this->form_validation->set_rules('storage_capacity', 'storage capacity', 'required');
        $this->form_validation->set_rules('price', 'price', 'numeric|callback_check_price_field');
        $this->form_validation->set_rules('currency', 'currency', 'numeric|callback_check_price_field');
        $this->form_validation->set_rules('feature_price_status', 'feature price status', 'required');
        $this->form_validation->set_rules('feature_price_talhatraining', 'feature price talhatraining', 'required|callback_check_feature_price_talhatraining_field');

        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'feature_price_management';
            $data['active_tab'] = 'virtual_classroom_feature';
            $data['all_virtual_classroom_feature'] = $this->vc_model->select_virtual_classroom_feature_info();
            foreach ($data['all_virtual_classroom_feature'] as $value) {
                $data['feature_holding_user'][$value->feature_price_id] = $this->vc_model->select_feature_holder($value->feature_price_id);
            }
            $data['all_online_exam_feature'] = $this->vc_model->select_online_exam_feature_info();
            $data['all_explore_expert_resume_feature'] = $this->vc_model->select_explore_expert_resume_feature_info();

            $data['add_virtual_classroom_feature'] = $this->load->view('admin/virtual_classroom/edit_virtual_classroom_feature', $data, TRUE);
            $data['main_content'] = $this->load->view('admin/virtual_classroom/feature_price_management', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $fdata = array();
            $fdata['virtual_classroom_number'] = $this->input->post('classroom_number', TRUE);
            $fdata['virtual_classroom_per_day'] = $this->input->post('virtual_classroom_per_day', TRUE);
            $fdata['virtual_classroom_attendees_number'] = $this->input->post('attendees_number', TRUE);
            $fdata['virtual_classroom_type'] = $this->input->post('class_type', TRUE);
            $fdata['feature_price_storage'] = $this->input->post('storage_capacity', TRUE);
            $fdata['feature_price_talhatraining'] = $this->input->post('feature_price_talhatraining', TRUE);
            $fdata['feature_price_status'] = $this->input->post('feature_price_status', TRUE);
            if ($fdata['feature_price_status'] != 3) {
                if ($fdata['feature_price_talhatraining'] == 2) { // not talhatraining feature
                    //$this->load->library('ForeignExchange');
                    //$fx = new ForeignExchange('USD', 'BDT');
                    $fdata['feature_price_currency'] = $currency_type = $this->input->post('currency', TRUE);
                    if ($currency_type == 2) {
                        //$fdata['virtual_classroom_price'] = fmtMoney($fx->toForeign($this->input->post('price', TRUE)));
                        $fdata['virtual_classroom_price'] = $this->tt_currency->set($this->input->post('price', TRUE), 'BDT', 'USD')->convert_currency()->get();
                    } else if ($currency_type == 1) {
                        $fdata['virtual_classroom_price'] = $this->input->post('price', TRUE);
                    }
                } else { ///talhatraining feature
                    $fdata['feature_price_currency'] = 'NULL';
                    $fdata['virtual_classroom_price'] = 'NULL';
                }
            } else {
                $fdata['feature_price_currency'] = 'NULL';
                $fdata['virtual_classroom_price'] = 'NULL';
            }
            $this->super_admin_feature_model->update_virtual_classroom_feature_info($fdata, $feature_id);

            if ($fdata['feature_price_talhatraining'] == 1) {
                if ($fdata['feature_price_status'] == '0') {
                    $data['new_assigned_user_id'] = '';
                    $data['feature_id'] = $feature_id;
                    // passign feature_selected_user, new_assigned_user_id = blank array, feature_id
                    $this->vc_model->unassign_talhatraining_resource_person_virtual_feature($data);
                } else {
                    $to_address = $this->input->post('to_address', true);
                    $to_address = explode(',', $to_address);
                    if ($to_address[count($to_address) - 1] == '') {
                        array_pop($to_address);
                    }
                    $this->vc_model->update_talhatraining_resource_person_virtual_feature($to_address, $feature_id, $resource_person_array);
                    $data['new_assigned_user_id'] = $to_address;
                    $data['feature_id'] = $feature_id;
                    // passign feature_selected_user, new_assigned_user_id, feature_id
                    $this->vc_model->unassign_talhatraining_resource_person_virtual_feature($data);
                }
            } else if ($fdata['feature_price_status'] == 3) {
                $this->vc_model->update_free_virtual_classroom_feature_user($feature_id);
            }
            redirect('feature_price_management');
        }
    }

    public function make_resource_person_array($feature_selected_user) {
        $array = array();
        foreach ($feature_selected_user as $value) {
            $array[] = $value->person_id;
        }
        return $array;
    }

    public function active_select_virtual_classroom_feature($feature_price_id) {
        $this->super_admin_feature_model->active_select_virtual_classroom_feature($feature_price_id);

        $data['feature_info'] = $this->vc_model->select_virtual_classroom_feature_info_by_id($feature_price_id);
        $data['feature_holding_user'] = $this->vc_model->select_feature_holder($data['feature_info']->feature_price_id);
        echo $this->load->view('admin/virtual_classroom/feature_price_management_action', $data, true);
    }

    /**
     * @Function            :   inactive_select_virtual_classroom_feature
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-15 12:18 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   make-feature-inactive/(:any)
     *
     * @Works               :   inactive_select_virtual_classroom_feature 
     *                          inactivate feature_price_id 
     *                              if feature price talhatraining is yes unassign tt resource person tt_feature
     *                              if feature price talhatraining is no  check feature holding user and just inactive feature 
     *                                  
     * @parameter           :   $feature_price_id
     * @Return              :   no
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function inactive_select_virtual_classroom_feature($feature_price_id) {
        $data['feature_info'] = $this->vc_model->select_virtual_classroom_feature_info_by_id($feature_price_id);
        $data['feature_holding_user'] = $this->vc_model->select_feature_holder($data['feature_info']->feature_price_id);
        $action_allow = 'yes';
        if ($data['feature_info']->feature_price_status == 3 || $data['feature_info']->feature_price_talhatraining == 1) {
            $action_allow = 'yes';
        } else {
            if ($data['feature_holding_user']) {
                $action_allow = 'no';
            }
        }
        if ($action_allow == 'yes') {
            if ($data['feature_info']->feature_price_talhatraining == 1) {
                $data['feature_selected_user'] = $data['feature_holding_user'];
                $data['new_assigned_user_id'] = '';
                $data['feature_id'] = $feature_price_id;
                // passign feature_selected_user, new_assigned_user_id, feature_id
                $this->vc_model->unassign_talhatraining_resource_person_virtual_feature($data);
            }
            $this->super_admin_feature_model->inactive_select_virtual_classroom_feature($feature_price_id);
        } else {
            echo '2'; // not inactivated
        }
        $data['feature_info'] = $this->vc_model->select_virtual_classroom_feature_info_by_id($feature_price_id);
        $data['feature_holding_user'] = $this->vc_model->select_feature_holder($data['feature_info']->feature_price_id);
        echo $this->load->view('admin/virtual_classroom/feature_price_management_action', $data, true);
    }

    public function delete_select_virtual_classroom_feature($feature_price_id) {
        $data['feature_info'] = $this->vc_model->select_virtual_classroom_feature_info_by_id($feature_price_id);
        $data['feature_holder'] = $this->vc_model->select_feature_holder($feature_price_id);

        $deletable_feature = 'yes';
        if ($data['feature_info']->feature_price_status == 3) {
            $deletable_feature = 'yes';
        } else {
            if ($data['feature_holder']) {
                $deletable_feature = 'no';
            }
        }

        if ($deletable_feature == 'yes') {
            foreach ($data['feature_holder'] as $value) {
                $this->super_admin_feature_model->delete_person_feature_price_id($value);
            }
            $this->super_admin_feature_model->delete_select_virtual_classroom_feature($feature_price_id);
        } else {
            echo '2'; // not deletable
        }
    }

    public function add_online_exam_feature() {
        $data = array();
        $data['active'] = 'feature_price_management';
        $data['active_tab'] = 'online_exam_feature';
        $this->session->set_userdata($data);
        $data['all_virtual_classroom_feature'] = $this->vc_model->select_virtual_classroom_feature_info();
        $this->load->library('form_validation');
        $this->form_validation->set_rules('online_exam_feature_number', 'exam_number', 'required|trim|xss_clean');
        $this->form_validation->set_rules('price', 'price', 'numeric|callback_check_price_field');
        $this->form_validation->set_rules('currency', 'currency', 'numeric|callback_check_price_field');
        $this->form_validation->set_rules('feature_price_status', 'feature_price_status', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['all_virtual_classroom_feature'] = $this->vc_model->select_virtual_classroom_feature_info();
            $data['all_online_exam_feature'] = $this->vc_model->select_online_exam_feature_info();
            $data['all_explore_expert_resume_feature'] = $this->vc_model->select_explore_expert_resume_feature_info();
            $data['add_online_exam_feature'] = $this->load->view('admin/virtual_classroom/add_online_exam_feature', $data, TRUE);
            $data['main_content'] = $this->load->view('admin/virtual_classroom/feature_price_management', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $data = array();
            $feature_price_id = $this->input->post('feature_price_id', TRUE);
            $data['online_exam_feature_number'] = $this->input->post('online_exam_feature_number', TRUE);
            $data['feature_price_status'] = $this->input->post('feature_price_status', TRUE);
            if ($data['feature_price_status'] != 3) {
                //$this->load->library('ForeignExchange');
                //$fx = new ForeignExchange('USD', 'BDT');
                $data['feature_price_currency'] = $currency_type = $this->input->post('currency', TRUE);
                if ($currency_type == 2) {
                    //$data['online_exam_feature_price'] = fmtMoney($fx->toForeign($this->input->post('price', TRUE)));
                    $data['online_exam_feature_price'] = $this->tt_currency->set($this->input->post('price', TRUE), 'BDT', 'USD')->convert_currency()->get();
                } else if ($currency_type == 1) {
                    $data['online_exam_feature_price'] = $this->input->post('price', TRUE);
                }
            } else {
                $data['feature_price_currency'] = 'NULL';
                $data['online_exam_feature_price'] = 'NULL';
            }
            $free_virtual_classroom_feature = $this->vc_model->select_free_virtual_classroom_feature();
            $free_online_exam_feature = $this->vc_model->select_free_online_exam_feature();
            $free_explore_expert_resume_feature = $this->vc_model->select_free_explore_expert_resume_feature();
            $previous_feature_id = $free_virtual_classroom_feature->feature_price_id . ',' . $free_online_exam_feature->feature_price_id . ',' . $free_explore_expert_resume_feature->feature_price_id;

            $feature_id = $this->super_admin_feature_model->save_online_exam_feature_info($data);
            if ($data['feature_price_status'] == 3) {
                if (!strstr($feature_id, $previous_feature_id)) {
                    $this->update_free_feature_user();
                }
            }

            $sdata['message'] = 'Virtual classroom feature has been Updated successfully';
            $this->session->set_userdata($sdata);

            redirect('feature_price_management');
        }
    }

    public function edit_online_exam_feature_set_id($feature_id) {
        $sdata['feature_id'] = $feature_id;
        $this->session->set_userdata($sdata);
        redirect('super_admin_virtual_classroom/edit-online-exam-feature');
    }

    public function edit_online_exam_feature() {
        $feature_id = $this->input->post('feature_price_id');
        $feature_id = str_replace("%F2", "/", $feature_id);
        $feature_id = $this->encrypt->decode($feature_id);
        if (!$feature_id) {
            $feature_id = $this->session->userdata('feature_id');
            $feature_id = str_replace("%F2", "/", $feature_id);
            $feature_id = $this->encrypt->decode($feature_id);
        }
        $data = array();
        $sdata['active'] = 'feature_price_management';
        $sdata['active_tab'] = 'online_exam_feature';
        $this->session->set_userdata($sdata);
        $data['all_virtual_classroom_feature'] = $this->vc_model->select_virtual_classroom_feature_info();
        $this->load->library('form_validation');
        $this->form_validation->set_rules('online_exam_feature_number', 'exam_number', 'required|trim|xss_clean');
        $this->form_validation->set_rules('price', 'price', 'numeric|callback_check_price_field');
        $this->form_validation->set_rules('currency', 'currency', 'numeric|callback_check_price_field');
        $this->form_validation->set_rules('feature_price_status', 'feature_price_status', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['all_virtual_classroom_feature'] = $this->vc_model->select_virtual_classroom_feature_info();
            $data['all_online_exam_feature'] = $this->vc_model->select_online_exam_feature_info();
            $data['all_explore_expert_resume_feature'] = $this->vc_model->select_explore_expert_resume_feature_info();
            $data['feature_info'] = $this->vc_model->select_virtual_classroom_feature_info_by_id($feature_id);
            $data['add_online_exam_feature'] = $this->load->view('admin/virtual_classroom/edit_online_exam_feature', $data, TRUE);
            $data['main_content'] = $this->load->view('admin/virtual_classroom/feature_price_management', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $data = array();
            $feature_price_id = $this->input->post('feature_price_id', TRUE);
            $data['online_exam_feature_number'] = $this->input->post('online_exam_feature_number', TRUE);

            $data['feature_price_status'] = $this->input->post('feature_price_status', TRUE);
            if ($data['feature_price_status'] != 3) {
                //$this->load->library('ForeignExchange');
                //$fx = new ForeignExchange('USD', 'BDT');
                $data['feature_price_currency'] = $currency_type = $this->input->post('currency', TRUE);
                if ($currency_type == 2) {
                    //$data['online_exam_feature_price'] = fmtMoney($fx->toForeign($this->input->post('price', TRUE)));
                    $data['online_exam_feature_price'] = $this->tt_currency->set($this->input->post('price', TRUE), 'BDT', 'USD')->convert_currency()->get();
                } else if ($currency_type == 1) {
                    $data['online_exam_feature_price'] = $this->input->post('price', TRUE);
                }
            } else {
                $data['feature_price_currency'] = 'NULL';
                $data['online_exam_feature_price'] = 'NULL';
            }

            $free_virtual_classroom_feature = $this->vc_model->select_free_virtual_classroom_feature();
            $free_online_exam_feature = $this->vc_model->select_free_online_exam_feature();
            $free_explore_expert_resume_feature = $this->vc_model->select_free_explore_expert_resume_feature();
            $previous_feature_id = $free_virtual_classroom_feature->feature_price_id . ',' . $free_online_exam_feature->feature_price_id . ',' . $free_explore_expert_resume_feature->feature_price_id;

            $this->super_admin_feature_model->update_online_exam_feature_info($data, $feature_id);
            if ($data['feature_price_status'] == 3) {
                if (!strstr($feature_id, $previous_feature_id)) {
                    $this->update_free_feature_user();
                }
            }

            $sdata['message'] = 'Virtual classroom feature has been updated successfully';
            $this->session->set_userdata($sdata);
            redirect('feature_price_management');
        }
    }

    public function add_explore_expert_resume_feature() {
        $data = array();
        $data['active'] = 'feature_price_management';
        $data['active_tab'] = 'explore_expert_resume_feature';
        $this->session->set_userdata($data);

        $this->load->library('form_validation');
        $this->form_validation->set_rules('explore_expert_resume_per_day', 'explore_expert_resume_per_day', 'required|trim|xss_clean');
        $this->form_validation->set_rules('price', 'price', 'numeric|callback_check_price_field');
        $this->form_validation->set_rules('currency', 'currency', 'numeric|callback_check_price_field');
        $this->form_validation->set_rules('feature_price_status', 'feature_price_status', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['all_virtual_classroom_feature'] = $this->vc_model->select_virtual_classroom_feature_info();
            $data['all_online_exam_feature'] = $this->vc_model->select_online_exam_feature_info();
            $data['all_explore_expert_resume_feature'] = $this->vc_model->select_explore_expert_resume_feature_info();

            $data['add_explore_expert_resume'] = $this->load->view('admin/virtual_classroom/add_explore_expert_resume', $data, TRUE);
            $data['main_content'] = $this->load->view('admin/virtual_classroom/feature_price_management', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $data = array();
            $feature_price_id = $this->input->post('feature_price_id', TRUE);
            $data['explore_expert_resume_per_day'] = $this->input->post('explore_expert_resume_per_day', TRUE);
            $data['feature_price_status'] = $this->input->post('feature_price_status', TRUE);
            if ($data['feature_price_status'] != 3) {
                //$this->load->library('ForeignExchange');
                //$fx = new ForeignExchange('USD', 'BDT');
                $data['feature_price_currency'] = $currency_type = $this->input->post('currency', TRUE);
                if ($currency_type == 2) {
                    //$data['explore_expert_resume_price'] = fmtMoney($fx->toForeign($this->input->post('price', TRUE)));
                    $data['explore_expert_resume_price'] = $this->tt_currency->set($this->input->post('price', TRUE), 'BDT', 'USD')->convert_currency()->get();
                } else if ($currency_type == 1) {
                    $data['explore_expert_resume_price'] = $this->input->post('price', TRUE);
                }
            } else {
                $data['feature_price_currency'] = 'NULL';
                $data['explore_expert_resume_price'] = 'NULL';
            }

            $free_virtual_classroom_feature = $this->vc_model->select_free_virtual_classroom_feature();
            $free_online_exam_feature = $this->vc_model->select_free_online_exam_feature();
            $free_explore_expert_resume_feature = $this->vc_model->select_free_explore_expert_resume_feature();
            $previous_feature_id = $free_virtual_classroom_feature->feature_price_id . ',' . $free_online_exam_feature->feature_price_id . ',' . $free_explore_expert_resume_feature->feature_price_id;

            $feature_id = $this->super_admin_feature_model->save_online_exam_feature_info($data);
            if ($data['feature_price_status'] == 3) {
                if (!strstr($feature_id, $previous_feature_id)) {
                    $this->update_free_feature_user();
                }
            }

            $sdata['message'] = 'Virtual Classroom Feature has been added successfully';
            $this->session->set_userdata($sdata);
            redirect('feature_price_management');
        }
    }

    public function edit_explore_expert_resume_feature_set_id($feature_id) {
        $sdata['feature_id'] = $feature_id;
        $this->session->set_userdata($sdata);
        redirect('super_admin_virtual_classroom/edit-explore-expert-resume-feature');
    }

    public function edit_explore_expert_resume_feature() {
        $feature_id = $this->input->post('feature_price_id');
        $feature_id = str_replace("%F2", "/", $feature_id);
        $feature_id = $this->encrypt->decode($feature_id);
        if (!$feature_id) {
            $feature_id = $this->session->userdata('feature_id');
            $feature_id = str_replace("%F2", "/", $feature_id);
            $feature_id = $this->encrypt->decode($feature_id);
        }
        $data = array();
        $data['active'] = 'feature_price_management';
        $data['active_tab'] = 'explore_expert_resume_feature';
        $this->session->set_userdata($data);

        $this->load->library('form_validation');
        $this->form_validation->set_rules('explore_expert_resume_per_day', 'explore_expert_resume_per_day', 'required|trim|xss_clean');
        $this->form_validation->set_rules('price', 'price', 'numeric|callback_check_price_field');
        $this->form_validation->set_rules('currency', 'currency', 'numeric|callback_check_price_field');
        $this->form_validation->set_rules('feature_price_status', 'feature_price_status', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['all_virtual_classroom_feature'] = $this->vc_model->select_virtual_classroom_feature_info();
            $data['all_online_exam_feature'] = $this->vc_model->select_online_exam_feature_info();
            $data['all_explore_expert_resume_feature'] = $this->vc_model->select_explore_expert_resume_feature_info();
            $data['feature_info'] = $this->vc_model->select_virtual_classroom_feature_info_by_id($feature_id);

            $data['add_explore_expert_resume'] = $this->load->view('admin/virtual_classroom/edit_explore_expert_resume', $data, TRUE);
            $data['main_content'] = $this->load->view('admin/virtual_classroom/feature_price_management', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $data = array();
            $feature_price_id = $this->input->post('feature_price_id', TRUE);
            $data['explore_expert_resume_per_day'] = $this->input->post('explore_expert_resume_per_day', TRUE);
            $data['feature_price_status'] = $this->input->post('feature_price_status', TRUE);
            if ($data['feature_price_status'] != 3) {
                //$this->load->library('ForeignExchange');
                //$fx = new ForeignExchange('USD', 'BDT');
                $data['feature_price_currency'] = $currency_type = $this->input->post('currency', TRUE);
                if ($currency_type == 2) {
                    //$data['explore_expert_resume_price'] = fmtMoney($fx->toForeign($this->input->post('price', TRUE)));
                    $data['explore_expert_resume_price'] = $this->tt_currency->set($this->input->post('price', TRUE), 'BDT', 'USD')->convert_currency()->get();
                } else if ($currency_type == 1) {
                    $data['explore_expert_resume_price'] = $this->input->post('price', TRUE);
                }
            } else {
                $data['feature_price_currency'] = 'NULL';
                $data['explore_expert_resume_price'] = 'NULL';
            }

            $free_virtual_classroom_feature = $this->vc_model->select_free_virtual_classroom_feature();
            $free_online_exam_feature = $this->vc_model->select_free_online_exam_feature();
            $free_explore_expert_resume_feature = $this->vc_model->select_free_explore_expert_resume_feature();
            $previous_feature_id = $free_virtual_classroom_feature->feature_price_id . ',' . $free_online_exam_feature->feature_price_id . ',' . $free_explore_expert_resume_feature->feature_price_id;

            $this->super_admin_feature_model->update_explore_expert_resume_feature($data, $feature_id);
            if ($data['feature_price_status'] == 3) {
                if (!strstr($feature_id, $previous_feature_id)) {
                    $this->update_free_feature_user();
                }
            }

            $sdata['message'] = 'Virtual Classroom Feature has been added successfully';
            $this->session->set_userdata($sdata);
            redirect('feature_price_management');
        }
    }

    public function check_price_field() {
        $feature_price_talhatraining = $this->input->post('feature_price_talhatraining', TRUE);
        $feature_price_status = $this->input->post('feature_price_status', TRUE);
        if ($feature_price_status == 3) {
            return TRUE;
        } else if ($feature_price_status == 1 || $feature_price_status == 0) {
            if ($feature_price_talhatraining == 1) {
                return TRUE;
            } else if ($feature_price_talhatraining == 2) {
                $price = $this->input->post('price', TRUE);
                if ($price == NULL) {
                    $this->form_validation->set_message('check_price_field', "<p style='color:red;'>Price Filed is required </p>");
                    return FALSE;
                } else {
                    return TRUE;
                }
                $currency = $this->input->post('currency', TRUE);
                if ($currency == NULL) {
                    $this->form_validation->
                            set_message('check_price_field', "<p style='color:red;'>currency is required </p>");
                    return FALSE;
                } else {
                    return TRUE;
                }
            }
        }
    }

    public function check_feature_price_talhatraining_field() {
        $feature_price_talhatraining = $this->input->post('feature_price_talhatraining', TRUE);
        $feature_price_status = $this->input->post('feature_price_status', TRUE);
        if ($feature_price_talhatraining > 2 || $feature_price_talhatraining < 1) {
            $this->form_validation->set_message('check_feature_price_talhatraining_field', "<p style='color:red;'>Please select this field</p>");
            return FALSE;
        }
        if ($feature_price_status == 3) { // for free
            if ($feature_price_talhatraining == 1) {
                $this->form_validation->set_message('check_feature_price_talhatraining_field', "<p style='color:red;'>Feature price talhatraining field cant not be yes for free</p>");
                return FALSE;
            } else if ($feature_price_talhatraining == 2) {
                return TRUE;
            }
        } else if ($feature_price_status == 1) { // for Active
            if ($feature_price_talhatraining == 1) { // tt feature
                $return_data = $this->check_resource_person_feature_status();
                if ($return_data['allow'] == 1) {
                    return TRUE;
                } else if ($return_data['allow'] == 2) {
                    $this->form_validation->set_message('check_feature_price_talhatraining_field', "<p style='color:red;'>Pleare Select Resouce person</p>");
                    return FALSE;
                } else if ($return_data['allow'] == 3) {
                    $this->form_validation->set_message('check_feature_price_talhatraining_field', "<p style='color:red;'>one or more resource person already assign another feature</p>");
                    return FALSE;
                }
            } else { // for paid feature
                return TRUE;
            }
        } else if ($feature_price_status == 0) { // for inactive
            if ($feature_price_talhatraining == 1) { // tt feature
                return TRUE;
            } else if ($feature_price_talhatraining == 2) { // for paid feature
                return TRUE;
            }
        }
    }

    public function check_resource_person_feature_status() {
        $free_virtual_classroom_feature = $this->vc_model->select_tt_virtual_classroom_feature();

        $person_id = $this->session->userdata('person_id');
        $to_address = $this->input->post('to_address', true);
        $to_address = explode(',', $to_address);
        if ($to_address[count($to_address) - 1] == '') {
            array_pop($to_address);
        }
        $data['tt_resource_person'] = $this->vc_model->select_talhatraining_resource_person();
        $resource_person_id = array();
        $feature_holding_person = '';
        foreach ($data['tt_resource_person'] as $v_resource_person) {
            if ($v_resource_person->person_id != $person_id) {
                $resource_person_id[] = $v_resource_person->person_id;

                $feature_price_id = $v_resource_person->feature_price_id;
                $feature_price_id = explode(',', $feature_price_id);
                if (in_array($feature_price_id[0], $free_virtual_classroom_feature) && in_array($v_resource_person->person_id, $to_address)) {
                    $feature_holding_person .= $v_resource_person->person_email . ', ';
                }
            }
        }

        $validate = TRUE;
        if ($to_address) {
            foreach ($to_address as $value) {
                if (!in_array($value, $resource_person_id)) {
                    $validate = FALSE;
                }
            }
        } else {
            $data['allow'] = 3;
            return $data;
        }

        if ($feature_holding_person) {
            $feature_holding_person = explode(',', $feature_holding_person);
            array_pop($feature_holding_person);
            $person = implode(',', $feature_holding_person);
            if (count($feature_holding_person) > 1) {
                $data['feature_holding_person_data'] = '<span style=color:grey>' . $person . '</span>' . ' <p> are selected another virtual classroom feature ';
            } else {
                $data['feature_holding_person_data'] = '<span style=color:grey>' . $person . '</span>' . '<p> is selected another virtual classroom feature ';
            }
        }
        if ($validate == TRUE) {
            $data['allow'] = 1;
            return $data;
        } else {
            $data['allow'] = 2;
            return $data;
        }
    }

}
