<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Super_admin_video extends TT_admin_login {

    public function __construct() {
        parent::__construct();
    }

    /*
     * @author Suddam Hossain
     * function index-> view video management form
     * parameter $person_id 
     * date:05/05/2015
     */

    public function index() {
        $data = array();
        $data['user_role'] = '';
        $data['active'] = 'video_management';
        $data['video_content'] = '';
        /*
         * Video Training Category
         */
        $data['video_category'] = $this->super_admin_video_model->select_video_category();
        $data['video_category_count'] = count($data['video_category']);

        /*
         * Video Training List
         */
        $data['video_training_list'] = $this->super_admin_video_model->select_video_training_list();
        $data['video_category_count'] = count($data['video_category']);

        $data['main_content'] = $this->load->view('admin/video/video_training_list', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /*
      -----------@@@RIPON@ Start Video Course Part----------------------------------
     */

    /**
     * @Function            : add_video_course 
     * @Used IN             : @function-'Self'  super_admin_video[@controller],
     * @Description         : Add video course   
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 10-02-2016 03:39 PM  
     * @Status              : available      
     * */
    public function add_video_course() {
        $this->form_validation->set_rules('video_course_title', 'Video Course Title', 'required|trim');
        $this->form_validation->set_rules('menu_id', 'Menu ID');
        $this->form_validation->set_rules('course_category_id', 'Category Name', 'required');
        $this->form_validation->set_rules('resource_person_id', 'Resource Person', 'required');
        $this->form_validation->set_rules('video_management_level', 'Video Course Level', 'required');
        $this->form_validation->set_rules('video_course_url', 'Video Course Url', 'required|trim|callback_url_check');
        $this->form_validation->set_rules('video_folder_name', 'Video Course Folder', 'required|trim|callback_folder_check');
        $this->form_validation->set_rules('video_management_author', 'Video Course Author');
        $this->form_validation->set_rules('video_management_meta_title', 'Video Course Meta Title', 'trim');
        $this->form_validation->set_rules('video_management_keyword', 'Video Course Topic');
        $this->form_validation->set_rules('video_management_meta_keywords', 'Video Course Meta Keyword');
        $this->form_validation->set_rules('video_management_meta_description', 'Video Course Meta Description', 'trim');
        $this->form_validation->set_rules('video_training_objectives', 'Video Course Training Objective');
        $this->form_validation->set_rules('video_training_outline', 'Video Course Training Outline');
        $this->form_validation->set_rules('video_language', 'Video Course Language', 'required');
        $this->form_validation->set_rules('video_access_level', 'Video Course Access Level', 'required');
        $this->form_validation->set_rules('video_management_rating', 'Video Course Rating');
        $this->form_validation->set_rules('video_course_type', 'Video Course Type', 'required');

        if ($this->input->post('video_course_type', TRUE) == 1) {
            $this->form_validation->set_rules('video_course_price_currency', 'Video Course Type', 'required');
            $this->form_validation->set_rules('video_course_price', 'Video Course Price', 'required|trim|numeric|greater_than[0]');
        }
        $this->form_validation->set_rules('video_management_status', 'Video Course Status', 'required');
        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['active_menu'] = 'video_course';
            $data['active_sub_menu'] = 'add_video_course';

            $data['all_menu'] = $this->super_admin_video_model->select_all_menu();
            $data['all_course_category'] = $this->super_admin_video_model->select_all_course_category_for_course();
            $data['resource_persons'] = $this->super_admin_video_model->select_all_resource_persons();
            $data['main_content'] = $this->load->view('admin/video/add_video_course', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $url_id = $this->url_model->save_video_course_url();
            $this->super_admin_video_model->save_video_course_information($url_id);
            redirect('manage-video-course');
        }
    }

    /**
     * @Function            : edit_video_course 
     * @Used IN             : @function-'Self'  super_admin_video[@controller],
     * @Description         : Edit Video Course
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-02-2016 02:41 PM  
     * @Status              : available      
     * */
    public function edit_video_course($video_course_url) {
        $data['video_course_info'] = $this->super_admin_video_model->get_single_video_course_information_by_url($video_course_url);
        $data['all_video_section'] = $this->super_admin_video_model->select_all_video_course_section_by_video_course_id($data['video_course_info']->video_management_id);

        $this->form_validation->set_rules('video_course_title', 'Video Course Title', 'required|trim');
        $this->form_validation->set_rules('menu_id', 'Menu ID');
        $this->form_validation->set_rules('course_category_id', 'Category Name', 'required');
        $this->form_validation->set_rules('resource_person_id', 'Resource Person', 'required');
        $this->form_validation->set_rules('video_management_level', 'Video Course Level', 'required');

        if ($data['video_course_info']->url != $this->input->post('video_course_url', TRUE)) {
            $this->form_validation->set_rules('video_course_url', 'Video Course Url', 'required|trim|callback_url_check');
        }

        $this->form_validation->set_rules('video_management_author', 'Video Course Author');
        $this->form_validation->set_rules('video_management_meta_title', 'Video Course Meta Title', 'trim|max_length[35]');
        $this->form_validation->set_rules('video_management_keyword', 'Video Course Topic');
        $this->form_validation->set_rules('video_management_meta_keywords', 'Video Course Meta Keyword');
        $this->form_validation->set_rules('video_management_meta_description', 'Video Course Meta Description', 'trim');
        $this->form_validation->set_rules('video_training_objectives', 'Video Course Training Objective');
        $this->form_validation->set_rules('video_training_outline', 'Video Course Training Outline');
        $this->form_validation->set_rules('video_language', 'Video Course Language', 'required');
        $this->form_validation->set_rules('video_access_level', 'Video Course Access Level', 'required');
        $this->form_validation->set_rules('video_management_rating', 'Video Course Rating');
        $this->form_validation->set_rules('video_course_type', 'Video Course Type', 'required');

        if ($this->input->post('video_course_type', TRUE) == 1) {
            $this->form_validation->set_rules('video_course_price_currency', 'Video Course Type', 'required');
            $this->form_validation->set_rules('video_course_price', 'Video Course Price', 'required|trim|numeric|greater_than[0]');
        }
        $this->form_validation->set_rules('video_management_status', 'Video Course Status', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['active_menu'] = 'video_course';
            $data['active_sub_menu'] = 'manage_video_course';

            $data['all_menu'] = $this->super_admin_video_model->select_all_menu($data['video_course_info']->menu_id);
            $data['all_course_category'] = $this->super_admin_video_model->select_all_course_category_for_course();
            $data['resource_persons'] = $this->super_admin_video_model->select_all_resource_persons();
            $data['main_content'] = $this->load->view('admin/video/edit_video_course', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $new_video_url = $this->input->post('video_course_url', TRUE);
            if ($data['video_course_info']->url != $new_video_url) {
                $this->url_model->update_video_course_url($data['video_course_info']->url_id, $this->input->post('video_course_url', TRUE));
            }
            $this->super_admin_video_model->update_video_course_information($data['video_course_info'], $new_video_url);
            redirect('manage-video-course');
        }
    }

    /**
     * @Function            : manage_video_course 
     * @Used IN             : @function-'Self'  super_admin_video[@controller],
     * @Description         : Manage all of video video using 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-02-2016 12:42 PM  
     * @Status              : available      
     * */
    public function manage_video_course($arg = NULL) {
        $data = array();
        $data['active_menu'] = 'video_course';
        $data['active_sub_menu'] = 'manage_video_course';

        if ($arg != NULL) {
            $data['page'] = $arg;
            $number = $arg * 10 - 10;
        } else {
            $data['page'] = 0;
            $number = 0;
        }
        $data['all_video_courses'] = $this->super_admin_video_model->select_all_video_course($number);
        $data['total_video_courses'] = $this->super_admin_video_model->get_total_video_course();
        $data['main_content'] = $this->load->view('admin/video/manage_video_course', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : get_video_course_by_search_value 
     * @Used IN             : @function-'Self'  super_admin_video[@controller],
     * @Description         : view video course by search
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-02-2016 11:00 AM  
     * @Status              : available      
     * */
    public function get_video_course_by_search_value() {
        $search_value = $this->input->post('search_value', TRUE);
        $search_value1 = '';
        if (trim($search_value) != '') {
            $search_value1 = $search_value;
        } else {
            $search_value1 = '';
        }
        $data['page'] = 0;
        $number = 0;
        $data['all_video_courses'] = $this->super_admin_video_model->select_all_video_course($number, $search_value1);
        $data['total_video_courses'] = $this->super_admin_video_model->get_total_video_course();
        echo $this->load->view('admin/video/ajax_page/view_video_courses', $data, true);
    }

    /**
     * @Function            : change_video_course_status_by_id 
     * @Used IN             : @function-'Self'  super_admin_video[@controller],
     * @Description         : Change Video Course Status
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-02-2016 01:42 PM  
     * @Status              : available      
     * */
    public function change_video_course_status_by_id() {
        $video_management_id = $this->input->post('video_management_id', TRUE);
        $status = $this->input->post('change_status', TRUE);
        $this->super_admin_video_model->change_video_course_status_by_id($video_management_id, $status);
        $data['video_course_value'] = $this->super_admin_video_model->get_single_video_course_information_by_id($video_management_id);
        echo $this->load->view('admin/video/ajax_page/view_change_status', $data, true);
    }

    /**
     * @Function            : url_check (php ser validation)
     * @Used IN             : @function-'add_video_course'  this[@controller],
     * @Description         : Ckeck all kinf of validation in a URl and check if it is exists  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-02-2016 12:45 PM
     * @Status              : available      
     * */
    public function url_check($url) {
        $sp = '/[!@#$%&*()^,._;:]/';
        if (preg_match($sp, $url)) {
            $this->form_validation->set_message('url_check', "URL Cann't contain any '/[!@#$%&*()^,._;:]/'  if need use '-' Don't use Space");
            return FALSE;
        } else if (preg_match('/[A-Z]/', $url)) {
            $this->form_validation->set_message('url_check', "URL Cann't contain any UpperCase Letter");
            return FALSE;
        } else if (strstr($url, ' ')) {
            $this->form_validation->set_message('url_check', " Don't use Space if need use '-', alse URL Cann't contain any special carecter like '/[!@#$%&*()^,._;:-]/'");
            return FALSE;
        } else if ($this->url_model->check_url_existence($url) == 1) {
            $this->form_validation->set_message('url_check', "This URL Already Exist");
            return FALSE;
        } else {
            $this->form_validation->set_message('url_check', "OK");
            return TRUE;
        }
    }

    /**
     * @Function            : check_video_course_keyword (php ser validation)
     * @Used IN             : @function-'add_video_course'  this[@controller],
     * @Description         : check empty Video course keywork  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-02-2016 12:59 PM
     * @Status              : available      
     * */
    public function check_video_course_keyword() {
        if ($this->input->post('video_management_keyword', TRUE)) {
            $video_course_keywords = $this->input->post('video_management_keyword', TRUE);
            $video_course_meta_keywords_string = implode(",", $video_course_keywords);
            $total_character = strlen($video_course_meta_keywords_string);
            if ($total_character < 80) {
                $video_course_keywords1 = array_filter($video_course_keywords, 'strlen');
                foreach ($video_course_keywords1 as $value) {
                    $value = trim($value);
                    if (empty($value)) {
                        $this->form_validation->set_message('check_video_course_keyword', "Can not insert empty value");
                        return FALSE;
                    } else {
                        continue;
                    }
                }
            } else {
                $this->form_validation->set_message('check_video_course_keyword', "Video Course Topic must contain less than 80 character");
                return FALSE;
            }
        }
    }

    /**
     * @Function            : check_video_course_meta_keyword (php ser validation)
     * @Used IN             : @function-'add_video_course'  this[@controller],
     * @Description         : check empty Video course keywork  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-02-2016 01:15 PM
     * @Status              : available      
     * */
    public function check_video_course_meta_keyword() {
        if ($this->input->post('video_management_meta_keywords', TRUE)) {
            $video_course_keywords = $this->input->post('video_management_meta_keywords', TRUE);
            $video_course_meta_keywords_string = implode(",", $video_course_keywords);
            $total_character = strlen($video_course_meta_keywords_string);
            if ($total_character < 80) {
                $video_course_keywords1 = array_filter($video_course_keywords, 'strlen');
                foreach ($video_course_keywords1 as $value) {
                    $value = trim($value);
                    if (empty($value)) {
                        $this->form_validation->set_message('check_video_course_meta_keyword', "Can not insert empty value");
                        return FALSE;
                    } else {
                        continue;
                    }
                }
            } else {
                $this->form_validation->set_message('check_video_course_meta_keyword', "Video Course Topic must contain less than 80 character");
                return FALSE;
            }
        }
    }

    /**
     * @Function            : check_video_course_url_exists 
     * @Used IN             : @function-'Self'  super_admin_video[@controller],
     * @Description         : Add video course   
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-02-2016 12:08 PM  
     * @Status              : available      
     * */
    public function check_video_course_url_exists() {
        $url_status = $this->input->post('url_status', TRUE);
        $video_url = $this->input->post('video_course_url', TRUE);
        if ($url_status == '1') {
            echo $this->url_model->check_url_exists($video_url);
        } else {
            echo $this->url_model->check_url_exists1($video_url);
        }
    }

    /**
     * @Function            : check_video_folder_name_exists 
     * @Used IN             : @function-'Self'  super_admin_video[@controller],
     * @Description         : Add video course   
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-02-2016 12:08 PM  
     * @Status              : available      
     * */
    public function check_video_folder_name_exists() {
        $video_folder_name = $this->input->post('video_folder_name', TRUE);
        $diriectory1 = scandir('content-library/' . $this->session->userdata('person_url') . '/my-video/');
        $diriectory = array_map('strtolower', $diriectory1);
        if (in_array(strtolower($video_folder_name), $diriectory)) {
            echo 1;
        } else {
            echo 2;
        }
    }

    /**
     * @Function            : check_edit_video_folder_name_exists 
     * @Used IN             : @function-'Self'  super_admin_video[@controller],
     * @Description         : check edit video folder existence   
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-02-2016 01:43 PM  
     * @Status              : available      
     * */
    public function check_edit_video_folder_name_exists() {
        $video_folder_name = $this->input->post('video_folder_name', TRUE);
        $video_management_id = $this->input->post('video_management_id', TRUE);
        $result = $this->super_admin_video_model->get_single_video_course_information_by_id($video_management_id);
        $course_creator_url = $this->super_admin_video_model->get_profile_url($result->course_creator_id);

        if (trim($video_folder_name) == $result->video_folder_name) {
            echo 2;
        } else {
            $diriectory1 = scandir('content-library/' . $course_creator_url . '/my-video/');
            $diriectory = array_map('strtolower', $diriectory1);
            if (in_array(strtolower($video_folder_name), $diriectory)) {
                echo 1;
            } else {
                echo 2;
            }
        }
    }

    /**
     * @Function            : folder_check 
     * @Used IN             : @function-'add_video_course'  super_admin_video[@controller],
     * @Description         : Add video course   
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-02-2016 12:17 PM  
     * @Status              : available      
     * */
    public function folder_check($video_folder_name) {
        if ($this->session->person_role != 6) {
            redirect();
        }
        $regx = '/^[0-9a-zA-Z\-]+$/';
        $directory = 'content-library/' . $this->session->userdata('person_url') . '/my-video/';
        if (is_dir($directory)) {
            //$diriectory1 = scandir('content-library/' . $this->session->userdata('person_url') . '/my-video/');
            //$diriectory = array_map('strtolower', $diriectory1);            
            $directory_content = array_map('strtolower', scandir($directory));
            if (in_array(strtolower($video_folder_name), $directory_content)) {
                $this->form_validation->set_message('folder_check', "Folder Name Already Exists");
                return FALSE;
            } elseif (!preg_match($regx, $video_folder_name)) {
                $this->form_validation->set_message('folder_check', " No Special Caracter Allow Accept ' - ' ");
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /*
      -----------@@@RIPON@ End Video Course Part----------------------------------
     */




    /*
      -----------@@@RIPON@ Start Video Course Work File Part----------------------------------
     */

    /**
     * @Function            : add_video_course_work_file 
     * @Used IN             : @function-'Self'      this[@controller],
     * @Description         : Add all course work file 
     * @                    : @Update1 - check codignitor validation and send file into model for save 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-02-2016 04:32 PM
     * @Updated Date Time   : 22-02-2016 10:15 AM
     * @Updated By          : Ripon Jaherul    
     * @Status              : available      
     * */
    public function add_video_course_work_file() {
        $this->form_validation->set_rules('course_category_id', 'Video Course Category', 'required');
        $this->form_validation->set_rules('course_id', 'Video Course Title', 'required');
        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['active_menu'] = 'video_course';
            $data['active_sub_menu'] = 'add_video_work_file';

            $data['section_counter'] = 1;
            $data['video_counter'] = 1;
            $data['all_course_category'] = $this->super_admin_video_model->select_all_course_category_for_course();
            $data['main_content'] = $this->load->view('admin/video/add_video_work_file', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_video_model->save_video_course_work_file();
            redirect('manage-video-work-file');
        }
    }

    /**
     * @Function            : edit_video_course_work_file 
     * @Used IN             : @function-'Self'           this[@controller],
     * @Description         : edit video course work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 22-02-2016 06:59 PM
     * @Updated Date Time   : 23-02-2016 10:46 AM
     * @Updated By          : Ripon Jaherul  
     * @Status              : available      
     * */
    public function edit_video_course_work_file($video_course_url) {
        $this->form_validation->set_rules('course_category_id', 'Video Course Category', 'required');
        $this->form_validation->set_rules('course_id', 'Video Course Title', 'required');
        if ($this->form_validation->run() == FALSE) {
            $data['active_menu'] = 'video_course';
            $data['active_sub_menu'] = 'manage_video_work_file';
            $data['section_counter'] = 0;
            $data['video_course_info'] = $this->super_admin_video_model->get_single_video_course_information_by_url($video_course_url);
            $data['all_video_section'] = $this->super_admin_video_model->select_all_video_course_section_by_video_course_id($data['video_course_info']->video_management_id);
            foreach ($data['all_video_section'] as $section_value) {
                $data['upload_video_info'][$section_value->upload_video_section_name] = $this->super_admin_video_model->get_all_upload_id_by_section_name1($data['video_course_info']->video_management_id, $section_value->upload_video_section_name);
                foreach ($data['upload_video_info'][$section_value->upload_video_section_name] as $upload_video_value) {
                    if ($upload_video_value->video_work_files == 1) {
                        $data['video_work_file_info'][$upload_video_value->upload_video_id] = $this->super_admin_video_model->get_work_file_info_by_video_upload_id($upload_video_value->upload_video_id);
                    }
                }
            }
            $data['main_content'] = $this->load->view('admin/video/edit_video_work_file', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_video_model->save_video_course_work_file();
            redirect('manage-video-work-file');
        }
    }

    /**
     * @Function            : add_video_course_work_file 
     * @Used IN             : @function-'Self'      this[@controller],
     * @Description         : Add all course work file 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 22-02-2016 03:44 PM 
     * @Status              : available      
     * */
    public function manage_video_course_work_file() {
        $data = array();
        $data['active_menu'] = 'video_course';
        $data['active_sub_menu'] = 'manage_video_work_file';

        $data['all_video_courses'] = $this->super_admin_video_model->select_all_video_course_by_video_work_file();
        foreach ($data['all_video_courses'] as $video_course_value) {
            $data['total_course_video'][$video_course_value->video_management_id] = count($this->super_admin_video_model->select_all_course_video_details_by_video_course_id($video_course_value->video_management_id));
        }
        $data['main_content'] = $this->load->view('admin/video/manage_video_work_file', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : view_video_course_work_file 
     * @Used IN             : @function-'Self'      this[@controller],
     * @Description         : view all uploaded video file using video_course_id 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 22-02-2016 04:53 PM 
     * @Status              : available      
     * */
    public function view_video_course_work_file($video_course_url) {
        $video_course_info = $this->super_admin_video_model->get_single_video_course_information_by_url($video_course_url);
        $data['serial'] = 0;
        $data['active_menu'] = 'video_course';
        $data['active_sub_menu'] = 'manage_video_work_file';
        $data['all_uploaded_video'] = $this->super_admin_video_model->select_all_course_video_details_by_video_course_id($video_course_info->video_management_id);
        foreach ($data['all_uploaded_video'] as $upload_video_value) {
            $data['video_work_file'][$upload_video_value->upload_video_id] = $this->super_admin_video_model->get_work_file_info_by_video_upload_id($upload_video_value->upload_video_id);
        }
        $data['main_content'] = $this->load->view('admin/video/view_video_work_file', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : get_video_course_value_by_category_id 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : get all available course using category ID  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-02-2016 04:33 PM    
     * @Status              : available      
     * */
    function get_video_course_value_by_category_id() {
        $category_id = $this->input->post('category_id', TRUE);
        $data['video_courses'] = $this->super_admin_video_model->get_all_course_by_category_id($category_id);
        echo $this->load->view('admin/video/ajax_page/course_dropdown_view', $data, true);
    }

    /**
     * @Function            : add_video_course_section_area 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : Add Video course Section area
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 21-02-2016 01:00 PM    
     * @Status              : available      
     * */
    function add_video_course_section_area() {
        $section_counter = $this->input->post('section_counter', TRUE);
        $video_management_id = $this->input->post('video_management_id', TRUE);
        $data['section_counter'] = ++$section_counter;
        $data['video_counter'] = 1;
        $data['video_course_info'] = $this->super_admin_video_model->get_single_video_course_information_by_id($video_management_id);
        echo $this->load->view('admin/video/ajax_page/view_video_section', $data, true);
    }

    /**
     * @Function            : remove_video_course_section_area 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : Remove Video course Section area
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 21-02-2016 12:05 AM    
     * @Status              : available      
     * */
    function remove_video_course_section_area() {
        $all_upload_video_id = $this->input->post('all_upload_video_id', TRUE);
        $all_upload_video_id_array = explode(',', $all_upload_video_id);

        $upload_video_info = $this->super_admin_video_model->get_upload_video_information_by_upload_video_id($all_upload_video_id_array[0]);
        $course_creator_url = $this->super_admin_video_model->get_profile_url($upload_video_info->course_creator_id);
        $section_directory = 'content-library/' . $course_creator_url . '/my-video/' . $upload_video_info->video_folder_name . '/' . $upload_video_info->upload_video_section_name;
        if (is_dir($section_directory)) {
            $this->super_admin_video_model->remove_directory($section_directory);
        }

        for ($i = 0; $i < count($all_upload_video_id_array); $i++) {
            $video_work_file_info = $this->super_admin_video_model->get_work_file_info_by_video_upload_id($all_upload_video_id_array[$i]);
            if ($video_work_file_info) {
                $this->super_admin_video_model->remove_upload_video_course_work_file_by_work_file_id($video_work_file_info->work_files_management_id);
            }
            $this->super_admin_video_model->delete_single_video_course_by_upload_video_id($all_upload_video_id_array[$i]);
        }
        echo 'success';
    }

    /**
     * @Function            : view_video_section_by_video_course_id 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : View Video section using course ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 17-02-2016 07:56 PM    
     * @Status              : available      
     * */
    function view_video_section_by_video_course_id() {
        $video_management_id = $this->input->post('video_management_id', TRUE);
        $data['section_counter'] = 1;
        $data['video_counter'] = 1;
        $data['video_course_info'] = $this->super_admin_video_model->get_single_video_course_information_by_id($video_management_id);
        echo $this->load->view('admin/video/ajax_page/view_video_section', $data, true);
    }

    /**
     * @Function            : check_video_course_work_file_name_existence 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : check video course work file name existence
     * @                    : @Update1 - change a single upload ID for whole work file in video section
     * @                    : @Update1 - add same video upload is check
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 17-02-2016 11:55 AM
     * @Updated Date Time   : 20-02-2016 11:11 AM   |   23-02-2016 12:56 AM
     * @Updated By          : Ripon Jaherul         |   Ripon Jaherul           
     * @Status              : available      
     * */
    function check_video_course_work_file_name_existence() {
        $all_upload_video_id_array = array();
        $upload_video_id = $this->input->post('upload_video_id', TRUE);
        $upload_video_id1 = $this->input->post('upload_video_id1', TRUE);
        $upload_video_info = $this->super_admin_video_model->get_upload_video_information_by_upload_video_id($upload_video_id);
        $all_upload_video_id = $this->super_admin_video_model->get_all_upload_id_by_section_name1($upload_video_info->video_management_id, $upload_video_info->upload_video_section_name);
        foreach ($all_upload_video_id as $value) {
            $all_upload_video_id_array[] = $value->upload_video_id;
        }
        $work_files_name = $this->input->post('work_files_name', TRUE);
        $result = $this->super_admin_video_model->check_video_course_work_file_name_existence(implode(',', $all_upload_video_id_array), $work_files_name, $upload_video_id1);
        if ($result) {
            echo 1;
        } else {
            echo 2;
        }
    }

    /**
     * @Function            : check_video_section_name_existence 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : Check video section name and existence
     * @                    : @Update1 -> add all_upload_id for check
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-02-2016 05:42 PM
     * @Updated Date Time   : 23-02-2016 12:07 PM
     * @Updated By          : Ripon Jaherul          
     * @Status              : available      
     * */
    function check_video_section_name_existence() {
        $video_section_name = $this->input->post('video_section_name', TRUE);
        $video_management_id = $this->input->post('video_management_id', TRUE);
        $all_upload_id1 = explode(',', $this->input->post('all_upload_id', TRUE));
        $all_upload_id = array_filter($all_upload_id1);

        if ($video_section_name != '' && $video_management_id != '') {
            $result = $this->super_admin_video_model->check_video_course_section_name($video_management_id, $video_section_name, implode(',', $all_upload_id));
            if ($result) {
                echo 1;
            } else {
                echo 2;
            }
        }
    }

    /**
     * @Function            : check_video_name_existence 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : Check video name and existence
     * @                    : @Update1 - check section_name using Upolad_video_id
     * @                    : @Update2 - check Upolad_video_id in Query if same name does not exists
     *  @Developed By       : Ripon Jaherul
     * @Start DateTime      : 15-02-2016 01:11 PM 
     * @Updated Date Time   : 20-02-2016 10:30 AM   |   23-02-2016 12:13 PM
     * @Updated By          : Ripon Jaherul         |   Ripon Jaherul    
     * @Status              : available      
     * */
    function check_video_name_existence() {
        $upload_video_id = $this->input->post('upload_video_id', TRUE);
        $upload_video_id1 = $this->input->post('upload_video_id1', TRUE);
        $upload_video_info = $this->super_admin_video_model->get_upload_video_information_by_upload_video_id($upload_video_id);
        $video_management_id = $this->input->post('video_management_id', TRUE);
        $video_name = $this->input->post('upload_video_name', TRUE);

        $result = $this->super_admin_video_model->check_upload_video_name($video_management_id, $upload_video_info->upload_video_section_name, $video_name, $upload_video_id1);
        if ($result) {
            echo 1;
        } else {
            echo 2;
        }
    }

    /**
     * @Function            : upload_video_for_video_course 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : Upload video in database as a draft
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 16-02-2016 10:42 AM    
     * @Status              : available      
     * */
    function upload_video_for_video_course() {
        ini_set('max_execution_time', 7200);
        $upload_video_id = $this->input->post('upload_video_id', TRUE);
        $all_upload_video_id_array1 = explode(',', $this->input->post('all_upload_video_id', TRUE));
        $all_upload_video_id_array = array_filter($all_upload_video_id_array1);

        if ($_FILES['video_file']) {
            $fileTmpLoc = $_FILES["video_file"]["tmp_name"];
            $fileName = $_FILES["video_file"]["name"];
            $fileSize = $_FILES["video_file"]["size"];
            if (!$fileTmpLoc) { // if file not chosen
                echo "error";
            } else {
                if ($fileSize < 524288000) {
//--------comment out before project upload in live server 
                    $data['video_management_id'] = $this->input->post('video_management_id', TRUE);
                    $data['upload_video_name'] = $video_name = $this->input->post('upload_video_name', TRUE);
                    $data['upload_video_size'] = $fileSize;
                    $data['upload_video_time_length'] = $this->get_video_duration($fileTmpLoc);
                    $data['upload_video_date'] = date('Y/m/d H:i:s', (time() - $this->session->userdata('time_offset')));
                    $data['upload_video_transcript'] = $this->input->post('upload_video_transcript', TRUE);
                    $data['upload_video_access_level'] = $this->input->post('upload_video_access_level', TRUE);
                    $data['upload_video_status'] = 5;
                    $data['video_work_files'] = 2;
                    $video_course_info = $this->super_admin_video_model->get_single_video_course_information_by_id($data['video_management_id']);
                    $course_creator_url = $this->super_admin_video_model->get_profile_url($video_course_info->course_creator_id);

                    // Make course video Section folder
                    if ($upload_video_id == '') {
                        if (!$all_upload_video_id_array) {
                            $data['upload_video_section_name'] = $this->input->post('upload_video_section_name', TRUE);
                            $directory_folder_name = str_replace(' ', '-', trim($video_course_info->video_folder_name));
                            $directory_video_section_name = str_replace(' ', '-', trim($this->input->post('upload_video_section_name', TRUE)));
                            $make_diriectory = 'content-library/' . $course_creator_url . '/my-video/' . $directory_folder_name . '/' . $directory_video_section_name . '/';
                            mkdir($make_diriectory, 0777, true);
                        } else {
                            $video_upload_info = $this->super_admin_video_model->get_upload_video_information_by_upload_video_id($all_upload_video_id_array[0]);
                            $data['upload_video_section_name'] = $video_upload_info->upload_video_section_name;
                        }
                    } else {
                        $video_upload_info = $this->super_admin_video_model->get_upload_video_information_by_upload_video_id($upload_video_id);
                        $file_path = 'content-library/' . $course_creator_url . $video_upload_info->upload_video_location;
                        if (file_exists($file_path)) {
                            unlink($file_path);
                        }
                        $data['upload_video_section_name'] = $video_upload_info->upload_video_section_name;
                    }
                    $video_folder_name = str_replace(' ', '-', trim($video_course_info->video_folder_name));
                    $upload_video_section_name = str_replace(' ', '-', trim($data['upload_video_section_name']));

                    $section_diriectory = 'content-library/' . $course_creator_url . '/my-video/' . $video_folder_name . '/' . $upload_video_section_name . '/';

                    $target_file = $section_diriectory . $fileName;
                    if (move_uploaded_file($fileTmpLoc, $target_file)) {
                        $file_explode = explode('.', $fileName);
                        $file_extention = $file_explode[count($file_explode) - 1];

                        // convert flv format for all upload video
                        $video_name = str_replace(' ', '-', trim($video_name));
                        $source_file = "$section_diriectory$video_name.$file_extention";
                        rename("$target_file", "$source_file");


                        $conversion_file_detail['file_name'] = "$video_name.$file_extention";
                        $conversion_file_detail['file_ext'] = ".$file_extention";
                        $conversion_file_detail['full_path'] = FCPATH . $source_file;
                        $conversion_file_detail['file_path'] = str_replace($conversion_file_detail['file_name'], '', $conversion_file_detail['full_path']);
                        $this->load->library('tt_video_converter');
                        $time_start = microtime(true);
                        $test_output = $this->tt_video_converter->set_file($conversion_file_detail)
                                                ->convert_video()->get_full_report();
                        $time_end = microtime(true);
                        $test_output['required_conversion_time'] = $time_end - $time_start;
                        if(!isset($test_output['error_message']['conversion_error_720p'])) {
                            $video_location = "/my-video/$video_folder_name/$upload_video_section_name" . '_converted_720p.mp4';
                            $data['upload_video_location'] = str_replace("content-library/$course_creator_url", '', $video_location);
                            $data['conversion_data'] = json_encode($test_output);
                            if ($upload_video_id == '') {
                                echo $this->super_admin_video_model->save_information_in_database('tbl_upload_video', $data);
                            } else {
                                $this->super_admin_video_model->update_information_in_database('tbl_upload_video', 'upload_video_id', $upload_video_id, $data);
                                echo $upload_video_id;
                            }
                        }else{
                            echo 'error';
                        }
                    }
                } else {
                    echo 'error';
                }
            }
        }
    }

    /**
     * @Function            : upload_video_course_work_file 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : Upload video course work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 17-02-2016 12:12 AM    
     * @Status              : available      
     * */
    function upload_video_course_work_file() {
        $work_files_management_id = $this->input->post('work_files_management_id', TRUE);
        if ($_FILES['video_work_file']) {
            $fileTmpLoc = $_FILES["video_work_file"]["tmp_name"];
            $fileName = $_FILES["video_work_file"]["name"];
            $fileSize = $_FILES["video_work_file"]["size"];
            if (!$fileTmpLoc) {
                echo "error";
            } else {
                if ($fileSize != 0) {
                    if ($fileSize < 10485760) {
                        $upload_video_id = $this->input->post('upload_video_id', TRUE);
                        $upload_video_info = $this->super_admin_video_model->get_upload_video_information_by_upload_video_id($upload_video_id);
                        $course_creator_url = $this->super_admin_video_model->get_profile_url($upload_video_info->course_creator_id);

                        $data['upload_video_id'] = $upload_video_id;
                        $data['work_file_folder_name'] = $upload_video_info->upload_video_section_name;
                        $data['work_files_name'] = $work_files_name = $this->input->post('work_files_name', TRUE);
                        $data['work_files_upload_date'] = date('Y/m/d', (time() - $this->session->userdata('time_offset')));
                        $data['work_file_size'] = $fileSize;
                        $data['work_files_management_access_level'] = $this->input->post('work_files_management_access_level', TRUE);
                        $data['work_files_status'] = 3;

                        $diriectory = 'content-library/' . $course_creator_url . '/my-video/' . $upload_video_info->video_folder_name . '/' . str_replace(' ', '-', $upload_video_info->upload_video_section_name) . '/';
                        if ($work_files_management_id != '') {
                            $video_work_file_info = $this->super_admin_video_model->get_upload_video_work_file_info_by_work_file_id($work_files_management_id);
                            $file_path = 'content-library/' . $course_creator_url . $video_work_file_info->work_files_url;
                            if (file_exists($file_path)) {
                                unlink($file_path);
                            }
                        }

                        $target_file = $diriectory . $fileName;
                        if (move_uploaded_file($fileTmpLoc, $target_file)) {
                            $file_explode = explode('.', $fileName);
                            $file_extention = $file_explode[count($file_explode) - 1];
                            $destination_file = $diriectory . "$work_files_name.$file_extention";
                            rename("$target_file", "$destination_file");
                            $data['work_files_url'] = '/my-video/' . $upload_video_info->video_folder_name . '/' . str_replace(' ', '-', $upload_video_info->upload_video_section_name ) . '/' . "$work_files_name.$file_extention";
                            //$this->cf->dd($data['work_files_url']);
                            if ($work_files_management_id == '') {
                                $this->super_admin_video_model->change_work_file_status_in_course_video($upload_video_id, 1);
                                echo $this->super_admin_video_model->save_information_in_database('tbl_work_files_management', $data);
                            } else {
                                $this->super_admin_video_model->update_information_in_database('tbl_work_files_management', 'work_files_management_id', $work_files_management_id, $data);
                                echo $work_files_management_id;
                            }
                        }
                    } else {
                        echo 'error';
                    }
                } else {
                    echo 'error';
                }
            }
        }
    }

    /**
     * @Function            : delete_video_course_all_video_file 
     * @Used IN             : @function-'deleteCourseVideoFile'             video_course.js
     * @Description         : Delete all video course Video file with work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 23-02-2016 01:25 PM    
     * @Status              : available      
     * */
    function delete_video_course_all_video_file() {
        $all_upload_id = Array();
        $video_course_id = $this->input->post('video_course_id', TRUE);
        $video_course_info = $this->super_admin_video_model->get_single_video_course_information_by_id($video_course_id);
        $course_creator_url = $this->super_admin_video_model->get_profile_url($video_course_info->course_creator_id);
        $all_upload_video_info = $this->super_admin_video_model->select_all_course_video_details_by_video_course_id($video_course_id);

        $diriectory = 'content-library/' . $course_creator_url . '/my-video/' . $video_course_info->video_folder_name . '/';
        if (is_dir($diriectory)) {
            $this->super_admin_video_model->remove_directory($diriectory);
        }
        if (!is_dir($diriectory)) {
            mkdir($diriectory, 0777, true);
        }
        foreach ($all_upload_video_info as $upload_video_value) {
            $all_upload_id[] = $upload_video_value->upload_video_id;
        }
        $this->super_admin_video_model->delete_all_video_course_work_file(implode(',', $all_upload_id));
        $this->super_admin_video_model->delete_all_course_video_file(implode(',', $all_upload_id));
        echo 'success';
    }

    /**
     * @Function            : delete_single_video_course_area 
     * @Used IN             : @function-'removeSingleVideo'             video_course.js
     * @                    : @function-'deleteSingleUploadVideo'       video_course.js
     * @Description         : Remove Single uploaded video course area with work file if it has been a work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 20-02-2016 05:34 PM
     * @Updated Date Time   : 22-02-2016 10:59 AM
     * @Updated By          : Ripon Jaherul     
     * @Status              : available      
     * */
    function delete_single_video_course_area() {
        $upload_video_id = $this->input->post('upload_video_id', TRUE);
        $upload_video_info = $this->super_admin_video_model->get_upload_video_information_by_upload_video_id($upload_video_id);
        $course_creator_url = $this->super_admin_video_model->get_profile_url($upload_video_info->course_creator_id);

        if (count($this->super_admin_video_model->get_all_upload_id_by_section_name1($upload_video_info->video_management_id, $upload_video_info->upload_video_section_name)) == 1) {
            $section_directory = 'content-library/' . $course_creator_url . '/my-video/' . $upload_video_info->video_folder_name . '/' . $upload_video_info->upload_video_section_name;
            if (is_dir($section_directory)) {
                $this->super_admin_video_model->remove_directory($section_directory);
            }
            $video_work_file_info = $this->super_admin_video_model->get_work_file_info_by_video_upload_id($upload_video_id);
            if ($video_work_file_info) {
                $this->super_admin_video_model->remove_upload_video_course_work_file_by_work_file_id($video_work_file_info->work_files_management_id);
            }
            $this->super_admin_video_model->delete_single_video_course_by_upload_video_id($upload_video_id);
        } else {
            $video_directory = 'content-library/' . $course_creator_url . $upload_video_info->upload_video_location;
            if (file_exists($video_directory)) {
                unlink($video_directory);
            }

            $video_work_file_info = $this->super_admin_video_model->get_work_file_info_by_video_upload_id($upload_video_id);
            if ($video_work_file_info) {
                $video_work_file_directory = 'content-library/' . $course_creator_url . $video_work_file_info->work_files_url;
                if (file_exists($video_work_file_directory)) {
                    unlink($video_work_file_directory);
                }
                $this->super_admin_video_model->remove_upload_video_course_work_file_by_work_file_id($video_work_file_info->work_files_management_id);
            }
            $this->super_admin_video_model->delete_single_video_course_by_upload_video_id($upload_video_id);
        }
        echo 'success';
    }

    /**
     * @Function            : remove_upload_video_course_work_file 
     * @Used IN             : @function-'removeUploadWorkFile'       video_course.js
     * @                    : @function-'deleteSingleWorkFile'       video_course.js
     * @Description         : Remove upload course work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 17-02-2016 05:22 AM    
     * @Status              : available      
     * */
    function remove_upload_video_course_work_file() {
        $work_files_management_id = $this->input->post('work_files_management_id', TRUE);
        $work_file_info = $this->super_admin_video_model->get_upload_video_work_file_info_by_work_file_id($work_files_management_id);
        $course_creator_url = $this->super_admin_video_model->get_profile_url($work_file_info->course_creator_id);
        $file_path = 'content-library/' . $course_creator_url . $work_file_info->work_files_url;
        if (file_exists($file_path)) {
            unlink($file_path);
        }
        $this->super_admin_video_model->change_work_file_status_in_course_video($work_file_info->upload_video_id, 2);
        $this->super_admin_video_model->remove_upload_video_course_work_file_by_work_file_id($work_files_management_id);
    }

    /**
     * @Function            : get_video_duration 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : get uploaded video duration
     * @Developed By        : Copied from---------- user_video[@Controller]
     * @Start DateTime      : 16-02-2016 12:14 AM    
     * @Status              : available      
     * */
    function get_video_duration($video_path) {
        $matches = '';
        $check_path = shell_exec("ffmpeg -i \"{$video_path}\" 2>&1");
        $search = '/Duration: (.*?),/';
        preg_match($search, $check_path, $matches);
        if (isset($matches[1])) {
            return $matches[1];
        } else {
            return 0;
        }
    }

    /**
     * @Function            : add_single_video_course_area 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : Add single video course area in video section
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 18-02-2016 12:03 PM    
     * @Status              : available      
     * */
    function add_single_video_course_area() {
        $video_counter = $this->input->post('video_counter', TRUE);
        $video_management_id = $this->input->post('video_management_id', TRUE);
        $data['section_counter'] = $this->input->post('section_counter', TRUE);
        $data['video_counter'] = ++$video_counter;
        $data['video_course_info'] = $this->super_admin_video_model->get_single_video_course_information_by_id($video_management_id);
        echo $this->load->view('admin/video/ajax_page/view_video_course_work_file', $data, true);
    }

    /**
     * @Function            : view_course_category_for_video_course 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : View Course Category if user does already upload single video work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 16-02-2016 03:53 AM    
     * @Status              : available      
     * */
    function view_course_category_for_video_course() {
        $video_management_id = $this->input->post('video_management_id', TRUE);
        $data['video_course_info'] = $this->super_admin_video_model->get_single_video_course_information_by_id($video_management_id);
        echo $this->load->view('admin/video/ajax_page/view_video_course_category', $data, true);
    }

    /**
     * @Function            : get_video_course_work_file_view 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : View Video Course Work file if user select work file 'YES'
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 16-02-2016 05:59 AM    
     * @Status              : available      
     * */
    function get_video_course_work_file_view() {
        $video_management_id = $this->input->post('video_management_id', TRUE);
        $data['section_counter'] = $this->input->post('section_counter', TRUE);
        $data['video_counter'] = $this->input->post('video_counter', TRUE);
        $data['video_course_info'] = $this->super_admin_video_model->get_single_video_course_information_by_id($video_management_id);
        echo $this->load->view('admin/video/ajax_page/view_single_work_file', $data, true);
    }

    /**
     * @Function            : view_course_category_for_video_course 
     * @Used IN             : @function-'Self'       this[@controller],
     * @Description         : View Video Course FIle Size
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 16-02-2016 03:59 AM    
     * @Status              : available      
     * */
    function view_video_course_file_size_by_video_course_id() {
        if ($_FILES['upload_file']) {
            $video_management_id = $this->input->post('video_management_id', TRUE);
            $result = $this->super_admin_video_model->get_single_video_course_information_by_id($video_management_id);
            $course_creator_url = $this->super_admin_video_model->get_profile_url($result->course_creator_id);
            $fileSize = '';
            $fileSize1 = $_FILES["upload_file"]["size"];
            $fileSize2 = round(($fileSize1 / 1024), 2);
            if ($fileSize2 > 1024) {
                $fileSize = round(($fileSize2 / 1024), 2) . ' MB';
            } else {
                $fileSize = ($fileSize2) . ' KB';
            }

            $dir = "content-library/" . $course_creator_url;
            $person_disk_space = $this->super_admin_video_model->person_available_disk_space($dir);
            if ($person_disk_space > 1048576) {
                $used_space = round(($person_disk_space / 1024 / 1024 / 1024), 2) . ' GB';
            } else {
                $used_space = round(($person_disk_space / 1024 / 1024), 2) . ' MB';
            }
            echo 'Your file size is <span style="color: red;">' . $fileSize . '</span>, and You have used <span style="color: red;">' . $used_space . '</span>';
        }
    }

    /*
      -----------@@@RIPON@ End Video Course Work File Part----------------------------------
     */

    /*
      -----------@@@RIPON@ Start Course Catgory Part----------------------------------
     */

    /**
     * @Function            : add_course_category 
     * @Used IN             : @self
     * @Description         : add Course Category from back-end user  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated1 Date Time  : 18-01-2016 01:38 PM
     * @Updated2 Date Time  : 06-02-2016 11:07 AM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function add_course_category() {
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_rules('course_category_name', 'Category Name', 'required|trim|max_length[150]|callback_course_category_name_check');
        $this->form_validation->set_rules('course_category_url', 'Category URL', 'required|trim|max_length[50]|callback_url_check');
        $this->form_validation->set_rules('course_category_id', 'Please Select Parent Menu');
        $this->form_validation->set_rules('course_category_author', 'Course Author');
        if ($this->input->post('course_category_id', TRUE)) {
            $this->form_validation->set_rules('course_category_id', 'Course Parent Category');
        }
        $this->form_validation->set_rules('course_category_description', 'Course Category Description');
        $this->form_validation->set_rules('course_category_meta_description', 'Course Category Meta Description');
        $this->form_validation->set_rules('to_address', 'Course Category Meta Key Words');
        $this->form_validation->set_rules('course_category_access_level', 'Access Level', 'required|trim');
        $this->form_validation->set_rules('course_category_home_page_view', 'Home Page View', '');
        $this->form_validation->set_rules('course_category_status', 'Status', 'required|max_length[1]');

        if ($this->form_validation->run() == FALSE) {
            $data['active_menu'] = 'video_course_category';
            $data['active_sub_menu'] = 'add_course_category';
            $data['all_course_category'] = $this->super_admin_video_model->select_all_course_category_name();
            $data['main_content'] = $this->load->view('admin/temporary/add_category_form', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            if ($_POST) {
                $course_category_url_id = $this->url_model->save_course_category_url();
                $this->super_admin_video_model->save_course_category_information($course_category_url_id);
                redirect('super-admin/manage-course-category');
            } else {
                redirect('super-admin/add-course-category');
            }
            redirect('super-admin/add-course-category');
        }
    }

    public function course_category_name_check($course_category_name) {
        $result = $this->super_admin_video_model->check_category_name_existance($course_category_name);
        if ($result) {
            $this->form_validation->set_message('course_category_name_check', "This Course Category Already Exists");
            return FALSE;
        } else {
            $this->form_validation->set_message('course_category_name_check', "OK");
            return TRUE;
        }
    }

    /**
     * @Function            : edit_course_category 
     * @Used IN             : @self
     * @Description         : Edit Course Category from back-end user  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated1 Date Time  : 18-01-2016 01:38 PM
     * @Updated2 Date Time  : 06-02-2016 11:21 AM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function edit_course_category($category_url) {
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $category_name = $this->input->post('course_category_name', TRUE);
        $old_category_name = $this->input->post('old_course_category_name', TRUE);
        $course_category_url = $this->input->post('course_category_url', TRUE);
        $old_category_url = $this->input->post('old_course_category_url', TRUE);

        if ($category_name == $old_category_name) {
            $this->form_validation->set_rules('course_category_name', 'Category Name', 'required|trim|max_length[150]');
        } else {
            $this->form_validation->set_rules('course_category_name', 'Category Name', 'required|trim|max_length[150]|callback_course_category_name_check');
        }
        if ($course_category_url == $old_category_url) {
            $this->form_validation->set_rules('course_category_url', 'Category URL', 'required|trim|max_length[50]');
        } else {
            $this->form_validation->set_rules('course_category_url', 'Category URL', 'required|trim|max_length[50]|callback_url_check');
        }

        $this->form_validation->set_rules('course_category_id', 'Please Select Parent Menu');
        $this->form_validation->set_rules('course_category_author', 'Course Author');
        if ($this->input->post('course_category_id', TRUE)) {
            $this->form_validation->set_rules('course_category_id', 'Course Parent Category');
        }
        $this->form_validation->set_rules('course_category_description', 'Course Category Description');
        $this->form_validation->set_rules('course_category_meta_description', 'Course Category Meta Description');
        $this->form_validation->set_rules('to_address', 'Course Category Meta Key Words');
        $this->form_validation->set_rules('course_category_access_level', 'Access Level', 'required|trim');
        $this->form_validation->set_rules('course_category_home_page_view', 'Home Page View', '');
        $this->form_validation->set_rules('course_category_status', 'Status', 'required|max_length[1]');
        if ($this->form_validation->run() == FALSE) {
            $data['active_menu'] = 'video_course_category';
            $data['active_sub_menu'] = 'manage_course_category';
            $data['category_value'] = $this->super_admin_video_model->get_single_category_by_url($category_url);
            $data['all_course_category'] = $this->super_admin_video_model->select_all_course_category_name_for_edit($category_url);
            $data['main_content'] = $this->load->view('admin/temporary/edit_category_form', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            if ($_POST) {
                $data['category_value'] = $this->super_admin_video_model->get_single_category_by_url($category_url);

                if ($course_category_url != $old_category_url) {
                    $this->url_model->update_course_category_url($course_category_url);
                }

                $this->super_admin_video_model->update_course_category_information($data['category_value']->course_category_id);
                redirect('super-admin/manage-course-category');
            }
        }
    }

    /**
     * @Function            : manage_course_category 
     * @Used IN             : @Self
     * @Description         : Manage course category and view change status also link to search
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 18-01-2016 05:40 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function manage_course_category($arg = NULL) {
        $data['active_menu'] = 'video_course_category';
        $data['active_sub_menu'] = 'manage_course_category';
        $data['page'] = 0;
        $number = 0;

        if ($arg == NULL) {
            $data['sort_by'] = '';
            $this->session->unset_userdata('sort_session');
            $this->session->unset_userdata('status_session');
        } elseif ($arg == 'asc' | $arg == 'desc') {
            $data['sort_by'] = $arg;
            $sData['sort_session'] = $arg;
            $this->session->set_userdata($sData);
        } else {
            $data['sort_by'] = $this->session->userdata('sort_session');
            $data['page'] = $arg;
            $number = $arg * 10 - 10;
        }

        $search_value = '';
        $sort = $this->session->userdata('sort_session');
        $status = $this->session->userdata('status_session');

        $data['total_course_category'] = $this->super_admin_video_model->total_course_category($status, $search_value);
        $data['all_course_category'] = $this->super_admin_video_model->select_all_course_category($sort, $search_value, $status, $number);
        foreach ($data['all_course_category'] as $category_value) {
            $data['parent_category'][$category_value->course_category_parent_id] = $this->super_admin_video_model->get_parent_course_category($category_value->course_category_parent_id);
        }
        $data['main_content'] = $this->load->view('admin/temporary/manage_course_category', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : get_course_category_by_status 
     * @Used IN             : @Self
     * @Description         : get all Course Category by Course Status
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 06-02-2016 05:40 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function get_course_category_by_status($status) {
        $sort = $this->session->userdata('sort_session');
        $data['page'] = 0;
        $search_value = '';

        if ($status != 'null') {
            $sData['status_session'] = $status;
            $this->session->set_userdata($sData);
        } else {
            $status = '';
            $sData['status_session'] = $status;
            $this->session->set_userdata($sData);
        }

        $data['total_course_category'] = $this->super_admin_video_model->total_course_category($status, $search_value);
        $data['all_course_category'] = $this->super_admin_video_model->select_all_course_category($sort, $search_value, $status, $data['page']);
        foreach ($data['all_course_category'] as $category_value) {
            $data['parent_category'][$category_value->course_category_parent_id] = $this->super_admin_video_model->get_parent_course_category($category_value->course_category_parent_id);
        }
        echo $this->load->view('admin/temporary/ajax/view_course_category', $data, true);
    }

    public function search_course_category($search_value1) {
        $data['page'] = 0;
        $search_value = '';

        if ($search_value1 != 'null') {
            $search_value = $search_value1;
        }

        $sort = $this->session->userdata('sort_session');
        $status = $this->session->userdata('status_session');
        $data['total_course_category'] = $this->super_admin_video_model->total_course_category($status, $search_value);
        $data['all_course_category'] = $this->super_admin_video_model->select_all_course_category($sort, $search_value, $status, $data['page']);
        foreach ($data['all_course_category'] as $category_value) {
            $data['parent_category'][$category_value->course_category_parent_id] = $this->super_admin_video_model->get_parent_course_category($category_value->course_category_parent_id);
        }
        echo $this->load->view('admin/temporary/ajax/view_course_category', $data, true);
    }

    /**
     * @Function            : check_course_by_category_id 
     * @Used IN             : @Self
     * @Description         : get all available course using category ID  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 06-02-2016 06:34 PM    
     * @Status              : available      
     * */
    public function check_course_by_category_id($category_id) {
        $result = $this->super_admin_video_model->check_course_by_category_id($category_id);
        if ($result) {
            echo 1;
        } else {
            echo 2;
        }
    }

    public function category_name_existance($category_name) {
        $result = $this->super_admin_video_model->check_category_name_existance($category_name);
        if ($result) {
            echo '1';
        } else {
            echo '2';
        }
    }

    public function change_course_category_action($category_id, $type) {
        $this->super_admin_video_model->change_course_category_action($category_id, $type);
        $data['type'] = $type;
        $data['category_value'] = $this->super_admin_video_model->select_category_value_by_category_id($category_id);
        echo $this->load->view('admin/temporary/ajax/manage_category_action.php', $data, TRUE);
    }

    public function check_category_child_id($category_id) {
        $result = $this->super_admin_video_model->check_category_child_id($category_id);
        if ($result) {
            echo '1';
        } else {
            echo '2';
        }
    }

    public function check_course_name_exists($caourse_name) {
        $result = $this->super_admin_video_model->check_course_name_exists($caourse_name);
        if ($result) {
            echo '1';
        } else {
            echo '2';
        }
    }

    /*
      -----------@@@RIPON@ Start Course Topic Part----------------------------------
     */

    /**
     * @Function            : add_course_topic 
     * @Used IN             : @self
     * @Description         : add Course Topic for view course
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 07-02-2016 09:38 AM
     * @Status              : available      
     * */
    public function add_course_topic() {
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_rules('course_topic_name', 'Course Topic Name', 'required|trim|max_length[50]|callback_check_course_topic_name_exists');
        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['active_menu'] = 'video_course_category';
            $data['active_sub_menu'] = 'add_course_topic';
            $data['main_content'] = $this->load->view('admin/temporary/add_course_topic_form', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            if ($_POST) {
                $this->super_admin_video_model->save_course_topic();
                redirect('super-admin/manage-course-topic');
            }
        }
    }

    /**
     * @Function            : check_course_topic_name_exists 
     * @Used IN             : @Function - (add_course_topic)           @this-Controller
     * @Description         : Check course topic name 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 07-02-2016 10:59 AM
     * @Status              : available      
     * */
    public function check_course_topic_name_exists($course_topic_name) {
        $result = $this->super_admin_video_model->check_course_topic_name_existence($course_topic_name);
        if ($result) {
            $this->form_validation->set_message('check_course_topic_name_exists', "Course Topic Name alreeady exists");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            : check_course_topic_name 
     * @Used IN             : @Self             @this-Controller
     * @Description         : Check course topic name 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 07-02-2016 10:39 AM
     * @Status              : available      
     * */
    public function check_course_topic_name($course_topic_name1) {
        $course_topic_name = urldecode($course_topic_name1);
        $result = $this->super_admin_video_model->check_course_topic_name_existence($course_topic_name);
        if ($result) {
            echo 1;
        } else {
            echo 2;
        }
    }

    /**
     * @Function            : manage_course_topic 
     * @Used IN             : @Self                   @this-Controller
     * @Description         : Manage course topic name also delete topic 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 07-02-2016 10:20 AM
     * @Status              : available      
     * */
    public function manage_course_topic() {
        $data = array();
        $data['active_menu'] = 'video_course_category';
        $data['active_sub_menu'] = 'manage_course_topic';
        $data['all_course_topic'] = $this->super_admin_video_model->select_all_course_topic_name();
        $data['main_content'] = $this->load->view('admin/temporary/manage_course_topic', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : delete_course_topic 
     * @Used IN             : @Self             @this-Controller
     * @Description         : delete course topic name Using topic ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 07-02-2016 10:21 AM
     * @Status              : available      
     * */
    public function delete_course_topic($course_topic_id) {
        $this->super_admin_video_model->delete_course_topic_by_topic_id($course_topic_id);
    }

    /*
      -----------@@@RIPON@ End Course Topic Part----------------------------------
     */

    /*
     * End temporary work for video course
     */
}
