<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Super_admin_support extends TT_admin_login {

    public function __construct() {
        parent::__construct();
    }
/**----------------------------- support knowledge backend start here (end line )-----------------------**/    
    /**
     * @Function            : knowledgebase
     * @Used IN             : admin/admin_master line----1490
     * @Description         : used to load view knowledgebase on backend page
     * @Developed By        : Tania Akter
     * @Start DateTime      : 27/04/2016  
     * @Status              : available      
     * */
    
    function knowledgebase() {
        $data = array();
        $data['active_menu'] = 'support';
        $data['active_sub_menu'] = 'knowledgebase';
        $data['main_content'] = $this->load->view('admin/support/knowledgebase', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : add_knowledgebase
     * @Used IN             : admin/support/knowledgebase ----16
     * @Description         : To add knowledgebase information
     * @Developed By        : Tania Akter
     * @Start DateTime      : 27/04/2016  
     * @Status              : available      
     * */
    function add_knowledgebase() {
        $person_id = $this->session->userdata('person_id');
        $this->super_admin_support_model->save_knowledgebase($person_id);
        redirect('manage-knowledgebase');
    }

    /**
     * @Function            : manage_knowledgebase
     * @Used IN             : admin/admin_master line----1491
     * @Description         : To add knowledgebase information
     * @Developed By        : Tania Akter
     * @Start DateTime      : 27/04/2016  
     * @Status              : available      
     * */
    function manage_knowledgebase($arg = NULL) { //Here, "$arg = NULL" NULL just means that in case $arg is not passed we will set it to NULL. It's just a way to make $arg optional
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['page'] = 0;  //page data index varaible in here i have initialize it 0 
        $data['number'] = 0; //number data index varaible, in here i have initialize it 0 
        if ($arg != NULL) {
            $data['arg'] = $arg;
            $data['page'] = $data['arg'];                               //if clicked on page number(like 1, 2, 3)for pagination $arg will be clicked page number and $arg stored on $data['sort_by'] array varaible.
            $data['number'] = $data['arg'] * 10 - 10;
        }
        $data['active_menu'] = 'support';
        $data['active_sub_menu'] = 'manage_knowledgebase';
        $data['total_knowledgebase'] = $this->super_admin_support_model->get_total_knowledgebase();
        $data['all_knowledgebase'] = $this->super_admin_support_model->select_all_knowledgebase_for_manage_knowledgebase($data['number']);
        $data['manage_support_by_person'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $data['main_content'] = $this->load->view('admin/support/manage_knowledgebase', $data, true);
        $this->load->view('admin/admin_master', $data);
    }
    
    
    /**
     * @Function            : edit_knowledgebase
     * @Used IN             : admin/support/manage_knowledgebase      line---52
     * @Description         : used to get editable knowledgebase information
     * @Developed By        : Tania Akter
     * @Start DateTime      : 27/04/2016  
     * @Status              : available      
     * */
    
    function edit_knowledgebase($support_id) {
        $data = array();
        $data['active_menu'] = 'support';
        $data['active_sub_menu'] = 'manage_knowledgebase';
        $data['edit_knowledgebase_info']= $this->super_admin_support_model->get_edit_knowledgebase_info($support_id);
        $data['main_content'] = $this->load->view('admin/support/edit_knowledgebase', $data, true);
        $this->load->view('admin/admin_master', $data);
    }
    /**
     * @Function            : update_knowledgebase
     * @Used IN             : admin/support/edit_knowledgebase      line---14
     * @Description         : update knowledgebase information
     * @Developed By        : Tania Akter
     * @Start DateTime      : 27/04/2016  
     * @Status              : available      
     * */
    function update_knowledgebase(){
        $this->super_admin_support_model->update_knowledgebase_info();
        redirect('manage-knowledgebase');
    }
    
      /**
     * @Function            : active_knowledgebase
     * @Used IN             : admin/support/manage_knowledgebase      line---74
     * @Description         : used to active knowledgebase
     * @Developed By        : Tania Akter
     * @Start DateTime      : 28/04/2016  
     * @Status              : available      
     * */
    function active_knowledgebase(){
        $this->super_admin_support_model->make_active_knowledgebase();
    }
      /**
     * @Function            : active_knowledgebase
     * @Used IN             : admin/support/manage_knowledgebase      line---92
     * @Description         : used to inactive knowledgebase
     * @Developed By        : Tania Akter
     * @Start DateTime      : 28/04/2016  
     * @Status              : available      
     * */
    function inactive_knowledgebase(){
        $this->super_admin_support_model->make_inactive_knowledgebase();
    }    
     /**
     * @Function            : delete_knowledgebase_by_id
     * @Used IN             : admin/support/manage_knowledgebase  line-49
     * @Description         : used to delete knowledgebase information
     * @Developed By        : Tania Akter
     * @Start DateTime      : 27/04/2016  
     * @Status              : available      
     * */ 
     function delete_knowledgebase_by_id() {     
         $this->super_admin_support_model->delete_knowledgebase_info_by_id();         
    }
    
     /**------------------------------support knowledgebase backend end here---------------------------**/
     /**------------------------------support idea backend start here---------------------------**/
    
     /**
     * @Function            : manage_idea
     * @Used IN             : admin/support/manage_ideas  line-
     * @Description         : used to view manage idea page according to pagination
     * @Developed By        : Tania Akter
     * @Start DateTime      : 08/05/2016  
     * @Status              : available      
     * */ 
    
    function manage_idea($arg = NULL){        
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['page'] = 0;  //page data index varaible in here i have initialize it 0 
        $data['number'] = 0; //number data index varaible, in here i have initialize it 0 
        if ($arg != NULL) {
           $data['arg'] = $arg;
           $data['page'] = $data['arg'];                               //if clicked on page number(like 1, 2, 3)for pagination $arg will be clicked page number and $arg stored on $data['sort_by'] array varaible.
           $data['number'] = $data['arg'] * 10 - 10;
       }
       $data['active_menu'] = 'support';
       $data['active_sub_menu'] = 'knowledgebase';      
       $data['manage_support_idea_by_person'] = $this->person_model->get_single_person_information_by_person_id($person_id);
       $data['total_idea']=$this->super_admin_support_model->get_total_idea();
       $data['all_idea']= $this->super_admin_support_model->select_all_idea_for_manage_idea($data['number']);
       $data['main_content'] = $this->load->view('admin/support/manage_ideas', $data, true);
       $this->load->view('admin/admin_master', $data); 
    }
    /**
     * @Function            : active_idea
     * @Used IN             : admin/support/manage_ideas  line- 50
     * @Description         : used to active idea
     * @Developed By        : Tania Akter
     * @Start DateTime      : 08/05/2016  
     * @Status              : available      
     * */ 
    function active_idea(){
      $this->super_admin_support_model->make_active_idea();  
    }
    
     /**
     * @Function            : inactive_idea
     * @Used IN             : admin/support/manage_ideas  line- 66
     * @Description         : used to inactive idea 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 08/05/2016  
     * @Status              : available      
     * */ 
    function inactive_idea(){
      $this->super_admin_support_model->make_inactive_idea();  
    }
    
      /**
     * @Function            : delete_idea
     * @Used IN             : admin/support/manage_ideas  line- 85
     * @Description         : used to delete idea
     * @Developed By        : Tania Akter
     * @Start DateTime      : 08/05/2016  
     * @Status              : available      
     * */
    function delete_idea(){
         $this->super_admin_support_model->delete_idea_by_id();
    }
    
       /**
     * @Function            : edit_idea
     * @Used IN             : admin/support/manage_ideas  line- 31
     * @Description         : used to edit idea
     * @Developed By        : Tania Akter
     * @Start DateTime      : 08/05/2016  
     * @Status              : available      
     * */
    function edit_idea($support_id){      
      $this->load->library('form_validation');
        $this->form_validation->set_rules('support_title', 'Support Title', 'required|callback_check_support_title' );
        $this->form_validation->set_rules('support_description', 'Support Description', 'required' );           
        if ($this->form_validation->run() == FALSE) {
        $data = array();
        $data['active_menu'] = 'support';
        $data['active_sub_menu'] = 'knowledgebase';
        $data['idea_edit_info']= $this->super_admin_support_model->get_edit_idea_info($support_id); 
        $data['get_edit_idea_file']=$this->super_admin_support_model->get_edit_idea_file($support_id);
        $data['main_content'] = $this->load->view('admin/support/edit_idea', $data, true);
        $this->load->view('admin/admin_master', $data);
        } else {      
        $this->super_admin_support_model->update_idea_info();
        redirect('manage-idea');          
        }
    }
     /**
     * @Function            : view_support_idea
     * @Used IN             : admin/support/manage_ideas  line- 18
     * @Description         : used to view idea by admin or super admin
     * @Developed By        : Tania Akter
     * @Start DateTime      : 11/05/2016  
     * @Status              : available      
     * */
    function view_support_idea($support_id){
       $person_id = $this->session->userdata('person_id');
        $data = $this->welcome_model->generate_menu();
        $data['content_variable']='support_view_content';
        $data['reply']='0';
        //$data['captcha'] = $this->registration_model->generate_captcha();
        $data['sign_in_person_info'] = $this->super_admin_support_model->sign_in_person_all_info($person_id);
        $data['idea_answer'] = $this->super_admin_support_model->get_idea_info($support_id);
        $data['related_idea'] = $this->super_admin_support_model->select_related_info(5, 2);
        $data['total_idea'] = $this->super_admin_support_model->select_total_related_idea_info();
        $data['all_idea_reply'] = $this->super_admin_support_model->get_all_idea_reply($support_id);
        foreach ($data['all_idea_reply'] as $idea_reply_value) {
            $data['idea_reply_attachment'][$idea_reply_value->support_reply_id] = $this->super_admin_support_model->get_reply_download_info($idea_reply_value->support_reply_id, 2);
        }
        $data['get_download'] = $this->super_admin_support_model->get_download_info($support_id, 1);
        $data['main_content'] = $this->load->view('front_end/tt_support/support_idea_answer', $data, TRUE);
        if($person_id)       {
        $this->load->view('user/master', $data); 
        }
        else {
          $this->load->view('front_end/master', $data);    
        } 
    }
    
     /**
     * @Function            : reply_support_idea
     * @Used IN             : admin/support/manage_ideas  line-43 
     * @Description         : used to reply on idea by admin or super admin
     * @Developed By        : Tania Akter
     * @Start DateTime      : 11/05/2016  
     * @Status              : available      
     * */
    function reply_support_idea($support_id){
        $person_id = $this->session->userdata('person_id');
        $data = $this->welcome_model->generate_menu();
        $data['content_variable']='support_view_content';
        $data['reply']='1';
        //$data['captcha'] = $this->registration_model->generate_captcha();
        $data['sign_in_person_info'] = $this->super_admin_support_model->sign_in_person_all_info($person_id);
        $data['idea_answer'] = $this->super_admin_support_model->get_idea_info($support_id);
        $data['related_idea'] = $this->super_admin_support_model->select_related_info(5, 2);
        $data['total_idea'] = $this->super_admin_support_model->select_total_related_idea_info();
        $data['all_idea_reply'] = $this->super_admin_support_model->get_all_idea_reply($support_id);
        foreach ($data['all_idea_reply'] as $idea_reply_value) {
            $data['idea_reply_attachment'][$idea_reply_value->support_reply_id] = $this->super_admin_support_model->get_reply_download_info($idea_reply_value->support_reply_id, 2);
        }
        $data['get_download'] = $this->super_admin_support_model->get_download_info($support_id, 1);
        $data['main_content'] = $this->load->view('front_end/tt_support/support_idea_answer', $data, TRUE);
        if($person_id) {
        $this->load->view('user/master', $data); 
        }
        else {
          $this->load->view('front_end/master', $data);    
        }  
    }
    
     /**
     * @Function            : delete_idea_file
     * @Used IN             : admin/support/edit_idea  line- 113
     * @Description         : used to delete attachment only
     * @Developed By        : Tania Akter
     * @Start DateTime      : 11/05/2016  
     * @Status              : available      
     * */
     function delete_idea_file(){
         $this->super_admin_support_model->delete_idea_file_by_id();
    }
    
    
    
     /**------------------------------support idea backend end here---------------------------**/
     /**------------------------------support bug report backend start here---------------------------**/
     /**
     * @Function            : manage_bug_report
     * @Used IN             : admin/support/manage_bug_report  
     * @Description         : used to manage bug report
     * @Developed By        : Tania Akter
     * @Start DateTime      : 15/05/2016  
     * @Status              : available      
     * */
    function manage_bug_report($arg=NULL){
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['page'] = 0;  //page data index varaible in here i have initialize it 0 
        $data['number'] = 0; //number data index varaible, in here i have initialize it 0 
        if ($arg != NULL) {
           $data['arg'] = $arg;
           $data['page'] = $data['arg'];                               //if clicked on page number(like 1, 2, 3)for pagination $arg will be clicked page number and $arg stored on $data['sort_by'] array varaible.
           $data['number'] = $data['arg'] * 10 - 10;
       }
       $data['active_menu'] = 'support';
       $data['active_sub_menu'] = 'knowledgebase';
       $data['manage_bug_report_by_person'] = $this->person_model->get_single_person_information_by_person_id($person_id);
       $data['total_bug']=$this->super_admin_support_model->get_total_bug();
       $data['all_bug_report']= $this->super_admin_support_model->select_all_bug_report_for_manage_bug($data['number']);
       $data['main_content'] = $this->load->view('admin/support/manage_bug_report', $data, true);
       $this->load->view('admin/admin_master', $data);    
    }
    /**
     * @Function            : delete_bug_report
     * @Used IN             : admin/support/manage_bug_report  
     * @Description         : used to delete bug report
     * @Developed By        : Tania Akter
     * @Start DateTime      : 15/05/2016  
     * @Status              : available      
     * */
    function delete_bug_report(){
      $this->super_admin_support_model->delete_bug_report_by_support_id();  
    }
    
    /**
     * @Function            : active_bug_report
     * @Used IN             : admin/support/manage_bug_report  
     * @Description         : used to active bug report
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function active_bug_report(){
     $this->super_admin_support_model->make_active_bug_report();     
    }
    
    /**
     * @Function            : active_bug_report
     * @Used IN             : admin/support/manage_bug_report  
     * @Description         : used to inactive bug report
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function inactive_bug_report(){
     $this->super_admin_support_model->make_inactive_bug_report();     
    }
     /**
     * @Function            : edit_bug_report
     * @Used IN             : admin/support/manage_bug_report  
     * @Description         : used to edit bug report
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function edit_bug_report($support_id){        
        $this->load->library('form_validation');
        $this->form_validation->set_rules('bug_subject', 'Bug Subject', 'required' );
        $this->form_validation->set_rules('bug_description', 'Bug Description', 'required' );           
        if ($this->form_validation->run() == FALSE) {
        $data = array();
        $data['active_menu'] = 'support';
        $data['active_sub_menu'] = 'knowledgebase';
        $data['bug_report_edit_info']= $this->super_admin_support_model->get_edit_bug_report_info($support_id); 
        $data['bug_report_attachment']=$this->super_admin_support_model->get_edit_bug_report_attachment($support_id);
        $data['main_content'] = $this->load->view('admin/support/edit_bug_report', $data, true);
        $this->load->view('admin/admin_master', $data);
        } else {      
        $this->super_admin_support_model->update_bug_report_info();
        redirect('manage-bug-report');          
        } 
    }
    
    
    /**
     * @Function            : view_support_bug_report
     * @Used IN             : admin/support/manage_bug_report  
     * @Description         : used to view bug report by admin/super admin
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
  
    function view_support_bug_report($support_id){
        $user_id = $this->session->userdata('person_id');
        $data = $this->welcome_model->generate_menu();
        $data['content_variable'] = 'support_view_content';
        $data['reply'] = '0';
        //$data['captcha'] = $this->registration_model->generate_captcha();
        $data['sign_in_person_info'] = $this->super_admin_support_model->sign_in_person_all_info($user_id);
        $data['bug_report_answer'] = $this->super_admin_support_model->get_bug_report_info($support_id);
        $data['related_bug_report'] = $this->super_admin_support_model->select_related_info(5, 3);
        $data['total_bug_report'] = $this->super_admin_support_model->select_total_related_bug_report_info();
        $data['all_bug_report_reply'] = $this->super_admin_support_model->get_all_bug_report_reply($support_id);
        foreach ($data['all_bug_report_reply'] as $bug_report_reply_value) {
            $data['bug_report_reply_attachment'][$bug_report_reply_value->support_reply_id] = $this->super_admin_support_model->get_reply_download_info($bug_report_reply_value->support_reply_id, 2);
        }
        $data['get_download'] = $this->super_admin_support_model->get_download_info($support_id, 1);
        $data['main_content'] = $this->load->view('front_end/tt_support/support_bug_report_answer', $data, TRUE);
        if ($user_id) {
            $this->load->view('user/master', $data);
        } else {
            $this->load->view('front_end/master', $data);
        }
    }
     /**
     * @Function            : reply_support_bug_report
     * @Used IN             : admin/support/manage_bug_report  
     * @Description         : used to reply on bug report by admin/super admin
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function reply_support_bug_report($support_id){
        $user_id = $this->session->userdata('person_id');
        $data = $this->welcome_model->generate_menu();
        $data['content_variable'] = 'support_view_content';
        $data['reply'] = '1';
        //$data['captcha'] = $this->registration_model->generate_captcha();
        $data['sign_in_person_info'] = $this->super_admin_support_model->sign_in_person_all_info($user_id);
        $data['bug_report_answer'] = $this->super_admin_support_model->get_bug_report_info($support_id);
        $data['related_bug_report'] = $this->super_admin_support_model->select_related_info(5, 3);
        $data['total_bug_report'] = $this->super_admin_support_model->select_total_related_bug_report_info();
        $data['all_bug_report_reply'] = $this->super_admin_support_model->get_all_bug_report_reply($support_id);
        foreach ($data['all_bug_report_reply'] as $bug_report_reply_value) {
            $data['bug_report_reply_attachment'][$bug_report_reply_value->support_reply_id] = $this->super_admin_support_model->get_reply_download_info($bug_report_reply_value->support_reply_id, 2);
        }
        $data['get_download'] = $this->super_admin_support_model->get_download_info($support_id, 1);
        $data['main_content'] = $this->load->view('front_end/tt_support/support_bug_report_answer', $data, TRUE);
        if ($user_id) {
            $this->load->view('user/master', $data);
        } else {
            $this->load->view('front_end/master', $data);
        }
    }
         /**
     * @Function            : delete_bug_file
     * @Used IN             : admin/support/edit_bug_report  
     * @Description         : used to delete bug report attachment only
     * @Developed By        : Tania Akter
     * @Start DateTime      : 17/05/2016  
     * @Status              : available      
     * */
    function delete_bug_file(){
       $this->super_admin_support_model->delete_bug_attachment_by_id();   
    }
   /**------------------------------support bug report backend end here---------------------------**/
    
 
   
}
