<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Super_admin_quiz extends TT_admin_login {

    public function __construct() {
        parent::__construct();
        $this->session->unset_userdata('active_menu');
    }

    public function index() {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz';
        $data['main_content'] = $this->load->view('admin/quiz/view_quiz', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function check_topic_name_existance() {
        $topic_name = preg_replace('/\s+/', ' ', trim($this->input->post('topic_name', TRUE)));
        echo $this->super_admin_quiz_model->check_topic_name_existance($topic_name);
    }

    public function check_quiz_public_id($public_id) {
        echo $this->super_admin_quiz_model->check_quiz_public_id($public_id);
    }

    public function check_url_existance($url) {
        echo $this->url_model->check_url_exists1($url);
    }

    /* START quiz */

    /**
     * @Function            :   create_quiz
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   21-02-2016 04:15 PM   |
     * @Updated Date Time   :
     * @Updated By          :   
     * @Router              :   super-admin/create-quiz
     *
     * @Works               :   create quiz
     *                          
     * @parameter           :   
     * @Return              :   no
     * @Redirect            :   super-admin/manage-quiz
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    function create_quiz() {
        $data = [];
        $person_id = $this->session->userdata('person_id');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz';
        $this->form_validation->set_rules('quiz_name', 'Quiz name', 'required|trim|max_length[150]');
        $this->form_validation->set_rules('quiz_topics_specification', 'Quiz topics ', 'required|min_length[1]');
        $this->form_validation->set_rules('quiz_public_id', 'Quiz public id', 'required|callback_validate_quiz_public_id[]');
        $this->form_validation->set_rules('quiz_url', 'Quiz url', 'required|callback_validate_quiz_url[]');
        $this->form_validation->set_rules('quiz_description', 'Quiz description');
        $this->form_validation->set_rules('quiz_random_static', 'Quiz Random Static', 'required');
//        $this->form_validation->set_rules('total_number_of_question', 'number of question', 'integer|trim|callback_validate_total_number_of_question');
//        $this->form_validation->set_rules('points_per_answer', 'Quiz Points Per Answer', 'integer|trim|callback_validate_point_per_answer');
//        $this->form_validation->set_rules('time_limit', 'Time Limit', 'integer|trim|callback_validate_time_limit');
//        $this->form_validation->set_rules('total_time', 'total time');
        $this->form_validation->set_rules('quiz_pulication_status', 'quiz permission', 'required');
//        $this->form_validation->set_rules('selected_id', 'Selected Group/ Course/ Video Course');
        $this->form_validation->set_rules('quiz_status', 'Quiz status', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['quiz_topics'] = $this->topic_model->select_all_parent_topic_id_if_child();
            $data['main_content'] = $this->load->view('admin/quiz/create_quiz', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $quiz_id = $this->super_admin_quiz_model->save_quiz_info();
            $sdata['points_per_answer'] = $this->input->post('points_per_answer', true);
            $sdata['time_limit'] = $this->input->post('time_limit', true);
            $this->session->set_userdata($sdata);
            $quiz_info = $this->super_admin_quiz_model->select_quiz_by_id($quiz_id);
            redirect('super-admin/quiz/' . $quiz_info->url . '/add-quiz-question');
        }
    }


    public function validate_quiz_public_id($quiz_public_id, $old_public_id) {
        if ($old_public_id == $quiz_public_id) {
            return true;
        } else {
            $result = $this->super_admin_quiz_model->check_quiz_public_id($quiz_public_id);
            if ($result == 1) {
                $this->form_validation->set_message('validate_quiz_public_id', "Quiz public id exist");
                return false;
            } else {
                $sp = '/^[0-9a-zA-Z]+$/';
                if (!preg_match($sp, $quiz_public_id)) {
                    $this->form_validation->set_message('validate_quiz_public_id', "Allowed valid chatacter 0-9, a-z or A-Z (space not allowed)");
                    return FALSE;
                } else {
                    return TRUE;
                }
            }
        }
    }

    public function validate_quiz_url($url, $old_url) {
        if ($old_url == $url) {
            return true;
        } else {
            $result = $this->url_model->check_url_exists1($url);
            if ($result == 1) {
                $this->form_validation->set_message('validate_quiz_url', "URL Already Exist");
                return false;
            } else {
                $sp = '/^[0-9a-zA-Z\-]+$/';
                if (!preg_match($sp, $url)) {
                    $this->form_validation->set_message('validate_quiz_url', "Allowed valid chatacter 0-9, a-z or A-Z (space not allowed)");
                    return FALSE;
                } else if (strstr($url, ' ')) {
                    $this->form_validation->set_message('validate_quiz_url', " Don't use Space if need use '-', alse URL Cann't contain any special carecter like '/[!@#$%&*()^,._;:-]/'");
                    return FALSE;
                } else if (preg_match('/--/', $url)) {
                    $this->form_validation->set_message('validate_quiz_url', "URL Cann't contain multiple hypen");
                    return FALSE;
                } else if (substr($url, (strlen($url) - 1)) == '-') {
                    $this->form_validation->set_message('validate_quiz_url', "No hypen allow at the last");
                    return FALSE;
                } else {
                    return TRUE;
                }
            }
        }
    }


    /**
     * @Function            :   edit_quiz
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   21-02-2016 04:15 PM   |
     * @Updated Date Time   :
     * @Updated By          :   
     * @Router              :   super-admin/edit-quiz/(:quiz)
     *
     * @Works               :   edit quiz
     *                          
     * @parameter           :   $quiz_url
     * @Return              :   no
     * @Redirect            :   super-admin/manage-quiz
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function edit_quiz($quiz_url) {
        $data = array();
        $data['quiz_url'] = $quiz_url;
        $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'manage_quiz'; // for add topic menu selected

        $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_url($quiz_url);
        if (!$data['quiz_info']) {
            redirect('super-admin/manage-quiz');
        }
        $data['parent_topic_info'] = $this->topic_model->select_topic_info_by_topic_id($data['quiz_info']->quiz_topics_specification);
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($data['quiz_info']->quiz_created_by);
        $data['quiz_questions'] = $this->super_admin_quiz_model->select_active_question_by_quiz_id($data['quiz_info']->quiz_id);
        $data['quize_attendies'] = $this->super_admin_quiz_model->select_quiz_attendees($data['quiz_info']->quiz_id);

//        $data['id_list'] = $this->super_admin_quiz_model->quiz_selected_id($data);
        // for random/static quiz
        $data['first_question'] = $this->super_admin_quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
        if ($data['first_question']) {
            $sdata['points_per_answer'] = $data['first_question']->points_per_answer;
            $sdata['time_limit'] = $data['first_question']->time_limit;
            $this->session->set_userdata($sdata);
        } else {
            $sdata['points_per_answer'] = '';
            $sdata['time_limit'] = '';
            $this->session->set_userdata($sdata);
        }

        $this->form_validation->set_rules('quiz_name', 'quiz name', 'required|trim|max_length[150]');
        $this->form_validation->set_rules('quiz_topics_specification', 'course ', 'required|min_length[1]');
        $this->form_validation->set_rules('quiz_public_id', 'Quiz Public Id', 'required|callback_validate_quiz_public_id[' . $data['quiz_info']->quiz_public_id . ']');
        $this->form_validation->set_rules('quiz_url', 'quiz url', 'required|callback_validate_quiz_url[' . $data['quiz_info']->url . ']');
        $this->form_validation->set_rules('quiz_description', 'quiz quiz_description');
        $this->form_validation->set_rules('quiz_random_static', 'Quiz Random Static', 'required');
//        $this->form_validation->set_rules('total_number_of_question', 'number of question', 'integer|trim|callback_validate_total_number_of_question');
//        $this->form_validation->set_rules('points_per_answer', 'Quiz Points Per Answer', 'integer|trim|callback_validate_point_per_answer');
//        $this->form_validation->set_rules('time_limit', 'Time Limit', 'integer|trim|callback_validate_time_limit');
//        $this->form_validation->set_rules('total_time', 'total time');
        $this->form_validation->set_rules('quiz_pulication_status', 'quiz permission', 'required');
//        $this->form_validation->set_rules('selected_id', 'Selected Group/ Course/ Video Course');
        $this->form_validation->set_rules('quiz_status', 'Quiz status', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['quiz_topics'] = $this->topic_model->select_all_parent_topic_id_if_child();
            $data['main_content'] = $this->load->view('admin/quiz/edit_quiz', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_quiz_model->update_quiz_info($data);
            $sdata['points_per_answer'] = $this->input->post('points_per_answer', true);
            $sdata['time_limit'] = $this->input->post('time_limit', true);
            $this->session->set_userdata($sdata);
            redirect('super-admin/quiz/' . $data['quiz_info']->url . '/add-quiz-question');
        }
    }

    /**
     * @Function            :   manage_quiz
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   01-02-2016 05:35 PM   |
     * @Updated Date Time   :
     * @Updated By          :   
     * @Router              :   super-admin/manage-quiz
     * @Works               :   manage quiz from admin panel
     * @parameter           :   $page = NULL
     * @Return              :   
     * @Redirect            :   
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function manage_quiz($page = NULL) {
        $data = $this->collect_quiz_data($page);
        $data['main_content'] = $this->load->view('admin/quiz/view_quiz', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

// update by tania
// update by tania
    public function collect_quiz_data($page = NULL) {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);

        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'manage_quiz';
        if ($this->input->post('search_value', TRUE)) {
            $data['search_value'] = $config['search_value'] = $this->input->post('search_value', TRUE);
        } else {
            $data['search_value'] = $config['search_value'] = '';
        }

        $data['page'] = $page;
        if (!$page) {
            $data['page'] = $page = 1;
        }
        $data['per_page_view'] = $config['per_page_view'] = 10;
        $config['start_limit_value'] = $start_limit_value = $data['page'] * $config['per_page_view'] - $config['per_page_view'];
        $config['quiz_editor_id'] = ($data['person_info']->person_role == 8) ? $data['person_info']->person_id : '';

        $data['quizes'] = $this->super_admin_quiz_model->select_quiz($config);
        $config['per_page_view'] = '';
        $data['total_data'] = count($this->super_admin_quiz_model->select_quiz($config));

        foreach ($data['quizes'] as $v_quiz) {
            $data['creator'][$v_quiz->quiz_created_by] = $this->person_model->get_single_person_information_by_person_id($v_quiz->quiz_created_by); // by tania
            $data['quiz_questions'][$v_quiz->quiz_id] = $this->super_admin_quiz_model->select_active_question_by_quiz_id($v_quiz->quiz_id);
            $data['quiz_attendies'][$v_quiz->quiz_id] = $this->super_admin_quiz_model->select_quiz_attendees($v_quiz->quiz_id);
        }
        return $data;
    }   

    /**
     * @Function            :   search_quiz
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   01-02-2016 05:45 PM   |
     * @Updated Date Time   :
     * @Updated By          :   
     * @Router              :   super-admin/search-quiz
     *
     * @Works               :   search quiz 
     *                          
     * @parameter           :   
     * @Return              :   no
     * @Redirect            :   super-admin/topic
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function search_quiz($page = NULL) {
        $data = $this->collect_quiz_data($page);
        echo $this->load->view('admin/quiz/view_quiz_search', $data, TRUE);
    }

    //tania 29-08-2016
    function delete_quiz() {
        $quiz_id = $this->input->post('quiz_id', TRUE);
        $data['quiz_info'] = $this->super_admin_quiz_model->get_quiz_info_by_quiz_id($quiz_id);
        $this->super_admin_quiz_model->delete_selected_quiz($data);
    }

    /**
     * @Function            :   select_quiz_access_user
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   21-02-2016 04:15 PM   |
     * @Updated Date Time   :
     * @Updated By          :   
     * @Router              :   super-admin/select-quiz-access-user
     *
     * @Works               :   create quiz
     *                          
     * @parameter           :   
     * @Return              :   no
     * @Redirect            :   super-admin/manage-quiz
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function select_quiz_access_user1() {
        $data['access_level'] = $access_level = $this->input->post('givenText', TRUE);
        $quiz_public_id = $this->input->post('quizPublicId', TRUE);
        $person_id = $this->session->userdata('person_id');

        if ($access_level == 3) {// My Link
            $data['link_person'] = $this->user_course_model->select_link_person($person_id);
        } else if ($access_level == 4) {// Only Group
            $data['group'] = $this->super_admin_quiz_model->select_group_by_person_id();
            if ($quiz_public_id) {
                $data['quiz_groups'] = $this->super_admin_quiz_model->select_quiz_group_permission($quiz_public_id);
            } else {
                $data['quiz_groups'] = '';
            }
        } else if ($access_level == 5) {// Course
            $data['all_course'] = $this->super_admin_quiz_model->select_public_course_by_person_id();  //only Organization / Trainer / Student
            foreach ($data['all_course'] as $v_course) {
                $data['course_permission'][$v_course->course_id] = $this->super_admin_quiz_model->select_quiz_course_permission_by_course_id($v_course->course_id);
            }
            if ($quiz_public_id) {
                $data['quiz_courses'] = $this->super_admin_quiz_model->select_quiz_course_permission($quiz_public_id);
                $data['course_permission'][$data['quiz_courses']->course_id] = '';
            } else {
                $data['quiz_courses'] = '';
            }
        } else if ($access_level == 6) {// Video Course
            $data['all_video_course'] = $this->super_admin_quiz_model->select_video_course_by_person_id($person_id);  //only Organization / Trainer / Student
            foreach ($data['all_video_course'] as $v_course) {
                $data['video_course_permission'][$v_course->video_management_id] = $this->super_admin_quiz_model->select_quiz_video_course_permission_by_course_id($v_course->video_management_id);
            }
            if ($quiz_public_id) {
                $data['quiz_video_courses'] = $this->super_admin_quiz_model->select_quiz_video_course_permission($quiz_public_id);
                $data['video_course_permission'][$data['quiz_video_courses']->video_management_id] = '';
            } else {
                $data['quiz_video_courses'] = '';
            }
        }

        echo $this->load->view('admin/quiz/select_quiz_access_user', $data, TRUE);
    }

    public function select_quiz_access_user() {
        $person_id = $this->session->userdata('person_id');
        $data['access_level'] = $access_level = $this->input->post('quiz_pulication_status', TRUE);
        echo $this->load->view('admin/quiz/select_quiz_access_user', $data, TRUE);
    }

    public function search_quiz_access() {
        $data['access_level'] = $access_level = $this->input->post('quiz_pulication_status', TRUE);
        $quiz_public_id = $this->input->post('quiz_public_id', TRUE);
        $search_text = $this->input->post('search_text', TRUE);
        $id_list = $this->input->post('id_list', TRUE);
        $person_id = $this->session->userdata('person_id');

        if ($access_level == 4) {// Only Group
            $counter = 0;
            $selected_counter = 0;
            if ($id_list) {
                $data['all_selected_group'] = $this->super_admin_quiz_model->select_tt_group_by_id_list($id_list);
                foreach ($data['all_selected_group'] as $group_value) {
                    ++$selected_counter;
                    if ($selected_counter <= 3) {
                        $data['first_column_selected_group'][] = $group_value;
                    } else {
                        $data['second_column_selected_group'][] = $group_value;
                    }
                }
            }

            if ($search_text != 'null') {
                $data['all_group'] = $this->super_admin_quiz_model->select_tt_group_by_search_text($search_text, $id_list);
                foreach ($data['all_group'] as $group_value) {
                    ++$counter;
                    if ($counter <= 3) {
                        $data['first_column_group'][] = $group_value;
                    } elseif ($counter <= 6) {
                        $data['second_column_group'][] = $group_value;
                    } else {
                        $data['third_column_group'][] = $group_value;
                    }
                }
            }
            echo $this->load->view('admin/quiz/quiz_group_list', $data, TRUE);
        } else if ($access_level == 5) {// Course
            $counter = 0;
            $selected_counter = 0;
            if ($id_list) {
                $data['all_selected_data'] = $this->super_admin_quiz_model->select_tt_course_by_id_list($id_list);
                foreach ($data['all_selected_data'] as $value) {
                    ++$selected_counter;
                    if ($selected_counter <= 3) {
                        $data['first_column_selected_data'][] = $value;
                    } else {
                        $data['second_column_selected_data'][] = $value;
                    }
                }
            }

            if ($search_text != 'null') {
                $course_id_list = $this->super_admin_quiz_model->select_course_id_from_quiz_permission();    //added by tania--- 03-07-2016
                $data['all_data'] = $this->super_admin_quiz_model->select_tt_course_by_search_text($search_text, $course_id_list);
                foreach ($data['all_data'] as $value) {
                    ++$counter;
                    if ($counter <= 3) {
                        $data['first_column_data'][] = $value;
                    } elseif ($counter <= 6) {
                        $data['second_column_data'][] = $value;
                    } else {
                        $data['third_column_data'][] = $value;
                    }
                }
            }
            echo $this->load->view('admin/quiz/quiz_course_list', $data, TRUE);
        } else if ($access_level == 6) {// Video Course
            $counter = 0;
            $selected_counter = 0;
            if ($id_list) {
                $data['all_selected_data'] = $this->super_admin_quiz_model->select_tt_video_course_by_id_list($id_list);
                foreach ($data['all_selected_data'] as $value) {
                    ++$selected_counter;
                    if ($selected_counter <= 3) {
                        $data['first_column_selected_data'][] = $value;
                    } else {
                        $data['second_column_selected_data'][] = $value;
                    }
                }
            }

            if ($search_text != 'null') {
                $data['all_data'] = $this->super_admin_quiz_model->select_tt_video_course_by_search_text($search_text, $id_list);
                foreach ($data['all_data'] as $value) {
                    ++$counter;
                    if ($counter <= 3) {
                        $data['first_column_data'][] = $value;
                    } elseif ($counter <= 6) {
                        $data['second_column_data'][] = $value;
                    } else {
                        $data['third_column_data'][] = $value;
                    }
                }
            }
            echo $this->load->view('admin/quiz/quiz_video_course_list', $data, TRUE);
        }
    }

    public function check_quiz_bind_id() {
        $person_id = $this->session->userdata('person_id');

        $data['access_level'] = $access_level = $this->input->post('quiz_pulication_status', TRUE);
        $quiz_public_id = $this->input->post('quiz_public_id', TRUE);
        $id = $this->input->post('id', TRUE);

        $data['access_level'] = $access_level = $this->input->post('quiz_pulication_status', TRUE);
        $quiz_public_id = $this->input->post('quiz_public_id', TRUE);
        $id = $this->input->post('id', TRUE);

        $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_all_status_by_public_id($quiz_public_id);
        $data['allready_assigned'] = '';
        if ($access_level == 4) {// Only Group
            $data['quiz_attendees'] = $this->super_admin_quiz_model->select_group_quiz_attendees_by_group_id($id, $data['quiz_info']->quiz_id);
        } else if ($access_level == 5) {// Course
            $data['quiz_attendees'] = $this->super_admin_quiz_model->select_course_quiz_attendees_by_course_id($id, $data['quiz_info']->quiz_id);
            $data['allready_assigned'] = $this->super_admin_quiz_model->check_course_assigned_in_quiz($id);
        } else if ($access_level == 6) {// Video Course
            $data['quiz_attendees'] = $this->super_admin_quiz_model->select_video_course_quiz_attendees_by_course_id($id, $data['quiz_info']->quiz_id);
            $data['allready_assigned'] = $this->super_admin_quiz_model->check_video_course_assigned_in_quiz($id);
        }


        if ($data['quiz_attendees']) {
            echo 'attendees-found';
            return;
        }
        if ($data['allready_assigned']) {
            echo 'allready-assigned';
            return;
        }
    }

    public function add_question($quiz_url = null) {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_question';
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $this->load->library('form_validation');
        $this->form_validation->set_rules('question_details', 'Question', 'required');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('points_per_answer', 'Markes', 'required');
        $this->form_validation->set_rules('time_limit', 'time limit', 'required');
        $this->form_validation->set_rules('option', 'option', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['quiz_topics'] = $this->super_admin_quiz_model->select_quiz_active_topic();
            $data['all_quiz'] = $this->super_admin_quiz_model->select_all_active_quiz_by_super_admin();
            $data['main_content'] = $this->load->view('admin/quiz/add_question', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_quiz_model->save_question_info();
            $sdata['quiz_url'] = $quiz_url = $this->input->post('quiz_id', true);
            $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_url($quiz_url);
            $sdata['question_type'] = $question_type = $this->input->post('question_type');
            $this->session->set_userdata($sdata);
            redirect('super-admin/add-question');
        }
    }

    public function add_quiz_question($quiz_url = null) {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz';

        $this->load->library('form_validation');
        $this->form_validation->set_rules('question_details', 'Question', 'required');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        ;
        $this->form_validation->set_rules('points_per_answer', 'Markes', 'required');
        $this->form_validation->set_rules('time_limit', 'time limit', 'required');
//        $this->form_validation->set_rules('option', 'option', 'required');
        $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_url($quiz_url);

        if (!$data['quiz_info']) {
            redirect('super-admin/quizes/' . $this->session->userdata('active_menu'));
        }
        $data['first_question'] = $this->super_admin_quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);

        if ($data['first_question']) {
            $sdata['points_per_answer'] = $data['first_question']->points_per_answer;
            $sdata['time_limit'] = $data['first_question']->time_limit;
            $this->session->set_userdata($sdata);
        }

        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'add_question';
            $data['quiz_url'] = $quiz_url;
//            $data['quiz_topics'] = $this->super_admin_quiz_model->select_quiz_active_topic();
            $data['all_quiz'] = $this->super_admin_quiz_model->select_active_quiz_by_person_id($person_id);
            $data['main_content'] = $this->load->view('admin/quiz/add_quiz_question', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_quiz_model->save_question_info();
            $this->session->unset_userdata('points_per_answer');
            $this->session->unset_userdata('time_limit');
            $sdata['question_type'] = $question_type = $this->input->post('question_type');
            $this->session->set_userdata($sdata);
            redirect('super-admin/quiz/' . $data['quiz_info']->url . '/add-quiz-question');
        }
    }

    public function validate_question_point_per_answer($points_per_answer, $quiz_random_static) {
        if ($quiz_random_static == '1') {
            if ($points_per_answer == '') {
                $this->form_validation->set_message('validate_question_point_per_answer', "Quiz per question number is required");
                return false;
            } else {
                return true;
            }
        }
    }

    public function validate_question_time_limit($time_limit, $quiz_random_static) {
        if ($quiz_random_static == '1') {
            if ($time_limit == '') {
                $this->form_validation->set_message('validate_question_time_limit', "Quiz per question time limit is required");
                return false;
            } else {
                return true;
            }
        }
    }

    public function edit_multiple_choice_question($quiz_url, $question_id) {
        $sdata = array();
        $sdata['question_type'] = "1";
        $this->session->set_userdata($sdata);

        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'manage_quiz';

        $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_url($quiz_url);
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($data['quiz_info']->quiz_created_by);
        $data['first_question'] = $this->super_admin_quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
        $data['question_info'] = $this->super_admin_quiz_model->select_question_info_by_id($question_id);
        $data['quiz_creator'] = $this->super_admin_quiz_model->get_quiz_creator_info_by_question_id($question_id);   //added by tania 27-07-2016
        $data['question_options'] = $this->super_admin_quiz_model->select_question_options_by_question_id($question_id);
        $data['quiz_url'] = $quiz_url;

        $this->form_validation->set_rules('question_details', 'Question', 'required');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('option[]', 'option', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['quiz_topics'] = $this->super_admin_quiz_model->select_quiz_active_topic();
            $data['all_quiz'] = $this->super_admin_quiz_model->select_active_quiz_by_person_id($person_id);
            $data['main_content'] = $this->load->view('admin/quiz/edit_multiple_choice_question', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_quiz_model->update_question_info($data['question_info']->question_id, $data['question_info']->question_details);
            $sdata['question_type'] = $question_type = $this->input->post('question_type');
            $this->session->set_userdata($sdata);

            redirect("super-admin/quiz/$quiz_url/question");
        }
    }

    public function edit_true_false_question($quiz_url, $question_id) {
        $sdata = array();
        $sdata['question_type'] = "2";
        $this->session->set_userdata($sdata);
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active'] = 'manage_quiz';

        $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_url($quiz_url);
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($data['quiz_info']->quiz_created_by);
        $data['first_question'] = $this->super_admin_quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
        $data['question_info'] = $this->super_admin_quiz_model->select_question_info_by_id($question_id);
        $data['question_options'] = $this->super_admin_quiz_model->select_question_options_by_question_id($question_id);
        $data['quiz_url'] = $quiz_url;
        $data['quiz_creator'] = $this->super_admin_quiz_model->get_quiz_creator_info_by_question_id($question_id);   //added by tania 27-07-2016

        $this->form_validation->set_rules('question_details', 'Question', 'required');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('option', 'option', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['quiz_topics'] = $this->super_admin_quiz_model->select_quiz_active_topic();
            $data['all_quiz'] = $this->super_admin_quiz_model->select_active_quiz_by_person_id($person_id);
            $data['main_content'] = $this->load->view('admin/quiz/edit_true_false_question', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_quiz_model->update_question_info($data['question_info']->question_id, $data['question_info']->question_details);
            $sdata['question_type'] = $question_type = $this->input->post('question_type');
            $this->session->set_userdata($sdata);
            redirect("super-admin/quiz/$quiz_url/question");
        }
    }

    public function edit_descriptive_question($quiz_url, $question_id) {
        $sdata = array();
        $sdata['question_type'] = "3";
        $this->session->set_userdata($sdata);

        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active'] = 'manage_quiz';

        $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_url($quiz_url);
        $data['first_question'] = $this->super_admin_quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
        $data['question_info'] = $this->super_admin_quiz_model->select_question_info_by_id($question_id);
        $data['question_options'] = $this->super_admin_quiz_model->select_question_options_by_question_id($question_id);
        $data['quiz_url'] = $quiz_url;

        $this->form_validation->set_rules('question_details', 'Question', 'required|trim');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('option', 'option', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['quiz_topics'] = $this->super_admin_quiz_model->select_quiz_active_topic();
            $data['all_quiz'] = $this->super_admin_quiz_model->select_active_quiz_by_person_id($person_id);
            $data['main_content'] = $this->load->view('admin/quiz/edit_descriptive_question', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_quiz_model->update_question_info($question_id);
            $sdata['question_type'] = $question_type = $this->input->post('question_type');
            $this->session->set_userdata($sdata);
            redirect("super-admin/quiz/$quiz_url/question");
        }
    }

    public function edit_fill_in_the_blank_question($quiz_url, $question_id) {
        $sdata = array();
        $sdata['question_type'] = "4";
        $this->session->set_userdata($sdata);

        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $data['active'] = 'manage_quiz';

        $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_url($quiz_url);
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($data['quiz_info']->quiz_created_by);
        $data['first_question'] = $this->super_admin_quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
        $data['question_info'] = $this->super_admin_quiz_model->select_question_info_by_id($question_id);
        $data['question_options'] = $this->super_admin_quiz_model->select_question_options_by_question_id($question_id);
        $data['quiz_url'] = $quiz_url;
        $data['quiz_creator'] = $this->super_admin_quiz_model->get_quiz_creator_info_by_question_id($question_id);   //added by tania 27-07-2016

        $this->form_validation->set_rules('question_details', 'Question', 'required');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('option', 'option', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['quiz_topics'] = $this->super_admin_quiz_model->select_quiz_active_topic();
            $data['all_quiz'] = $this->super_admin_quiz_model->select_active_quiz_by_person_id($person_id);
            $data['main_content'] = $this->load->view('admin/quiz/edit_fill_in_the_blank_question', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_quiz_model->update_question_info($data['question_info']->question_id, $data['question_info']->question_details);
            $sdata['question_type'] = $question_type = $this->input->post('question_type');
            $this->session->set_userdata($sdata);
            redirect("super-admin/quiz/$quiz_url/question");
        }
    }

    public function get_quiz_required_information($quiz_url) {
        $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_url($quiz_url);
        $data['first_question'] = $this->super_admin_quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
        if ($data['first_question']) {
            $sdata['points_per_answer'] = $data['first_question']->points_per_answer;
            $sdata['time_limit'] = $data['first_question']->time_limit;
            $this->session->set_userdata($sdata);
        }
        echo $this->load->view('admin/quiz/quiz_information_for_question', $data, TRUE);
    }

    public function get_quiz_required_information_edit($quiz_url, $question_id) {
        $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_url($quiz_url);
        $data['first_question'] = $this->super_admin_quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
        $data['question_info'] = $this->super_admin_quiz_model->select_question_info_by_id($question_id);

        if ($data['quiz_info']->quiz_created_by != $this->session->userdata('person_id') && $data['question_info']->quiz_id != $data['quiz_info']->quiz_id) {
            echo 'Question is not FOUND!!';
        } else {
            echo $this->load->view('admin/quiz/quiz_information_for_question_edit', $data, TRUE);
        }
    }

    public function view_quiz_test() {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz';

        $data['main_content'] = $this->load->view('admin/profile_view/view_test', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function check_public_quiz() {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz';

        $code = $this->uri->segment(2);
        $result = $this->super_admin_quiz_model->select_quiz_by_public_id($code);

        if ($result && $result->quiz_pulication_status == 1) {
            $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_id($result->quiz_id);
            $data['creator_info'] = $this->profile_model->person_info_by_person_id($result->quiz_created_by);
            $data['main_content'] = $this->load->view('admin/quiz/attendee_quiz_view', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else if ($result && $result->quiz_permission != 1) {
            redirect();
        } else {
            redirect();
        }
    }

    public function add_topics() {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz';

        $data['main_content'] = $this->load->view('admin/video/add_topics', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function add_moreTopics($Counter) {
        $data = array();
        $data['Counter'] = $Counter;
        echo $this->load->view('admin/video/add_topics_ajax_file', $data, TRUE);
    }

    public function add_grade($quiz_url) {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active'] = 'manage_grade';

        $this->form_validation->set_rules('grade_total_number', 'grade_total_number', 'required');
        $this->form_validation->set_rules('grade_name', 'grade_name', 'required');
        $this->form_validation->set_rules('grade_number', 'grade_number', 'required');

        $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_url($quiz_url);
        $data['quiz_grades'] = $this->super_admin_quiz_model->select_quiz_all_grade($data['quiz_info']->quiz_id);
        if (!$data['quiz_info']) {
            redirect();
        }

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('admin/quiz/edit_grade', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_quiz_model->save_grade_info($data['quiz_info']->quiz_id);
            redirect('super-admin/quiz/' . $data['quiz_info']->url . '/view-grade');
        }
    }

    public function add_more_grade($grade_number) {
        $data['grade_number'] = $grade_number;
        echo $this->load->view('admin/quiz/more_grade', $data, TRUE);
    }

    public function delete_grade($grade_id) {
        $this->db->where('grade_id', $grade_id);
        $this->db->delete('tbl_grade');
        echo 1;
    }

    public function view_grade() {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active'] = 'manage_grade';

        $data['all_quizes'] = $this->super_admin_quiz_model->select_all_quiz_by_person_id($person_id);
        foreach ($data['all_quizes'] as $v_quiz) {
            $data['quiz_grades'][$v_quiz->quiz_id] = $this->super_admin_quiz_model->select_quiz_all_grade($v_quiz->quiz_id);
        }

        $data['main_content'] = $this->load->view('admin/quiz/view_grade', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function activate_grade($grade_id) {
        $data = array();
        $this->super_admin_quiz_model->active_selected_grade($grade_id);
        $data['grade_info'] = $this->super_admin_quiz_model->select_grade_by_id($grade_id);
        echo $this->load->view('admin/quiz/view_grade_actions', $data, TRUE);
    }

    public function inactivate_grade($grade_id) {
        $data = array();
        $this->super_admin_quiz_model->inactive_selected_grade($grade_id);
        $data['grade_info'] = $this->super_admin_quiz_model->select_grade_by_id($grade_id);
        echo $this->load->view('admin/quiz/view_grade_actions', $data, TRUE);
    }

    public function archive_grade($grade_id) {
        $data = array();
        $this->super_admin_quiz_model->archive_selected_grade($grade_id);
        $data['grade_info'] = $this->super_admin_quiz_model->select_grade_by_id($grade_id);
        echo $this->load->view('admin/quiz/view_grade_actions', $data, TRUE);
    }

    public function edit_grade($quiz_url) {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz';

        $this->form_validation->set_rules('grade_total_number', 'grade_total_number', 'required');
        $this->form_validation->set_rules('grade_name', 'grade_name', 'required');
        $this->form_validation->set_rules('grade_number', 'grade_number', 'required');

        $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_url($quiz_url);
        $data['quiz_grades'] = $this->super_admin_quiz_model->select_quiz_all_grade($data['quiz_info']->quiz_id);

        if (!$data['quiz_info']) {
            redirect();
        }
        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('admin/quiz/edit_grade', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_quiz_model->update_grade_info($data['quiz_info']->quiz_id);
            redirect('super-admin/quiz/view-grade');
        }
    }

    public function quiz_grade_details($quiz_url) {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active'] = 'manage_grade';
        $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_url($quiz_url);
        $data['quiz_grades'] = $this->super_admin_quiz_model->select_quiz_all_grade($data['quiz_info']->quiz_id);

        $data['main_content'] = $this->load->view('admin/quiz/selected_grade_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function edit_selected_grade() {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz';

        $data['main_content'] = $this->load->view('admin/quiz/edit_selected_grade', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /*
     * @Description         : Displays the create certificate page in admin section
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Updated By          : Md Mashqur Ul Alam
     * @Updated Date Time   : 23-01-17
     * @parameter           : Null
     * @status              : available   
     */    
    
    public function create_certificate() {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active'] = 'create_certificate';
        $this->form_validation->set_rules('certificate_name', 'quiz', 'required');
        $this->form_validation->set_rules('certificate_description', 'quiz Description');
        $this->form_validation->set_rules('certificate_share_status', 'Cirtificate Share Status', 'required');
        $this->form_validation->set_rules('certificate_status', 'certificate Status', 'required');
        
        // Added for displying admin panel menu
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'create_certificate';
        
        $data['all_quizes'] = $this->super_admin_quiz_model->select_all_quiz_by_person_id($person_id);

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('admin/quiz/create_certificate', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $certicate_id = $this->super_admin_quiz_model->save_certificate_information();
            $data['certificate_info'] = $this->super_admin_quiz_model->select_certificate_by_id($certicate_id);
            redirect('super-admin/assign-certificate/' . $data['certificate_info']->certificate_public_id);
        }
    }

    public function assign_certificate($certicate_public_id) {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz';

        $data['certificate_info'] = $this->super_admin_quiz_model->select_certificate_by_public_id($certicate_public_id);
        $data['quizes'] = $this->super_admin_quiz_model->select_all_quiz_by_person_id($person_id);

        $data['quiz_certificate'] = $this->super_admin_quiz_model->select_all_quiz_by_certificate($data['certificate_info']->certificate_id);

        if (!$_POST) {
            $data['main_content'] = $this->load->view('admin/quiz/assign_certificate', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $certificate_id = $data['certificate_info']->certificate_id;
            $this->super_admin_quiz_model->update_quiz_certificate($certificate_id);
            redirect('super-admin/quizes/certificate');
        }
    }

    public function skip_assign_certificate() {
        redirect('super-admin/quizes/certmanage_gradeificate');
    }

    /**
     * @Description         : Displays the view certificate page in admin section
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Updated By          : Md Mashqur Ul Alam
     * @Updated Date Time   : 23-01-17
     * @parameter           : Null
     * @status              : available       
     * */
    public function view_certificate() {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active'] = 'view_certificate';
        
        // Added for displying admin panel menu
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'view_certificate';
        
        $data['all_certificate'] = $this->super_admin_quiz_model->select_all_certificate();
        $data['main_content'] = $this->load->view('admin/quiz/view_certificate', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function edit_certificate($certificate_public_id) {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz';
        $this->form_validation->set_rules('certificate_name', 'quiz', 'required');
        $this->form_validation->set_rules('certificate_description', 'quiz Description');
        $this->form_validation->set_rules('certificate_share_status', 'Cirtificate Share Status', 'required');
        $this->form_validation->set_rules('certificate_status', 'certificate Status', 'required');

        $data['certificate_info'] = $this->super_admin_quiz_model->select_certificate_by_public_id($certificate_public_id);

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('admin/quiz/edit_certificate', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_quiz_model->update_certificate_information($data['certificate_info']->certificate_id);
            $quiz_id = $this->input->post('quiz_id', TRUE);
            $data['certificate_info'] = $this->super_admin_quiz_model->select_certificate_by_public_id($certificate_public_id);
            redirect('super-admin/quizes/certificate');
        }
    }

    public function activate_certificate($certificate_public_id) {
        $data = array();
        $data['certificate_info'] = $this->super_admin_quiz_model->select_certificate_by_public_id($certificate_public_id);
        $this->super_admin_quiz_model->active_selected_certificate($data['certificate_info']->certificate_id);
        $data['certificate_info'] = $this->super_admin_quiz_model->select_certificate_by_public_id($certificate_public_id);
        echo $this->load->view('admin/quiz/view_certificate_actions', $data, TRUE);
    }

    public function inactivate_certificate($certificate_public_id) {
        $data = array();
        $data['certificate_info'] = $this->super_admin_quiz_model->select_certificate_by_public_id($certificate_public_id);
        $this->super_admin_quiz_model->inactive_selected_certificate($data['certificate_info']->certificate_id);
        $data['certificate_info'] = $this->super_admin_quiz_model->select_certificate_by_public_id($certificate_public_id);
        echo $this->load->view('admin/quiz/view_certificate_actions', $data, TRUE);
    }

    public function archive_certificate($certificate_public_id) {
        $data = array();
        $data['certificate_info'] = $this->super_admin_quiz_model->select_certificate_by_public_id($certificate_public_id);
        $this->super_admin_quiz_model->archive_selected_certificate($data['certificate_info']->certificate_id);
        $data['certificate_info'] = $this->super_admin_quiz_model->select_certificate_by_public_id($certificate_public_id);
        echo $this->load->view('admin/quiz/view_certificate_actions', $data, TRUE);
    }

    public function certificate_view($certificate_public_id) {
        $data = array();
        $data['certificate_info'] = $this->super_admin_quiz_model->select_certificate_by_public_id($certificate_public_id);
        $data['creator_info'] = $this->profile_model->person_info_by_person_id($data['certificate_info']->certificate_created_by);
        $this->load->view('admin/quiz/certificate_view', $data);
    }

    public function certificate_holders($certificate_public_id) {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz';

        $data['main_content'] = $this->load->view('admin/quiz/view_certificate_holders', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function view_question($quiz_url) {
        $data = array();
        $data['quiz_url'] = $quiz_url;
        $data['person_id'] = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz';

        $person_id = $this->session->userdata('person_id');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_url($quiz_url);
        $data['quiz_creator'] = $data['quiz_info']->quiz_created_by;
        $quiz_id = $data['quiz_info']->quiz_id;

        $data['mcq'] = $this->super_admin_quiz_model->select_multiple_choice_question($quiz_id);
        foreach ($data['mcq'] as $v_question) {
            $data['mcq_currect_answer'][$v_question->question_id] = $this->super_admin_quiz_model->select_mcq_currect_ans($v_question->question_id);
        }

        $data['true_false_question'] = $this->super_admin_quiz_model->select_true_false_question($quiz_id);
        foreach ($data['true_false_question'] as $v_question) {
            $data['true_false_currect_answer'][$v_question->question_id] = $this->super_admin_quiz_model->select_true_false_currect_ans($v_question->question_id);
        }

        $data['descriptive_question'] = $this->super_admin_quiz_model->select_descriptive_question_question($quiz_id);
        foreach ($data['descriptive_question'] as $v_question) {
            $data['descriptive_question_currect_answer'][$v_question->question_id] = $this->super_admin_quiz_model->select_descriptive_question_currect_ans($v_question->question_id);
        }

        $data['fill_blank_question'] = $this->super_admin_quiz_model->select_fill_blank_question_question($quiz_id);
        foreach ($data['fill_blank_question'] as $v_question) {
            $data['fill_blank_question_currect_answer'][$v_question->question_id] = $this->super_admin_quiz_model->select_fill_blank_question_currect_ans($v_question->question_id);
        }

        $data['main_content'] = $this->load->view('admin/quiz/view_question', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function manage_grade() {
        $data = array();
        $data['active'] = 'manage_grade';
        $data['main_content'] = $this->load->view('admin/quiz/manage_grade', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function save_question() {
        $this->form_validation->set_rules('question', 'Question', 'required|trim|max_length[50]');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('topic_id', 'Topic ', 'required|min_length[1]');
        $this->form_validation->set_rules('points_per_answer', 'Markes', 'required');
        $this->form_validation->set_rules('time_limit', 'time limit', 'required');
        $this->form_validation->set_rules('option', 'option', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'add_question';
            $data['all_topic'] = $this->super_admin_quiz_model->select_all_topic();
            $data['all_quiz'] = $this->super_admin_quiz_model->select_all_quiz();
            $data['main_content'] = $this->load->view('admin/add_question_form', $data, true);
            $this->load->view('admin/admin_admin_master', $data);
        } else {
            $this->super_admin_quiz_model->save_question_info();
            redirect('super-admin/quiz/add_question');
        }
    }

    public function update_question() {
        $this->form_validation->set_rules('question', 'Question', 'required|trim|max_length[50]');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('topic_id', 'Topic ', 'required|min_length[1]');
        $this->form_validation->set_rules('points_per_answer', 'Markes', 'required');
        $this->form_validation->set_rules('time_limit', 'time limit', 'required');
        $this->form_validation->set_rules('option', 'option', 'required');
        $this->form_validation->set_rules('question_type', 'question type', 'required');

        $question_id = $this->input->post('question_id', true);

        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'manage_question';
            $data['all_topic'] = $this->super_admin_quiz_model->select_all_topic();
            $data['all_quiz'] = $this->super_admin_quiz_model->select_all_quiz();
            $data['question_info'] = $this->super_admin_quiz_model->select_question_info_by_id($question_id);
            $data['option_info'] = $this->super_admin_quiz_model->select_option_info_by_id($question_id);
            $data['main_content'] = $this->load->view('admin/edit_question', $data, true);
            $this->load->view('admin/admin_admin_master', $data);
        } else {
            $this->super_admin_quiz_model->update_question_info($question_id);
            redirect('super-admin/quiz/manage_question');
        }
    }

    public function edit_question($question_id) {
        $data['active'] = 'manage_question';
        $data['all_topic'] = $this->super_admin_quiz_model->select_all_topic();
        $data['all_quiz'] = $this->super_admin_quiz_model->select_all_quiz();
        $data['question_info'] = $this->super_admin_quiz_model->select_question_info_by_id($question_id);
        $data['option_info'] = $this->super_admin_quiz_model->select_option_info_by_id($question_id);
        $data['main_content'] = $this->load->view('admin/edit_question', $data, true);
        $this->load->view('admin/admin_admin_master', $data);
    }

    public function activate_question($question_id) {
        $this->super_admin_quiz_model->active_selected_question($question_id);
        $data['question_info'] = $this->super_admin_quiz_model->select_question_info_by_id($question_id);
        $data['currect_answer'] = $this->super_admin_quiz_model->select_currect_ans($question_id);
        echo $this->load->view('admin/quiz/view_question_actions', $data, TRUE);
    }

    public function inactivate_question($question_id) {
        $this->super_admin_quiz_model->inactive_selected_question($question_id);
        $data['question_info'] = $this->super_admin_quiz_model->select_question_info_by_id($question_id);
        $data['currect_answer'] = $this->super_admin_quiz_model->select_currect_ans($question_id);
        echo $this->load->view('admin/quiz/view_question_actions', $data, TRUE);
    }

    public function archive_question($question_id) {
        $this->super_admin_quiz_model->archive_selected_question($question_id);
        $data['question_info'] = $this->super_admin_quiz_model->select_question_info_by_id($question_id);
        $data['currect_answer'] = $this->super_admin_quiz_model->select_currect_ans($question_id);
    }

    public function view_quiz_result($quiz_public_id) {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz';

        $data['quiz_info'] = $this->super_admin_quiz_model->select_quiz_by_public_id($quiz_public_id);
        $data['quiz_questions'] = $this->super_admin_quiz_model->select_active_question_by_quiz_id($data['quiz_info']->quiz_id);
        $data['quiz_result'] = $this->super_admin_quiz_model->select_quiz_result($person_id, $data['quiz_info']->quiz_id);

        $data['correct_ans'] = $correct_ans = $data['quiz_result']->quiz_correct_answer;
        $data['wrong_ans'] = $wrong_ans = $data['quiz_result']->quiz_wrong_answer;
        $data['total_question'] = $total_question = $data['quiz_result']->quiz_total_question;
        $data['total_marks'] = $total_marks = $data['quiz_result']->quiz_total_marks;
        $data['receive_marks'] = $receive_marks = $data['quiz_result']->quiz_receive_marks;
        $data['taken_time'] = $taken_time = $data['quiz_result']->quiz_finish_time;
        if (!$correct_ans) {
            $correct_ans = 0;
        }
        if (!$wrong_ans) {
            $wrong_ans = 0;
        }
        if (!$receive_marks) {
            $receive_marks = 0;
        }

        $data['unanswered'] = $total_question - ($correct_ans + $wrong_ans);


        if ($total_question) {
            $data['correct_percentage'] = ($correct_ans * 100) / $total_question;
        } else {
            $data['correct_percentage'] = 0;
        }
        if ($total_marks) {
            $data['marks_percentage'] = ($receive_marks * 100) / $total_marks;
        } else {
            $data['marks_percentage'] = 0;
        }

        $data['quiz_grade'] = $this->super_admin_quiz_model->select_quiz_grade($data['quiz_info']->quiz_id);
        if ($data['quiz_grade']) {
            foreach ($data['quiz_grade'] as $v_grade) {
                if ($receive_marks >= $v_grade->grade_number && $v_grade->grade_number > $temp_total) {
                    $temp_total = $v_grade->grade_number;
                    $grade_id = $v_grade->grade_id;
                } else {
                    $grade_id = $v_grade->grade_id;
                }
            }
            if ($grade_id) {
                $data['grade'] = $this->super_admin_quiz_model->select_grade_by_id($grade_id);
            }
        }

        $data['main_content'] = $this->load->view('admin/quiz/view_quiz_result', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

// 29-08-2016   
    function active_quiz() {
        $this->super_admin_quiz_model->active_quiz_status();
    }

    function inactive_quiz() {
        $this->super_admin_quiz_model->inactive_quiz_status();
    }

    public function add_topic() {
        $data = array();
        $data['person_id'] = $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz_topic';
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        // php form validation for form field
        $this->form_validation->set_rules('topic_name', 'Quiz topic name', 'required|trim|max_length[150]|callback_validate_topic_name[]');
        $this->form_validation->set_rules('topic_detail', 'Topic detail');
        $this->form_validation->set_rules('topic_url', 'Topic url', 'required|callback_validate_topic_url[]');
        $this->form_validation->set_rules('topic_status', 'Topic status', 'required');
        // end php form validation for form field
        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('admin/quiz/add_topic', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $data['topic_id'] = $this->super_admin_quiz_model->save_topic_info(); // save topic info and get last inserted id
            $data['topic_info'] = $this->super_admin_quiz_model->select_topic_by_id($data['topic_id']); // Select all the data of latest inserted id
            redirect('super-admin/manage-topic');
        }
    }

    /**
     * @Function            :   validate_topic_name
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   29-02-2016 11:05 AM   |
     * @Updated Date Time   :
     * @Updated By          :   
     * @Router              :   
     * @Works               :   validate topic name from add topic and edit topic
     * @parameter           :   
     * @Return              :   true/false
     * @Redirect            :   
     * @External call       :   
     * @Internal call       :   $this->add_topic (codeigniter callback function from validation rule for url)
     *
     * */
    public function validate_topic_name($topic_name, $old_topic_name) {
        $function_name = 'validate_topic_name';
        if ($old_topic_name == $topic_name) {
            return true;
        } else {
            $result = $this->super_admin_quiz_model->check_topic_name_existance($topic_name);
            if ($result == 1) {
                $this->form_validation->set_message($function_name, "Topic name already Exist");
                return false;
            }
        }
        return TRUE;
    }

    /**
     * @Function            :   validate_topic_url
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   29-02-2016 11:05 AM   |
     * @Updated Date Time   :
     * @Updated By          :   
     * @Router              :   
     * @Works               :   validate topic url from add topic and edit topic     *
     * @parameter           :   
     * @Return              :   true/false
     * @Redirect            :   
     * @External call       :   
     * @Internal call       :   $this->add_topic (codeigniter callback function from validation rule for url)
     *
     * */
    public function validate_topic_url($url, $old_url) {
        $function_name = 'validate_topic_url';
        if ($old_url == $url) {
            return true;
        } else {
            $result = $this->url_model->check_url_exists1($url);
            if ($result == 1) {
                $this->form_validation->set_message($function_name, "URL Already Exist");
                return false;
            } else {
                $sp = '/^[0-9a-zA-Z\-]+$/';
                if (!preg_match($sp, $url)) {
                    $this->form_validation->set_message($function_name, "Allowed valid chatacter 0-9, a-z or A-Z (space not allowed)");
                    return FALSE;
                } else if (strstr($url, ' ')) {
                    $this->form_validation->set_message($function_name, " Don't use Space if need use '-'. Allowed valid chatacter 0-9, a-z or A-Z");
                    return FALSE;
                } else if (preg_match('/--/', $url)) {
                    $this->form_validation->set_message($function_name, "URL Cann't contain multiple hypen");
                    return FALSE;
                } else if (substr($url, (strlen($url) - 1)) == '-') {
                    $this->form_validation->set_message($function_name, "No hypen allow at the last");
                    return FALSE;
                } else if ($url_change_different != '') {
                    if ($url_change_different < 1) {
                        $this->form_validation->set_message($function_name, "You can not change url within 1 days");
                        return FALSE;
                    }
                }
            }
        }
        return TRUE;
    }

    /**
     * @Function            :   edit_topic
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   29-02-2016 12:45 PM   |
     * @Updated Date Time   :
     * @Updated By          :   
     * @Router              :   super-admin/edit-topic/(:topic_url)
     *
     * @Works               :   Edit topic from backend
     *
     * @parameter           :   
     * @Return              :   no
     * @Redirect            :   super-admin/manage-topic
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function edit_topic($topic_url) {
        $data = array();
        $data['topic_url'] = $topic_url;
        $data['person_id'] = $person_id = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'add_quiz_topic';
        $data['topic_info'] = $this->super_admin_quiz_model->select_topic_by_url($topic_url);
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        if (!$data['topic_info']) {
            redirect('super-admin/manage-topic');
        }
        $data['topic_quizes'] = $this->super_admin_quiz_model->select_topic_quizes_by_topic_id($data['topic_info']->topic_id);
        $data['topic_creator'] = $this->profile_model->person_info_by_person_id($data['topic_info']->topic_created_by);
        $topic_name = $data['topic_info']->topic_name;
        $this->form_validation->set_rules('topic_name', 'Quiz topic name', 'required|trim|max_length[150]|callback_validate_topic_name[' . $topic_name . ']');
        $this->form_validation->set_rules('topic_url', 'Topic url', 'required|callback_validate_topic_url[' . $topic_url . ']');
        $this->form_validation->set_rules('topic_status', 'Topic status', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('admin/quiz/edit_topic', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->super_admin_quiz_model->update_topic_info($data);
            $data['topic_info'] = $this->super_admin_quiz_model->select_topic_by_id($data['topic_info']->topic_id);
            redirect('super-admin/manage-topic');
        }
    }

    /**
     * @Function            :   manage_topic
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   29-02-2016 11:35 PM   |
     * @Updated Date Time   :
     * @Updated By          :   Tania Akter  ( 26-07-2016) 
     * @Router              :   super-admin/manage-topic
     *
     * @Works               :   Manage topic from backend
     *                          manage topic which are added by tt or other user (all)
     *                          
     * @parameter           :   
     * @Return              :   no
     * @Redirect            :   super-admin/topic
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function manage_topic($page = NULL) {
        $data = array();
        $data['person_id'] = $this->session->userdata('person_id');
        $data['active_menu'] = 'quiz';
        $data['active_sub_menu'] = 'manage_quiz_topic'; // for add topic menu selected

        $data['page'] = $page;
        if (!$page) {
            $data['page'] = $page = 1;
        }
        $data['per_page_view'] = $config['per_page_view'] = 10;
        $config['start_limit_value'] = $start_limit_value = $data['page'] * $config['per_page_view'] - $config['per_page_view'];

        $data['all_topic'] = $this->super_admin_quiz_model->select_all_topic_by_pagination($config);
        $config['per_page_view'] = '';
        $data['total_data'] = count($this->super_admin_quiz_model->select_all_topic_by_pagination($config));

        foreach ($data['all_topic'] as $v_topic) {
            $data['topic_quizes'][$v_topic->topic_id] = $this->super_admin_quiz_model->select_topic_quizes_by_topic_id($v_topic->topic_id);
            $data['topic_creator'][$v_topic->topic_id] = $this->person_model->get_single_person_information_by_person_id($v_topic->topic_created_by); //tania
        }
        $data['main_content'] = $this->load->view('admin/quiz/view_topic', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            :   manage_topic
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   29-02-2016 11:35 PM   |
     * @Updated Date Time   :
     * @Updated By          :   
     * @Router              :   super-admin/manage-topic
     *
     * @Works               :   Manage topic from backend
     *                          manage topic which are added by tt or other user (all)
     *                          
     * @parameter           :   
     * @Return              :   no
     * @Redirect            :   super-admin/topic
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function topic_pagination($page = NULL) {
        $data = array();
        $data['person_id'] = $this->session->userdata('person_id');
        $data['active'] = 'manage_topic';

        if ($this->input->post('search_value', TRUE)) {
            $data['search_value'] = $config['search_value'] = $this->input->post('search_value', TRUE);
        } else {
            $data['search_value'] = $config['search_value'] = '';
        }

        $data['page'] = $page;
        if (!$page) {
            $data['page'] = $page = 1;
        }
        $data['per_page_view'] = $config['per_page_view'] = 10;
        $config['start_limit_value'] = $start_limit_value = $data['page'] * $config['per_page_view'] - $config['per_page_view'];

        $data['all_topic'] = $this->super_admin_quiz_model->select_all_topic_by_pagination($config);
        $config['per_page_view'] = '';
        $data['total_data'] = count($this->super_admin_quiz_model->select_all_topic_by_pagination($config));

        foreach ($data['all_topic'] as $v_topic) {
            $data['topic_quizes'][$v_topic->topic_id] = $this->super_admin_quiz_model->select_topic_quizes_by_topic_id($v_topic->topic_id);
            $data['topic_creator'][$v_topic->topic_id] = $this->profile_model->person_info_by_person_id($v_topic->topic_created_by);
        }
        echo $this->load->view('admin/quiz/view_topic_search', $data, TRUE);
    }

    /**
     * @Function            :   search_topic
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   29-02-2016 11:35 PM   |
     * @Updated Date Time   :
     * @Updated By          :   
     * @Router              :   super-admin/search-quiz-topic
     *
     * @Works               :   Manage topic from backend
     *                          manage topic which are added by tt or other user (all)
     *                          
     * @parameter           :   
     * @Return              :   no
     * @Redirect            :   super-admin/topic
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function search_quiz_topic($page = NULL) {
        $data = array();
        $data['person_id'] = $this->session->userdata('person_id');
        $data['active'] = 'manage_topic';

        if ($this->input->post('search_value', TRUE)) {
            $data['search_value'] = $config['search_value'] = $this->input->post('search_value', TRUE);
        } else {
            $data['search_value'] = $config['search_value'] = '';
        }

        $data['page'] = $page;
        if (!$page) {
            $data['page'] = $page = 1;
        }
        $data['per_page_view'] = $config['per_page_view'] = 3;
        $config['start_limit_value'] = $start_limit_value = $data['page'] * $config['per_page_view'] - $config['per_page_view'];

        $data['all_topic'] = $this->super_admin_quiz_model->select_all_topic_by_pagination($config);
        $config['per_page_view'] = '';
        $data['total_data'] = count($this->super_admin_quiz_model->select_all_topic_by_pagination($config));

        foreach ($data['all_topic'] as $v_topic) {
            $data['topic_quizes'][$v_topic->topic_id] = $this->super_admin_quiz_model->select_topic_quizes_by_topic_id($v_topic->topic_id);
            $data['topic_creator'][$v_topic->topic_id] = $this->profile_model->person_info_by_person_id($v_topic->topic_created_by);
        }

        echo $this->load->view('admin/quiz/view_topic_search', $data, TRUE);
    }

    function change_status($topic_url, $topic_status) {
        $data['topic_info'] = $this->super_admin_quiz_model->select_topic_by_url($topic_url);
        $this->super_admin_quiz_model->change_status($data['topic_info']->topic_id, $topic_status);
        $data['topic_quizes'][$data['topic_info']->topic_id] = $this->super_admin_quiz_model->select_topic_quizes_by_topic_id($data['topic_info']->topic_id);
        $data['topic_creator'][$data['topic_info']->topic_id] = $this->person_model->get_single_person_information_by_person_id($data['topic_info']->topic_created_by);
        echo $this->load->view('admin/quiz/view_topic_after_action', $data, TRUE);
    }

    public function delete_topic($topic_url) {
        $data['topic_info'] = $this->super_admin_quiz_model->select_topic_by_url($topic_url);
        $this->super_admin_quiz_model->delete_topic($data['topic_info']->topic_id);
    }

    public function view_topic_quiz($topic_url, $page = null) {
        $data = array();
        $data['person_id'] = $this->session->userdata('person_id');
        $data['active'] = 'manage_topic';
        if ($this->input->post('search_value', TRUE)) {
            $data['search_value'] = $config['search_value'] = $this->input->post('search_value', TRUE);
        } else {
            $data['search_value'] = $config['search_value'] = '';
        }

        $data['topic_info'] = $this->super_admin_quiz_model->select_topic_by_url($topic_url);
        $topic_id = $data['topic_info']->topic_id;
        $data['page'] = $page;
        if (!$page) {
            $data['page'] = $page = 1;
        }
        $data['per_page_view'] = $config['per_page_view'] = 3;
        $config['start_limit_value'] = $start_limit_value = $data['page'] * $config['per_page_view'] - $config['per_page_view'];

        $data['quizes'] = $this->super_admin_quiz_model->select_topic_quizes_by_topic_id($topic_id);
        $config['per_page_view'] = '';
        $data['total_data'] = count($this->super_admin_quiz_model->select_topic_quizes_by_topic_id($topic_id));

        foreach ($data['quizes'] as $v_quiz) {
            $data['creator'][$v_quiz->quiz_id] = $this->profile_model->person_info_by_person_id($v_quiz->quiz_created_by);
            $data['quiz_questions'][$v_quiz->quiz_id] = $this->super_admin_quiz_model->select_active_question_by_quiz_id($v_quiz->quiz_id);
            $data['quiz_attendies'][$v_quiz->quiz_id] = $this->super_admin_quiz_model->select_quiz_attendees($v_quiz->quiz_id);
        }
        $data['main_content'] = $this->load->view('admin/quiz/view_quiz', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

}
