<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Super_admin_classroom extends TT_admin_login {

    public function __construct() {
        parent::__construct();
        
        $this->load->model('super_admin_classroom_model', 'sa_class_model');
        $this->super_admin_classroom_model->check_for_tt_class_not_held();
    }

    public function index() {
        redirect('babbamamma');
    }

    /**
     * @Function            :   validate_classroom_title
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 04:40 PM   | 03-02-2016 02:50PM (make same as course name)
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   validate_classroom_title
     *
     * @parameter           :   NONE
     * @Return              :   boolean true/false
     * @Redirect            :   no
     * @Internal call       :   
     *
     * */
    public function validate_classroom_title($classroom_title) {
        $classroom_old_title = $this->input->post('classroom_old_title');
        return TRUE;
    }

    /**
     * @Function            :   validate_resource_person
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 04:40 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   resource person will be only talhatraining resource person whose are assigned in talhatraining feature
     *
     * @parameter           :   NONE
     * @Return              :   boolean true/false
     * @Redirect            :   no
     * @Internal call       :   
     *
     * */
    public function validate_resource_person($person_id) {
        $resource_person_info = $this->sa_class_model->select_resource_person_information($person_id);
        $feature_price_id = explode(',', $resource_person_info->feature_price_id);
        $data['virtual_classroom_feature_info'] = $this->super_admin_feature_model->select_feature_info_by_id($feature_price_id[0]);
        if ($resource_person_info) {
            $talhatraining_feature = $data['virtual_classroom_feature_info']->feature_price_talhatraining; //talhatraining feature = 1;            
            if ($talhatraining_feature == 1) { //FOR talhatraining feature
                return true;
            } else if ($data['virtual_classroom_feature_info']->feature_price_status == 3) { // FOR free feature
                return TRUE;
            } else {
                return TRUE;
            }
        } else {
            $this->form_validation->set_message('validate_resource_person', "selected resource person is not under talhatraining");
            return FALSE;
        }
    }

    /**
     * @Function            :   validate_resource_person
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 04:40 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   resource person will be only talhatraining resource person whose are assigned in talhatraining feature
     *
     * @parameter           :   NONE
     * @Return              :   boolean true/false
     * @Redirect            :   no
     * @Internal call       :   
     *
     * */
    public function validate_classroom_course_batch($course_batch_id) {
        $course_batch_id = $this->input->post('course_batch_id', TRUE);
        $course_batch_id_list = implode(',', $this->input->post('course_batch_id', TRUE));

        $resource_person_id = $this->input->post('resource_person', TRUE);
        $data['resource_person_info'] = $this->sa_class_model->select_resource_person_information($resource_person_id);
        $feature_price_id = explode(',', $data['resource_person_info']->feature_price_id);

        if ($feature_price_id[0]) {
            $virtual_classroom_info = $this->super_admin_feature_model->select_virtual_classroom_feature_info_by_id($feature_price_id[0]);
        }

        if (!$course_batch_id) {
            $this->form_validation->set_message('validate_classroom_course_batch', "<span style=color:red>Minimum one course batch is required</span>");
            return FALSE;
        } elseif (isset($course_batch_id)) {
            $tolal_student = $this->sa_class_model->select_selected_batches_total_student($course_batch_id_list);
            if ($tolal_student->total > $virtual_classroom_info->virtual_classroom_attendees_number) {
                $this->form_validation->set_message('validate_classroom_course_batch', "<span style=color:red>resource person virtual classroom attendees number is greater then selected batches total students</span>");
                return FALSE;
            }
            if (count($course_batch_id) >= 5) {
                $this->form_validation->set_message('validate_classroom_course_batch', "<span style=color:red>You can assign maximum 5 batch in a classroom</span>");
                return FALSE;
            }
            return TRUE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            :   validate_class_date
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 04:40 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   class date can not be previous date
     *
     * @parameter           :   NONE
     * @Return              :   boolean true/false
     * @Redirect            :   no
     * @Internal call       :   
     *
     * */
    public function validate_class_date($class_date) {
        $today = date('Y-m-d', strtotime(gmdate('Y-m-d')) - $this->session->userdata('time_offset'));
        if ($class_date < $today) {
            $this->form_validation->set_message('validate_class_date', "Class date cant't less then today");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            :   validate_class_start_time
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 05:01 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   class start time can not be less then now time
     *
     * @parameter           :   NONE
     * @Return              :   boolean true/false
     * @Redirect            :   no
     * @Internal call       :   
     *
     * */
    public function validate_class_start_time($class_start_time) {
        return TRUE;
        $class_date = $this->input->post('class_date');
        $now = date('H:i:s', gmdate('H:i:s') - $this->session->userdata('time_offset'));
        $class_start_time = date('H:i:s', $class_start_time);

        $today = date('Y-m-d', strtotime(gmdate('Y-m-d')) - $this->session->userdata('time_offset'));
        if ($class_date == $today) {
            if ($class_start_time < $now) {
                $this->form_validation->set_message('validate_class_start_time', "Class start time cant't less then now");
                return FALSE;
            }
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            :   validate_duration
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 05:01 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   Minimum class duration 30 minute
     *                          Maximum class duration 180 minute
     *
     * @parameter           :   $duration
     * @Return              :   boolean true/false
     * @Redirect            :   no
     * @Internal call       :   
     *
     * */
    public function validate_duration($duration) {
        if ($duration < 30) {
            $this->form_validation->set_message('validate_duration', "Minimum class duration 30 minute");
            return FALSE;
        } else if ($duration > 180) {
            $this->form_validation->set_message('validate_duration', "Maximum class duration 180 minute");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            :   validate_classroom_record_status
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 05:01 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   record status depends on selected resource person feature
     *
     * @parameter           :   $duration
     * @Return              :   boolean true/false
     * @Redirect            :   no
     * @Internal call       :   
     *
     * */
    public function validate_classroom_record_status($record_status) {
        $person_id = $this->input->post('resource_person', TRUE);
        $data['person_info'] = $this->sa_class_model->select_resource_person_information($person_id);
        $person_role = $data['person_info']->person_role;

        $feature_price_id = explode(',', $data['person_info']->feature_price_id);
        $data['virtual_classroom_feature_info'] = $this->super_admin_feature_model->select_active_feature_by_feature_id($feature_price_id[0]);
        $virtual_classroom_type = $data['virtual_classroom_feature_info']->virtual_classroom_type;
        if ($virtual_classroom_type == 1) {
            if ($record_status == '') {
                return TRUE;
            } else if ($record_status != '') {
                $this->form_validation->set_message('validate_classroom_record_status', "You don't have any access to select ");
                return FALSE;
            }
        } else if ($virtual_classroom_type == 2) {
            if ($record_status == '') {
                $this->form_validation->set_message('validate_classroom_record_status', "virtual classroom record status is required");
                return FALSE;
            } else if ($record_status == 1 || $record_status == 2) {
                return TRUE;
            }
        }
    }

    /**
     * @Function            :   validate_schedule_class
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 05:01 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   schedule class depends on selected resource person feature
     *
     * @parameter           :   $duration
     * @Return              :   boolean true/false
     * @Redirect            :   no
     * @Internal call       :   
     *
     * */
    public function validate_schedule_class() {
        $result = $this->check_feature_for_schedule_class_validation();
        if ($result == 2) {
            return TRUE;
        } else if ($result == 1) {
            $this->form_validation->set_message('validate_schedule_class', "<span style=color:red>Maximum number of class schedule is over in this schedule</span>");
            return FALSE;
        } else if ($result == 3) {
            $this->form_validation->set_message('validate_schedule_class', "<span style=color:red>Selected resource person feature is expired</span>");
            return FALSE;
        }
    }

    /**
     * @Function            :   check_student_in_multiple_batch
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-03 06:00 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   super-admin/check-student-in-multiple-batch
     *
     * @Works               :   check selected batch have have same student in more then one batche
     *
     * @parameter           :   NONE
     * @Return              :   
     * @Redirect            :   no
     *
     * @Internal call       :   
     * */
    public function check_student_in_multiple_batch() {
        $data = array();
        $matched_student_list = array();
        $batch_student_array = array();
        $data['select_batches'] = array();

        $batch_id_list = $this->input->post('batchList', TRUE);
        if ($batch_id_list) {
            $data['select_batches'] = $this->sa_class_model->select_course_selected_batch_info($batch_id_list);
        }

        $student_list = array();
        foreach ($data['select_batches'] as $k => $v_b) {
            $student_list1[$k] = $v_b->student_id;
            $student_list2 = explode(',', $student_list1[$k]);

            foreach ($student_list2 as $k => $v) {
                $student_list[] = $v;
            }
        }
        $student_list = array_count_values($student_list);
        $flag = 1;
        $matched_list = array();
        if ($student_list) {
            foreach ($student_list as $k => $v) {
                if ($v > 1) {
                    $matched_list[] = $k;
                    $flag = 2;
                }
            }
        }
        if ($flag === 2) {
            $matched_student_list = implode(',', $matched_list);
            $data['matched_student_list'] = $this->sa_class_model->select_student_info($matched_student_list);
            foreach ($data['matched_student_list'] as $v_match_student) {
                if ($v_match_student->payment_id) {
                    $data['student_payment_info'][$v_match_student->student_id] = $this->payment_model->payment_info_by_payment_id($v_match_student->payment_id);
                }
                $data['student_batches'][$v_match_student->student_id] = $this->super_admin_batch_model->select_student_assigned_batch($v_match_student->student_id);
            }
            echo $this->load->view('admin/classroom/matched_student_list', $data,TRUE);
            return;
        }
        if ($flag === 1) {
            echo 'no_matched';
            return;
        }
    }

    /**
     * @Function            :   schedule_classroom
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-21 08:00 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :
     *
     * @Works               :   check schedule for selected course based on selected resource person feature
     *
     * @parameter           :   NONE
     * @Return              :   integer value (1 = virtual_classroom_number overflow, 2 = allow, 3 = feature_price_expire_date is over)
     * @Redirect            :   no
     *
     * @Internal call       :   schedule_clssroom()
     *                          check_schedule_availability()
     *                          validate_schedule_class()
     *                          edit_clssroom_schedule()
     * */
    public function check_feature_for_schedule_class_validation() {
        $schedule_date = $this->input->post('class_date', TRUE);
        $schedule_time = $this->input->post('class_start_time', TRUE);
        $class_duration = $this->input->post('duration', TRUE) * 60;
        $classroom_id = $this->input->post('classroom_id', TRUE);
        $schedule_start_date_time = date('Y-m-d H:i:s', strtotime($schedule_date . ' ' . $schedule_time));
        $schedule_end_date_time = date('Y-m-d H:i:s', strtotime($schedule_start_date_time) + $class_duration);

        $person_id = $this->input->post('resource_person', TRUE);
        $data['person_info'] = $this->sa_class_model->select_resource_person_information($person_id);


        $data['feature_info'] = $this->super_admin_feature_model->check_course_feature_information($data['person_info']->person_id);
        if ($data['feature_info']) {
            $data['virtual_classroom_number'] = $data['feature_info']->virtual_classroom_number;
            $data['virtual_classroom_per_day'] = $data['feature_info']->virtual_classroom_per_day;
            $data['virtual_classroom_attendees_number'] = $data['feature_info']->virtual_classroom_attendees_number;
            $data['virtual_classroom_type'] = $data['feature_info']->virtual_classroom_type;
        } else {
            return 0;
        }

        $total_scheduled_class = 0;
        $course_id_list = '';
        $data['courses'] = $this->sa_class_model->select_resource_person_courses($data['person_info']->resource_person_id);
        foreach ($data['courses'] as $key => $value) {
            $course_id_list .= $value->course_id . ',';
        }

        $scheduled_class_in_date = $this->sa_class_model->person_class_schedule_by_course_list_and_date($classroom_id, $course_id_list, $schedule_date);
        $total_scheduled_class_in_date = count($scheduled_class_in_date);
        if ($total_scheduled_class_in_date >= $data['virtual_classroom_per_day']) {
            return 4;  // class per day is over 
        }

        $scheduled_class = $this->sa_class_model->person_class_schedule_by_course_list_and_date_time($classroom_id, $course_id_list, $schedule_start_date_time, $schedule_end_date_time);
        $total_scheduled_class = count($scheduled_class);
        if ($total_scheduled_class >= $data['virtual_classroom_number']) {
            return 1;  // maximum number of schedule is over in this time
        }

        return 2; // schedule available
    }

    /**
     * @Function            :   check_feature_info
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-21 08:00 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :
     *
     * @Works               :   check schedule by delected resource person feature price info
     *
     * @parameter           :   NONE
     * @Return              :   string (NeedUpdate, Updated)
     * @Redirect            :   no
     *
     * @External call       :   call from ajax
     *                          schedule_classroom view
     *                          edit_schedule_classroom view
     * @Internal call       :
     *
     * */
    public function check_feature_info($person_id) {
        $data['last_feature_detail'] = $result = $this->payment_model->select_last_feature_payment_info_by_id($person_id);
        $payment_id = $data['last_feature_detail']->payment_id;
        $data['bill_payment_info'] = $this->payment_model->payment_info_by_payment_id($payment_id);
        $data['total_paid'] = $this->payment_model->total_payment_info_by_payment_id($payment_id);

        $data['today'] = $today = date('Y-m-d', strtotime(gmdate("Y-m-d")) - $this->session->userdata('time_offset'));
        if ($data['last_feature_detail']->feature_price_expire_date < $today && $data['last_feature_detail']->feature_price_payment_status == 1) {
            return 'NeedUpdate';
        }
        if ($data['last_feature_detail']->payment_status != 1 && $data['last_feature_detail']->feature_price_payment_status == 2) {
            return 'NeedUpdate';
        }
        return 'Updated';
    }

    public function check_classroom_feature_status() {
        $response = $this->check_feature_for_schedule_class_validation();
        echo $response;
        return;
    }

    /**
     * @Function            :   select_category_course
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-22 10:30 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :
     *
     * @Works               :   select talhatrining category course from schedule classroom  when select course from modal
     *
     * @parameter           :
     * @Return              :   echo course_list view
     * @Redirect            :   no
     *
     * @External call       :   call from ajax
     *                          schedule_classroom view (add_course modal)
     *                          edit_schedule_classroom view (add_course modal)
     * @Internal call       :
     *
     * */
    public function select_category_course() {
        $category_id = $_POST['category_id'];
        $data['courses'] = $this->sa_class_model->select_talhatraining_category_course_by_category_id($category_id);
        foreach ($data['courses'] as $key => $v_course) {
            $data['course_batch'] = $this->sa_class_model->select_course_active_batches($v_course->course_id);
            if (!$data['course_batch']) {
                unset($data['courses'][$key]);
                continue;
            }
            $data['class_session_number'][$v_course->course_id] = $this->sa_class_model->select_class_session_number($v_course->course_id);
            $data['resource_person_info'][$v_course->course_id] = $this->sa_class_model->select_resource_person_information($v_course->c_resource_person_id);
        }
        echo $this->load->view('admin/classroom/course_list', $data,TRUE);
    }

    /**
     * @Function            :   classroom_selected_batch_info
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   02-02-2016 12:34 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :
     *
     * @Works               :   collect selected batch information
     *
     * @parameter           :
     * @Return              :   no
     * @Redirect            :   no
     *
     * @External call       :   call from ajax
     *                          schedule_classroom view
     *                          edit_schedule_classroom view
     * @Internal call       :
     *
     * */
    public function classroom_selected_batch_info() {
        $data = array();
        $course_id = $this->input->post('course_id', TRUE);
        $course_batch_id_list = $this->input->post('batch_list', TRUE);
        $total_student = 0;
        if ($course_batch_id_list) {
            $data['course_info'] = $this->sa_class_model->select_course_info_by_id($course_id);
            $data['selected_batch_total_student'] = $this->sa_class_model->select_selected_batches_total_student($course_batch_id_list);
            if ($data['course_info']) {
                $data['resource_person_info'] = $this->sa_class_model->select_resource_person_information($data['course_info']->resource_person_id);
                $feature_price_id = explode(',', $data['resource_person_info']->feature_price_id);
                $data['virtual_classroom_feature_info'] = $this->super_admin_feature_model->select_active_feature_by_feature_id($feature_price_id[0]);
                if ($data['virtual_classroom_feature_info']) {
                    $data['virtual_classroom_number'] = $data['virtual_classroom_feature_info']->virtual_classroom_number;
                    $data['virtual_classroom_attendees_number'] = $data['virtual_classroom_feature_info']->virtual_classroom_attendees_number;
                    $data['virtual_classroom_type'] = $data['virtual_classroom_feature_info']->virtual_classroom_type;
                }
                if ($data['selected_batch_total_student']->total) {
                    $total_student = $data['selected_batch_total_student']->total;
                }
            }
            echo '<span style=color:green>Total student: ' . $total_student . '<span><br>';
            echo '<input type="hidden" id="total_student" name="total_student" value="' . $total_student . '">';
            if ($data['virtual_classroom_feature_info']->virtual_classroom_attendees_number < $total_student) {
                echo '<input type="hidden" id="total_student_allow" name="total_student_allow" value="no">';
                echo "<span id='possible_attendees' style=color:red>You can't add more then (" . $data['virtual_classroom_feature_info']->virtual_classroom_attendees_number . ") students in one class<span>";
            } else {
                echo '<input type="hidden" id="total_student_allow" name="total_student_allow" value="yes">';
            }
        } else {
            echo '<span style=color:green>Total student: ' . $total_student . '<span><br>';
            echo '<input type="hidden" id="total_student" name="total_student" value="' . $total_student . '">';
            echo '<input type="hidden" id="total_student_allow" name="total_student_allow" value="no">';
            echo "<span id='possible_attendees' style=color:red>You must have to select minimum one batch <span>";
        }


        return;
    }

    /**
     * @Function            :   check_schedule_availability
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-22 10:30 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :
     *
     * @Works               :   select talhatrining category course from schedule classroom  when select course from modal
     *
     * @parameter           :
     * @Return              :   integer value (1 = virtual_classroom_number overflow, 2 = allow, 3 = feature_price_expire_date is over)
     * @Redirect            :   no
     *
     * @External call       :   call from ajax
     *                          schedule_classroom view
     *                          edit_schedule_classroom view
     * @Internal call       :
     *
     * */
    public function check_schedule_availability() {
        $response = $this->check_feature_for_schedule_class_validation();
        echo $response;
    }

    /**
     * @Function            :   select_classroom_course_batch
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   01-02-2016 07:25 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   super-admin/select-classroom-course-batch
     *
     * @Works               :   select_classroom_course_batch using ajax 
     *
     * @parameter           :   
     * @Return              :   echo batch view
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function select_classroom_course_batch() {
        $course_id = $this->input->post('course_id', TRUE);
        $data['batch_id_list'] = $this->input->post('batchList', TRUE);
        $data['course_info'] = $this->sa_class_model->select_course_info_by_id($course_id);
        $data['resource_person_info'] = $this->sa_class_model->select_resource_person_information($data['course_info']->resource_person_id);
        $data['course_batches'] = $this->sa_class_model->select_course_active_batches($course_id);

        $feature_price_id = explode(',', $data['resource_person_info']->feature_price_id);
        $data['virtual_classroom_feature_info'] = $this->super_admin_feature_model->select_active_feature_by_feature_id($feature_price_id[0]);
        if ($data['virtual_classroom_feature_info']) {
            $data['virtual_classroom_number'] = $data['virtual_classroom_feature_info']->virtual_classroom_number;
            $data['virtual_classroom_attendees_number'] = $data['virtual_classroom_feature_info']->virtual_classroom_attendees_number;
            $data['virtual_classroom_type'] = $data['virtual_classroom_feature_info']->virtual_classroom_type;
        }

        $counter = 0;
        foreach ($data['course_batches'] as $batch_value) {
            ++$counter;
            if ($counter <= 3) {
                $data['first_column_batch'][] = $batch_value;
            } elseif ($counter <= 6) {
                $data['second_column_batch'][] = $batch_value;
            } else {
                $data['third_column_batch'][] = $batch_value;
            }
        }
        echo $this->load->view('admin/classroom/course_batch_list', $data,TRUE);
    }

    /**
     * @Function            :   select_feature_information
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 02:55 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   super-admin-select-feature-information
     *
     * @Works               :   select feature information using ajax 
     *
     * @parameter           :   
     * @Return              :   echo data as responce text
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function select_feature_information() {

        $person_id = $this->input->post('resource_person', TRUE);
        $data['person_info'] = $this->sa_class_model->select_resource_person_information($person_id);
        $feature_price_id = explode(',', $data['person_info']->feature_price_id);
        $data['virtual_classroom_feature_info'] = $this->super_admin_feature_model->select_active_feature_by_feature_id($feature_price_id[0]);
        $data['virtual_classroom_number'] = 0;
        if ($data['virtual_classroom_feature_info']) {
            $data['virtual_classroom_number'] = $data['virtual_classroom_feature_info']->virtual_classroom_number;
            $data['virtual_classroom_attendees_number'] = $data['virtual_classroom_feature_info']->virtual_classroom_attendees_number;
            $data['virtual_classroom_type'] = $data['virtual_classroom_feature_info']->virtual_classroom_type;
        }

        echo $data['virtual_classroom_number'] . ' ##';
        echo $data['virtual_classroom_attendees_number'] . ' ##';
        echo $data['virtual_classroom_type'] . ' ##';
    }

    /**
     * @Function            :   classroom_review_and_publish
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 02:55 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :
     *
     * @Works               :   classroom review and publish user can preview classroom and able to change classroom url
     *
     * @parameter           :   $classroom_url
     * @Return              :   
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    /**
     * @Function            :   publish_classroom_schedule
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 02:55 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :
     *
     * @Works               :   publish classroom and redirect to upcomming class
     *
     * @parameter           :   $classroom_url
     * @Return              :   
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */

    /**
     * @Function            :   upcoming_class
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 02:55 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   super-admin/upcoming-class
     *
     * @Works               :   Talhatraining upcomming class
     *
     * @parameter           :   
     * @Return              :   
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function ajax_check_classroom_url_exist() {
        $classroom_url = $this->input->post('classroom_url', TRUE);
        $classroom_recent_url = $this->input->post('classroom_recent_url', TRUE);
        if ($classroom_recent_url != $classroom_url) {
            echo $this->url_model->check_url_exists1($classroom_url);
        } else {
            echo 1;
        }
    }

    /**
     * @Function            :   update_classroom_url
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 02:55 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   super-admin/upcoming-class
     *
     * @Works               :   update classroom url from review and publish
     *
     * @parameter           :   $urlID, $NewURL
     * @Return              :   
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function update_classroom_url($urlID, $NewURL) {
        $NewURL1 = urldecode($NewURL);
        $this->url_model->update_classroom_url($urlID, $NewURL1);
        $data['classroom_info'] = $this->sa_class_model->select_classroom_info_by_url($NewURL);
        echo $this->load->view('user/class/review_publish_updated_url_view', $data, TRUE);
    }

    /**
     * @Function            :   upcoming_class
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 02:55 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   super-admin/upcoming-class
     *
     * @Works               :   Talhatraining upcomming class
     *
     * @parameter           :   
     * @Return              :   
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    /**
     * @Function            :   current_class
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 02:55 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   super-admin/current-class
     *
     * @Works               :   Talhatraining current class
     *
     * @parameter           :   
     * @Return              :   
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    /**
     * @Function            :   previous_class
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 02:55 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   super-admin/previous-class
     *
     * @Works               :   Talhatraining previous class
     *
     * @parameter           :   
     * @Return              :   
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    /**
     * @Function            :   edit_schedule_classroom
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 02:55 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   super-admin/edit-classroom-schedule/(:any)
     *
     * @Works               :   edit classroom schedule of talhatraining course
     *
     * @parameter           :   $classroom_url
     * @Return              :   
     * @Redirect            :   redirect to super-admin-dashboard 
     *                              if person have no previlage to change course classroom schedule
     *                              if classroom url not found
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */

    /**
     * @Function            :   delete_class_schedule
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 02:55 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   super-admin/edit-classroom-schedule/(:any)
     *
     * @Works               :   delete class schedule using classroom_id
     *                          check authentication
     *
     * @parameter           :   $classroom_id
     * @Return              :   no
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function delete_class_schedule($classroom_id) {
        $allow = TRUE;
        if ($allow) {
            $this->sa_class_model->delete_classroom_schedule($classroom_id);
            echo '';
        }
    }

    /**
     * @Function            :   cancel_class_schedule
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-23 02:55 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   super-admin/edit-classroom-schedule/(:any)
     *
     * @Works               :   cancel class schedule using classroom_id
     *                          check authentication
     *
     * @parameter           :   $classroom_id
     * @Return              :   no
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function cancel_class_schedule($classroom_id) {
        $person_id = $this->session->userdata('person_id');
        $data['person_info'] = $this->sa_class_model->person_info_by_person_id($person_id);

        $data['classroom_info'] = $this->sa_class_model->select_classroom_info_by_id($classroom_id);
        $data['classroom_assigned_student'] = $this->sa_class_model->select_assigned_student($classroom_id);
        $course_id = $data['classroom_info']->course_id;
        $data['course_info'] = $this->sa_class_model->select_course_info_by_id($course_id);
        $resource_person_id = $data['course_info']->resource_person_id;
        $data['resource_person_info'] = $this->sa_class_model->select_resource_person_information($resource_person_id);
        $data['classroom_creator_info'] = $this->profile_model->person_info_by_id($data['classroom_info']->person_id);

        $allow = TRUE;
        if ($allow) {
            $this->sa_class_model->cancel_classroom_schedule($classroom_id);
            $data['classroom_info'] = $this->sa_class_model->select_classroom_info($classroom_id);
            echo $this->load->view('admin/classroom/classroom_row', $data,TRUE);
        }
    }

    /**
     * @Function            :   unassign_student
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-25 12:16 PM   |
     * @Updated Date Time   :
     * @Updated By          :   
     * @Router              :   super-admin/unassign-student/(:any)/(:any)
     *
     * @Works               :   assign student from ajax
     *
     * @parameter           :   $student_id (encrypted), $classroom_url
     * @Return              :   no
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function unassign_student($student_id, $classroom_url) {
        $data['classroom_info'] = $this->sa_class_model->select_classroom_info_by_url($classroom_url);
        $data['student_info'] = $this->classroom_model->select_student_info_by_student_id($student_id);
        $data['student_payment_info'] = $this->payment_model->payment_info_by_payment_id($data['student_info']->payment_id);
        $data['registered_student_status'] = $this->classroom_model->select_assigned_student_by_student_id($data['student_info']->student_id, $data['classroom_info']->classroom_id);

        $course_id = $data['classroom_info']->course_id;
        $data['course_info'] = $this->sa_class_model->select_course_info_by_id($course_id);
        $resource_person_id = $data['course_info']->resource_person_id;
        $data['resource_person_info'] = $this->sa_class_model->select_resource_person_information($resource_person_id);

        $feature_price_id = explode(',', $data['resource_person_info']->feature_price_id);
        $data['virtual_classroom_feature_info'] = $this->classroom_model->select_active_feature_by_feature_id($feature_price_id[0]);
        if ($data['virtual_classroom_feature_info']) {
            $data['virtual_classroom_number'] = $data['virtual_classroom_feature_info']->virtual_classroom_number;
            $data['virtual_classroom_attendees_number'] = $data['virtual_classroom_feature_info']->virtual_classroom_attendees_number;
            $data['virtual_classroom_type'] = $data['virtual_classroom_feature_info']->virtual_classroom_type;
        }
        $data['assigned_student'] = $this->sa_class_model->select_assigned_student($data['classroom_info']->classroom_id);

        $this->db->where('classroom_student_id', $data['registered_student_status']->classroom_student_id)->delete('tbl_classroom_student');

        $data['registered_student_status'] = $this->classroom_model->select_assigned_student_by_student_id($data['student_info']->student_id, $data['classroom_info']->classroom_id);
        echo $this->load->view('admin/classroom/course_registered_student_action', $data, true);
    }

    /**
     * @Function            :   join_class
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-01-25 02:55 PM   |
     * @Updated Date Time   :
     * @Updated By          :   
     * @Router              :   super-admin/unassign-student/(:any)/(:any)
     *
     * @Works               :   super admin or admin can join in tt classroom class
     *
     * @parameter           :   $classroom_url
     * @Return              :   no
     * @Redirect            :   no
     *
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function join_class($classroom_url) {
        $person_id = $this->session->userdata('person_id');
        $person_role = $this->session->userdata('person_role');        
        $now = date('Y-m-d H:i:s', strtotime(gmdate('Y-m-d H:i:s')));

        $data['classroom_info'] = $this->sa_class_model->select_classroom_info_by_url($classroom_url);

        $course_id = $data['classroom_info']->course_id;
        $data['course_info'] = $this->sa_class_model->select_course_info_by_id($course_id);
        if (!$data['course_info']) {
            $sdata = array();
            $sdata['message'] = 'This Course Informationis not Found';
            $this->session->set_userdata($sdata);
            redirect('super-admin-dashboard');
        }

        $resource_person_id = $data['course_info']->resource_person_id;
        $data['resource_person_info'] = $this->sa_class_model->select_resource_person_information($resource_person_id);

        $data['classroom_creator_info'] = $this->profile_model->person_info_by_id($data['classroom_info']->person_id);


        $class_start_time = date('Y-m-d H:i:s', strtotime($data['classroom_info']->class_start_time));
        $class_time_in_second = $data['classroom_info']->class_duration * 60 * 60;
        $class_possible_end_time = date("Y-m-d H:i:s", (strtotime($class_start_time) + $class_time_in_second));

       // $base_url = "http://classroom.talhatraining.com/";
                   $base_url = "http://localhost/classroom/";
        $redirect_url = "$base_url#$classroom_url";
        header("location: $redirect_url");
    }

    /*
      -----------@@@RIPON@ Start Super Admin Classroom Part----------------------------------
     */

    /**
     * @Function            : schedule_classroom 
     * @Used IN             : @function-'schedule_classroom.php' 
     * @Description         : Schedule classroom in super admin 
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : 21-01-2016 08:00 PM
     * @Updated Date Time   : 15-03-2016 12:25 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function schedule_classroom() {
        $data = array();
        $data['active_menu'] = 'classroom';
        $data['active_sub_menu'] = 'schedule_class';
        $tt_teacher = $this->profile_model->get_all_resource_person_id_by_resource_person_type(1);
        if ($tt_teacher) {
            $data['course_category'] = $this->super_admin_course_model->select_course_category_by_resource_person_id(implode(',', $tt_teacher));
        } else {
            $data['course_category'] = '';
        }
        $this->form_validation->set_rules('classroom_title', 'Classroom Title', 'required|trim|max_length[256]');
        $this->form_validation->set_rules('hidden_course_id', 'Course Name', 'required|trim');
        $this->form_validation->set_rules('hidden_course_name', 'Course Name', 'trim');
        $this->form_validation->set_rules('class_start_date', 'Class Start Date', 'required|trim');
        $this->form_validation->set_rules('class_start_time', 'Class Start Time', 'required|trim');
        $this->form_validation->set_rules('class_duration', 'Class Duration', 'required|trim');
        $this->form_validation->set_rules('classroom_instruction', 'Classroom Instruction', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('admin/classroom/schedule_class', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $classroom_id = $this->sa_class_model->save_classroom_information();
            $data['classroom_info'] = $this->sa_class_model->select_classroom_info_by_classroom_id($classroom_id);
            redirect('classroom-review-and-publish/' . $data['classroom_info']->url);
        }
    }

    /**
     * @Function            : edit_schedule_classroom 
     * @Used IN             : @function-'edit_schedule_classroom.php' 
     * @Description         : edit Schedule classroom in super admin 
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : 21-01-2016 08:00 PM
     * @Updated Date Time   : 16-03-2016 11:13 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function edit_schedule_classroom($classroom_url) {
        $data = array();
        $data['active_menu'] = 'classroom';
        $data['active_sub_menu'] = 'schedule_class';

        $data['classroom_info'] = $this->sa_class_model->select_classroom_info_by_classroom_url($classroom_url);
        if ($data['classroom_info']) {
            
        }
        $tt_teacher = $this->profile_model->get_all_resource_person_id_by_resource_person_type(1);
        $data['course_category'] = $this->super_admin_course_model->select_course_category_by_resource_person_id(implode(',', $tt_teacher));
        $data['feature_info'] = $this->super_admin_feature_model->check_tt_resource_person_feature_sataus($data['classroom_info']->resource_person_id);

        $this->form_validation->set_rules('classroom_title', 'Classroom Title', 'required|trim|max_length[256]');
        $this->form_validation->set_rules('hidden_course_id', 'Course Name', 'required|trim');
        $this->form_validation->set_rules('hidden_course_name', 'Course Name', 'trim');
        $this->form_validation->set_rules('class_start_date', 'Class Start Date', 'required|trim');
        $this->form_validation->set_rules('class_start_time', 'Class Start Time', 'required|trim');
        $this->form_validation->set_rules('class_duration', 'Class Duration', 'required|trim');
        $this->form_validation->set_rules('classroom_instruction', 'Classroom Instruction', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('admin/classroom/edit_classroom_schedule', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $classroom_id = $this->sa_class_model->update_class_schedule_information($data['classroom_info']);
            $data['classroom_info'] = $this->sa_class_model->select_classroom_info_by_classroom_id($classroom_id);
            redirect('classroom-review-and-publish/' . $data['classroom_info']->url);
        }
    }

    /**
     * @Function            : classroom_review_and_publish 
     * @Used IN             : @function-'schedule_classroom'   this[@Controller] 
     * @Description         : review and published in super admin 
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : 21-01-2016 08:00 PM
     * @Updated Date Time   : 15-03-2016 12:25 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function classroom_review_and_publish($classroom_url) {
        $data = array();
        $data['active_menu'] = 'classroom';
        $data['active_sub_menu'] = 'schedule_class';
        $data['classroom_info'] = $this->sa_class_model->select_classroom_info_by_classroom_url($classroom_url);
        if (!$data['classroom_info']) {
            redirect();
        }
        $data['course_info'] = $this->super_admin_course_model->select_course_value_by_course_id($data['classroom_info']->course_id);
        if (!$data['course_info']) {
            redirect();
        }
        $data['classroom_id'] = $data['classroom_info']->classroom_id;
        $data['course_id'] = $data['classroom_info']->course_id;
        $data['main_content'] = $this->load->view('admin/classroom/schedule_class_review_and_publish', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : publish_classroom_schedule 
     * @Used IN             : @function-'schedule_classroom'   this[@Controller] 
     * @Description         : published classroom in super admin 
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : 21-01-2016 08:00 PM
     * @Updated Date Time   : 15-03-2016 11:30 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function publish_classroom_schedule() {
        redirect('super-admin/upcoming-class');
    }

    /**
     * @Function            : update_classroom_url_form 
     * @Used IN             : @function-'review_and_publish.php' 
     * @Description         : update classroom url form
     * @Developed By        : Copied from 'classroom(controller)'
     * @Start DateTime      : 15-03-2016 11:13 PM    
     * @Status              : available      
     * */
    function update_classroom_url_form() {
        $classroom_id = $this->input->post('classroom_id', TRUE);
        $data['classroom_info'] = $this->sa_class_model->select_classroom_info_by_classroom_id($classroom_id);
        echo $this->load->view('admin/classroom/ajax_page/add_classroom_url_form', $data, true);
    }

    /**
     * @Function            : check_classroom_url 
     * @Used IN             : @function-'review_and_publish.php' 
     * @Description         : check class url
     * @Developed By        : Copied from 'classroom(controller)'
     * @Start DateTime      : 15-03-2016 11:13 PM  
     * @Status              : available      
     * */
    function check_classroom_url() {
        $new_classroom_url = $this->input->post('new_classroom_url', TRUE);
        echo $this->url_model->check_url_exists1($new_classroom_url);
    }

    /**
     * @Function            : save_update_classroom_url 
     * @Used IN             : @function-'review_and_publish.php' 
     * @Description         : save update classroom url
     * @Developed By        : Copied from 'classroom(controller)'
     * @Start DateTime      : 15-03-2016 11:13 PM     
     * @Status              : available      
     * */
    function save_update_classroom_url() {
        $new_classroom_url = $this->input->post('new_classroom_url', TRUE);
        $classroom_id = $this->input->post('classroom_id', TRUE);
        $data['classroom_info'] = $this->sa_class_model->select_classroom_info_by_classroom_id($classroom_id);
        if ($new_classroom_url != $data['classroom_info']->url) {
            echo $this->url_model->update_classroom_url($data['classroom_info']->classroom_url_id, $new_classroom_url);
        } else {
            echo $data['classroom_info']->url;
        }
    }

    /**
     * @Function            : get_selected_course_by_category_id 
     * @Used IN             : @function-'schedule_classroom.php'  
     * @Description         : Schedule classroom in super admin 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 21-01-2016 08:00 PM     
     * @Status              : available      
     * */
    function get_selected_course_by_category_id() {
        $tt_teacher1 = $this->profile_model->get_all_resource_person_id_by_resource_person_type(1);
        $tt_teacher = implode(',', $tt_teacher1);
        $course_category_id = $this->input->post('course_category_id', TRUE);
        $data['all_courses'] = $this->super_admin_course_model->select_course_by_course_category_id($course_category_id, $tt_teacher);
        echo $this->load->view('admin/classroom/ajax_page/view_course', $data, true);
    }

    /**
     * @Function            : get_course_feature_information 
     * @Used IN             : @function-'view_course.php'{@modal[superadmin/classroom/schedulr_class.php]}  
     * @Description         : get course feature information 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 16-03-2016 12:21 AM     
     * @Status              : available      
     * */
    function get_course_feature_information() {
        $classroom_type = '';
        $course_id = $this->input->post('course_id', TRUE);
        $course_info = $this->super_admin_course_model->select_course_value_by_course_id($course_id);
        $feature_info = $this->super_admin_feature_model->check_tt_resource_person_feature_sataus($course_info->resource_person_id);
        if ($feature_info->virtual_classroom_type == 1) {
            $classroom_type = 'Live Broadcasting';
        } else if ($feature_info->virtual_classroom_type == 2) {
            $classroom_type = 'Live Broadcasting and Recording';
        }
        echo $feature_info->virtual_classroom_attendees_number . ',' . $classroom_type;
    }

    /**
     * @Function            : check_resource_person_feature_status 
     * @Used IN             : @function-'schedule_classroom.php'  
     * @Description         : check resource person stataus
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-03-2016 01:00 PM     
     * @Status              : available      
     * */
    function check_resource_person_feature_status() {
        $course_id = $this->input->post('course_id', TRUE);
        $course_info = $this->super_admin_course_model->select_course_value_by_course_id($course_id);
        $feature_info = $this->super_admin_feature_model->check_tt_resource_person_feature_sataus($course_info->resource_person_id);
        if ($feature_info) {
            echo 1;
        } else {
            echo 2;
        }
    }

    /**
     * @Function            : check_classroom_start_date 
     * @Used IN             : @function-'schedule_classroom.php'  
     * @Description         : check classroom start date
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-03-2016 05:13 PM     
     * @Status              : available      
     * */
    function check_classroom_start_date() {
        $course_id = $this->input->post('course_id', TRUE);
        $classroom_id = $this->input->post('classroom_id', TRUE);
        $class_start_date = $this->input->post('class_start_date', TRUE);
        $todays_date = date('Y-m-d', (time() - $this->session->userdata('time_offset')));
        if ($class_start_date >= $todays_date) {
            $course_info = $this->super_admin_course_model->select_course_value_by_course_id($course_id);
            $all_course1 = $this->super_admin_course_model->select_all_course_by_resource_person_id($course_info->resource_person_id);
            $all_course = implode(',', $all_course1);
            $total_class = count($this->sa_class_model->get_total_classroom_in_single_date($classroom_id, $class_start_date, $all_course));
            if ($total_class > 5) {
                echo 3;
            } else {
                echo 1;
            }
        } else {
            echo 2;
        }
    }

    /**
     * @Function            : check_classroom_start_time 
     * @Used IN             : @function-'schedule_classroom.php'  
     * @Description         : check classroom start date time
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-03-2016 05:49 PM     
     * @Status              : available      
     * */
    function check_classroom_start_time() {
        $class_start_date = $this->input->post('class_start_date', TRUE);
        $class_start_time = $this->input->post('class_start_time', TRUE);
        $class_start_date_time1 = $class_start_date . ' ' . $class_start_time;
        $todays_date = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $class_start_date_time2 = strtotime($class_start_date_time1);
        $class_start_date_time = date("Y-m-d H:i", $class_start_date_time2);
        if ($class_start_date_time >= $todays_date) {
            echo 1;
        } else {
            echo 2;
        }
    }

    /**
     * @Function            : check_classroom_duration 
     * @Used IN             : @function-'schedule_classroom.php'  
     * @Description         : check duration
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-03-2016 06:36 PM     
     * @Status              : available      
     * */
    function check_classroom_duration() {
        $course_id = $this->input->post('course_id', TRUE);
        $course_info = $this->super_admin_course_model->select_course_value_by_course_id($course_id);
        $all_course1 = $this->super_admin_course_model->select_all_course_by_resource_person_id($course_info->resource_person_id);
        $all_course = implode(',', $all_course1);
        $class_start_date = $this->input->post('class_start_date', TRUE);
        $class_start_time1 = $class_start_date . ' ' . date('H:i:s', strtotime($this->input->post('class_start_time', TRUE)));
        $class_duration = $this->input->post('class_duration', TRUE);
        $classroom_id = $this->input->post('classroom_id', true);
        $class_end_time1 = strtotime($class_start_time1) + ($class_duration * 60);
        $class_start_time = date('Y-m-d H:i:s', strtotime("$class_start_time1"));
        $class_end_time = date('Y-m-d H:i:s', $class_end_time1);
        $total_class = count($this->sa_class_model->check_classroom_schedule($classroom_id, $all_course, $class_start_time, $class_end_time));
        if ($total_class > 0) {
            echo 2;
        } else {
            echo 1;
        }
    }

    /**
     * @Function            : check_classroom_action 
     * @Used IN             : @function-'classroom/my_classs.php' 
     * @Description         : check classroom action
     * @Developed By        : Copied form 'classroom' [@Controller]
     * @Start DateTime      : 16-03-2016 02:34 PM   
     * @Status              : available      
     * */
    public function check_classroom_action() {
        $status = $this->input->post('status', TRUE);
        $classroom_id = $this->input->post('classroom_id', TRUE);
        if ($status == 'Delete') {
            $data['classroom_status'] = 6;
            $this->user_course_model->update_information_in_database('tbl_classroom', 'classroom_id', $classroom_id, $data);
        } else if ($status == 'Cancel') {
            $data['classroom_status'] = 5;
            $this->user_course_model->update_information_in_database('tbl_classroom', 'classroom_id', $classroom_id, $data);
        }
        echo 'success';
    }

    /*
      -----------@@@RIPON@ Start Super Admin Classroom Part----------------------------------
     */
    /*
      -----------@@@RIPON@ Start Super Admin view Classroom Part----------------------------------
     */

    /**
     * @Function            : upcoming_class 
     * @Used IN             : @function-'upcoming_class.php' 
     * @Description         : view upcomming class 
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : 21-01-2016 08:00 PM
     * @Updated Date Time   : 16-03-2016 01:23 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function upcoming_class() {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        $data['active_menu'] = 'classroom';
        $data['active_sub_menu'] = 'upcoming';

        $data['i'] = 0;
        $data['status'] = 1;
        $todays_date = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $data['all_classes'] = $this->sa_class_model->get_upcomming_classroom($todays_date);
        if (!$data['all_classes']) {
            $data['classroom_status_message'] = 'You do not have any Upcoming class';
        } else {
            $data['classroom_status_message'] = '';
        }

        foreach ($data['all_classes'] as $class_value) {
            $data['course_info'][$class_value->classroom_id] = $this->user_course_model->select_course_information_by_course_id($class_value->course_id);
            $data['resource_person_info'][$class_value->classroom_id] = $this->profile_model->select_resource_person_info_by_resource_person_id($data['course_info'][$class_value->classroom_id]->resource_person_id);
            if ($data['resource_person_info'][$class_value->classroom_id]->resource_person_type == 3) {
                $data['organization_info'][$class_value->classroom_id] = $this->profile_model->select_organization_info_by_organization_id($data['resource_person_info'][$class_value->classroom_id]->organization_id);
            }
        }

        $data['main_content'] = $this->load->view('admin/classroom/tt_class', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : view_classroom_course_register_student 
     * @Used IN             : @function-'course_registered_student.php' 
     * @Description         : view assign Student 
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : 2016-01-23 02:55 PM
     * @Updated Date Time   : 19-03-2016 01:21 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function view_classroom_course_register_student($classroom_url) {
        $sdata['active_menu'] = 'tt_schedule_classroom';
        $sdata['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $this->session->set_userdata($sdata);

        $person_id = $this->session->userdata('person_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        $data['classroom_info'] = $this->sa_class_model->select_classroom_info_by_classroom_url($classroom_url);
        $data['course_registered_student'] = $this->super_admin_course_model->select_course_registered_student_by_course_id($data['classroom_info']->course_id);
        foreach ($data['course_registered_student'] as $student_value) {
            $data['assign_student_info'][$student_value->student_id] = $this->sa_class_model->assign_student_info_student_id($data['classroom_info']->classroom_id, $student_value->student_id);
        }

        $data['main_content'] = $this->load->view('admin/classroom/course_registered_student', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : view_classroom_assigned_student 
     * @Used IN             : @function-'classroom_assigned_student.php' 
     * @Description         : view assign Student 
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : 2016-01-23 02:55 PM
     * @Updated Date Time   : 19-03-2016 05:55 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function view_classroom_assigned_student($classroom_url) {
        $sdata['active_menu'] = 'tt_schedule_classroom';
        $sdata['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $this->session->set_userdata($sdata);

        $person_id = $this->session->userdata('person_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        $data['classroom_info'] = $this->sa_class_model->select_classroom_info_by_classroom_url($classroom_url);
        $data['classroom_assigned_student'] = $this->sa_class_model->select_classroom_assigned_student_by_classroom_id($data['classroom_info']->classroom_id);
        foreach ($data['classroom_assigned_student'] as $student_value) {
            $data['assign_student_info'][$student_value->student_id] = $this->sa_class_model->assign_student_info_student_id($data['classroom_info']->classroom_id, $student_value->student_id);
        }

        $data['main_content'] = $this->load->view('admin/classroom/classroom_assigned_student', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : check_student_permission 
     * @Used IN             : @function-'course_registrad_student.php'  
     * @Description         : check permission in course registrad student
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 19-03-2016 04:21 PM   
     * @Status              : available      
     * */
    function check_student_permission() {
        $course_id = $this->input->post('course_id', TRUE);
        $course_info = $this->super_admin_course_model->select_course_value_by_course_id($course_id);
        $resouce_person_info = $this->profile_model->select_resource_person_info_by_resource_person_id($course_info->resource_person_id);
        $total_class = 0;
        $csData['classroom_id'] = $this->input->post('classroom_id', TRUE);
        $feature_info = $this->super_admin_feature_model->check_course_feature_information($resouce_person_info->person_id);
        $assigned_student_info = count($this->classroom_model->get_all_assigned_student_by_classroom_id($csData['classroom_id']));

        if ($feature_info->virtual_classroom_attendees_number > $assigned_student_info) {
            $data['classroom_info'] = $this->classroom_model->select_classroom_info_by_classroom_id($csData['classroom_id']);
            $csData['student_id'] = $this->input->post('student_id', TRUE);
            $data['student_info'] = $this->classroom_model->get_student_information_student_id($csData['student_id']);
            $all_student_id = $this->classroom_model->get_all_student_id_by_person_id($data['student_info']->person_id);
            if ($all_student_id->student_id_string != '') {
                $all_classroom_id = $this->classroom_model->get_all_classroom_id_by_multiple_student_id($all_student_id->student_id_string);
                if ($all_classroom_id->classroom_id_string != '') {
                    $total_class = count($this->classroom_model->get_remaining_classroom_by_classroom_id_with_date($all_classroom_id->classroom_id_string, $data['classroom_info']->class_start_time, $data['classroom_info']->class_end_time));
                }
            }
            if ($total_class < 1) {
                echo 1;
            } else {
                echo 2;
            }
        } else {
            echo 3;
        }
    }

    /**
     * @Function            : check_student_permission 
     * @Used IN             : @function-'course_registrad_student.php'  
     * @Description         : change permission in course registrad student
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 19-03-2016 05:12 PM   
     * @Status              : available      
     * */
    function change_student_permission() {
        $type = $this->input->post('type', TRUE);
        $data['course_id'] = $this->input->post('course_id', TRUE);
        $sData['student_id'] = $data['student_id'] = $this->input->post('student_id', TRUE);
        $sData['classroom_id'] = $data['classroom_id'] = $this->input->post('classroom_id', TRUE);
        if ($type == 'Assign') {
            $sData['attendance_time'] = date('Y-m-d H:i:s', (time() - $this->session->userdata('time_offset')));
            $sData['classroom_student_join_status'] = 6;
            $this->user_course_model->save_information_in_database('tbl_classroom_student', $sData);
            $data['assigned_student_info'] = $this->sa_class_model->get_assigned_student_information_student_id($sData['student_id']);
            echo $this->load->view('admin/classroom/ajax_page/student_list_action', $data, true);
        } else if ($type == 'Unassign') {
            $this->classroom_model->remove_assigned_student($data['classroom_id'], $data['student_id']);
            $data['assigned_student_info'] = $this->sa_class_model->get_assigned_student_information_student_id($sData['student_id']);
            echo $this->load->view('admin/classroom/ajax_page/student_list_action', $data, true);
        }
    }

    /**
     * @Function            : current_class 
     * @Used IN             : @function-'admin/classroom/current_class.php' 
     * @Description         : view upcomming class 
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : 21-01-2016 08:00 PM
     * @Updated Date Time   : 16-03-2016 01:23 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function current_class() {
        $data = array();
        $person_id = $this->session->userdata('person_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);
        $data['active_menu'] = 'classroom';
        $data['active_sub_menu'] = 'current';

        $data['i'] = 0;
        $data['status'] = 2;
        $todays_date = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $data['all_classes'] = $this->sa_class_model->get_current_classroom($todays_date);
        if (!$data['all_classes']) {
            $data['classroom_status_message'] = 'You do not have any Current class';
        } else {
            $data['classroom_status_message'] = '';
        }

        foreach ($data['all_classes'] as $class_value) {
            $data['course_info'][$class_value->classroom_id] = $this->user_course_model->select_course_information_by_course_id($class_value->course_id);
            $data['resource_person_info'][$class_value->classroom_id] = $this->profile_model->select_resource_person_info_by_resource_person_id($data['course_info'][$class_value->classroom_id]->resource_person_id);
            if ($data['resource_person_info'][$class_value->classroom_id]->resource_person_type == 3) {
                $data['organization_info'][$class_value->classroom_id] = $this->profile_model->select_organization_info_by_organization_id($data['resource_person_info'][$class_value->classroom_id]->organization_id);
            }
        }
        $data['main_content'] = $this->load->view('admin/classroom/tt_class', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : previous_class 
     * @Used IN             : @function-'admin/classroom/previous_class.php' 
     * @Description         : view previous class 
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : 21-01-2016 08:00 PM
     * @Updated Date Time   : 16-03-2016 10:42 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function previous_class() {
        $data = array();
        $data['user_role'] = '';
        $sdata['active_menu'] = 'tt_schedule_classroom';
        $sdata['active_sub_menu'] = 'previous';
        $this->session->set_userdata($sdata);
        $person_id = $this->session->userdata('person_id');
        $data['person_info'] = $this->profile_model->get_single_person_information_by_person_id($person_id);

        $data['i'] = 0;
        $data['status'] = 3;
        $todays_date = date('Y-m-d H:i', (time() - $this->session->userdata('time_offset')));
        $data['all_classes'] = $this->sa_class_model->get_previous_classroom($todays_date);
        if (!$data['all_classes']) {
            $data['classroom_status_message'] = 'You do not have any Previous class';
        } else {
            $data['classroom_status_message'] = '';
        }

        foreach ($data['all_classes'] as $class_value) {
            $data['course_info'][$class_value->classroom_id] = $this->user_course_model->select_course_information_by_course_id($class_value->course_id);
            $data['resource_person_info'][$class_value->classroom_id] = $this->profile_model->select_resource_person_info_by_resource_person_id($data['course_info'][$class_value->classroom_id]->resource_person_id);
            if ($data['resource_person_info'][$class_value->classroom_id]->resource_person_type == 3) {
                $data['organization_info'][$class_value->classroom_id] = $this->profile_model->select_organization_info_by_organization_id($data['resource_person_info'][$class_value->classroom_id]->organization_id);
            }
        }

        $data['main_content'] = $this->load->view('admin/classroom/tt_class', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /*
      -----------@@@RIPON@ End Super Admin view Classroom Part----------------------------------
     */
}
