<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Super_Admin_Account extends TT_admin_login {

    public function __construct() {
        parent::__construct();
        $this->load->model('super_admin_account_model');
    }

    /*
      -----------@@@RIPON@ Start Course Register Student Part (29-08-18)----------------------------------
     */

    /**
     * @Description         : view all course register student
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 05-02-2017 11:26 AM 
     * */
    private $limit;
    private $total_student;
    private $page_nuumber;
    private $register_student_data = [];

    function accounts_course_register_students($arg = '') {
        $this->limit = ($arg == '') ? 0 : (($arg - 1) * 10);
        $this->page_nuumber = ($arg == '') ? 1 : $arg;
        $this->register_student_data['active_menu'] = 'accounts';
        $this->register_student_data['active_sub_menu'] = 'course_register_student';

        if (empty($arg)) {
            $this->utility_model->remove_session_data('sess_search_input', 'sess_payment_status', 'sess_selected_date');
        }

        if (empty($this->session->sess_search_input) && empty($this->session->sess_payment_status) && empty($this->session->sess_selected_date)) {
            $this->register_student_data['student_info'] = $this->student_model->set_type(1)
                            ->set_limit($this->limit)->set_student_by_type()->get_result();
            $this->total_student = $this->student_model->set_total_student_by_type()->get_result();
        } else {
            $this->accounts_set_data_for_course_register_student();
        }

        $this->accounts_get_data_for_course_register_students();

        $this->register_student_data['main_content'] = $this->load->view('admin/account/view_course_register_student', $this->register_student_data, TRUE);
        $this->load->view('admin/admin_master', $this->register_student_data);
    }

    /**
     * @Description         : search all course register student
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 05-02-2017 11:56 AM 
     * */
    function accounts_search_course_register_students() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $this->accounts_set_session_data_for_course_register_student();

        $this->accounts_set_data_for_course_register_student();

        $this->accounts_get_data_for_course_register_students();

        $view_page = $this->load->view('admin/account/ajax_page/view_course_register_student', $this->register_student_data, TRUE);
        echo json_encode($view_page);
    }

    /**
     * @Description         : get all data course register student
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 05-02-2017 02:41 PM 
     * */
    function accounts_get_data_for_course_register_students() {
        if (!empty($this->register_student_data['student_info'])) {
            foreach ($this->register_student_data['student_info'] as $value) {
                $this->register_student_data['person_info'][$value->student_id] = $this->person_model
                                ->set_person_id($value->person_id)->set_field_name('person_first_name,person_last_name,url')
                                ->set_info_with_url_by_id()->get_info();

                $this->register_student_data['payment_info'][$value->student_id] = $this->payment_model
                                ->set_field_name('payment_id,payment_status')->set_person_id($value->person_id)
                                ->set_type($value->student_type)->set_type_id($value->student_type_id)
                                ->set_payment_info_by_person_and_course_id()->get_info();
                if (!empty($this->register_student_data['payment_info'][$value->student_id])) {
                    $this->register_student_data['encrypt_payment_id'][$value->student_id] = $this->encryption->encrypt($this->register_student_data['payment_info'][$value->student_id]->payment_id);
                }
            }
            $parameter = array('url' => 'admin/course-register-students/', 'total_row' => $this->total_student, 'per_page' => 10, 'current_page' => $this->page_nuumber, 'total_link' => 10);
            $this->register_student_data['paginzation_link'] = $this->tt_pagination->view_pagination_link($parameter);
        }
    }

    /**
     * @Description         : set session data course register student
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 05-02-2017 03:28 PM 
     * */
    function accounts_set_session_data_for_course_register_student() {
        $search_input = trim($this->input->post('search_input', TRUE));
        $payment_status = $this->input->post('payment_status', TRUE);
        $selected_date = $this->input->post('selected_date', TRUE);

        $s_data = [];
        $s_data['sess_search_input'] = ($search_input == 'null') ? $this->session->sess_search_input : $search_input;
        $s_data['sess_payment_status'] = ($payment_status == 'null') ? $this->session->sess_payment_status : $payment_status;
        $s_data['sess_selected_date'] = ($selected_date == 'null') ? $this->session->sess_selected_date : $selected_date;
        $this->session->set_userdata($s_data);
    }

    /**
     * @Description         : set data course register student
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 05-02-2017 03:28 PM 
     * */
    function accounts_set_data_for_course_register_student() {
        if (empty($this->session->sess_payment_status)) {
            $student_info = $this->student_model->set_type(1)
                            ->set_search_input($this->session->sess_search_input)
                            ->set_register_date_time($this->session->sess_selected_date)
                            ->set_student_id_by_student_reg_date_and_name()->get_result();
        } else {
            $student_info = $this->student_model->set_type(1)
                            ->set_payment_status($this->session->sess_payment_status)
                            ->set_search_input($this->session->sess_search_input)
                            ->set_register_date_time($this->session->sess_selected_date)
                            ->set_student_id_by_student_reg_date_name_and_payment_status()->get_result();
        }

        if (!empty($student_info->id)) {
            $this->register_student_data['student_info'] = $this->student_model
                            ->set_limit($this->limit)->set_student_id(explode(',', $student_info->id))
                            ->set_student_by_multiple_student_id()->get_result();
            $this->total_student = count(explode(',', $student_info->id));
        } else {
            $this->register_student_data['student_info'] = [];
        }
    }

    /**
     * @Description         : assign course for registration
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-01-2016 03:03 PM   
     * */
    function assign_course($person_url) {
        $person_info = $this->person_model->set_person_url($person_url)->set_field_name('person_email')->set_info_by_url()->get_info();
        if (empty($person_info)) {
            redirect();
        }

        $this->form_validation->set_rules('parent_topic_id', 'Parent topic', 'required');
        $this->form_validation->set_rules('child_topic_id', 'Child topic', 'required');
        $this->form_validation->set_rules('course_id', 'Course name', 'required');
        $this->form_validation->set_rules('coupon_id', 'Coupon name');

        if ($this->form_validation->run() == FALSE) {
            $this->get_assign_course_data($person_url);
        } else {
            $this->register_course($person_url);
        }
    }

    /**
     * @Description         : get assign course data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-01-2016 12:52 PM   
     * */
    function get_assign_course_data($person_url) {
        $data = [];
        $data['person_url'] = $person_url;
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'course_learner';
        $todays_date = date('Y-m-d', (time() - $this->session->time_offset));
        $data['parent_topic'] = $this->utility_model->get_all_table_data('topic_id,topic_name', 'tbl_topic', ['parent_topic_id' => 0]);
        $data['all_coupon'] = $this->coupon_model->set_field_name('coupon_id,coupon_name')->set_coupon_type(2)->set_date($todays_date)
                        ->set_coupon_status(1)->set_coupon_data()->get_result();
        $data['main_content'] = $this->load->view('admin/account/assign_course', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Description         : assign course for registration
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-01-2016 03:03 PM   
     * */
    function get_course_by_topic() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }

        $child_topic_id = $this->input->post('child_topic_id', TRUE);
        $person_url = $this->input->post('person_url', TRUE);
        $person_info = $this->person_model->set_person_url($person_url)->set_field_name('person_id')->set_info_by_url()->get_info();

        // get course ID if this student enroll more course
        $student_enroll_course = $this->student_model->set_type(1)->set_person_id($person_info->person_id)
                        ->set_course_video_course_id()->get_result();
        $course_id_array = ($student_enroll_course) ? explode(',', $student_enroll_course->id) : [];

        // get course info except already enroll course by topic ID
        $course_info = $this->course_model->set_field_name('course_name,url')->set_topic_id($child_topic_id)->set_course_id($course_id_array)
                        ->set_course_info_by_topic_id()->get_result();
        echo json_encode($course_info);
    }

    /**
     * @Description         : single student all courses account details
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-01-2017 10:47 AM   
     * */
    private $account_data = [];

    function accounts_single_student_all_course_details($person_url) {
        $person_info = $this->person_model->set_person_url($person_url)->set_field_name('person_id')->set_info_by_url()->get_info();
        if (empty($person_info)) {
            redirect();
        }

        $this->account_data['active_menu'] = 'accounts';
        $this->account_data['active_sub_menu'] = 'course_learner';
        $this->account_data['total_price'] = $this->account_data['total_discount'] = $this->account_data['total_paid'] = $this->account_data['total_due'] = $this->account_data['total_tt'] = $this->account_data['total_user'] = 0;

        $this->account_data['all_payment'] = $this->payment_model
                ->set_field_name('*')->set_person_id($person_info->person_id)
                ->set_type(1)->set_status([1, 2, 6])
                ->all_payment_info_by_person_id()
                ->get_result();

        foreach ($this->account_data['all_payment'] as $value) {
            // set course price information
            $this->set_course_info_with_price($value);

            // det payment discount amount
            $this->set_payment_discount_amount($value);

            // set paid amount
            $this->set_payment_paid_amount($value);

            // set othewr amount
            $this->set_payment_other_amount($value);
        }

        $this->account_data['main_content'] = $this->load->view('admin/account/student_total_payment_details', $this->account_data, true);
        $this->load->view('admin/admin_master', $this->account_data);
    }

    /**
     * @Description         : set course information with price
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-01-2017 12:15 PM   
     * */
    function set_course_info_with_price($value) {
        $this->account_data['encode_payment_id'][$value->payment_id] = $this->encryption->encrypt($value->payment_id);
        $this->account_data['course_info'][$value->payment_id] = $this->course_model
                        ->set_course_id($value->payment_type_id)->set_field_name('url,person_id,course_name')
                        ->set_course_info_with_url_by_course_id()->get_result();

        if ($value->payment_currency == 2) {
            $this->account_data['course_price'][$value->payment_id] = $this->tt_currency
                            ->set($value->unit_price, 'USD', 'BDT')->convert_currency()->get();
        } else {
            $this->account_data['course_price'][$value->payment_id] = $value->unit_price;
        }
        $this->account_data['total_price'] += $this->account_data['course_price'][$value->payment_id];
        return $this;
    }

    /**
     * @Description         : set payment discount amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-01-2017 12:15 PM   
     * */
    function set_payment_discount_amount($value) {
        if ($value->discounted_price != 0) {
            $this->account_data['course_discount_price'][$value->payment_id] = ($value->payment_currency == 2) ? $this->tt_currency
                            ->set($value->discounted_price, 'USD', 'BDT')->convert_currency()->get() : $value->discounted_price;
        } else {
            $this->account_data['course_discount_price'][$value->payment_id] = 0;
        }
        $this->account_data['total_discount'] += $this->account_data['course_discount_price'][$value->payment_id];
        return $this;
    }

    /**
     * @Description         : set payment paid amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-01-2017 12:16 PM   
     * */
    function set_payment_paid_amount($value) {
        $paid_amount[$value->payment_id] = $this->payment_model
                        ->set_payment_id($value->payment_id)
                        ->generate_paid_amount()->get_total_paid_amount();

        if (!empty($paid_amount[$value->payment_id])) {
            $currency_type[$value->payment_id] = $this->invoice_payment_model->set_currency_info()->get_result()->currency_type;

            $this->account_data['paid_amount'][$value->payment_id] = ($currency_type[$value->payment_id] == 2) ? $this->tt_currency
                            ->set($paid_amount[$value->payment_id], 'USD', 'BDT')->convert_currency()->get() : $paid_amount[$value->payment_id];
        } else {
            $this->account_data['paid_amount'][$value->payment_id] = 0;
        }

        $this->account_data['total_paid'] += $this->account_data['paid_amount'][$value->payment_id];
        return $this;
    }

    /**
     * @Description         : set payment other amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-01-2017 12:15 PM   
     * */
    function set_payment_other_amount($value) {
        $this->account_data['due_amount'][$value->payment_id] = (($this->account_data['course_price'][$value->payment_id] - $this->account_data['course_discount_price'][$value->payment_id]) - $this->account_data['paid_amount'][$value->payment_id]);
        $this->account_data['total_due'] += $this->account_data['due_amount'][$value->payment_id];

        if ($this->account_data['course_info'][$value->payment_id]->person_id == 1) {
            $this->account_data['tt_amount'][$value->payment_id] = $this->account_data['paid_amount'][$value->payment_id];
        } else {
            $this->account_data['tt_amount'][$value->payment_id] = (($this->account_data['paid_amount'][$value->payment_id] * 10) / 100);
        }

        $this->account_data['total_tt'] += $this->account_data['tt_amount'][$value->payment_id];

        $this->account_data['user_amount'][$value->payment_id] = ($this->account_data['paid_amount'][$value->payment_id] - $this->account_data['tt_amount'][$value->payment_id]);
        $this->account_data['total_user'] += $this->account_data['user_amount'][$value->payment_id];
        return $this;
    }

    /**
     * @Description         : delete all invoice by payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-01-2017 10:47 AM   
     * */
    private $invoice_id_array = [];

    function accounts_delete_student_payment() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $payment_id = $this->encryption->decrypt($this->input->post('payment_id', TRUE));
        $invoice_info = $this->invoice_model
                        ->set_payment_id($payment_id)
                        ->set_all_invoice_info_by_payment_id()->get_result();

        foreach ($invoice_info as $value) {
            $this->invoice_id_array[] = $value->invoice_id;
            $invoice_payment_info = $this->invoice_payment_model->set_invoice_id($value->invoice_id)
                            ->set_field_name('invoice_payment_id,invoice_payment_type,invoice_payment_type_id')
                            ->get_invoice_payment_info_by_invoice_id()->get_result();

            if ($invoice_payment_info) {
                $this->delete_invoice_payment_info($invoice_payment_info);
            }
        }

        // delete invoice and random information
        $this->delete_invoice_info();
    }

    /**
     * @Description         : delete invoice payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-01-2017 12:18 PM   
     * */
    function delete_invoice_payment_info($invoice_payment_info) {
        switch ($invoice_payment_info->invoice_payment_type) {
            case 1: // for Cash
                $this->payment_process_model->set_primary_key('payment_cash_id')
                        ->set_primary_key_value($invoice_payment_info->invoice_payment_type_id)
                        ->set_table_name('tbl_payment_cash')
                        ->delete();
                break;
            case 2: // for cheque
                $this->payment_process_model->set_primary_key('payment_cheque_id')
                        ->set_primary_key_value($invoice_payment_info->invoice_payment_type_id)
                        ->set_table_name('tbl_payment_cheque')
                        ->delete();
                break;
            case 3: // for bkash
                $this->payment_process_model->set_primary_key('payment_bkash_id')
                        ->set_primary_key_value($invoice_payment_info->invoice_payment_type_id)
                        ->set_table_name('tbl_payment_bkash')
                        ->delete();
                break;
        }

        // delete invoice payment information
        $this->invoice_payment_model->set_invoice_payment_id($invoice_payment_info->invoice_payment_id)->delete();
    }

    /**
     * @Description         : delete invoice information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-01-2017 12:18 PM   
     * */
    function delete_invoice_info() {
        $invoice_id = min($this->invoice_id_array);
        $invoice_id_array = array_diff($this->invoice_id_array, [$invoice_id]);

        foreach ($invoice_id_array as $value) {
            $random_info = $this->utility_model
                    ->set_single_row_info('*', 'tbl_random', ['random_type' => 1, 'random_type_id' => $value])
                    ->get_single_row_info();

            // delete random information
            if ($random_info) {
                $this->random_number_model->set_random_id($random_info->random_id)->delete();
            }

            // delete invoice information
            $this->invoice_model->set_invoice_id($value)->delete();
        }
    }

    /*
      -----------@@@RIPON@ Start Course Register Student Part (29-08-18)----------------------------------
     */

    /**
     * @Description         : register course from back end
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-01-2016 03:25 PM   
     * */
    private $person_info;
    private $course_info;

    function register_course($person_url) {
        // get person information by person url
        $this->person_info = $this->person_model
                        ->set_person_url($person_url)
                        ->set_field_name('person_id,person_first_name,person_last_name,person_email')
                        ->set_info_by_url()->get_info();

        // get course information by course url
        $course_url = $this->input->post('course_id', TRUE);
        $this->course_info = $this->course_model
                        ->set_field_name('course_id,course_name,course_type,course_start_date,last_date_of_registration,person_id,resource_person_id,course_resource_person_view_invoice,url')
                        ->set_url($course_url)
                        ->set_info_by_url()->get_result();

        // register student by this course
        $this->student_model->set_type(1)
                ->set_type_id($this->course_info->course_id)
                ->set_person_id($this->person_info->person_id)->save();

        // save notification information for Assign Course
        $this->set_notification_data_for_assign_course()->save_notification();

        // send mail for Assign Course
        $this->set_mail_data_for_assign_course()->send_mail();

        // if course is paid then go to this function
        if ($this->course_info->course_type == 1) {
            $this->save_payment_for_assign_course();
        }

        // if course is free then go to this function
        if ($this->course_info->course_type == 2) {
            redirect('admin/larner-course');
        }
    }

    /**
     * @Description         : save payment for assign course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-01-2016 05:03 PM   
     * */
    private $price_info;
    private $random_number;
    private $payment_discount_amount;

    function save_payment_for_assign_course() {
        $this->price_info = $this->utility_model
                ->get_table_information('price_currency,price', 'tbl_price', ['price_type' => 1, 'price_type_id' => $this->course_info->course_id]);

        // get coupon ID and uses coupon discount
        $this->set_coupon_discount();

        // Save payment information
        $this->save_course_payment_information();

        // Save invoice information
        $this->save_course_invoice_information();

        // save notification information for create invoice
        $this->set_notification_data_for_create_invoice()->save_notification();

        // Save random information
        $this->tt_random_number->set_random_data(1, $this->invoice_id)->save_random_value();

        // Filter random number
        $this->random_number = $this->tt_random_number->filter_number('12')->get_filter_number();

        // send mail for Assign Course
        $this->set_mail_data_for_create_invoice()->send_mail();

        // redirect invoice 
        redirect('admin/view-invoice/' . $this->random_number);
    }

    /**
     * @Description         : save payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-01-2016 05:06 PM   
     * */
    private $payment_id;

    function save_course_payment_information() {
        $this->payment_id = $this->payment_model
                        ->set_person_id($this->person_info->person_id)
                        ->set_type(1)
                        ->set_type_id($this->course_info->course_id)
                        ->set_currency($this->price_info->price_currency)
                        ->set_unit_price($this->price_info->price)
                        ->set_discounted_price($this->payment_discount_amount)
                        ->set_total_price($this->price_info->price)
                        ->set_status(3)
                        ->save()
                        ->get_insert_id()->get_id();
        return $this;
    }

    /**
     * @Description         : save course invoice information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-01-2016 05:06 PM   
     * */
    private $invoice_id;

    function save_course_invoice_information() {
        $course_description = $this->course_info->course_name . ',' . $this->course_info->course_start_date;
        $this->invoice_id = $this->invoice_model
                        ->set_payment_id($this->payment_id)
                        ->datetime()
                        ->set_description($course_description)
                        ->save()
                        ->get_insert_id()->get_id();
        return $this;
    }

    /**
     * @Description         : set coupon discount for create invoice
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-01-2016 05:07 PM   
     * */
    function set_coupon_discount() {
        $coupon_id = $this->input->post('coupon_id', TRUE);
        if (!empty($coupon_id)) {
            $this->payment_discount_amount = $this->coupon_model
                            ->set_coupon_id($coupon_id)
                            ->set_price_currency($this->price_info->price_currency)
                            ->set_price($this->price_info->price)
                            ->calculate_coupon_discount()->get_result();
        } else {
            $this->payment_discount_amount = 0;
        }
        return $this;
    }

    /**
     * @Description         : set notification data for assign course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-01-2016 03:52 PM   
     * */
    private $notify_to;
    private $notify_by;
    private $notification_type;
    private $notification_type_id;
    private $notification_description;

    function set_notification_data_for_assign_course() {
        $notification_description = [];
        $notification_description[1] = '<strong>Talha Training</strong> assign a course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong> for <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong>';
        $notification_description[$this->person_info->person_id] = '<strong>Talha Training</strong> assign a course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong> for <strong>you</strong>';

        $resource_person_info = $this->resource_person_model
                        ->set_resource_person_id($this->course_info->resource_person_id)
                        ->set_info_by_resource_person_id()->get_result();
        if ($this->course_info->person_id != $resource_person_info->person_id) {
            $notification_description[$resource_person_info->person_id] = '<strong>Talha Training</strong> assign a course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong> for <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong>';
        }

        if ($this->course_info->person_id != 1) {
            $notification_description[$this->course_info->person_id] = '<strong>Talha Training</strong> assign your course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong> for <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong>';
        }

        $this->notification_description = serialize($notification_description);
        $this->notify_by = $this->person_info->person_id;
        $this->notify_to = implode(',', array_keys($notification_description));
        $this->notification_type = 6;
        $this->notification_type_id = $this->course_info->course_id;
        return $this;
    }

    /**
     * @Description         : set notification data for create invoice
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-01-2016 03:52 PM   
     * */
    function set_notification_data_for_create_invoice() {
        $notification_description = [];
        $notification_description[1] = '<strong>Talha Training</strong> created a paid invoice for <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong>';
        $notification_description[$this->person_info->person_id] = '<strong>Talha Training</strong> created a paid invoice to a course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong> for <strong>you</strong>';
        if ($this->course_info->person_id != 1) {
            $notification_description[$this->course_info->person_id] = '<strong>Talha Training</strong> created a paid invoice to your course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong> for <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong>';
        }

        if ($this->course_info->course_resource_person_view_invoice == 1) {
            $resource_person_info = $this->resource_person_model
                            ->set_resource_person_id($this->course_info->resource_person_id)
                            ->set_info_by_resource_person_id()->get_result();
            $notification_description[$resource_person_info->person_id] = '<strong>Talha Training</strong> created a paid invoice to a course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong> for <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong>';
        }

        $this->notification_description = serialize($notification_description);
        $this->notify_by = $this->person_info->person_id;
        $this->notify_to = implode(',', array_keys($notification_description));
        $this->notification_type = 8;
        $this->notification_type_id = $this->invoice_id;
        return $this;
    }

    /**
     * @Description         : save notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-01-2016 06:40 PM   
     * */
    function save_notification() {
        // save notification information
        $this->notification_model
                ->set_notify_by($this->notify_by)
                ->set_notify_to($this->notify_to)
                ->set_notification_description($this->notification_description)
                ->set_notification_type($this->notification_type)
                ->save();

        // save notification type 
        $this->notification_model->set_insert_id()
                ->set_notification_type_info_id($this->notification_type_id)
                ->save_type_info();
        return $this;
    }

    /**
     * @Description         : set mail data for mail
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-01-2016 03:51 PM   
     * */
    private $mail_subject;
    private $mail_site_link;
    private $mail_to;
    private $mail_person_name;
    private $email_message;
    private $mail_view_page;

    function set_mail_data_for_assign_course() {
        $this->mail_subject = 'Assign course';
        $this->mail_site_link = base_url() . $this->course_info->url;
        $this->mail_to = $this->person_info->person_email;
        $this->mail_person_name = $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name;
        $this->email_message = get_message('assign_course_message');
        $this->mail_view_page = 'assign_course';
        return $this;
    }

    /**
     * @Description         : set mail data for create invoice
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-01-2016 05:01 PM   
     * */
    function set_mail_data_for_create_invoice() {
        $this->mail_subject = 'New Invoice';
        $this->mail_site_link = base_url() . 'user/view-invoice/' . $this->random_number;
        $this->mail_to = $this->person_info->person_email;
        $this->mail_person_name = $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name;
        $this->email_message = get_message('assign_course_invoice_message');
        $this->mail_view_page = 'invoice_created_view';
        return $this;
    }

    /**
     * @Description         : send mail to payment person
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-01-2016 03:51 PM   
     * */
    function send_mail() {
        $mail_data = [];
        $mail_data['name'] = 'TalhaTraining Contact';
        $mail_data['from'] = 'no-reply@talhatraining.com';
        $mail_data['subject'] = $this->mail_subject;
        $mail_data['title_message'] = 'Talha Training';
        $mail_data['site_link'] = $this->mail_site_link;
        $mail_data['to'] = $this->mail_to;
        $mail_data['person_name'] = $this->mail_person_name;
        $mail_data['message'] = $this->email_message;

        $this->mailer_model->set_mail_data($mail_data)
                ->set_mail_view_page($this->mail_view_page)
                ->send_mail();
        return $this;
    }

    /*
      -----------@@@RIPON@ End Course Register Student Part (29-08-18)----------------------------------
     */

    /*
      -----------@@@RIPON@ Start View Organization Earning Part (02-02-17)----------------------------------
     */

    /**
     * @Description         : view organization account earning information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-02-2017 11:51 PM   
     * */
    private $earn_data = [];

    public function earn_by_organizaton_account() {
        $this->earn_data['active_menu'] = 'accounts';
        $this->earn_data['active_sub_menu'] = 'organization_earning';
        $this->session->set_userdata('active_sub_menu', 'organization_earning');

        $all_organization_id = $this->payment_model->set_organization_id_course_payment_info()->get_result();

        if (!empty($all_organization_id)) {
            $this->earn_data['organization_info'] = $this->person_model->set_field_name('person_id,person_first_name,person_last_name,url')
                            ->set_person_id(explode(',', $all_organization_id->id))
                            ->set_multiple_person_info_with_url_by_person_id()->get_info();

            foreach ($this->earn_data['organization_info'] as $value) {
                $this->earn_data['course_id'][$value->person_id] = $this->course_model->set_person_id($value->person_id)->set_course_id_for_payment()->get_result();
                
                $this->earn_data['net_earning'][$value->person_id] = $this->get_organization_net_earning($value->person_id);
            }

            if (isset($this->earn_data['course_id'])) {
                foreach ($this->earn_data['course_id'] as $key => $value) {
                    $this->account_get_total_payment_amount($key, $value);
                }
            }            
            
        } else {
            $this->earn_data['organization_info'] = [];
        } 
        $this->earn_data['main_content'] = $this->load->view('admin/account/view_organization_earning', $this->earn_data, true);
        $this->load->view('admin/admin_master', $this->earn_data);
    }

    /**
     * @Description         : view organization account earning information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-02-2017 12:00 PM   
     * */
    function earn_by_teacher_account() {
        $this->earn_data['active_menu'] = 'accounts';
        $this->earn_data['active_sub_menu'] = 'teacher_earning';
        $this->session->set_userdata('active_sub_menu', 'teacher_earning');

        $all_teacher_id = $this->payment_model->set_individual_teacher_id_course_payment_info()->get_result();

        if (!empty($all_teacher_id)) {
            $this->earn_data['teacher_info'] = $this->person_model->set_field_name('person_id,person_first_name,person_last_name,url')
                            ->set_person_id(explode(',', $all_teacher_id->id))
                            ->set_multiple_person_info_with_url_by_person_id()->get_info();

            foreach ($this->earn_data['teacher_info'] as $value) {
                $this->earn_data['course_id'][$value->person_id] = $this->course_model->set_person_id($value->person_id)->set_course_id_for_payment()->get_result();
            }

            if (isset($this->earn_data['course_id'])) {
                foreach ($this->earn_data['course_id'] as $key => $value) {
                    $this->account_get_total_payment_amount($key, $value);
                }
            }
        } else {
            $this->earn_data['teacher_info'] = [];
        }

        $this->earn_data['main_content'] = $this->load->view('admin/account/view_teacher_earning', $this->earn_data, true);
        $this->load->view('admin/admin_master', $this->earn_data);
    }

    /**
     * @Description         : get total payment amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-02-2017 12:00 PM   
     * */
    function account_get_total_payment_amount($person_id, $course_id) {
        // calculate total course amount
        $this->account_calculate_total_amount($person_id, $course_id);

        // calculate total paid amount
        $this->account_calculate_paid_amount($person_id, $course_id);

        $this->earn_data['tt_amount'][$person_id] = (($this->earn_data['paid_amount'][$person_id] * 10) / 100);
        $this->earn_data['revenue_amount'][$person_id] = ($this->earn_data['paid_amount'][$person_id] - $this->earn_data['tt_amount'][$person_id]);
    }

    /**
     * @Description         : calaulate total payment amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-02-2017 03:16 PM    
     * */
    function account_calculate_total_amount($person_id, $course_id) {
        $this->earn_data['total_amount'][$person_id] = 0;
        $payment_info = $this->payment_model->set_field_name('payment_currency,unit_price')
                        ->set_type(1)->set_type_id(explode(',', $course_id))->set_status([1, 2, 3])
                        ->set_payment_info_by_payment_type_id()->get_result();

        foreach ($payment_info as $value) {
            if ($value->payment_currency == 2) {
                $unit_price = $this->tt_currency->set($value->unit_price, 'USD', 'BDT')->convert_currency()->get();
            } else {
                $unit_price = $value->unit_price;
            }
            $this->earn_data['total_amount'][$person_id] += $unit_price;
        }
    }

    /**
     * @Description         : calculate total paid payment amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-02-2017 03:16 PM   
     * */
    function account_calculate_paid_amount($person_id, $course_id) {
        $this->earn_data['paid_amount'][$person_id] = 0;
        $all_payment_id = $this->payment_model->set_type(1)
                        ->set_type_id(explode(',', $course_id))->set_status([1, 2, 3])
                        ->set_payment_id_by_payment_type_id()->get_result();

        if (!empty($all_payment_id)) {
            $all_invoice_id = $this->invoice_model->set_payment_id(explode(',', $all_payment_id->id))
                            ->set_all_invoice_id_by_payment_id()->get_result();
        }

        if (!empty($all_invoice_id)) {
            $payment_invoice_info = $this->invoice_payment_model->set_field_name('currency_type,paid_amount')
                            ->set_invoice_id(explode(',', $all_invoice_id->id))
                            ->get_invoice_payment_info_by_multiple_invoice_id()->get_result();

            foreach ($payment_invoice_info as $value) {
                if ($value->currency_type == 2) {
                    $paid_price = $this->tt_currency->set($value->paid_amount, 'USD', 'BDT')->convert_currency()->get();
                } else {
                    $paid_price = $value->paid_amount;
                }
                $this->earn_data['paid_amount'][$person_id] += $paid_price;
            }
        }
    }

    /**
     * @Description         : View all course for view account information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-02-2017 03:13 PM   
     * */
    private $earning_data = [];

    function account_view_course_earning($person_url) {
        $this->person_info = $this->person_model->set_person_url($person_url)
                        ->set_field_name('person_id,person_country')->set_info_by_url()->get_info();

        $this->earning_data['active_menu'] = 'accounts';
        $this->earning_data['active_sub_menu'] = $this->session->active_sub_menu;
        $this->earning_data['course_id'] = $this->course_model->set_person_id($this->person_info->person_id)->set_course_id_for_payment()->get_result();

        if (!empty($this->earning_data['course_id'])) {
            $this->earning_data['earning_info'] = $this->payment_model
                            ->set_field_name('payment_type,payment_type_id,payment_currency,unit_price')->set_type(1)
                            ->set_type_id(explode(',', $this->earning_data['course_id']))->set_limit(0)->set_earning_info()->get_info();

            foreach ($this->earning_data['earning_info'] as $value) {

                // set data for view earning
                $this->set_data_for_view_earning($value);                
            }
        }
        $this->earning_data['main_content'] = $this->load->view('admin/account/view_course_earning', $this->earning_data, true);
        $this->load->view('admin/admin_master', $this->earning_data);
    }

    /**
     * @Description         : set data for earning 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-02-2017 02:21 PM   
     * */
    function set_data_for_view_earning($value) {        
        $this->earning_data['course_data'][$value->payment_type_id] = $this->utility_model
                        ->set_single_row_info('course_name,url_id', 'tbl_course', ['course_id' => $value->payment_type_id])->get_single_row_info();

        if ($value->payment_currency == 1) {
            $this->earning_data['course_price'][$value->payment_type_id] = $value->unit_price;
        }
        if ($value->payment_currency == 2) {
            $this->earning_data['course_price'][$value->payment_type_id] = $this->tt_currency->set($value->unit_price, 'USD', 'BDT')->convert_currency()->get();
        }

        $this->earning_data['currency_sign'][$value->payment_type_id] = '&nbsp;&#x9f3;';
        $this->earning_data['url'][$value->payment_type_id] = $this->utility_model
                        ->set_single_row_info('url', 'tbl_url', ['url_id' => $this->earning_data['course_data'][$value->payment_type_id]->url_id])->get_single_row_info();
        $this->earning_data['total_student'][$value->payment_type_id] = $this->student_model->set_type($value->payment_type)->set_type_id($value->payment_type_id)->set_total_student_by_course_id()->get_result();
    }

    /**
     * @Description         : view all course payment student 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-02-2017 03:43 PM   
     * */
    private $earning_student_data = [];

    function account_view_student_invoice($course_url) {
        $course_info = $this->course_model->set_field_name('person_id,course_id')->set_url($course_url)->set_info_by_url()->get_result();

        $this->earning_student_data['active_menu'] = 'accounts';
        $this->earning_student_data['active_sub_menu'] = $this->session->active_sub_menu;
        $this->earning_student_data['student_info'] = $this->student_model->set_type(1)->set_type_id($course_info->course_id)
                        ->set_student_info_by_type_id()->get_result();

        foreach ($this->earning_student_data['student_info'] as $value) {
            $this->earning_student_data['person_info'][$value->student_id] = $this->person_model
                            ->set_field_name('person_id,person_first_name,person_last_name,url')
                            ->set_person_id($value->person_id)
                            ->set_info_with_url_by_id()->get_info();

            $this->earning_student_data['payment_info'][$value->student_id] = $this->payment_model
                            ->set_field_name('*')
                            ->set_person_id($value->person_id)
                            ->set_type($value->student_type)
                            ->set_type_id($value->student_type_id)
                            ->set_payment_info_by_person_id()->get_result();
            $this->earning_student_data['encrypt_payment_id'][$value->student_id] = $this->encryption->encrypt($this->earning_student_data['payment_info'][$value->student_id]->payment_id);

            // set payable amount
            $this->set_payable_amount_for_earning_view_student_invoice($value);
            // set Paid and Due amount
            $this->set_paid_amount_for_earning_view_student_invoice($value);
        }
        $this->earning_student_data['main_content'] = $this->load->view('admin/account/view_earning_students', $this->earning_student_data, true);
        $this->load->view('admin/admin_master', $this->earning_student_data);
    }

    /**
     * @Description         : set payable amount for earning invoice student
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-02-2017 03:14 PM   
     * */
    function set_payable_amount_for_earning_view_student_invoice($value) {
        $this->earning_student_data['payment_currency_sign'][$value->student_id] = '&nbsp;&#x9f3;';
        if ($this->earning_student_data['payment_info'][$value->student_id]->payment_currency == 1) {
            $this->earning_student_data['payable_amount'][$value->student_id] = $this->earning_student_data['payment_info'][$value->student_id]->unit_price - $this->earning_student_data['payment_info'][$value->student_id]->discounted_price;
        }

        if ($this->earning_student_data['payment_info'][$value->student_id]->payment_currency == 2) {
            $payable_amount = $this->earning_student_data['payment_info'][$value->student_id]->unit_price - $this->earning_student_data['payment_info'][$value->student_id]->discounted_price;
            $this->earning_student_data['payable_amount'][$value->student_id] = $this->tt_currency->set($payable_amount, 'USD', 'BDT')->convert_currency()->get();
        }
    }

    /**
     * @Description         : set paid and due amount for earning invoice student
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-02-2017 03:14 PM   
     * */
    function set_paid_amount_for_earning_view_student_invoice($value) {
        $paid_amount = $this->payment_model
                        ->set_payment_id($this->earning_student_data['payment_info'][$value->student_id]->payment_id)
                        ->generate_paid_amount()->get_total_paid_amount();
        $paid_currency = $this->invoice_payment_model->set_currency_info()->get_result();

        if (!empty($paid_amount)) {
            if ($paid_currency->currency_type == 1) {
                $this->earning_student_data['paid_amount'][$value->student_id] = $paid_amount;
            }

            if ($paid_currency->currency_type == 2) {
                $this->earning_student_data['paid_amount'][$value->student_id] = $this->tt_currency->set($paid_amount, 'USD', 'BDT')->convert_currency()->get();
            }
        } else {
            $this->earning_student_data['paid_amount'][$value->student_id] = 0;
        }

        $this->earning_student_data['paid_currency_sign'][$value->student_id] = '&nbsp;&#x9f3;';
        $this->earning_student_data['due_amount'][$value->student_id] = $this->earning_student_data['payable_amount'][$value->student_id] - $this->earning_student_data['paid_amount'][$value->student_id];
        $this->earning_student_data['user_amount'][$value->student_id] = (($this->earning_student_data['paid_amount'][$value->student_id] * 90) / 100);
        $this->earning_student_data['tt_amount'][$value->student_id] = (($this->earning_student_data['paid_amount'][$value->student_id] * 10) / 100);
    }

    /**
     * @Description         : view total earning by course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-02-2017 03:57 PM   
     * */
    function earning_view_earning_by_course($course_url) {
        $course_info = $this->course_model->set_field_name('course_id')->set_url($course_url)->set_info_by_url()->get_result();

        if (empty($course_info)) {
            redirect();
        }

        $this->earning_student_data['active_menu'] = 'accounts';
        $this->earning_student_data['active_sub_menu'] = $this->session->active_sub_menu;
        $this->earning_student_data['student_info'] = $this->student_model->set_type(1)->set_type_id($course_info->course_id)
                        ->set_student_info_by_type_id()->get_result();

        $this->earning_student_data['currency_sign'] = '';
        $this->earning_student_data['total_payable_amount'] = 0;
        $this->earning_student_data['total_due_amount'] = 0;
        $this->earning_student_data['total_paid_amount'] = 0;
        $this->earning_student_data['total_user_amount'] = 0;
        $this->earning_student_data['total_tt_amount'] = 0;
        foreach ($this->earning_student_data['student_info'] as $value) {
            $this->earning_student_data['person_info'][$value->student_id] = $this->person_model
                            ->set_field_name('person_id,person_first_name,person_last_name,url')
                            ->set_person_id($value->person_id)
                            ->set_info_with_url_by_id()->get_info();

            $this->earning_student_data['payment_info'][$value->student_id] = $this->payment_model
                            ->set_field_name('*')
                            ->set_person_id($value->person_id)
                            ->set_type($value->student_type)
                            ->set_type_id($value->student_type_id)
                            ->set_payment_info_by_person_id()->get_result();
            $this->earning_student_data['encrypt_payment_id'][$value->student_id] = $this->encryption->encrypt($this->earning_student_data['payment_info'][$value->student_id]->payment_id);

            // set payable amount
            $this->set_payable_amount_for_earning_view_student_invoice($value);

            // set Paid and Due amount
            $this->set_paid_amount_for_earning_view_student_invoice($value);

            // set total payable amount
            $this->earning_student_data['currency_sign'] = $this->earning_student_data['payment_currency_sign'][$value->student_id];
            $this->earning_student_data['total_payable_amount'] += $this->earning_student_data['payable_amount'][$value->student_id];
            $this->earning_student_data['total_due_amount'] += $this->earning_student_data['due_amount'][$value->student_id];
            $this->earning_student_data['total_paid_amount'] += $this->earning_student_data['paid_amount'][$value->student_id];
            $this->earning_student_data['total_user_amount'] += $this->earning_student_data['user_amount'][$value->student_id];
            $this->earning_student_data['total_tt_amount'] += $this->earning_student_data['tt_amount'][$value->student_id];
        }

        $this->earning_student_data['main_content'] = $this->load->view('admin/account/view_course_total_earning', $this->earning_student_data, TRUE);
        $this->load->view('admin/admin_master', $this->earning_student_data);
    }

    /**
     * @Description         : View all invoice for earning 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-02-2017 04:13 PM    
     * */
    private $invoice_data = [];

    function earning_view_all_invoice() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $counter = 0;
        $payment_id = $this->encryption->decrypt($this->input->post('payment_id', TRUE));
        if (!empty($payment_id)) {
            $this->invoice_data['payment_info'] = $this->payment_model->set_payment_id($payment_id)->set_info()->get_info();
            $this->invoice_data['invoice_info'] = $this->invoice_model
                            ->set_payment_id($payment_id)
                            ->set_all_invoice_info_by_payment_id()->get_result();

            foreach ($this->invoice_data['invoice_info'] as $value) {
                $this->invoice_data['invoice_payment_info'][$value->invoice_id] = $this->utility_model
                        ->get_table_information('*', 'tbl_invoice_payment', ['invoice_id' => $value->invoice_id]);

                // set paid amount for all earning invoice
                $this->set_paid_amount_for_earning_view_all_invoice($value);
                if (!empty($this->invoice_data['invoice_payment_info'][$value->invoice_id])) {
                    $counter++;
                }
                $temp_invoice_id = $this->utility_model
                                ->get_table_information('random_number', 'tbl_random', ['random_type' => 1, 'random_type_id' => $value->invoice_id])->random_number;
                $this->invoice_data['random_id'][$value->invoice_id] = $this->tt_random_number->set_random_number($temp_invoice_id)->filter_number('45')->get_filter_number();
            }
        } else {
            $this->invoice_data['invoice_info'] = [];
        }
        $this->invoice_data['counter'] = $counter;
        $view_page = $this->load->view('admin/account/ajax_page/view_earning_invoice', $this->invoice_data, TRUE);
        echo json_encode($view_page);
    }

    /**
     * @Description         : set paid amount for all earining all invoice
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-02-2017 03:31 PM    
     * */
    function set_paid_amount_for_earning_view_all_invoice($value) {
        if ($this->invoice_data['invoice_payment_info'][$value->invoice_id]) {
            $this->invoice_data['paid_currency_sign'][$value->invoice_id] = '&nbsp;&#x9f3;';
            if ($this->invoice_data['invoice_payment_info'][$value->invoice_id]->currency_type == 1) {
                $this->invoice_data['paid_amount'][$value->invoice_id] = $this->invoice_data['invoice_payment_info'][$value->invoice_id]->paid_amount;
            }
            if ($this->invoice_data['invoice_payment_info'][$value->invoice_id]->currency_type == 2) {
                $this->invoice_data['paid_amount'][$value->invoice_id] = $this->tt_currency->set($this->invoice_data['invoice_payment_info'][$value->invoice_id]->paid_amount, 'USD', 'BDT')->convert_currency()->get();
            }
        }
    }

    /*
      -----------@@@RIPON@ End View Organization Earning Part (02-02-17)----------------------------------
     */

    public function video_learners() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['main_content'] = $this->load->view('admin/account/student_management/video_student_course', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function category_wise_course() {
        $category_id = $this->input->post('category_id', TRUE);
        $data['option'] = $this->input->post('option', TRUE);
        if ($data['option'] == 1) {
            $data['all_course_info'] = $this->super_admin_account_model->select_all_course_by_category($category_id);

            echo $this->load->view('admin/account/ajax_account_pages/course_drop_down_page', $data, true);
        } else if ($data['option'] == 2) {
            $data['all_video_info'] = $this->super_admin_account_model->select_all_video_by_category($category_id);

            echo $this->load->view('admin/account/ajax_account_pages/course_drop_down_page', $data, true);
        } else {
            echo $this->load->view('admin/account/ajax_account_pages/course_drop_down_page', $data, true);
        }
    }

    public function select_cupon_id() {
        $data = array();
        $data['option'] = $this->input->post('option', TRUE);
        if ($data['option'] == 1) {
            $data['all_course_cupon'] = $this->super_admin_account_model->select_all_course_cupon();

            echo $this->load->view('admin/account/ajax_account_pages/cupon_drop_down_page', $data, true);
        } else if ($data['option'] == 2) {
            $data['all_video_cupon'] = $this->super_admin_account_model->select_all_video_cupon();
            //print_r( $data['all_video_cupon']);
            echo $this->load->view('admin/account/ajax_account_pages/cupon_drop_down_page', $data, true);
        } else {
            echo $this->load->view('admin/account/ajax_account_pages/cupon_drop_down_page', $data, true);
        }
    }

    public function user_payment_details($person_id) { //no routes found
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['all_course'] = $this->super_admin_account_model->select_all_course_for_that_person($person_id);
        if ($data['all_course']) {
            foreach ($data['all_course'] as $val) {
                $data['all_course_info'][$val->student_id] = $this->super_admin_account_model->select_all_course_info($val->course_id);
                $data['all_payment_info'][$val->student_id] = $this->super_admin_account_model->select_all_payment_info($val->payment_id);
            }
        }
        $data['main_content'] = $this->load->view('admin/account/student_management/student_payment_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function organization_payment_details() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'course_account_management';
        //$data['active'] = 'course_account_management';
        $data['main_content'] = $this->load->view('admin/account/temp/organization_account_payment_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function user_total_payment_details() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'course_learner';
        $data['main_content'] = $this->load->view('admin/account/student_management/student_total_payment_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function organization_total_payment_details() { //no routes found
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['main_content'] = $this->load->view('admin/account/temp/organization_total_payment_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function earn_by_course() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'course_account_management';
        //$data['active'] = 'course_account_management';
        $data['main_content'] = $this->load->view('admin/account/temp/earn_course_account_management', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function total_earn_by_course() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'course_account_management';
        //$data['active'] = 'course_account_management';
        $data['main_content'] = $this->load->view('admin/account/temp/total_earn_course_account_management', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function earn_by_video_course() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['main_content'] = $this->load->view('admin/account/temp/earn_course_account_management', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function total_earn_by_video_course() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['main_content'] = $this->load->view('admin/account/temp/total_earn_video_course_account_management', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function total_earn_by_feature() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['main_content'] = $this->load->view('admin/account/temp/total_earn_feature_account_management', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function earn_by_individual_teacher_account() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['main_content'] = $this->load->view('admin/account/temp/individual_teacher_account_management', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function expense_account_management() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['main_content'] = $this->load->view('admin/account/temp/expense', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function earning_account_management() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['main_content'] = $this->load->view('admin/account/temp/earning', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function course_batch_account() {
        $data = array();
        // $data['active'] = 'course_account_management';
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'course_account_management';
        $data['main_content'] = $this->load->view('admin/account/temp/course_batch_account_management', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function course_account_view() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'course_account_management';
        //$data['active'] = 'course_account_management';
        $data['main_content'] = $this->load->view('admin/account/temp/course_account_view', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function video_course_account_management() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['main_content'] = $this->load->view('admin/account/temp/course_account_management', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function online_training_account_management() { //no routes found
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['main_content'] = $this->load->view('admin/account/temp/course_account_management', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    //will be use for view course earning batch wise  
    public function payment_details() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'course_account_management';
        $data['main_content'] = $this->load->view('admin/account/temp/payment_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function student_account_details() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'course_account_management';
        //$data['active'] = 'course_account_management';
        $data['main_content'] = $this->load->view('admin/account/temp/student_account_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function invoice() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'course_account_management';
        //$data['active'] = 'course_account_management';
        $data['main_content'] = $this->load->view('admin/account/temp/payment_invoice', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function view_course_information() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['main_content'] = $this->load->view('admin/course/temp/view_course_detail_information', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function selected_course_category_details() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['main_content'] = $this->load->view('admin/course/temp/selected_course_category_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function organization_course_account_details() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['main_content'] = $this->load->view('admin/account/temp/organization_course_account_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function selected_organization_invoice_details() {
        $data = array();
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'video_learners';
        $data['main_content'] = $this->load->view('admin/account/temp/selected_organization_invoice_details', $data, true);
        $this->load->view('admin/admin_master', $data);
    }
    
    
    /**
     * @Function            : get_organization_net_earning 
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 29-04-17
     * @Parameter           : $org_person_id
     * @Status              : Available       
     * */   
    function get_organization_net_earning($org_person_id){
        $confirmed_payment_detail = $this->payment_model->get_confirmed_payment_by_person_id($org_person_id);
        $total_net_earning = 0;
        foreach($confirmed_payment_detail as $payment){
            $total_net_earning += $payment->payment_amount;
        }
        return $total_net_earning;        
    }
    
    
    /**
     * @Function            : view_all_payment_request 
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 29-04-17
     * @Parameter           : $org_person_id
     * @Status              : Available       
     * */   
    function view_all_payment_request(){
        if($this->input->is_ajax_request()){
            $course_url = $this->input->post('course_url', TRUE);
            $data['payment_request'] = $this->payment_model->get_all_payment_request_by_course_url($course_url);
            $view_page = $this->load->view('admin/account/ajax_page/view_payment_request', $data, TRUE);
            echo json_encode($view_page);
        }
    }
    
    
    /**
     * @Function            : confirm_payment_request 
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 30-04-17
     * @Status              : Available       
     * */
    function confirm_payment_request(){
        if($this->input->is_ajax_request()){
            $course_id = $this->payment_model->get_course_id_by_url();                        
            $this->payment_model->confirm_payment_request($course_id->course_id);
            echo json_encode('payment confirmed');
        }
    }

}
