<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Send_video_course_invitation extends TT_admin_login {
    public function __construct() {
        parent::__construct();
        $this->load->model('Send_video_course_invitation_model');
    }
    public function send_video_course_invitation_menu() {
        $data['active_menu'] = 'view_invitation';
        $data['active_sub_menu'] = 'manage_invitation';
        return $data;
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 6-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'send-video-course-invitation/(.+)'
     * @Description         : Send invitation form show for video course invitation
     * @view                : null
     * @redirect            : 'view-video-course-invitation/(.+)'
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : send_video_course_invitation_menu() is used to get the menu
     *                        send_video_course_invitation_form_validation() is used for check form validation
     *                        send_invitation_receive_person() is used for insert invitation_receive_person info in db
     * @Parameter           : Null
     * @Return              : Null       
     * @value               : $data array keep the values of video course, send_invitation_type
     *                        $invitation_data keep the values of invitation for insert data in db
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function send_video_course_invitation($video_course_url){
        $data['active_menu'] = 'video_course_back_end';
        $data['active_sub_menu'] = 'manage_video_course_back_end';
        $data['video_course'] = $this->Manage_admin_video_course_model->view_single_video_course_info($video_course_url);
        
        $this->send_video_course_invitation_form_validation();
        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('send_video_course_invitation/send_video_course_invitation', $data, TRUE);
            $this->load->view('admin/admin_master', $data);
        }else{
            $data['send_invitation_type'] = $send_invitation_type = $this->input->post('send_invitation_type', TRUE);
            $this->session->set_userdata('send_invitation_type', $send_invitation_type);
            $invitation_data = $this->send_video_course_invitation_field_info($data['video_course'], $send_invitation_type);
            $data['invitation_id'] = $invitation_id = $this->Send_video_course_invitation_model->send_video_course_invitation_info($invitation_data['invitation']);
            
            $this->send_invitation_receive_person($invitation_id, $invitation_data['invitation_send_to']);
            
            redirect('view-video-course-invitation/'.$video_course_url);
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 6-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 
     * @Description         : Send invitation receive person info insert in db
     * @view                : null
     * @redirect            : 
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : send_video_course_invitation() 
     * @Parameter           : $invitation_id, $invitation_send_to
     * @Return              : Null       
     * @value               : $invitation_receive_person array keep the values of invitation_receive_person for insert data
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function send_invitation_receive_person($invitation_id, $invitation_send_to){
        foreach ($invitation_send_to as $invitation_send_to_email){
            $invitation_receive_person['invitation_id'] = $invitation_id;
            $invitation_receive_person['invitation_send_to_email'] = $invitation_send_to_email;
            $invitation_receive_person['invitation_receive_person_status'] = 1;
            $this->Send_video_course_invitation_model->send_invitation_receive_person_info($invitation_receive_person);
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 6-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 
     * @Description         : Get Send invitation field info
     * @view                : null
     * @redirect            : 
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : send_video_course_invitation() 
     * @Parameter           : $video_course, $send_invitation_type
     * @Return              : $data       
     * @value               : $data array keep the values of invitation for insert data
     *                        $person_email keep the values of tt-user person email based on send_invitation_type
     *                        $email_array_unique check the same email
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function send_video_course_invitation_field_info($video_course, $send_invitation_type) {
        $data['invitation']['person_id'] = $this->session->userdata('person_id');
        if($send_invitation_type == 1){
            $invitation_send_to_anonymous = $this->input->post('invitation_send_to_anonymous', TRUE);
            $email_array_unique = array_unique(explode(",", rtrim($invitation_send_to_anonymous, ',')));
            $data['invitation_send_to'] = $email_array_unique;
            $data['invitation']['invitation_user_number'] = count($email_array_unique);
        }else{
            $invitation_user_number = $this->input->post('invitation_send_to_user', TRUE);
            $person_email = $this->Send_video_course_invitation_model->send_invitation_user_email($invitation_user_number, $send_invitation_type);
            foreach ($person_email as $email_list){
                $email_array_unique[] = $email_list['person_email'];
            }
            $data['invitation_send_to'] = $email_array_unique;
            $data['invitation']['invitation_user_number'] = count($email_array_unique);
        }
        $data['invitation']['invitation_message'] = $this->input->post('invitation_message', TRUE);
        $data['invitation']['invitation_type'] = 1;
        $data['invitation']['invitation_type_id'] = $video_course->video_course_id;
        $data['invitation']['invitation_send_type'] = $send_invitation_type;
        $data['invitation']['invitation_sent_date'] = date('Y/m/d H:i:s', (time() - $this->session->userdata('time_offset')));
        
        return $data;
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 6-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 
     * @Description         : Check Send invitation form validation
     * @view                : null
     * @redirect            : 
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : send_video_course_invitation() 
     * @Parameter           : null
     * @Return              : null       
     * @value               : $send_invitation_type keep the value of [anonymus, tt, indvidual, group]
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function send_video_course_invitation_form_validation() {
        $this->form_validation->set_rules('send_invitation_type', 'send invitation type', 'required');
        if($this->input->post('send_invitation_type') != ''){
            $send_invitation_type = $this->input->post('send_invitation_type');
            if($send_invitation_type == 1){
                $this->form_validation->set_rules('invitation_send_to_anonymous', 'Invitation Email', 'required|callback_email_check');
            }else{
                $this->form_validation->set_rules('invitation_send_to_user', 'Invitation User number', 'required|trim|integer');
            }
        }
        $this->form_validation->set_rules('invitation_message', 'Invitation Message', 'required|trim');
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 6-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 
     * @Description         : Check Email form validation
     * @view                : null
     * @redirect            : 
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : send_video_course_invitation_form_validation() 
     * @Parameter           : null
     * @Return              : boolean(T/F)       
     * @value               : $person_email keep the input email
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function email_check() {
        $person_email = $this->input->post('invitation_send_to_anonymous', TRUE);
        $sp = '/^([_a-z0-9\-]+)(\.[_a-z0-9\-]+)*@([a-z0-9\-]{2,}\.)*([a-z]{2,4})(,([_a-z0-9\-]+)(\.[_a-z0-9\-]+)*@([a-z0-9\-]{2,}\.)*([a-z]{2,4}))*$/';
        if (preg_match($sp,$person_email)) {           
                return TRUE;            
        } else {
            $this->form_validation->set_message('email_check', 'Please Type valid email address');
            return FALSE;
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 7-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'view-video-course-invitation/(.+)'
     * @Description         : View video course all invitation data
     * @view                : 'send_video_course_invitation/view_video_course_invitation'
     * @redirect            : 
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : send_video_course_invitation_menu() 
     * @Parameter           : $video_course_url
     * @Return              :    
     * @value               : $data array keep the value video_course, invitation_data, send_invitation_tab
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function view_video_course_invitation($video_course_url){
        $data = $this->send_video_course_invitation_menu();
        
        $data['video_course'] = $this->Manage_admin_video_course_model->view_single_video_course_info($video_course_url);
        $data['anonymous_invitation'] = $this->Send_video_course_invitation_model->send_video_course_invitation_anonymous_info($data['video_course']->video_course_id, 1);
        $data['user_invitation'] = $this->Send_video_course_invitation_model->send_video_course_invitation_tt_user_info($data['video_course']->video_course_id, 1);
        
        $send_invitation_type = $this->session->userdata('send_invitation_type');
        if(isset($send_invitation_type)){
            $data['send_invitation_tab'] = ($send_invitation_type == 1) ? 'anonymous': 'user';
        }else{
            $data['send_invitation_tab'] = 'anonymous';
        }
        
        
        $data['main_content'] = $this->load->view('send_video_course_invitation/view_video_course_invitation', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 7-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'send-invitation'
     * @Description         : send video course invitation to user [one by one]
     * @view                : 
     * @redirect            : 
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : send_email() 
     * @Parameter           : null
     * @Return              : null 
     * @value               : $invitation_id keep the value of invitation_id
     *                        $video_course_url keep the value of video_course url
     *                        $video_course keep the value of video_course data
     *                        $invitation_info keep the value of invitation data
     *                        $invitation_receive_person keep the value of invitation_receive_person data
     *                        $mdata array keep the value which is send to email
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function send_video_course_invitation_by_email(){
        if($this->input->is_ajax_request()){
            $invitation_id = $this->input->post('invitation_id', TRUE);
            $video_course_url = $this->input->post('video_course_url', TRUE);
            
            $video_course = $this->Manage_admin_video_course_model->view_single_video_course_info($video_course_url);
            $invitation_info = $this->Send_video_course_invitation_model->get_send_video_course_invitation_info($invitation_id);
            $invitation_receive_person = $this->Send_video_course_invitation_model->get_send_invitation_receive_person_info($invitation_id);
            
            $mdata = array();
            $mdata['video_course'] = $video_course;
            $mdata['from_address'] = 'no-replay@talhatraining.com';
            $mdata['company_name'] = 'Talha Training';
            $mdata['admin_name'] = 'Talha Training';
            $mdata['to_address'] = $invitation_receive_person->invitation_send_to_email;
            $mdata['subject'] = 'Invitation Message for enroll new video course';
            $mdata['invitation_message'] = $invitation_info->invitation_message;
            $this->send_email($invitation_id, $mdata, 'mailscript_video_course_invitation');
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 7-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 
     * @Description         : send email to user [one by one]
     * @view                : 
     * @redirect            : 
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : send_video_course_invitation_by_email(), send_invitation_again()
     * @Parameter           : $invitation_id, $mdata, $templateNmae
     * @Return              : null 
     * @value               : $invitation_receive_person array keep the value for update invitation_receive_person info in db
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function send_email($invitation_id, $mdata, $templateNmae) {
        $this->email->set_mailtype('html');
        $this->email->from($mdata['from_address'], $mdata['admin_name']);
        $this->email->to($mdata['to_address']);
        $this->email->subject($mdata['subject']);
        $body = $this->load->view('send_video_course_invitation/' . $templateNmae, $mdata, true);
        $this->email->message($body);
        if ($this->email->send()){
            $invitation_receive_person['invitation_id'] = $invitation_id;
            $invitation_receive_person['invitation_send_to_email'] = $mdata['to_address'];
            $invitation_receive_person['invitation_receive_person_status'] = 2;
            $invitation_user_number = $this->Send_video_course_invitation_model->update_send_invitation_receive_person_info($invitation_receive_person);
            echo '{"action":"sent","msg":"The message has been sent to '.$invitation_receive_person['invitation_send_to_email'].'","invitation_user_number":"'.$invitation_user_number.'"}';
        }else{
            $invitation_receive_person['invitation_id'] = $invitation_id;
            $invitation_receive_person['invitation_send_to_email'] = $mdata['to_address'];
            $invitation_receive_person['invitation_receive_person_status'] = 3;
            $invitation_user_number = $this->Send_video_course_invitation_model->update_send_invitation_receive_person_info($invitation_receive_person);
            echo '{"action":"not-sent","msg":"The message has no been sent to '.$invitation_receive_person['invitation_send_to_email'].'","invitation_user_number":"'.$invitation_user_number.'"}';
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 8-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'send-video-course-invitation-user-list/(.+)'
     * @Description         : invitation user list
     * @view                : send_video_course_invitation/view_invited_user
     * @redirect            : 
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : send_video_course_invitation_menu() for get menu
     * @Parameter           : $invitation_id
     * @Return              : null 
     * @value               : $data array keep the value of invitation_receive_person, person_email
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function send_video_course_invitation_user_list($invitation_id) {
        $data = $this->send_video_course_invitation_menu();
        $limit_offset = 0;
        $data['page_number'] = $page_number = 1;
        
        $data['serial'] = 0;
        $data['invitation_id'] = $invitation_id;
        $data['invitation_receive_person'] = $this->Send_video_course_invitation_model->sent_invitation_receive_person_info_by_invitation_id($invitation_id,'', $limit_offset);
        $data['person_email'] = $this->Send_video_course_invitation_model->check_send_invitation_email_with_person_email($data['invitation_receive_person']['invitation_receive_person_data']);
        
        $total_row = $data['invitation_receive_person']['count_invitation_receive_person'];
        $params = array('url' => '', 'div_id' => 'send_video_course_invitation_user_list_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['send_video_course_invitation_user_list_pagination'] = $this->tt_pagination->view_pagination_link($params);
        
        $data['main_content'] = $this->load->view('send_video_course_invitation/view_invited_user', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 8-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'send-invitation-again'
     * @Description         : send invitation to user again
     * @view                : 
     * @redirect            : 
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : send_email() for send email
     * @Parameter           : 
     * @Return              : null 
     * @value               : $invitation_receive_person_id keep the value of invitation_receive_person_id
     *                        $video_course keep the value of video_course data
     *                        $invitation_info keep the value of invitation data
     *                        $invitation_receive_person keep the value of invitation_receive_person data
     *                        $mdata array keep the value which is send to email
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function send_invitation_again() {
        if($this->input->is_ajax_request()){
            $invitation_receive_person_id = $this->input->post('invitation_receive_person_id', TRUE);
            $invitation_receive_person = $this->Send_video_course_invitation_model->get_send_invitation_receive_person_info_by_invitation_receive_person_id($invitation_receive_person_id);
            $invitation_info = $this->Send_video_course_invitation_model->get_send_video_course_invitation_info($invitation_receive_person->invitation_id);
            $video_course = $this->Manage_admin_video_course_model->edit_admin_video_course_info($invitation_info->invitation_type_id);
            
            $mdata = array();
            $mdata['video_course'] = $video_course;
            $mdata['from_address'] = 'no-replay@talhatraining.com';
            $mdata['company_name'] = 'Talha Training';
            $mdata['admin_name'] = 'Talha Training';
            $mdata['to_address'] = $invitation_receive_person->invitation_send_to_email;
            $mdata['subject'] = 'Invitation Message for enroll new video course';
            $mdata['invitation_message'] = $invitation_info->invitation_message;
            $this->send_email($invitation_info->invitation_id, $mdata, 'mailscript_video_course_invitation');
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 8-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'delete-invitation-receive-person'
     * @Description         : delete invitation receive person
     * @view                : send_video_course_invitation/ajax_view/view_invited_user_list
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : null
     * @Return              : null 
     * @value               : $invitation_receive_person_id keep the value of invitation_receive_person_id
     *                        $invitation_receive_person keep the value of invitation_receive_person data
     *                        $data array keep the value of invitation_receive_person, person_email
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function delete_invitation_receive_person() {
        if($this->input->is_ajax_request()){
            $invitation_receive_person_id = $this->input->post('invitation_receive_person_id', TRUE);
            $invitation_receive_person = $this->Send_video_course_invitation_model->get_send_invitation_receive_person_info_by_invitation_receive_person_id($invitation_receive_person_id);
            $this->Send_video_course_invitation_model->delete_invitation_receive_person($invitation_receive_person_id, $invitation_receive_person);
            
            $data['page_number'] = $page_number = $this->input->post('page_number', TRUE);
            $limit_offset = ($page_number * 10) - 10;
            $data['serial'] = $limit_offset;
            $data['invitation_receive_person'] = $this->Send_video_course_invitation_model->sent_invitation_receive_person_info_by_invitation_id($invitation_receive_person->invitation_id, '', $limit_offset);
            $data['person_email'] = $this->Send_video_course_invitation_model->check_send_invitation_email_with_person_email($data['invitation_receive_person']['invitation_receive_person_data']);
            
            $total_row = $data['invitation_receive_person']['count_invitation_receive_person'];
            $params = array('url' => '', 'div_id' => 'send_video_course_invitation_user_list_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['send_video_course_invitation_user_list_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('send_video_course_invitation/ajax_view/view_invited_user_list', $data, TRUE);
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 8-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'manage-send-video-course-invitation'
     * @Description         : all video course, invitation data list view
     * @view                : send_video_course_invitation/manage_send_video_course_invitation
     * @redirect            : 
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : null
     * @Return              : null 
     * @value               : $data array keep the value of menu, serial, video_course, invitation_data, send_invitation
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function manage_send_video_course_invitation() {
        $data = $this->send_video_course_invitation_menu();
        $this->session->unset_userdata('send_invitation_type');
        $limit_offset = 0;
        $page_number = 1;
        
        $data['serial'] = 0;
        $data['video_course'] = $this->Manage_admin_video_course_model->manage_limit_admin_video_course_info($limit_offset);
        foreach ($data['video_course'] as $video_course){
            $data['invitation_data'][$video_course->video_course_id] = $this->Send_video_course_invitation_model->get_send_video_course_invitation_info_by_invitation_type_id($video_course->video_course_id);
            $data['send_invitation'][$video_course->video_course_id] = count($data['invitation_data'][$video_course->video_course_id]['invitation']);
        }
        $total_row = count($this->Manage_admin_video_course_model->manage_admin_video_course_info());
        $params = array('url' => '', 'div_id' => 'manage_send_video_course_invitation_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['manage_send_video_course_invitation_pagination'] = $this->tt_pagination->view_pagination_link($params);
        
        $data['main_content'] = $this->load->view('send_video_course_invitation/manage_send_video_course_invitation', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 9-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'search-send-video-course-invitation'
     * @Description         : search by video course title to know the data of invitation
     * @view                : send_video_course_invitation/ajax_view/search_send_video_course_invitation
     * @redirect            : manage-send-video-course-invitation [if not ajax request]
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : null
     * @Return              : null 
     * @value               : $data array keep the value of menu, serial, video_course, invitation_data, send_invitation
     *                        $search_value keep the value search input 
     *                        $video_course_data keep the value video_course , count data
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function search_manage_send_video_course_invitation() {
        if ($this->input->is_ajax_request()) {
            $search_value = $this->input->post('search_value', TRUE);
            
            $page = $this->input->post('page_number', TRUE);
            $page_number = isset($page) ? $page : 1 ;
            $limit_offset = ($page_number - 1) * 10;
            
            $video_course_data = $this->Send_video_course_invitation_model->search_send_video_course_invitation_info($search_value, $limit_offset);
            $data['video_course'] = $video_course_data['video_course'];
            $data['serial'] = $limit_offset;
            foreach ($video_course_data['video_course'] as $video_course){
                $data['invitation_data'][$video_course->video_course_id] = $this->Send_video_course_invitation_model->get_send_video_course_invitation_info_by_invitation_type_id($video_course->video_course_id);
                $data['send_invitation'][$video_course->video_course_id] = count($data['invitation_data'][$video_course->video_course_id]['invitation']);
            }
            $total_row = $video_course_data['count_video_course'];
            $params = array('url' => '', 'div_id' => 'manage_send_video_course_invitation_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['manage_send_video_course_invitation_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('send_video_course_invitation/ajax_view/search_send_video_course_invitation', $data, TRUE);
        } else {
            redirect('manage-send-video-course-invitation');
        }
    }
    
    public function search_send_video_course_invitation_user_list() {
        if ($this->input->is_ajax_request()) {
            $search_value = $this->input->post('search_value', TRUE);
            $invitation_id = $this->input->post('invitation_id', TRUE);
            
            $data['page_number'] = $page = $this->input->post('page_number', TRUE);
            $page_number = isset($page) ? $page : 1 ;
            $limit_offset = ($page_number - 1) * 10;
            
            $data['serial'] = $limit_offset;
            $data['invitation_receive_person'] = $this->Send_video_course_invitation_model->search_send_video_course_invitation_user_list($search_value, $invitation_id, $limit_offset);
            $data['person_email'] = $this->Send_video_course_invitation_model->check_send_invitation_email_with_person_email($data['invitation_receive_person']['invitation_receive_person_data']);

            $total_row = $data['invitation_receive_person']['count_invitation_receive_person'];
            $params = array('url' => '', 'div_id' => 'send_video_course_invitation_user_list_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['send_video_course_invitation_user_list_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('send_video_course_invitation/ajax_view/view_invited_user_list', $data, TRUE);
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 9-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : 'pagination-send-video-course-invitation'
     * @Description         : pagination of manage send invitation
     * @view                : send_video_course_invitation/ajax_view/search_send_video_course_invitation
     * @redirect            : manage-send-video-course-invitation [if not ajax request]
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : null
     * @Return              : null 
     * @value               : $data array keep the value of menu, serial, video_course, invitation_data, send_invitation
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function pagination_manage_send_video_course_invitation() {
        if ($this->input->is_ajax_request()) {
            $page_number = $this->input->post('page_number', TRUE);
            $limit_offset = ($page_number * 10) - 10;
            
            $data['serial'] = $limit_offset;
            $data['video_course'] = $this->Manage_admin_video_course_model->manage_limit_admin_video_course_info($limit_offset);
            foreach ($data['video_course'] as $video_course){
                $data['invitation_data'][$video_course->video_course_id] = $this->Send_video_course_invitation_model->get_send_video_course_invitation_info_by_invitation_type_id($video_course->video_course_id);
                $data['send_invitation'][$video_course->video_course_id] = count($data['invitation_data'][$video_course->video_course_id]['invitation']);
            }
            
            $total_row = count($this->Manage_admin_video_course_model->manage_admin_video_course_info());
            $params = array('url' => '', 'div_id' => 'manage_send_video_course_invitation_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['manage_send_video_course_invitation_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('send_video_course_invitation/ajax_view/search_send_video_course_invitation', $data, TRUE);
        } else {
            redirect('manage-send-video-course-invitation');
        }
    }
    
    
    public function pagination_view_video_course_invitation() {
        if ($this->input->is_ajax_request()) {
            $video_course_url = $this->input->post('video_course_url', TRUE);
            $send_invitation_tab = $this->input->post('send_invitation_tab', TRUE);
            $page_number = $this->input->post('page_number', TRUE);
            
            $data['video_course'] = $this->Manage_admin_video_course_model->view_single_video_course_info($video_course_url);
            $data['send_invitation_tab'] = $send_invitation_tab;
            switch ($send_invitation_tab) {
                case 'anonymous':
                    $data['anonymous_invitation'] = $this->Send_video_course_invitation_model->send_video_course_invitation_anonymous_info($data['video_course']->video_course_id, $page_number);
                    break;
                case 'user':
                    $data['user_invitation'] = $this->Send_video_course_invitation_model->send_video_course_invitation_tt_user_info($data['video_course']->video_course_id, $page_number);
                    break;
            }
            echo $this->load->view('send_video_course_invitation/ajax_view/view_video_course_invitation_pagination', $data, TRUE);
        }
    }
    
    public function pagination_send_video_course_invitation_user_list() {
        if ($this->input->is_ajax_request()) {
            $invitation_id = $this->input->post('invitation_id', TRUE);
            $data['page_number'] = $page_number = $this->input->post('page_number', TRUE);
            $limit_offset = ($page_number * 10) - 10;
            
            $data['serial'] = $limit_offset;
            $data['invitation_id'] = $invitation_id;
            $data['invitation_receive_person'] = $this->Send_video_course_invitation_model->sent_invitation_receive_person_info_by_invitation_id($invitation_id,'', $limit_offset);
            $data['person_email'] = $this->Send_video_course_invitation_model->check_send_invitation_email_with_person_email($data['invitation_receive_person']['invitation_receive_person_data']);

            $total_row = $data['invitation_receive_person']['count_invitation_receive_person'];
            $params = array('url' => '', 'div_id' => 'send_video_course_invitation_user_list_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['send_video_course_invitation_user_list_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('send_video_course_invitation/ajax_view/view_invited_user_list', $data, TRUE);
        }
    }
    
    public function send_registration_invitation() {
        if ($this->input->is_ajax_request()) {
            $invitation_receive_person_id = $this->input->post('invitation_receive_person_id', TRUE);
            
            $invitation_receive_person = $this->Send_video_course_invitation_model->get_send_invitation_receive_person_info_by_invitation_receive_person_id($invitation_receive_person_id);
            $invitation_info = $this->Send_video_course_invitation_model->get_send_video_course_invitation_info($invitation_receive_person->invitation_id);
            $mdata['video_course'] = $this->Manage_admin_video_course_model->edit_admin_video_course_info($invitation_info->invitation_type_id);
            
            $this->email->set_mailtype('html');
            $this->email->from('no-replay@talhatraining.com', 'Talha Training');
            $this->email->to($invitation_receive_person->invitation_send_to_email);
            $this->email->subject('Invitation Message for Join TT');
            $body = $this->load->view('send_video_course_invitation/mailscript_registration_invitation', $mdata, true);
            $this->email->message($body);
            if($this->email->send()){
                echo 'sent';
            }else{
                echo 'failed';
            }
        }
    }
}