<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Quiz extends CI_Controller {

    //put your code here
    function __construct() {
        parent::__construct();
        $user_id = $this->session->userdata('user_id');
        if ($user_id == NULL) {
            redirect('sign-in', 'refresh');
        }
        $person_role = $this->session->userdata('person_role');
        if ($person_role == 1) {
            redirect('babbamamma');
        } else if ($person_role == 2) {
            redirect('babbamamma');
        } else if ($person_role == 6) {
            redirect('babbamamma');
        }
    }

    public function index() {
        $person_id = $this->session->userdata('user_id');
// Right Sidebar Content Information

        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;

        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['main_content'] = $this->load->view('user/quiz/view_quiz', $data, true);
        $this->load->view('user/master', $data);
    }

    public function organization_quiz() {
        $person_id = $this->session->userdata('user_id');
// Right Sidebar Content Information

        $sdata = array();
        $data['active_menu'] = $sdata['active_menu'] = 'organization';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'myQuiz';
        $data['redirect_url'] = $sdata['redirect_url'] = 'quizes/organization';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $this->session->set_userdata($sdata);

        $this->session->unset_userdata('points_per_answer');
        $this->session->unset_userdata('time_limit');

        $page_number = 1;
        $data['total_row_quiz'] = count($this->quiz_model->select_all_quiz_by_person_id($person_id));
        $data['all_quiz'] = $this->quiz_model->select_limit_quiz_by_person_id($person_id, 0);
        foreach ($data['all_quiz'] as $v_quiz) {
            $data['quiz_questions'][$v_quiz->quiz_id] = $this->quiz_model->select_active_question_by_quiz_id($v_quiz->quiz_id);
        }
        $params = array('url' => '', 'div_id' => 'total_quiz_paginationtalha', 'total_row' => $data['total_row_quiz'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        
        $data['main_content'] = $this->load->view('user/quiz/view_quiz', $data, true);
        $this->load->view('user/master', $data);
    }

    public function teacher_quiz() {
        $person_id = $this->session->userdata('user_id');
// Right Sidebar Content Information
        $sdata = array();
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['active_menu'] = $sdata['active_menu'] = 'teacher';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'myQuiz';
        $data['redirect_url'] = $sdata['redirect_url'] = 'quizes/organization';
        $this->session->set_userdata($sdata);
        $this->session->unset_userdata('points_per_answer');
        $this->session->unset_userdata('time_limit');
        
        $page_number = 1;
        $data['total_row_quiz'] = count($this->quiz_model->select_all_quiz_by_person_id($person_id));
        $data['all_quiz'] = $this->quiz_model->select_limit_quiz_by_person_id($person_id, 0);
        foreach ($data['all_quiz'] as $v_quiz) {
            $data['quiz_questions'][$v_quiz->quiz_id] = $this->quiz_model->select_active_question_by_quiz_id($v_quiz->quiz_id);
        }
        $params = array('url' => '', 'div_id' => 'total_quiz_paginationtalha', 'total_row' => $data['total_row_quiz'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        
        $data['main_content'] = $this->load->view('user/quiz/view_quiz', $data, true);
        $this->load->view('user/master', $data);
    }
    
    public function teacher_quiz_ajax_view() {
        if ($this->input->is_ajax_request()){
            $page_number = $this->input->post('page_number', TRUE);
            $limit_offset = ($page_number * 10) - 10;
            $person_id = $this->session->userdata('user_id');
    // Right Sidebar Content Information
            $sdata = array();
            $data['left_side_menu_view'] = 1;
            $data['left_side'] = 1;
            $data['active_menu'] = $sdata['active_menu'] = 'teacher';
            $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'myQuiz';
            $data['redirect_url'] = $sdata['redirect_url'] = 'quizes/organization';
            $this->session->set_userdata($sdata);
            $this->session->unset_userdata('points_per_answer');
            $this->session->unset_userdata('time_limit');

            $data['total_row_quiz'] = count($this->quiz_model->select_all_quiz_by_person_id($person_id));
            $data['all_quiz'] = $this->quiz_model->select_limit_quiz_by_person_id($person_id,$limit_offset );
            foreach ($data['all_quiz'] as $v_quiz) {
                $data['quiz_questions'][$v_quiz->quiz_id] = $this->quiz_model->select_active_question_by_quiz_id($v_quiz->quiz_id);
            }
            $params = array('url' => '', 'div_id' => 'total_quiz_paginationtalha', 'total_row' => $data['total_row_quiz'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);
            
            echo $this->load->view('user/quiz/view_teacher_quiz_ajax_view', $data, true);
        }
    }

    public function learner_quiz() {
        $person_id = $this->session->userdata('user_id');
// Right Sidebar Content Information
        $sdata = array();
        $data['active_menu'] = $sdata['active_menu'] = 'learner';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'learner_quiz';
        $data['redirect_url'] = $sdata['redirect_url'] = 'quizes/organization';
        $this->session->set_userdata($sdata);
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $page_number = 1;
        $data['all_quiz'] = $this->quiz_model->select_learner_limit_quiz_by_person_id($person_id, 0);
        $data['all_row_quiz'] = count($this->quiz_model->select_learner_all_quiz_by_person_id($person_id));
        //$this->cf->debug($data['all_row_quiz']);
        foreach ($data['all_quiz'] as $v_quiz) {
            $data['quiz_topic_info'][$v_quiz->quiz_id] = $this->topic_model->select_topic_info_by_topic_id($v_quiz->topic_id);
            $data['quiz_result'][$v_quiz->quiz_id] = $this->quiz_model->select_quiz_result($person_id, $v_quiz->quiz_id);
            $data['quiz_questions'][$v_quiz->quiz_id] = $this->quiz_model->select_active_question_by_quiz_id($v_quiz->quiz_id);
        }
        $params = array('url' => '', 'div_id' => 'learner_quiz_pagination', 'total_row' => $data['all_row_quiz'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);

        $data['main_content'] = $this->load->view('user/quiz/view_quiz_learner', $data, true);
        $this->load->view('user/master', $data);
    }
    
    public function learner_quiz_ajax_view(){
        if ($this->input->is_ajax_request()){
        $person_id = $this->session->userdata('user_id');
        $sdata = array();
        $data['active_menu'] = $sdata['active_menu'] = 'learner';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'learner_quiz';
        $data['redirect_url'] = $sdata['redirect_url'] = 'quizes/organization';
        $this->session->set_userdata($sdata);
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $page_number = $this->input->post('page_number',TRUE);
        $limit_offset = ($page_number*10)-10;
        $data['all_quiz'] = $this->quiz_model->select_learner_limit_quiz_by_person_id($person_id, $limit_offset);
        $data['all_row_quiz'] = count($this->quiz_model->select_learner_all_quiz_by_person_id($person_id));
        //$this->cf->debug($data['all_row_quiz']);
        foreach ($data['all_quiz'] as $v_quiz) {
            $data['quiz_topic_info'][$v_quiz->quiz_id] = $this->topic_model->select_topic_info_by_topic_id($v_quiz->topic_id);
            $data['quiz_result'][$v_quiz->quiz_id] = $this->quiz_model->select_quiz_result($person_id, $v_quiz->quiz_id);
            $data['quiz_questions'][$v_quiz->quiz_id] = $this->quiz_model->select_active_question_by_quiz_id($v_quiz->quiz_id);
        }
        $params = array('url' => '', 'div_id' => 'learner_quiz_pagination', 'total_row' => $data['all_row_quiz'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);

        echo  $this->load->view('user/quiz/view_learner_quiz_ajax_view', $data, true);
      
        }
    }

    public function view_learner_grade() {
        $person_id = $this->session->userdata('user_id');
// Right Sidebar Content Information

        $sdata = array();
        $data['active_menu'] = $sdata['active_menu'] = 'learner';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'learner_quiz';
        $data['redirect_url'] = $sdata['redirect_url'] = 'quizes/organization';
        $this->session->set_userdata($sdata);
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $data['all_quiz'] = $this->quiz_model->select_all_quiz_by_person_id($person_id);
        foreach ($data['all_quiz'] as $v_quiz) {
            $data['quiz_questions'][$v_quiz->quiz_id] = $this->quiz_model->select_active_question_by_quiz_id($v_quiz->quiz_id);
        }
        $data['main_content'] = $this->load->view('user/quiz/view_learner_grade', $data, true);
        $this->load->view('user/master', $data);
    }

    public function view_learner_certificate() {
        $person_id = $this->session->userdata('user_id');
// Right Sidebar Content Information

        $sdata = array();
        $data['active_menu'] = $sdata['active_menu'] = 'learner';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'learner_quiz';
        $data['redirect_url'] = $sdata['redirect_url'] = 'quizes/organization';
        $this->session->set_userdata($sdata);
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $data['all_quiz'] = $this->quiz_model->select_all_quiz_by_person_id($person_id);
        foreach ($data['all_quiz'] as $v_quiz) {
            $data['quiz_questions'][$v_quiz->quiz_id] = $this->quiz_model->select_active_question_by_quiz_id($v_quiz->quiz_id);
        }
        $data['main_content'] = $this->load->view('user/quiz/view_learner_certificate', $data, true);
        $this->load->view('user/master', $data);
    }

    public function details_quiz_result() {
        $person_id = $this->session->userdata('user_id');
// Right Sidebar Content Information
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $sdata = array();
        $data['active_menu'] = $sdata['active_menu'] = 'learner';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'learner_quiz';
        $data['redirect_url'] = $sdata['redirect_url'] = 'quizes/organization';
        $this->session->set_userdata($sdata);
        $data['left_content'] = $this->load->view('user/side_menu', $data, TRUE);
        $data['right_content'] = $this->load->view('user/right_content', $data, TRUE);

        $data['all_quiz'] = $this->quiz_model->select_all_quiz_by_person_id($person_id);
        foreach ($data['all_quiz'] as $v_quiz) {
            $data['quiz_questions'][$v_quiz->quiz_id] = $this->quiz_model->select_active_question_by_quiz_id($v_quiz->quiz_id);
        }
        $data['main_content'] = $this->load->view('user/quiz/details_quiz_result', $data, true);
        $this->load->view('user/master', $data);
    }

    public function check_quiz_public_id($public_id) {
        echo $this->quiz_model->check_quiz_public_id($public_id);
    }

    public function check_quiz_topic($topic_name) {
        echo $this->quiz_model->check_quiz_topic($topic_name);
    }

    public function create_quiz() {
        $person_id = $this->session->userdata('user_id');
// Right Sidebar Content Information
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');

        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $this->form_validation->set_rules('quiz_name', 'quiz name', 'required|trim|max_length[50]');
        $this->form_validation->set_rules('parent_topic_id', 'Parent topic ', 'required|min_length[1]');
        $this->form_validation->set_rules('quiz_topics_specification', 'Topic ', 'required|min_length[1]');
        $this->form_validation->set_rules('quiz_public_id', 'Quiz Public Id', 'required|callback_validate_quiz_public_id[]');
        $this->form_validation->set_rules('quiz_url', 'quiz url', 'required|callback_validate_quiz_url[]');
        $this->form_validation->set_rules('quiz_description', 'quiz quiz_description');
        $this->form_validation->set_rules('quiz_random_static', 'Quiz Random Static', 'required');
        $this->form_validation->set_rules('quiz_pulication_status', 'quiz permission', 'required');
        $this->form_validation->set_rules('quiz_status', 'Quiz status', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['quiz_topics'] = $this->topic_model->select_all_parent_topic_id_if_child();
            $data['main_content'] = $this->load->view('user/quiz/create_quiz', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $quiz_id = $this->quiz_model->save_quiz_info();
            $sdata['points_per_answer'] = $this->input->post('points_per_answer', true);
            $sdata['time_limit'] = $this->input->post('time_limit', true);
            $sdata['message'] = 'Quiz has been added successfully';
            $this->session->set_userdata($sdata);
            $quiz_info = $this->quiz_model->select_quiz_by_id($quiz_id);
            redirect('quiz/' . $quiz_info->url . '/add-quiz-question');
        }
    }

    public function validate_quiz_public_id($quiz_public_id, $old_public_id) {
        if ($old_public_id == $quiz_public_id) {
            return true;
        } else {
            $result = $this->quiz_model->check_quiz_public_id($quiz_public_id);
            if ($result == 1) {
                $this->form_validation->set_message('validate_quiz_public_id', "Quiz public id exist");
                return false;
            } else {
                $sp = '/^[0-9a-zA-Z]+$/';
                if (!preg_match($sp, $quiz_public_id)) {
                    $this->form_validation->set_message('validate_quiz_public_id', "Allowed valid chatacter 0-9, a-z or A-Z (space not allowed)");
                    return FALSE;
                } else {
                    return TRUE;
                }
            }
        }
    }

    public function validate_quiz_url($url, $old_url) {
        if ($old_url == $url) {
            return true;
        } else {
            $result = $this->url_model->check_url_exists1($url);
            if ($result == 1) {
                $this->form_validation->set_message('validate_quiz_url', "URL Already Exist");
                return false;
            } else {
                $sp = '/^[0-9a-zA-Z\-]+$/';
                if (!preg_match($sp, $url)) {
                    $this->form_validation->set_message('validate_quiz_url', "Allowed valid chatacter 0-9, a-z or A-Z (space not allowed)");
                    return FALSE;
                } else if (strstr($url, ' ')) {
                    $this->form_validation->set_message('validate_quiz_url', " Don't use Space if need use '-', alse URL Cann't contain any special carecter like '/[!@#$%&*()^,._;:-]/'");
                    return FALSE;
                } else if (preg_match('/--/', $url)) {
                    $this->form_validation->set_message('validate_quiz_url', "URL Cann't contain multiple hypen");
                    return FALSE;
                } else if (substr($url, (strlen($url) - 1)) == '-') {
                    $this->form_validation->set_message('validate_quiz_url', "No hypen allow at the last");
                    return FALSE;
                } else {
                    return TRUE;
                }
            }
        }
    }

    public function edit_quiz($quiz_url) {
        $data['quiz_url'] = $quiz_url;
        $data['person_id'] = $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);

        if (!$data['quiz_info']) {
            redirect('quizes/' . $this->session->userdata('active_menu'));
        }
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['first_question'] = $this->quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);

        if ($data['first_question']) {
            $sdata['points_per_answer'] = $data['first_question']->points_per_answer;
            $sdata['time_limit'] = $data['first_question']->time_limit;
            $this->session->set_userdata($sdata);
        }
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $this->form_validation->set_rules('quiz_name', 'quiz name', 'required|trim|max_length[50]');
        $this->form_validation->set_rules('quiz_topics_specification', 'course ', 'required|min_length[1]');
        $this->form_validation->set_rules('quiz_public_id', 'Quiz Public Id', 'required|callback_validate_quiz_public_id[' . $data['quiz_info']->quiz_public_id . ']');
        $this->form_validation->set_rules('quiz_url', 'quiz url', 'required|callback_validate_quiz_url[' . $data['quiz_info']->url . ']');
        $this->form_validation->set_rules('quiz_description', 'quiz quiz_description');
        $this->form_validation->set_rules('quiz_random_static', 'Quiz Random Static', 'required');
        $this->form_validation->set_rules('quiz_pulication_status', 'quiz permission', 'required');
//        $this->form_validation->set_rules('to_address', 'Selected Group/ Course/ Video Course');
        $this->form_validation->set_rules('quiz_status', 'Quiz status', 'required');
        if ($this->form_validation->run() == FALSE) {
            $data['parent_topic_info'] = $this->topic_model->select_topic_info_by_topic_id($data['quiz_info']->quiz_topics_specification);
            $data['quiz_topics'] = $this->topic_model->select_all_parent_topic_id_if_child();
            $data['main_content'] = $this->load->view('user/quiz/edit_quiz', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->quiz_model->update_quiz_info($data);
            $sdata['points_per_answer'] = $this->input->post('points_per_answer', true);
            $sdata['time_limit'] = $this->input->post('time_limit', true);
            $sdata['message'] = 'Quiz Updated successfully';
            $this->session->set_userdata($sdata);
            redirect('quiz/' . $data['quiz_info']->url . '/add-quiz-question');
        }
    }

    public function change_quiz_status($url, $status) {
        $data = array();
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($url);
        $this->quiz_model->change_quiz_status($data['quiz_info']->quiz_id, $status);
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($url);
        $data['quiz_questions'] = $this->quiz_model->select_active_question_by_quiz_id($data['quiz_info']->quiz_id);
        echo $this->load->view('user/quiz/view_quiz_actions', $data, TRUE);
    }

    public function select_quiz_access_user() {

        $data['access_level'] = $access_level = $_POST['givenText'];
        $quiz_public_id = $_POST['quizPublicId'];
        $person_id = $this->session->userdata('user_id');

        if ($access_level == 3) {// My Link
            $data['link_person'] = $this->user_course_model->select_link_person($person_id);
        } else if ($access_level == 4) {// Only Group
            $data['group'] = $this->quiz_model->select_group_by_person_id($person_id);
            if ($quiz_public_id) {
                $data['quiz_groups'] = $this->quiz_model->select_quiz_group_permission($quiz_public_id);
            } else {
                $data['quiz_groups'] = '';
            }
        } else if ($access_level == 5) {// Course
            $data['all_course'] = $this->quiz_model->select_public_course_by_person_id($person_id);  //only Organization / Trainer / Student
            foreach ($data['all_course'] as $v_course) {
                $data['course_permission'][$v_course->course_id] = $this->quiz_model->select_quiz_course_permission_by_course_id($v_course->course_id);
            }
            if ($quiz_public_id) {
                $data['quiz_courses'] = $this->quiz_model->select_quiz_course_permission($quiz_public_id);
                $data['course_permission'][$data['quiz_courses']->course_id] = '';
            } else {
                $data['quiz_courses'] = '';
            }
        } else if ($access_level == 6) {// Video Course
            $data['all_video_course'] = $this->quiz_model->select_video_course_by_person_id($person_id);  //only Organization / Trainer / Student
            foreach ($data['all_video_course'] as $v_course) {
                $data['video_course_permission'][$v_course->video_management_id] = $this->quiz_model->select_quiz_video_course_permission_by_course_id($v_course->video_management_id);
            }
            if ($quiz_public_id) {
                $data['quiz_video_courses'] = $this->quiz_model->select_quiz_video_course_permission($quiz_public_id);
                $data['video_course_permission'][$data['quiz_video_courses']->video_management_id] = '';
            } else {
                $data['quiz_video_courses'] = '';
            }
        }
        echo $this->load->view('user/quiz/select_quiz_access_user', $data, TRUE);
    }

    public function add_question($quiz_url = null) {
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $this->load->library('form_validation');
        $this->form_validation->set_rules('question_details', 'Question', 'required|trim');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('points_per_answer', 'Markes', 'required');
        $this->form_validation->set_rules('time_limit', 'time limit', 'required');
        $this->form_validation->set_rules('option[]', 'option', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'add_question';
            $data['quiz_topics'] = $this->quiz_model->select_quiz_active_topic();
            $data['left_side_menu_view'] = 1;
            $data['left_side'] = 1;
            $data['all_quiz'] = $this->quiz_model->select_active_quiz_by_person_id($person_id);
            if($this->input->post('question_type')){
                $data['question_type'] = $question_type = $this->input->post('question_type');
                $this->session->set_userdata($data);
            }
            $data['main_content'] = $this->load->view('user/quiz/add_question', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->quiz_model->save_question_info();
            $sdata['quiz_url'] = $quiz_url = $this->input->post('quiz_id', true);
            $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);
            $sdata['question_type'] = $question_type = $this->input->post('question_type');
            $sdata['message'] = 'question has been added successfully';
            $this->session->set_userdata($sdata);
            redirect('add-question');
        }
    }

    public function add_quiz_question($quiz_url = null) {
        $person_id = $this->session->userdata('user_id');   // Right Sidebar Content Information      
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $this->load->library('form_validation');
        $this->form_validation->set_rules('question_details', 'Question', 'trim|required');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('points_per_answer', 'Markes', 'required');
        $this->form_validation->set_rules('time_limit', 'time limit', 'required');
        $this->form_validation->set_rules('option[]', 'answer text', 'required');
         $this->form_validation->set_rules('status', 'option choice', 'required');

        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);
        if (!$data['quiz_info']) {
            redirect('quizes/' . $this->session->userdata('active_menu'));
        }
        $data['first_question'] = $this->quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);

        if ($data['first_question']) {
            $sdata['points_per_answer'] = $data['first_question']->points_per_answer;
            $sdata['time_limit'] = $data['first_question']->time_limit;
            $this->session->set_userdata($sdata);
        }

        if ($this->form_validation->run() == FALSE) {
            $data['left_side_menu_view'] = 1;
            $data['left_side'] = 1;
            $data['active'] = 'add_question';
            $data['quiz_url'] = $quiz_url;
            $data['all_quiz'] = $this->quiz_model->select_active_quiz_by_person_id($person_id);
            $data['main_content'] = $this->load->view('user/quiz/add_quiz_question', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->quiz_model->save_question_info();
            $this->session->unset_userdata('points_per_answer');
            $this->session->unset_userdata('time_limit');
            $sdata['question_type'] = $question_type = $this->input->post('question_type');
            $sdata['message'] = 'question has been added successfully';
            $this->session->set_userdata($sdata);
            redirect('quiz/' . $data['quiz_info']->url . '/add-quiz-question');
        }
    }

    public function edit_multiple_choice_question() {
        $data['person_id'] = $person_id = $this->session->userdata('user_id');
        $quiz_url = $this->uri->segment(1);
        $question_id = $this->uri->segment(3);
        $sdata = array();
        $sdata['question_type'] = "1";
        $this->session->set_userdata($sdata);
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);
        $data['first_question'] = $this->quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
        $data['question_info'] = $this->quiz_model->select_question_info_by_id($question_id);
        $data['question_options'] = $this->quiz_model->select_question_options_by_question_id($question_id);
        $data['quiz_url'] = $quiz_url;
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);

        $this->form_validation->set_rules('question_details', 'Question', 'required');
        $this->form_validation->set_rules('points_per_answer', 'Markes', 'required');
        $this->form_validation->set_rules('time_limit', 'time limit', 'required');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('option[]', 'option', 'required');
        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'add_question';
            $data['left_side_menu_view'] = 1;
            $data['left_side'] = 1;
            $data['quiz_topics'] = $this->quiz_model->select_quiz_active_topic();
            $data['all_quiz'] = $this->quiz_model->select_active_quiz_by_person_id($person_id);
            $data['main_content'] = $this->load->view('user/quiz/edit_multiple_choice_question', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->quiz_model->update_question_info($data['question_info']->question_id, $data['question_info']->question_details);
            $sdata['question_type'] = $question_type = $this->input->post('question_type');
            $sdata['message'] = 'question has been Updated successfully';
            $this->session->set_userdata($sdata);
            redirect("quiz/$quiz_url/question");
        }
    }

    public function edit_true_false_question() {
        $data['person_id'] = $person_id = $this->session->userdata('user_id');
        $quiz_url = $this->uri->segment(1);
        $question_id = $this->uri->segment(3);
        $sdata = array();
        $sdata['question_type'] = "2";
        $this->session->set_userdata($sdata);
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);
        $data['first_question'] = $this->quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
        $data['question_info'] = $this->quiz_model->select_question_info_by_id($question_id);
        $data['question_options'] = $this->quiz_model->select_question_options_by_question_id($question_id);
        $data['quiz_url'] = $quiz_url;
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);

        $this->form_validation->set_rules('question_details', 'Question', 'required');
        $this->form_validation->set_rules('points_per_answer', 'Markes', 'required');
        $this->form_validation->set_rules('time_limit', 'time limit', 'required');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('option[]', 'option', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'add_question';
            $data['left_side_menu_view'] = 1;
            $data['left_side'] = 1;
            $data['quiz_topics'] = $this->quiz_model->select_quiz_active_topic();
            $data['all_quiz'] = $this->quiz_model->select_active_quiz_by_person_id($person_id);
            $data['main_content'] = $this->load->view('user/quiz/edit_true_false_question', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->quiz_model->update_question_info($data['question_info']->question_id, $data['question_info']->question_details);
            $sdata['question_type'] = $question_type = $this->input->post('question_type');
            $sdata['message'] = 'question has been added successfully';
            $this->session->set_userdata($sdata);
            redirect("quiz/$quiz_url/question");
        }
    }

    public function edit_descriptive_question() {
        $quiz_url = $this->uri->segment(1);
        $question_id = $this->uri->segment(3);
        $sdata = array();
        $sdata['question_type'] = "3";
        $this->session->set_userdata($sdata);
        // Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);
        $data['first_question'] = $this->quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
        $data['question_info'] = $this->quiz_model->select_question_info_by_id($question_id);
        $data['question_options'] = $this->quiz_model->select_question_options_by_question_id($question_id);
        $data['quiz_url'] = $quiz_url;

        $this->form_validation->set_rules('question_details', 'Question', 'required|trim');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('option', 'option', 'required');
        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'add_question';
            $data['left_side_menu_view'] = 1;
            $data['left_side'] = 1;
            $data['quiz_topics'] = $this->quiz_model->select_quiz_active_topic();
            $data['all_quiz'] = $this->quiz_model->select_active_quiz_by_person_id($person_id);
            $data['main_content'] = $this->load->view('user/quiz/edit_descriptive_question', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->quiz_model->update_question_info($question_id);
            $sdata['question_type'] = $question_type = $this->input->post('question_type');
            $sdata['message'] = 'question has been added successfully';
            $this->session->set_userdata($sdata);
            redirect("quiz/$quiz_url/question");
        }
    }

//tania 27-07-2016
    public function edit_fill_in_the_blank_question() {
        $quiz_url = $this->uri->segment(1);
        $question_id = $this->uri->segment(3);
        $sdata = array();
        $sdata['question_type'] = "4";
        $this->session->set_userdata($sdata);
        $data['person_id'] = $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);
        $data['first_question'] = $this->quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
        $data['question_info'] = $this->quiz_model->select_question_info_by_id($question_id);
        $data['question_options'] = $this->quiz_model->select_question_options_by_question_id($question_id);
        $data['quiz_url'] = $quiz_url;
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);

        $this->form_validation->set_rules('question_details', 'Question', 'required');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('option', 'option', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'add_question';
            $data['quiz_topics'] = $this->quiz_model->select_quiz_active_topic();
            $data['all_quiz'] = $this->quiz_model->select_active_quiz_by_person_id($person_id);
            $data['main_content'] = $this->load->view('user/quiz/edit_fill_in_the_blank_question', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->quiz_model->update_question_info($data['question_info']->question_id, $data['question_info']->question_details);
            $sdata['question_type'] = $question_type = $this->input->post('question_type');
            $sdata['message'] = 'question has been added successfully';
            $this->session->set_userdata($sdata);
            redirect("quiz/$quiz_url/question");
        }
    }

    public function get_quiz_required_information($quiz_url) {
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);
        $data['first_question'] = $this->quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
        if ($data['first_question']) {
            $sdata['points_per_answer'] = $data['first_question']->points_per_answer;
            $sdata['time_limit'] = $data['first_question']->time_limit;
            $this->session->set_userdata($sdata);
        }
        echo $this->load->view('user/quiz/quiz_information_for_question', $data, TRUE);
    }

    public function get_quiz_required_information_edit($quiz_url, $question_id) {
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);
        $data['first_question'] = $this->quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
        $data['question_info'] = $this->quiz_model->select_question_info_by_id($question_id);
        if ($data['quiz_info']->quiz_created_by != $this->session->userdata('user_id') && $data['question_info']->quiz_id != $data['quiz_info']->quiz_id) {
            echo 'Question is not FOUND!!';
            exit();
        } else {
            echo $this->load->view('user/quiz/quiz_information_for_question_edit', $data, TRUE);
        }
    }

    public function view_quiz_test() {
        $data = array();
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $this->load->view('user/master', $data);
    }

    public function check_public_quiz() {
        $data = array();
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;

        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['right_content'] = $this->load->view('user/profile_view/profile_right_content', $data, TRUE);
        $code = $this->uri->segment(2);
        $result = $this->quiz_model->select_quiz_by_public_id($code);

        if ($result && $result->quiz_pulication_status == 1) {
            $data['quiz_info'] = $this->quiz_model->select_quiz_by_id($result->quiz_id);
            $data['creator_info'] = $this->profile_model->person_info_by_person_id($result->quiz_created_by);
            $data['main_content'] = $this->load->view('user/quiz/attendee_quiz_view', $data, true);
            $this->load->view('user/master', $data);
        } else if ($result && $result->quiz_permission != 1) {
            redirect();
        } else {
            redirect();
        }
    }

    public function add_topics() {
        $person_id = $this->session->userdata('user_id');

        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $this->load->view('user/master', $data);
    }

    public function add_moreTopics($Counter) {
        $data = array();
        $data['Counter'] = $Counter;
        echo $this->load->view('user/video/add_topics_ajax_file', $data, TRUE);
    }

    public function add_grade($quiz_url) {
        $person_id = $this->session->userdata('user_id');
// Right Sidebar Content Information
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;

        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $this->form_validation->set_rules('grade_total_number', 'grade_total_number', 'required');
        $this->form_validation->set_rules('grade_name', 'grade_name', 'required');
        $this->form_validation->set_rules('grade_number', 'grade_number', 'required');
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);
        $data['quiz_grades'] = $this->quiz_model->select_quiz_all_grade($data['quiz_info']->quiz_id);
        if (!$data['quiz_info']) {
            redirect();
        }
        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/quiz/edit_grade', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->quiz_model->save_grade_info($data['quiz_info']->quiz_id);
            $sdata['message'] = 'Quiz Grade has been added successfully';
            $this->session->set_userdata($sdata);
            redirect('quiz/' . $data['quiz_info']->url . '/view-grade');
        }
    }

    public function add_more_grade($grade_number) {
        $data['grade_number'] = $grade_number;
        echo $this->load->view('user/quiz/more_grade', $data, TRUE);
    }

    public function delete_grade($grade_id) {
        $this->db->where('grade_id', $grade_id);
        $this->db->delete('tbl_grade');
        echo 1;
    }

    public function view_grade() {
// Right Sidebar Content Information

        $person_id = $this->session->userdata('user_id');
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['all_quizes'] = $this->quiz_model->select_all_quiz_by_person_id($person_id);
        foreach ($data['all_quizes'] as $v_quiz) {
            $data['quiz_grades'][$v_quiz->quiz_id] = $this->quiz_model->select_quiz_all_grade($v_quiz->quiz_id);
        }
        $data['main_content'] = $this->load->view('user/quiz/view_grade', $data, true);
        $this->load->view('user/master', $data);
    }

    public function activate_grade($grade_id) {
        $data = array();
        $this->quiz_model->active_selected_grade($grade_id);
        $data['grade_info'] = $this->quiz_model->select_grade_by_id($grade_id);
        echo $this->load->view('user/quiz/view_grade_actions', $data, TRUE);
    }

    public function inactivate_grade($grade_id) {
        $data = array();
        $this->quiz_model->inactive_selected_grade($grade_id);
        $data['grade_info'] = $this->quiz_model->select_grade_by_id($grade_id);
        echo $this->load->view('user/quiz/view_grade_actions', $data, TRUE);
    }

    public function archive_grade($grade_id) {
        $data = array();
        $this->quiz_model->archive_selected_grade($grade_id);
        $data['grade_info'] = $this->quiz_model->select_grade_by_id($grade_id);
        echo $this->load->view('user/quiz/view_grade_actions', $data, TRUE);
    }

    public function edit_grade($quiz_url) {
// Right Sidebar Content Information
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $this->form_validation->set_rules('grade_total_number', 'grade_total_number', 'required');
        $this->form_validation->set_rules('grade_name', 'grade_name', 'required');
        $this->form_validation->set_rules('grade_number', 'grade_number', 'required');

        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);
        $data['quiz_grades'] = $this->quiz_model->select_quiz_all_grade($data['quiz_info']->quiz_id);

        if (!$data['quiz_info']) {
            redirect();
        }
        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/quiz/edit_grade', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->quiz_model->update_grade_info($data['quiz_info']->quiz_id);
            $sdata['message'] = 'Quiz Grade has been added successfully';
            $this->session->set_userdata($sdata);
            redirect('quiz/view-grade');
        }
    }

    public function quiz_grade_details($quiz_url) {
        $data = array();
// Right Sidebar Content Information
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);
        $data['quiz_grades'] = $this->quiz_model->select_quiz_all_grade($data['quiz_info']->quiz_id);
        $data['main_content'] = $this->load->view('user/quiz/selected_grade_details', $data, true);
        $this->load->view('user/master', $data);
    }

    public function edit_selected_grade() {
        $data = array();
// Right Sidebar Content Information
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['main_content'] = $this->load->view('user/quiz/edit_selected_grade', $data, true);
        $this->load->view('user/master', $data);
    }

    public function create_certificate() {
        $data = array();
// Right Sidebar Content Information


        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');


        $this->form_validation->set_rules('certificate_name', 'quiz', 'required');
        $this->form_validation->set_rules('certificate_description', 'quiz Description');
        $this->form_validation->set_rules('certificate_share_status', 'Cirtificate Share Status', 'required');
        $this->form_validation->set_rules('certificate_status', 'certificate Status', 'required');

        $data['all_quizes'] = $this->quiz_model->select_all_quiz_by_person_id($person_id);

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/quiz/create_certificate', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $certicate_id = $this->quiz_model->save_certificate_information();
            $sdata['message'] = 'Quiz Certificate has been added successfully';
            $this->session->set_userdata($sdata);
            $data['certificate_info'] = $this->quiz_model->select_certificate_by_id($certicate_id);
            redirect('assign-certificate/' . $data['certificate_info']->certificate_public_id);
        }
    }

    public function assign_certificate($certicate_public_id) {

// Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['certificate_info'] = $this->quiz_model->select_certificate_by_public_id($certicate_public_id);
        $data['quizes'] = $this->quiz_model->select_all_quiz_by_person_id($person_id);

        $data['quiz_certificate'] = $this->quiz_model->select_all_quiz_by_certificate($data['certificate_info']->certificate_id);

        if (!$_POST) {
            $data['main_content'] = $this->load->view('user/quiz/assign_certificate', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $certificate_id = $data['certificate_info']->certificate_id;
            $this->quiz_model->update_quiz_certificate($certificate_id);
            redirect('quizes/certificate');
        }
    }

    public function skip_assign_certificate() {
        redirect('quizes/certificate');
    }

    public function view_certificate() {
        $data = array();
// Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['all_certificate'] = $this->quiz_model->select_all_certificate();

        $data['main_content'] = $this->load->view('user/quiz/view_certificate', $data, true);
        $this->load->view('user/master', $data);
    }

    public function edit_certificate($certificate_public_id) {
        $data = array();
// Right Sidebar Content Information


        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $this->form_validation->set_rules('certificate_name', 'quiz', 'required');
        $this->form_validation->set_rules('certificate_description', 'quiz Description');
        $this->form_validation->set_rules('certificate_share_status', 'Cirtificate Share Status', 'required');
        $this->form_validation->set_rules('certificate_status', 'certificate Status', 'required');

        $data['certificate_info'] = $this->quiz_model->select_certificate_by_public_id($certificate_public_id);

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/quiz/edit_certificate', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->quiz_model->update_certificate_information($data['certificate_info']->certificate_id);
            $sdata['message'] = 'Quiz Certificate has been added successfully';
            $this->session->set_userdata($sdata);
            $quiz_id = $this->input->post('quiz_id', TRUE);
            $data['certificate_info'] = $this->quiz_model->select_certificate_by_public_id($certificate_public_id);

            redirect('quizes/certificate');
        }
    }

    public function activate_certificate($certificate_public_id) {
        $data = array();

        $data['certificate_info'] = $this->quiz_model->select_certificate_by_public_id($certificate_public_id);
        $this->quiz_model->active_selected_certificate($data['certificate_info']->certificate_id);
        $data['certificate_info'] = $this->quiz_model->select_certificate_by_public_id($certificate_public_id);
        echo $this->load->view('user/quiz/view_certificate_actions', $data, TRUE);
    }

    public function inactivate_certificate($certificate_public_id) {
        $data = array();
        $data['certificate_info'] = $this->quiz_model->select_certificate_by_public_id($certificate_public_id);
        $this->quiz_model->inactive_selected_certificate($data['certificate_info']->certificate_id);
        $data['certificate_info'] = $this->quiz_model->select_certificate_by_public_id($certificate_public_id);
        echo $this->load->view('user/quiz/view_certificate_actions', $data, TRUE);
    }

    public function archive_certificate($certificate_public_id) {
        $data = array();
        $data['certificate_info'] = $this->quiz_model->select_certificate_by_public_id($certificate_public_id);
        $this->quiz_model->archive_selected_certificate($data['certificate_info']->certificate_id);
        $data['certificate_info'] = $this->quiz_model->select_certificate_by_public_id($certificate_public_id);
        echo $this->load->view('user/quiz/view_certificate_actions', $data, TRUE);
    }

    public function certificate_view($certificate_public_id) {
        $data = array();
        $data['certificate_info'] = $this->quiz_model->select_certificate_by_public_id($certificate_public_id);
        $data['creator_info'] = $this->profile_model->person_info_by_person_id($data['certificate_info']->certificate_created_by);
        $this->load->view('user/quiz/certificate_view', $data);
    }

    public function certificate_holders($certificate_public_id) {
        $data = array();
// Right Sidebar Content Information

        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');

        $data['main_content'] = $this->load->view('user/quiz/view_certificate_holders', $data, true);
        $this->load->view('user/master', $data);
    }

    public function view_question($quiz_url) {
        $data = array();
        $data['person_id'] = $this->session->userdata('person_id');
        $data['quiz_url'] = $quiz_url;
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);
        $data['quiz_creator'] = $data['quiz_info']->quiz_created_by;
        $quiz_id = $data['quiz_info']->quiz_id;
        $page_number = 1;
        
        $data['total_mcq'] = count($this->quiz_model->select_multiple_choice_question($quiz_id));
        $data['mcq'] = $this->quiz_model->select_limited_multiple_choice_question($quiz_id, 0);

        foreach ($data['mcq'] as $v_question) {
            $data['mcq_currect_answer'][$v_question->question_id] = $this->quiz_model->select_mcq_currect_ans($v_question->question_id);
        }
        $data['total_true_false_question'] = count($this->quiz_model->select_true_false_question($quiz_id));
        $data['true_false_question'] = $this->quiz_model->select_limited_true_false_question($quiz_id, 0);
        foreach ($data['true_false_question'] as $v_question) {
            $data['true_false_currect_answer'][$v_question->question_id] = $this->quiz_model->select_true_false_currect_ans($v_question->question_id);
        }

        $data['descriptive_question'] = $this->quiz_model->select_descriptive_question_question($quiz_id);
        foreach ($data['descriptive_question'] as $v_question) {
            $data['descriptive_question_currect_answer'][$v_question->question_id] = $this->quiz_model->select_descriptive_question_currect_ans($v_question->question_id);
        }

        $data['fill_blank_question'] = $this->quiz_model->select_fill_blank_question_question($quiz_id);
        foreach ($data['fill_blank_question'] as $v_question) {
            $data['fill_blank_question_currect_answer'][$v_question->question_id] = $this->quiz_model->select_fill_blank_question_currect_ans($v_question->question_id);
        }
        
        // For Multiple choice question pagination
        $params = array('url' => '', 'div_id' => 'multiple_choice_pagination_link', 'total_row' => $data['total_mcq'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['multiple_choice_pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        
        // For true false question pagination
        $params = array('url' => '', 'div_id' => 'true_false_pagination_link', 'total_row' => $data['total_true_false_question'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['true_false_pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        
        $data['main_content'] = $this->load->view('user/quiz/view_question', $data, true);
        $this->load->view('user/master', $data);
    }
    
    public function multiple_choice_ajax_view(){
        if ($this->input->is_ajax_request()) {
        $data = array();
        $page_number = $this->input->post('current_page', TRUE);
        $quiz_url = $this->input->post('quiz_url', TRUE);
        $limit_offset = ($page_number*10)-10;
        $data['person_id'] = $this->session->userdata('person_id');
        $data['quiz_url'] = $quiz_url;
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);
        $data['quiz_creator'] = $data['quiz_info']->quiz_created_by;
        $quiz_id = $data['quiz_info']->quiz_id;        
        $data['total_mcq'] = count($this->quiz_model->select_multiple_choice_question($quiz_id));
        $data['mcq'] = $this->quiz_model->select_limited_multiple_choice_question($quiz_id, $limit_offset);
        foreach ($data['mcq'] as $v_question) {
            $data['mcq_currect_answer'][$v_question->question_id] = $this->quiz_model->select_mcq_currect_ans($v_question->question_id);
        }
        $params = array('url' => '', 'div_id' => 'multiple_choice_pagination_link', 'total_row' => $data['total_mcq'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['multiple_choice_pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        echo $this->load->view('user/quiz/multiple_question_ajax_view', $data, true);
        }
    }
    
    public function true_false_ajax_view(){
        if($this->input->is_ajax_request()){
        $data = array();
        $page_number = $this->input->post('current_page', TRUE);
        $quiz_url = $this->input->post('quiz_url', TRUE);
        $limit_offset = ($page_number*10)-10;
        $data['person_id'] = $this->session->userdata('person_id');
        $data['quiz_url'] = $quiz_url;
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $data['quiz_info'] = $this->quiz_model->select_quiz_by_url($quiz_url);
        $data['quiz_creator'] = $data['quiz_info']->quiz_created_by;
        $quiz_id = $data['quiz_info']->quiz_id; 
        $data['total_true_false_question'] = count($this->quiz_model->select_true_false_question($quiz_id));
        $data['true_false_question'] = $this->quiz_model->select_limited_true_false_question($quiz_id, $limit_offset);
        foreach ($data['true_false_question'] as $v_question) {
            $data['true_false_currect_answer'][$v_question->question_id] = $this->quiz_model->select_true_false_currect_ans($v_question->question_id);
        }
        $params = array('url' => '', 'div_id' => 'true_false_pagination_link', 'total_row' => $data['total_true_false_question'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['true_false_pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        echo $this->load->view('user/quiz/true_false_ajax_view', $data, true);
        }
    }
    //new quiz controller updated by Afrin jahan noumin
    //function: type wise quiz
    

    public function type_wise_quiz($url) {
        $data = array();
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['main_content'] = $this->load->view('user/quiz/type_wise_quiz', $data, TRUE);
        $this->load->view('user/master', $data);
    }

    public function add_quiz() {

        $data['active'] = 'add_quiz';
        $data['all_course'] = $this->quiz_model->select_all_course();
        $data['all_topic'] = $this->quiz_model->select_all_topic();
        $data['all_group'] = $this->quiz_model->select_all_group();
        $data['main_content'] = $this->load->view('admin/add_quiz_form', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function save_quiz() {

        $this->load->library('form_validation');
        $this->form_validation->set_rules('quiz_name', 'quiz name', 'required|trim|max_length[50]');
        $this->form_validation->set_rules('group_id', 'Group id ', 'required|min_length[1]');
        $this->form_validation->set_rules('quiz_category_name', 'course ', 'required|min_length[1]');
        $this->form_validation->set_rules('quiz_topics_specification', 'quiz topics', 'required|min_length[1]');
        $this->form_validation->set_rules('total_time', 'total time');
        $this->form_validation->set_rules('quiz_description', 'quiz quiz_description');
        $this->form_validation->set_rules('total_number_of_question', 'number of question', 'required');

        $this->form_validation->set_rules('quiz_url', 'quiz url', 'required');
        $this->form_validation->set_rules('quiz_permission', 'quiz permission', 'required|min_length[1]');
        $this->form_validation->set_rules('quiz_status', 'status', 'required');
        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'add_quiz';
            $data['all_course'] = $this->quiz_model->select_all_course();
            $data['all_group'] = $this->quiz_model->select_all_group();
            $data['all_topic'] = $this->quiz_model->select_all_topic();
            $data['main_content'] = $this->load->view('admin/add_quiz_form', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {

            $this->quiz_model->save_quiz_info();
            $sdata['message'] = 'Quiz has been added successfully';
            $this->session->set_userdata($sdata);
            redirect('quiz/add_quiz');
        }
    }

    public function save_question() {

        $this->load->library('form_validation');
        $this->form_validation->set_rules('question', 'Question', 'required|trim|max_length[50]');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('topic_id', 'Topic ', 'required|min_length[1]');
        $this->form_validation->set_rules('points_per_answer', 'Markes', 'required');
        $this->form_validation->set_rules('time_limit', 'time limit', 'required');
        $this->form_validation->set_rules('option', 'option', 'required');

        if ($this->form_validation->run() == FALSE) {
            $data['active'] = 'add_question';
            $data['all_topic'] = $this->quiz_model->select_all_topic();
            $data['all_quiz'] = $this->quiz_model->select_all_quiz();
            $data['main_content'] = $this->load->view('admin/add_question_form', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->quiz_model->save_question_info();
            $sdata['message'] = 'question has been added successfully';
            $this->session->set_userdata($sdata);
            redirect('quiz/add_question');
        }
    }

    public function update_question() {

        $this->load->library('form_validation');
        $this->load->library('form_validation');
        $this->form_validation->set_rules('question', 'Question', 'required|trim|max_length[50]');
        $this->form_validation->set_rules('quiz_id', 'Quiz ', 'required|min_length[1]');
        $this->form_validation->set_rules('topic_id', 'Topic ', 'required|min_length[1]');
        $this->form_validation->set_rules('points_per_answer', 'Markes', 'required');
        $this->form_validation->set_rules('time_limit', 'time limit', 'required');
        $this->form_validation->set_rules('option', 'option', 'required');
        $this->form_validation->set_rules('question_type', 'question type', 'required');

        $question_id = $this->input->post('question_id', true);

        if ($this->form_validation->run() == FALSE) {
            $this->load->library('form_validation');

            $data['active'] = 'manage_question';
            $data['all_topic'] = $this->quiz_model->select_all_topic();
            $data['all_quiz'] = $this->quiz_model->select_all_quiz();
            $data['question_info'] = $this->quiz_model->select_question_info_by_id($question_id);
            $data['option_info'] = $this->quiz_model->select_option_info_by_id($question_id);
            $data['main_content'] = $this->load->view('admin/edit_question', $data, true);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->quiz_model->update_question_info($question_id);
            redirect('quiz/manage_question');
        }
    }

    public function edit_question($question_id) {

        $this->load->library('form_validation');

        $data['active'] = 'manage_question';
        $data['all_topic'] = $this->quiz_model->select_all_topic();
        $data['all_quiz'] = $this->quiz_model->select_all_quiz();
        $data['question_info'] = $this->quiz_model->select_question_info_by_id($question_id);
        $data['option_info'] = $this->quiz_model->select_option_info_by_id($question_id);
        $data['main_content'] = $this->load->view('admin/edit_question', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function group_information($group_id, $start = null) {
        $data = array();
        $data['active'] = 'manage_quiz';

        $status = $this->session->userdata('status');
        $short = $this->session->userdata('short');
        $data['start'] = ($start) ? $start : 0;
        $limit = $this->session->userdata('per_page');

        $status = (!$status) ? $status : '';
        $limit = ($limit == '') ? $limit : 10;

        $data['total_group_members'] = count($this->super_admin_group_model->select_group_member($group_id, '', '', $status, $short));
        $data['group_members'] = $this->super_admin_group_model->select_group_member($group_id, $data['start'], $limit, $status, $short);
        $data['this_page'] = count($data['group_members']);
        $data['main_content'] = $this->load->view('admin/group_con/group_member_list', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    public function manage_group($start = null) {

        $data = array();
        $data['active'] = 'manage_group';

        $status = $this->session->userdata('status');
        $short = $this->session->userdata('short');
        $data['start'] = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $limit = $this->session->userdata('per_page');

        if (!$status) {
            $status = '';
        }
        if ($limit == '') {
            $limit = 2;
        }

        $data['total_group'] = count($this->super_admin_group_model->select_group('', '', $status, $short));
        $data['groups'] = $this->super_admin_group_model->select_group($data['start'], $limit, $status, $short);
        $data['this_page'] = count($data['groups']);
        $data['main_content'] = $this->load->view('admin/group_con/group_list', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    public function manage_quiz() {
        $data = array();
        $data['active'] = 'manage_qiuz';

        $status = $this->session->userdata('status');
        $short = $this->session->userdata('short');
        $data['start'] = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $limit = $this->session->userdata('per_page');

        if (!$status) {
            $status = '';
        }
        if (!$limit) {
            $limit = 2;
        }
        $data['total_quiz'] = count($this->quiz_model->select_quiz('', '', $status, $short));
        $data['quiz'] = $this->quiz_model->select_quiz($data['start'], $limit, $status, $short);

        $data['this_page'] = count($data['quiz']);

        $data['main_content'] = $this->load->view('admin/manage_quiz', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function manage_question() {

        $data = array();
        $data['active'] = 'manage_question';

        $status = $this->session->userdata('status');
        $short = $this->session->userdata('short');
        $data['start'] = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $limit = $this->session->userdata('per_page');

        if (!$status) {
            $status = '';
        }
        if (!$limit) {
            $limit = 10;
        }
        $data['total_question'] = count($this->quiz_model->select_question('', '', $status, $short));
        $data['question'] = $this->quiz_model->select_question($data['start'], $limit, $status, $short);

        foreach ($data['question'] as $term) {
            $data['options'][$term->question_id] = $this->quiz_model->select_question_by_id($term->question_id);
        }

        $data['this_page'] = count($data['question']);

        $data['main_content'] = $this->load->view('admin/manage_question', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    public function activate_question($question_id) {
        $this->quiz_model->active_selected_question($question_id);
        $data['question_info'] = $this->quiz_model->select_question_info_by_id($question_id);
        $data['currect_answer'] = $this->quiz_model->select_currect_ans($question_id);
        echo $this->load->view('user/quiz/view_question_actions', $data, TRUE);
    }

    public function inactivate_question($question_id) {
        $this->quiz_model->inactive_selected_question($question_id);
        $data['question_info'] = $this->quiz_model->select_question_info_by_id($question_id);
        $data['currect_answer'] = $this->quiz_model->select_currect_ans($question_id);
        echo $this->load->view('user/quiz/view_question_actions', $data, TRUE);
    }

    public function archive_question($question_id) {
        $this->quiz_model->archive_selected_question($question_id);
        $data['question_info'] = $this->quiz_model->select_question_info_by_id($question_id);
        $data['currect_answer'] = $this->quiz_model->select_currect_ans($question_id);
        echo '';
    }

    public function view_quiz_result($quiz_public_id) {
// Right Sidebar Content Information
        
        $person_id = $this->session->userdata('user_id');
        $sdata = array();
        $data['active_menu'] = $sdata['active_menu'] = 'learner';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'learner_quiz';
        $data['redirect_url'] = $sdata['redirect_url'] = 'quizes/organization';
        $this->session->set_userdata($sdata);
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;

        $data['quiz_info'] = $this->quiz_model->select_quiz_by_public_id($quiz_public_id);
        $data['quiz_questions'] = $this->quiz_model->select_active_question_by_quiz_id($data['quiz_info']->quiz_id);
        $data['quiz_result'] = $this->quiz_model->select_quiz_result($person_id, $data['quiz_info']->quiz_id);
        if (!$data['quiz_info'] || !$data['quiz_questions'] || !$data['quiz_result']) {
            redirect('quizes/learner');
        }

        $data['correct_ans'] = $correct_ans = $data['quiz_result']->quiz_correct_answer;
        $data['wrong_ans'] = $wrong_ans = $data['quiz_result']->quiz_wrong_answer;
        $data['total_question'] = $total_question = $data['quiz_result']->quiz_total_question;
        $data['total_marks'] = $total_marks = $data['quiz_result']->quiz_total_marks;
        $data['receive_marks'] = $receive_marks = $data['quiz_result']->quiz_receive_marks;
        $data['taken_time'] = $taken_time = $data['quiz_result']->quiz_finish_time;
        if (!$correct_ans) {
            $correct_ans = 0;
        }
        if (!$wrong_ans) {
            $wrong_ans = 0;
        }
        if (!$receive_marks) {
            $receive_marks = 0;
        }

        $data['unanswered'] = $total_question - ($correct_ans + $wrong_ans);
        if ($total_question) {
            $data['correct_percentage'] = ($correct_ans * 100) / $total_question;
        } else {
            $data['correct_percentage'] = 0;
        }
        if ($total_marks) {
            $data['marks_percentage'] = ($receive_marks * 100) / $total_marks;
        } else {
            $data['marks_percentage'] = 0;
        }

        $data['main_content'] = $this->load->view('user/quiz/view_quiz_result', $data, true);
        $this->load->view('user/master', $data);
    }    
    
    public function change_quiz_result_status($result_id, $status) {
        $this->quiz_model->change_quiz_result_status($result_id, $status);        
    }

    public function change_quiz_result_permission($result_id, $permission) {        
        $this->quiz_model->change_quiz_result_permission($result_id, $permission);        
    }
    
}
