<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Public_quiz extends CI_Controller {

    public function __construct() {
        parent::__construct();

        $this->load->model('f_end_model', 'f_model');
        $this->load->model('quiz_model', 'q_model');
    }

    public function check_public_quiz($url) {
        $this->session->unset_userdata('quiz_id');
        $this->session->unset_userdata('running_quiz_status');

        $mdata = $this->welcome_model->generate_menu();
        $data['right_content_variation'] = 2; // quiz right content
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $person_id = $this->session->userdata('user_id');
        $data = array_merge($data, $mdata);
        $data['quiz_info'] = $this->q_model->select_quiz_all_status_by_url($url);

        if (!$data['quiz_info']) {
            redirect('all-quiz');
        }
        $data['first_question'] = $this->quiz_model->select_quiz_first_question($data['quiz_info']->quiz_id);
        $data['quiz_questions'] = $this->q_model->select_active_question_by_quiz_id($data['quiz_info']->quiz_id);

        $code = $data['quiz_info']->quiz_public_id;
        if ($data['quiz_info']->quiz_created_by != $person_id) {
            $data['quiz_info'] = $this->q_model->select_quiz_by_public_id($code);
        }
        $quiz_pulication_status = $data['quiz_info']->quiz_pulication_status;
        $data['quiz_url'] = $url;           //added by tania 
        switch ($quiz_pulication_status) {
            case 1:// Public User
                $data['quiz_url'] = $url;
                $data['creator_info'] = $this->profile_model->person_info_by_id($data['quiz_info']->quiz_created_by);
                $data['main_content'] = $this->load->view('front_end/quiz/attendee_quiz_view', $data, true);
                $this->load->view('user/master', $data);
                break;
            case 2:// All TT USer
                if ($this->session->userdata('user_id') || $this->session->userdata('person_id')) {
                    $data['creator_info'] = $this->profile_model->person_info_by_id($data['quiz_info']->quiz_created_by);
                    $data['main_content'] = $this->load->view('front_end/quiz/attendee_quiz_view', $data, true);
                    $this->load->view('user/master', $data);
                } else {
                    $sdata['quiz_start_url'] = 'quiz/' . $url;
                    $this->session->set_userdata($sdata);
                    redirect('sign-in');
                }
                break;

            case 3: // quiz creator linked User
                if ($person_id) {
                    $data['creator_info'] = $this->profile_model->person_info_by_id($data['quiz_info']->quiz_created_by);
                    if ($person_id == $data['quiz_info']->quiz_created_by) {
                        $data['main_content'] = $this->load->view('front_end/quiz/attendee_quiz_view', $data, true);
                        $this->load->view('user/master', $data);
                        break;
                    }
                    $result = $this->profile_model->select_person_to_person_link($data['quiz_info']->quiz_created_by);
                    if ($result) {
                        $data['main_content'] = $this->load->view('front_end/quiz/attendee_quiz_view', $data, true);
                        $this->load->view('user/master', $data);
                        break;
                    } else {// redirecting to quiz creator profile 
                        redirect($data['creator_info']->url . '/profile');
                    }
                } else {
                    $sdata['url'] = 'quiz/' . $code;
                    redirect('sign-in');
                }
                break;

            case 4:// quiz creator Group User
                if ($person_id) {
                    $data['creator_info'] = $this->profile_model->person_info_by_id($data['quiz_info']->quiz_created_by);
                    if ($this->session->userdata('user_id') == $data['quiz_info']->quiz_created_by) {
                        $data['main_content'] = $this->load->view('front_end/quiz/attendee_quiz_view', $data, true);
                        $this->load->view('user/master', $data);
                        return;
                    }
                    $group_permission = $this->quiz_model->select_quiz_group_permission($data['quiz_info']->quiz_public_id);
                    foreach ($group_permission as $v_group_permission) {
                        $result = $this->profile_model->select_group_member_by_person_and_group_id($person_id, $v_group_permission->group_id);
                        if ($result) {
                            $data['main_content'] = $this->load->view('front_end/quiz/attendee_quiz_view', $data, true);
                            $this->load->view('user/master', $data);
                            return;
                        }
                    }
                    redirect('groups/learner'); // redirecting to group list
                    break;
                } else {
                    $sdata['url'] = 'quiz/' . $code;
                    redirect('sign-in');
                }
                break;

            case 5:// all public course (public user)
                $course_permission = $this->quiz_model->select_quiz_course_permission($data['quiz_info']->quiz_public_id);
                $sdata['tab'] = 'quiz';
                $this->session->set_userdata($sdata);
                $course_info = $this->user_course_model->select_course_info_by_id($course_permission->course_id);
                if ($course_info) {
                    redirect($course_info->url);
                } else {
                    redirect('all-quiz');
                }
                break;
            case 6:// all public course user (public user )
                if ($person_id) {
                    $video_course_permission = $this->quiz_model->select_quiz_video_course_permission($data['quiz_info']->quiz_public_id);
                    $video_course_info = $this->user_video_model->select_video_management_by_id($video_course_permission->video_management_id);
                    if ($video_course_info) {
                        $sdata['tab'] = 'quiz';
                        $this->session->set_userdata($sdata);
                        redirect($video_course_info->url);
                    } else {
                        redirect('all-quiz');
                    }
                } else {
                    $sdata['url'] = 'quiz/' . $code;
                    redirect('sign-in');
                }
                break;
            default:
                redirect('all-quiz');
                break;
        }
    }

    public function start_create_quiz() {
        $person_id = $this->session->userdata('person_id');
        if ($person_id) {
            $person_info = $this->profile_model->select_link_person_info($person_id);
            if ($person_info->person_role == 3) {
                $sdata['active_menu'] = 'teacher';
                $this->session->set_userdata($sdata);
            } else if ($person_info->person_role == 4) {
                $sdata['active_menu'] = 'organization';
                $this->session->set_userdata($sdata);
            } else {
                $sdata['url'] = 'start-create-quiz';
                $this->session->set_userdata($sdata);
                redirect('sign-in');
            }
            redirect('create-quiz');
        } else {
            $sdata['url'] = 'start-create-quiz';
            $this->session->set_userdata($sdata);
            redirect('sign-in');
        }
    }

    //update by tania 19-08-2016
    function all_quiz() {
        $data = $this->welcome_model->generate_menu();
        $sdata['topic_grade'] = 'All Latest';
        $this->session->set_userdata($sdata);
        $data['number'] = 3;
        $data['content_variable'] = 'quiz_group_active';
        $data['left_side'] = 1;
        $data['right_content_variation'] = 2;

        $data['tt_all_quiz_left_menu'] = 1;
        //add 31-08-2016       
        $data['quiz_topic_id'] = $quiz_topic_id = $this->quiz_model->get_all_quiz_topic_id();

        if ($quiz_topic_id) {
            $data['total_quiz'] = count(explode(',', $quiz_topic_id));
        }
        $data['all_quiz_topic'] = $this->quiz_model->select_latest_quiz_topic($data['number']);
        $data['page'] = 1;
        $tab = $this->session->userdata('quiz_tab');
        if ($tab != '') {
            $data['quiz_tab'] = $tab;
        } else {
            $data['quiz_tab'] = 'popular';
        }

        $data['total_rows'] = $this->quiz_model->get_total_quiz();

        $data['all_popular_quiz'] = $this->quiz_model->select_all_popular_quiz();
        foreach ($data['all_popular_quiz'] as $value) {
            $data['quiz_url'][$value->quiz_id] = $this->quiz_model->quiz_url_by_quiz_id($value->quiz_id);
            $data['created_by'][$value->quiz_created_by] = $this->person_model->get_single_person_information_by_person_id($value->quiz_created_by);
            $data['quiz_quiestion'][$value->quiz_id] = $this->quiz_model->select_all_active_question_by_quiz_id($value->quiz_id);
        }
        $data['all_latest_quiz'] = $this->quiz_model->select_all_latest_quiz();
        foreach ($data['all_latest_quiz'] as $value) {
            $data['quiz_url'][$value->quiz_id] = $this->quiz_model->quiz_url_by_quiz_id($value->quiz_id);
            $data['created_by'][$value->quiz_created_by] = $this->person_model->get_single_person_information_by_person_id($value->quiz_created_by);
            $data['quiz_quiestion'][$value->quiz_id] = $this->quiz_model->select_all_active_question_by_quiz_id($value->quiz_id);
        }

        $data['person_id'] = $this->session->person_id;
        $data['main_content'] = $this->load->view('front_end/quiz/all_quiz_test', $data, TRUE);
        $this->load->view('user/master', $data);
    }

//tania 20-08-2016
    function select_topic_wise_quiz() {
        $data['page'] = 1;
        $topic_id = $this->input->post("topic_id", TRUE);
        $topic_id_array = array_filter(explode(',', $topic_id));
        if ($topic_id) {
            $data['total_rows'] = $this->quiz_model->topic_wise_total_quiz($topic_id_array, $topic_id);
            $data['quizes'] = $this->quiz_model->select_all_quiz_topic_wise($topic_id_array, $topic_id);
            foreach ($data['quizes'] as $value) {
                $data['quiz_url'][$value->quiz_id] = $this->quiz_model->quiz_url_by_quiz_id($value->quiz_id);
                $data['created_by'][$value->quiz_created_by] = $this->quiz_model->person_info_by_person_idfor_quiz_topic($value->quiz_created_by);
                $data['quiz_quiestion'][$value->quiz_id] = $this->quiz_model->select_all_active_question_by_quiz_id($value->quiz_id);
            }
            $gdata['latest_quiz'] = $this->quiz_model->select_latest_quiz_topic_wise($topic_id_array, $topic_id);
            foreach ($gdata['latest_quiz'] as $value) {
                $data['quiz_url'][$value->quiz_id] = $this->quiz_model->quiz_url_by_quiz_id($value->quiz_id);
                $gdata['created_by'][$value->quiz_created_by] = $this->quiz_model->person_info_by_person_idfor_quiz_topic($value->quiz_created_by);
                $gdata['quiz_quiestion'][$value->quiz_id] = $this->quiz_model->select_all_active_question_by_quiz_id($value->quiz_id);
            }
        } else if ($topic_id == NULL) {
            $data['total_rows'] = $this->quiz_model->get_total_quiz();
            $data['quizes'] = $this->quiz_model->select_all_popular_quiz();
            foreach ($data['quizes'] as $value) {
                $data['quiz_url'][$value->quiz_id] = $this->quiz_model->quiz_url_by_quiz_id($value->quiz_id);
                $data['created_by'][$value->quiz_created_by] = $this->quiz_model->person_info_by_person_idfor_quiz_topic($value->quiz_created_by);
                $data['quiz_quiestion'][$value->quiz_id] = $this->quiz_model->select_all_active_question_by_quiz_id($value->quiz_id);
            }
            $gdata['latest_quiz'] = $this->quiz_model->select_all_latest_quiz();
            foreach ($gdata['latest_quiz'] as $value) {
                $data['quiz_url'][$value->quiz_id] = $this->quiz_model->quiz_url_by_quiz_id($value->quiz_id);
                $gdata['created_by'][$value->quiz_created_by] = $this->quiz_model->person_info_by_person_idfor_quiz_topic($value->quiz_created_by);
                $gdata['quiz_quiestion'][$value->quiz_id] = $this->quiz_model->select_all_active_question_by_quiz_id($value->quiz_id);
            }
        }
        echo $this->load->view('front_end/quiz/quiz_ajax_page/topic_wise_quiz_view', $data, TRUE) . "#########";
        echo $this->load->view('front_end/quiz/quiz_ajax_page/topic_wise_latest_quiz_view', $gdata, TRUE);
    }

//tania 23-08-2016   
    function view_latest_for_ajax_view($page, $limit) {
        $data['total_rows'] = $this->quiz_model->get_total_quiz();
        $data['page'] = $page;
        $data['all_latest_quiz'] = $this->quiz_model->select_all_latest_quiz_pagination($limit);
        foreach ($data['all_latest_quiz'] as $value) {
            $data['quiz_url'][$value->quiz_id] = $this->quiz_model->quiz_url_by_quiz_id($value->quiz_id);
            $data['created_by'][$value->quiz_created_by] = $this->person_model->get_single_person_information_by_person_id($value->quiz_created_by);
            $data['quiz_quiestion'][$value->quiz_id] = $this->quiz_model->select_all_active_question_by_quiz_id($value->quiz_id);
        }
        echo $this->load->view('front_end/quiz/quiz_ajax_page/view_latest_quiz', $data, TRUE);
    }

//tania 23-08-2016    
    function view_popular_quiz_for_ajax_view($page, $limit) {
        $data['total_rows'] = $this->quiz_model->get_total_quiz();
        $data['page'] = $page;
        $data['all_popular_quiz'] = $this->quiz_model->select_all_popular_quiz_pagination($limit);
        foreach ($data['all_popular_quiz'] as $value) {
            $data['quiz_url'][$value->quiz_id] = $this->quiz_model->quiz_url_by_quiz_id($value->quiz_id);
            $data['created_by'][$value->quiz_created_by] = $this->person_model->get_single_person_information_by_person_id($value->quiz_created_by);
            $data['quiz_quiestion'][$value->quiz_id] = $this->quiz_model->select_all_active_question_by_quiz_id($value->quiz_id);
        }
        echo $this->load->view('front_end/quiz/quiz_ajax_page/view_popular_quiz', $data, TRUE);
    }

//tania 23-08-2016   
    function quiz_pagination() {
        $quiz_type = $this->input->post('quiz_type', TRUE);
        $topic_id = $this->input->post('topic_id', TRUE);
        $topic_id_array = explode(',', $topic_id);
        $page = $this->input->post('page_number', TRUE);
        $limit = $page * 10 - 10;
        if ($topic_id) {
            if ($quiz_type == 'popular') {
                $this->topic_wise_view_popular_quiz_for_ajax_view($page, $limit, $topic_id_array, $topic_id);
            } else if ($quiz_type == 'latest') {
                $this->topic_wise_view_latest_quiz_for_ajax_view($page, $limit, $topic_id_array, $topic_id);
            }
        } else {
            if ($quiz_type == 'popular') {
                $this->view_popular_quiz_for_ajax_view($page, $limit);
            } else if ($quiz_type == 'latest') {
                $this->view_latest_for_ajax_view($page, $limit);
            }
        }
    }

//29-08-2016    
    function topic_wise_view_popular_quiz_for_ajax_view($page, $limit, $topic_id_array, $topic_id) {
        $data['total_rows'] = $this->quiz_model->topic_wise_total_quiz($topic_id_array, $topic_id);
        $data['page'] = $page;
        $data['quizes'] = $this->quiz_model->select_all_quiz_topic_wise_pagination($topic_id_array, $topic_id, $limit);
        foreach ($data['quizes'] as $value) {
            $data['quiz_url'][$value->quiz_id] = $this->quiz_model->quiz_url_by_quiz_id($value->quiz_id);
            $data['created_by'][$value->quiz_created_by] = $this->quiz_model->person_info_by_person_idfor_quiz_topic($value->quiz_created_by);
            $data['quiz_quiestion'][$value->quiz_id] = $this->quiz_model->select_all_active_question_by_quiz_id($value->quiz_id);
        }
        echo $this->load->view('front_end/quiz/quiz_ajax_page/view_popular_quiz_topic_wise', $data, TRUE);
    }

//29-08-2016    
    function topic_wise_view_latest_quiz_for_ajax_view($page, $limit, $topic_id_array, $topic_id) {
        $gdata['total_rows'] = $this->quiz_model->topic_wise_total_quiz($topic_id_array, $topic_id);
        $gdata['page'] = $page;
        $gdata['latest_quiz'] = $this->quiz_model->select_latest_quiz_topic_wise_pagination($topic_id_array, $topic_id, $limit);
        foreach ($gdata['latest_quiz'] as $value) {
            $gdata['quiz_url'][$value->quiz_id] = $this->quiz_model->quiz_url_by_quiz_id($value->quiz_id);
            $gdata['created_by'][$value->quiz_created_by] = $this->quiz_model->person_info_by_person_idfor_quiz_topic($value->quiz_created_by);
            $gdata['quiz_quiestion'][$value->quiz_id] = $this->quiz_model->select_all_active_question_by_quiz_id($value->quiz_id);
        }
        echo $this->load->view('front_end/quiz/quiz_ajax_page/view_latest_quiz_topic_wise', $gdata, TRUE);
    }

// tania update 20-08-2016
    function select_more_quiz() {
        $data = array();
        $data['number'] = $this->input->post("number", TRUE);
        $data['latest_quiz_topic'] = $this->quiz_model->select_latest_quiz_topic($data['number']);
        echo ($data['number'] + 3) . '######';
        echo json_encode($data['latest_quiz_topic']);
    }

    public function select_latest_quiz() {
        $data = array();
        $data['number'] = $this->input->post("number", TRUE);
        $data['latest_quiz_topic'] = $this->quiz_model->select_latest_quiz_topic($data['number']);

        echo $this->load->view('front_end/quiz/quiz_ajax_page/latest_quiz_ajax_page', $data, TRUE);
    }

    public function latest_quiz() {
        $this->all_quiz();
    }

    public function popular_quiz() {
        $data = $this->welcome_model->generate_menu();
        $data['meta_description'] = '';
        $data['meta_keywords'] = '';
        $data['author'] = '';
        $sdata['topic_grade'] = 'All Popular';
        $this->session->set_userdata($sdata);
//Latest Quiz topics
        $data['latest_quiz_topic'] = $this->quiz_model->select_latest_quiz_topic();

//popular quiz topics
        $data['popular_quiz_topic'] = $this->quiz_model->select_popular_quiz_topic();

//All Quiz
        $start = 0;
        $limit = NULL;
        $status = NULL;
        $short = NULL;
        $data['quizes'] = $this->quiz_model->select_active_popular_quiz($start, $limit, $status, $short = NULL);
        foreach ($data['quizes'] as $value) {
            $data['created_by'][$value->quiz_id] = $this->profile_model->person_info_by_id($value->quiz_created_by);
            $data['quiz_quiestion'][$value->quiz_id] = $this->quiz_model->select_all_active_question_by_quiz_id($value->quiz_id);
        }
        $data['person_id'] = $this->session->userdata('user_id');
        $data['main_content'] = $this->load->view('front_end/quiz/all_quiz_test', $data, TRUE);
        $this->load->view('front_end/master', $data);
    }

    public function topic_specific_latest_quiz($topic_url) {
        $sdata['topic_grade'] = 'Latest';
        $this->session->set_userdata($sdata);
        redirect($topic_url . '/quiz/topic');
    }

    public function topic_specific_popular_quiz($topic_url) {
        $sdata['topic_grade'] = 'Popular';
        $this->session->set_userdata($sdata);
        redirect($topic_url . '/quiz/topic');
    }

    public function topic_specific_quiz($topic_url) {

        $data = $this->welcome_model->generate_menu();
        $data['meta_description'] = '';
        $data['meta_keywords'] = '';
        $data['author'] = '';

//Latest Quiz topics
        $data['latest_quiz_topic'] = $this->quiz_model->select_latest_quiz_topic();

//popular quiz topics
        $data['popular_quiz_topic'] = $this->quiz_model->select_popular_quiz_topic();

//All Quiz
        $start = 0;
        $limit = NULL;
        $status = NULL;
        $short = NULL;
        $topic_grade = $this->session->userdata('topic_grade');
        if ($topic_grade == 'Latest') {
            $data['quizes'] = $this->quiz_model->select_topic_specific_latest_quiz($topic_url, $start, $limit, $status, $short = NULL);
            foreach ($data['quizes'] as $value) {
                $data['created_by'][$value->quiz_id] = $this->profile_model->person_info_by_id($value->quiz_created_by);
                $data['quiz_quiestion'][$value->quiz_id] = $this->quiz_model->select_all_active_question_by_quiz_id($value->quiz_id);
            }
        } else {
            $data['quizes'] = $this->quiz_model->select_topic_specific_popular_quiz($topic_url, $start, $limit, $status, $short = NULL);
            foreach ($data['quizes'] as $value) {
                $data['created_by'][$value->quiz_id] = $this->profile_model->person_info_by_id($value->quiz_created_by);
                $data['quiz_quiestion'][$value->quiz_id] = $this->quiz_model->select_all_active_question_by_quiz_id($value->quiz_id);
            }
        }


        $data['person_id'] = $this->session->userdata('user_id');
        $data['main_content'] = $this->load->view('front_end/quiz/all_quiz_test', $data, TRUE);
        $this->load->view('front_end/master', $data);
    }

    public function start_quiz($quiz_public_id) {
        $person_id = $this->session->userdata('user_id');
        $data = $this->welcome_model->generate_menu();
        $data['right_content_variation'] = 0; // when no right content show
        $running_quiz_status = $this->session->userdata('running_quiz_status');
        if (!$running_quiz_status) {
            $this->session->unset_userdata('correct_ans');
            $this->session->unset_userdata('wrong_ans');
            $this->session->unset_userdata('total_question');
            $this->session->unset_userdata('total_marks');
            $this->session->unset_userdata('receive_marks');
            $this->session->unset_userdata('quiz_id');
            $this->session->unset_userdata('taken_time');
            unset($_SESSION['pageload']);
        }
        $data['quiz_info'] = $result = $this->q_model->select_quiz_by_public_id($quiz_public_id);
        if (!$data['quiz_info']) {
            redirect();
        }

        $quiz_id = $result->quiz_id;

        $data['question'] = $this->f_model->select_all_active_question_info($quiz_id);
        foreach ($data['question'] as $term) {
            $data['options'][$term->question_id] = $this->f_model->select_question_by_id($term->question_id);
            $data['correct_answer'][$term->question_id] = $this->quiz_model->select_correct_option($term->question_id);
        }
        $data['total_question'] = count($this->f_model->select_all_active_question_info($quiz_id));
        $data['total_marks'] = $this->f_model->select_all_marks_active_question_info($quiz_id);

        $sdata = array();
        if ($data['quiz_info']->quiz_random_static == 1) {
            $sdata['total_question'] = $data['quiz_info']->total_number_of_question;
        } else {
            $sdata['total_question'] = $data['total_question'];
        }
        $sdata['total_marks'] = $data['total_marks']->total;
        $sdata['quiz_id'] = $quiz_id;
        $sdata['quiz_public_id'] = $quiz_public_id;
        $sdata['running_quiz_status'] = TRUE;
        $this->session->set_userdata($sdata);

        if ($result->quiz_pulication_status == 1) {// quiz permission for Public and TT USER
            $permission = true;
            $data['creator_info'] = $this->person_model->get_single_person_information_by_person_id($result->quiz_created_by);
            $data['main_content'] = $this->load->view('front_end/quiz/quiz_test', $data, true);
            $this->load->view('user/master', $data);
        } else if ($result->quiz_pulication_status == 2) {// quiz permission for Public and TT USER
            if (!$person_id) {
                redirect('sign-in');
            }
            $data['creator_info'] = $this->person_model->get_single_person_information_by_person_id($result->quiz_created_by);
            $data['main_content'] = $this->load->view('front_end/quiz/quiz_test', $data, true);
            $this->load->view('user/master', $data);
        } else if ($result->quiz_pulication_status == 3) {// quiz permission for Link 
            $data['creator_info'] = $this->person_model->get_single_person_information_by_person_id($data['quiz_info']->quiz_created_by);
            if ($person_id == $data['quiz_info']->quiz_created_by) {
                $data['main_content'] = $this->load->view('front_end/quiz/quiz_test', $data, true);
                $this->load->view('user/master', $data);
                return;
            }
            $result = $this->profile_model->select_person_to_person_link($data['quiz_info']->quiz_created_by);
            if ($result) {
                $data['main_content'] = $this->load->view('front_end/quiz/quiz_test', $data, true);
                $this->load->view('user/master', $data);
            } else {// redirecting to quiz creator profile 
                redirect($data['creator_info']->url . '/profile');
            }
        } else if ($result->quiz_pulication_status == 4) {// quiz permission for Group      
            if (!$person_id) {
                redirect('sign-in');
            }

            $data['creator_info'] = $this->person_model->get_single_person_information_by_person_id($data['quiz_info']->quiz_created_by);
            if ($person_id == $data['quiz_info']->quiz_created_by) {
                $data['main_content'] = $this->load->view('front_end/quiz/quiz_test', $data, true);
                $this->load->view('user/master', $data);
                return;
            }
            $group_permission = $this->quiz_model->select_quiz_group_permission($data['quiz_info']->quiz_public_id);
            foreach ($group_permission as $v_group_permission) {
                $result = $this->profile_model->select_group_member_by_person_and_group_id($person_id, $v_group_permission->group_id);
                if ($result) {
                    $data['main_content'] = $this->load->view('front_end/quiz/quiz_test', $data, true);
                    $this->load->view('user/master', $data);
                    return;
                }
                $permission = FALSE;
            }

            if ($permission == FALSE) {
                redirect('all-group');
            }
        } else if ($result && $result->quiz_permission != 1) {
            redirect();
        }
    }

    public function continue_quiz() {

        $quiz_id = $this->session->userdata('quiz_id');

        $data['active'] = 'manage_question';

        $data['question'] = $this->f_model->select_all_active_question_info($quiz_id);
        foreach ($data['question'] as $term) {
            $data['options'][$term->question_id] = $this->f_model->select_question_by_id($term->question_id);
        }
        $data['total_question'] = count($this->f_model->select_all_active_question_info($quiz_id));
        $data['total_marks'] = $this->f_model->select_all_marks_active_question_info($quiz_id);

        $sdata = array();

        $sdata['total_question'] = $data['total_question'];
        $sdata['total_marks'] = $data['total_marks']->total;
        $this->session->set_userdata($sdata);

        $data['quiz_info'] = $this->q_model->select_quiz_by_id($quiz_id);
        $data['creator_info'] = $this->profile_model->person_info_by_person_id($result->quiz_created_by);

        $data['main_content'] = $this->load->view('front_end/quiz/quiz_test', $data, true);
        $this->load->view('user/master', $data);
    }

    public function quiz_marking($quiz_public_id) {
        $selected_ans = Array();
        $mark_per_question = $this->input->post('points_per_answer', TRUE);
        $question_type = $this->input->post('question_type', TRUE);
        $question_id = $this->input->post('question_id', TRUE);
        $taken_time = $this->input->post('taken_time', TRUE);
        $question_info = $this->f_model->select_question_info_by_id($question_id);
        /* --------- 1. start quiz details result ------------ */
        if ($this->session->userdata('sess_ques_id')) {
            $question_id_arr = $this->session->userdata('sess_ques_id');
            $question_id_arr[] = $question_info->question_id;
        } else {
            $question_id_arr[] = $question_info->question_id;
        }
        $this->session->set_userdata('sess_ques_id', $question_id_arr);
        /* ---------1. end quiz details result ------------ */


        if ($_POST['submit_btn'] == 'Skip Question') {
            /* --------- 2. start quiz details result ------------ */
            if ($this->session->userdata('sess_selected_ans')) {
                $selected_ans = $this->session->userdata('sess_selected_ans');
                $selected_ans[] = '';
            } else {
                $selected_ans[] = '';
            }
            $this->session->set_userdata('sess_selected_ans', $selected_ans);
            /* --------- 2.end quiz details result ------------ */
            $qdata['taken_time'] = $this->session->userdata('taken_time') + ($taken_time);
            $this->session->set_userdata($qdata);
            redirect('quiz/' . $quiz_public_id . '/start-quiz');
        }
        if ($question_type == 4) {
            $result = $this->f_model->select_fil_answer_words($question_id);
            $answer_word = explode(",", $result->descriptive_ans_keyword);
            $total_answer_word = count(array_pop($answer_word));
            $answer = $this->input->post('fill_answer', TRUE);
            $student_answer = (explode(" ", $answer));
            $words = array(".", "?", ":", ",", ";", "'", "(", ")", "=", "+", "  ");
            $student_answer = str_replace($words, "", $student_answer);
            $unique_ans = array_unique($student_answer);
            $temp_ans_count = 0;
            if ($unique_ans) {
                foreach ($unique_ans as $v_answer) {
                    $result = $this->f_model->match_fil_answer_word($v_answer);
                    if ($result) {
                        $temp_ans_count++;
                    }
                }
            }
            $percentage = ($temp_ans_count * 100) / $total_answer_word;

            if ($percentage >= 5) {
                $qdata['correct_ans'] = $this->session->userdata('correct_ans') + 1;
                $qdata['receive_marks'] = $this->session->userdata('receive_marks') + $mark_per_question;
                $qdata['taken_time'] = $this->session->userdata('taken_time') + $taken_time;
                $this->session->set_userdata($qdata);
                redirect('quiz/' . $quiz_public_id . '/start-quiz');
            } else {
                $qdata['wrong_ans'] = $this->session->userdata('wrong_ans') + 1;
                $qdata['taken_time'] = $this->session->userdata('taken_time') + $taken_time;
                $this->session->set_userdata($qdata);
                redirect('quiz/' . $quiz_public_id . '/start-quiz');
            }
        } else {
            if (isset($_POST['status'])) {
                /* --------- 3. start quiz details result ------------ */
                if ($this->session->userdata('sess_selected_ans')) {
                    $selected_ans = $this->session->userdata('sess_selected_ans');
                    $selected_ans[] = $this->get_option_status($this->input->post('status', true));
                } else {
                    $selected_ans[] = $this->get_option_status($this->input->post('status', true));
                }
                $this->session->set_userdata('sess_selected_ans', $selected_ans);
                /* --------- 3. end quiz details result ------------ */

                foreach ($_POST['status'] as $key => $v_status) {
                    $option_id = $key;
                    $value = $v_status;
                }
                if ($value == '') {
                    $qdata['taken_time'] = $this->session->userdata('taken_time') + ($taken_time);
                    $this->session->set_userdata($qdata);
                    redirect('quiz/' . $quiz_public_id . '/start-quiz');
                }

                $result = $this->f_model->confirm_answer($value);

                $sdata = array();
                if ($result) {
                    $qdata['correct_ans'] = $this->session->userdata('correct_ans') + 1;
                    $qdata['receive_marks'] = $this->session->userdata('receive_marks') + $mark_per_question;
                    $qdata['taken_time'] = $this->session->userdata('taken_time') + $taken_time;
                    $this->session->set_userdata($qdata);
                    redirect('quiz/' . $quiz_public_id . '/start-quiz');
                } else {
                    $qdata['wrong_ans'] = $this->session->userdata('wrong_ans') + 1;
                    $this->session->set_userdata($qdata);
                    redirect('quiz/' . $quiz_public_id . '/start-quiz');
                }
            } else {
                /* --------- 4. start quiz details result ------------ */
                if ($this->session->userdata('sess_selected_ans')) {
                    $selected_ans = $this->session->userdata('sess_selected_ans');
                    $selected_ans[] = '';
                } else {
                    $selected_ans[] = '';
                }
                $this->session->set_userdata('sess_selected_ans', $selected_ans);
                /* --------- 4. end quiz details result ------------ */
                $qdata['taken_time'] = $this->session->userdata('taken_time') + ($taken_time);
                $this->session->set_userdata($qdata);
                redirect('quiz/' . $quiz_public_id . '/start-quiz');
            }
        }
    }

    function get_option_status($status) {
        $status1 = '';
        for ($i = 0; $i < count($status); $i++) {
            if ($status[$i] != '') {
                $status1 = $status[$i];
                break;
            }
        }
        return $status1;
    }

//tania 03-09-2016
    function view_details_quiz_result($quiz_public_id) {
        if ($this->session->userdata('sess_ques_id') == '') {
            redirect('quiz/' . $quiz_public_id . '/quiz-result');
        }
        $data = $this->welcome_model->generate_menu();
        $data['right_content_variation'] = 0; // when no right content show

        $data['sess_ques_id'] = $this->session->userdata('sess_ques_id');
        $data['sess_selected_ans'] = $this->session->userdata('sess_selected_ans');

        $data['main_content'] = $this->load->view('front_end/quiz/quiz_result_details', $data, true);
        $this->load->view('user/master', $data);
        $this->session->unset_userdata('sess_ques_id');
        $this->session->unset_userdata('sess_selected_ans');
    }

    public function save_quiz_result($quiz_url) {
        $person_id = $this->session->userdata('person_id');
        $data['quiz_info'] = $this->q_model->select_quiz_all_status_by_url($quiz_url);
        if (!$data['quiz_info']) {
            redirect();
        }
        $data['quiz_questions'] = $this->q_model->select_active_question_by_quiz_id($data['quiz_info']->quiz_id);

        $quiz_taken_number = $data['quiz_info']->quiz_taken_number + 1;
        $this->db->set('quiz_taken_number', $quiz_taken_number);
        $this->db->where('quiz_id', $data['quiz_info']->quiz_id);
        $this->db->update('tbl_quiz');

        if ($person_id) {
            $data['person_quiz_result'] = $this->q_model->select_quiz_result($person_id, $data['quiz_info']->quiz_id);

            if (!$data['person_quiz_result']) {
                $insert_id = $this->q_model->save_quiz_result_info($data);
                $sdata['quiz_result_id'] = $insert_id;

                $this->session->set_userdata($sdata);
            } else {
                $this->q_model->update_quiz_result_info($data);
                $sdata['quiz_result_id'] = $data['person_quiz_result']->quiz_result_id;
                $this->session->set_userdata($sdata);
            }
            redirect('quiz/' . $data['quiz_info']->quiz_public_id . '/quiz-result');
        } else {
            redirect('quiz/' . $data['quiz_info']->quiz_public_id . '/quiz-result');
        }
    }

    public function unset_quiz_result_session() {
        $this->session->unset_userdata('correct_ans');
        $this->session->unset_userdata('wrong_ans');
        $this->session->unset_userdata('total_question');
        $this->session->unset_userdata('total_marks');
        $this->session->unset_userdata('receive_marks');
        $this->session->unset_userdata('quiz_id');
        $this->session->unset_userdata('taken_time');
        unset($_SESSION['pageload']);
    }

    public function quiz_public_result($quiz_public_id) {
        $data = $this->welcome_model->generate_menu();
        $this->session->unset_userdata('running_quiz_status');
        $person_id = $this->session->userdata('user_id');
        $data['right_content_variation'] = 0;

        $data['quiz_info'] = $this->q_model->select_quiz_by_public_id($quiz_public_id);
        $data['quiz_questions'] = $this->q_model->select_active_question_by_quiz_id($data['quiz_info']->quiz_id);
        $data['correct_ans'] = $correct_ans = $this->session->userdata('correct_ans');
        $data['wrong_ans'] = $wrong_ans = $this->session->userdata('wrong_ans');
        $data['total_question'] = $total_question = $this->session->userdata('total_question');
        $data['total_marks'] = $total_marks = $this->session->userdata('total_marks');
        $data['receive_marks'] = $receive_marks = $this->session->userdata('receive_marks');
        $data['taken_time'] = $taken_time = $this->session->userdata('taken_time');

        if (!$correct_ans) {
            $correct_ans = 0;
        }
        if (!$wrong_ans) {
            $wrong_ans = 0;
        }
        if (!$receive_marks) {
            $receive_marks = 0;
        }

        $data['unanswered'] = $total_question - ($correct_ans + $wrong_ans);
        if ($total_question) {
            $data['correct_percentage'] = ($correct_ans * 100) / $total_question;
        } else {
            $data['correct_percentage'] = 0;
        }
        if ($total_marks) {
            $data['marks_percentage'] = ($receive_marks * 100) / $total_marks;
        } else {
            $data['marks_percentage'] = 0;
        }


        $data['active'] = 'start_quiz';
        $data['main_content'] = $this->load->view('front_end/quiz/quiz_result', $data, true);
        if ($person_id) {
            $this->load->view('user/master', $data);
        } else {
            $this->load->view('front_end/master', $data);
        }
    }

    public function publish_result($quiz_public_id) {
        $this->session->unset_userdata('running_quiz_status');
        $data['quiz_info'] = $this->q_model->select_quiz_by_public_id($quiz_public_id);
        if (!$data['quiz_info']) {
            redirect();
        }

        $person_id = $this->session->userdata('user_id');
        if (!$person_id) {
            $sdata['url'] = base_url() . 'public_quiz/save_quiz_result';
            $this->session->set_userdata($sdata);
            redirect('sign-in');
        } else {
            redirect('quizes/learner');
        }
    }

    public function publish_quiz_result($quiz_public_id, $result_id) {
        $this->unset_quiz_result_session();
        $this->quiz_model->publish_quiz_result($result_id);
        redirect('quizes/learner');
    }

}
