<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of author
 *
 * @Author Md Jaherul Islam
 * 
 * All view Page=>
 * 1. user/payment/invoice.php
 * 2. user/payment/modal/cash_payment.php
 * 3. user/payment/modal/cheque_payment.php
 */
class Payment extends TT_user_login {

    public function __construct() {
        parent::__construct();
        $this->load->model(['invoice_model', 'invoice_payment_model',
            'payment_process_model', 'admin_payment_model', 'bank_branch_model', 'bank_model']);
    }

    /**
     * @Description         : view right side information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 06:06 PM   
     * */
    function get_right_side_data($data, $payment_sub_menu) {
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'payment';
        $data['payment_sub_menu'] = $payment_sub_menu;
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        return $data;
    }

    /*
      -----------@@@Start@ View All Invoice----------------------------------
     */

    /**
     * @Description         : View payment Details
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-11-2016 12:06 PM   
     * */
    public function view_invoices() {
        $data = [];
        $person_id = $this->session->person_id;
        //Get all payment ID by logged IN person ID
        $payment_id = $this->payment_model->set_person_id($person_id)->get_all_id_by_person_id();
        //Get all Due Payment information
        $data['due_payment'] = $this->get_due_amount_for_course($person_id);
        // Remove session Data
        $this->utility_model->remove_session_data('invoice_start_date', 'invoice_end_date', 'invoice_payment_status', 'invoice_page_number');

        //Get invoice information by all payment ID
        $data['invoice_info'] = $this->invoice_model
                        ->set_payment_id(explode(',', $payment_id))->set_limit(0)->get_info_by_payment_id()->get_result();

        // get Invoice Data type=>1[Page_number]
       
        $invoice_data = $this->get_data_for_view_invoices($data, 1);
        // get right side data
        $right_data = $this->get_right_side_data($invoice_data, 'invoice');
        
        $right_data['main_content'] = $this->load->view('user/payment/all_invoice', $right_data, TRUE);
        $this->load->view('user/master', $right_data);
    }
    
    /**
     * @Description         : get_due_amount_for_course
     * @Developed By        : MD Delwar Hossain
     * @Start DateTime      : 3-4-2017 10:06 AM   
     * */
    function get_due_amount_for_course($person_id){
        //$this->load->library('ForeignExchange');
        //$fx = new ForeignExchange('BDT', 'USD');
        $invoice_info = $this->payment_model->get_total_invoice_info_by_person_id($person_id);
        $invoice_payment_info = $this->payment_model->get_total_invoice_payment_info_by_person_id($person_id);
        $due_payment = [];
       
        foreach($invoice_info as $invoice_detail){          
            $paid_amount = $this->get_paid_payment($invoice_detail['payment_id'], $invoice_payment_info);

            if($paid_amount == 0){
                $due_payment[$invoice_detail['invoice_id']] = ($invoice_detail['total_price']-$invoice_detail['discounted_price'])-$paid_amount;
            }
            else{
                foreach($invoice_payment_info as $invoice_payment){
                    if(($invoice_payment['currency_type'] == 1) && ($invoice_detail['payment_currency'] == 2)){
                        //$paid_amount = $fx->toForeign($paid_amount);
                        $paid_amount = $this->tt_currency->set($paid_amount, 'BDT', 'USD')->convert_currency()->get();
                        $due_payment[$invoice_detail['invoice_id']] = ($invoice_detail['total_price']-$invoice_detail['discounted_price'])-$paid_amount;
                        break;
                    }
                    elseif(($invoice_payment['currency_type'] == 2) && ($invoice_detail['payment_currency'] == 1)){
                        //$paid_amount = $fx->toBase($paid_amount);
                        $paid_amount = $this->tt_currency->set($paid_amount, 'USD', 'BDT')->convert_currency()->get();
                        $due_payment[$invoice_detail['invoice_id']] = ($invoice_detail['total_price']-$invoice_detail['discounted_price'])-$paid_amount;
                        break;
                    }
                    elseif(($invoice_payment['currency_type'] == 1) && ($invoice_detail['payment_currency'] == 1)){
                        $due_payment[$invoice_detail['invoice_id']] = ($invoice_detail['total_price']-$invoice_detail['discounted_price'])-$paid_amount;
                        break;
                    }
                    elseif(($invoice_payment['currency_type'] == 2) && ($invoice_detail['payment_currency'] == 2)){
                        $due_payment[$invoice_detail['invoice_id']] = ($invoice_detail['total_price']-$invoice_detail['discounted_price'])-$paid_amount;
                        break;
                    }
                }
            }
        }
        return $due_payment;
    }
    /**
     * @Description         : get_due_amount_for_course
     * @Developed By        : MD Delwar Hossain
     * @Start DateTime      : 3-4-2017 1:06 PM   
     * */
    function get_paid_payment($payment_id, $invoice_payment_detail){
        $paid_amount = 0;
        foreach($invoice_payment_detail as $invoice_payment){
            if(array_key_exists('payment_id', $invoice_payment) && $invoice_payment['payment_id'] == $payment_id){
                $paid_amount += $invoice_payment['paid_amount'];
            }
        }
        return $paid_amount;
    }
    
    /**
     * @Description         : View Partial payment Details
     * @Developed By        : MD Delwar Hossain
     * @Start DateTime      : 2-4-2017  
     * */
    public function view_partial_paid_invoices($course_url){
        //echo $course_url;
        $data = [];
        $person_id = $this->session->person_id;
        //Get all payment ID by logged IN person ID
        $payment_id = $this->payment_model->get_partial_payment_id($person_id, $course_url);
        //Get all Due Payment information
        $data['due_payment'] = $this->get_due_amount_for_course($person_id);
        // Remove session Data
        $this->utility_model->remove_session_data('invoice_start_date', 'invoice_end_date', 'invoice_payment_status', 'invoice_page_number');
        
        //Get invoice information by all payment ID
        $data['invoice_info'] = $this->invoice_model
                        ->set_payment_id($payment_id)->get_info_by_payment_id()->get_result();
        // get Invoice Data type=>1[Page_number]
        $invoice_data = $this->get_data_for_view_invoices($data, 1);
        
        // get right side data
        $right_data = $this->get_right_side_data($invoice_data, 'invoice');
        
        $right_data['main_content'] = $this->load->view('user/payment/all_invoice', $right_data, TRUE);
        $this->load->view('user/master', $right_data);
    }
    
    /**
     * @Description         : View Student Partial payment Details
     * @Developed By        : MD Delwar Hossain
     * @Start DateTime      : 5-4-2017  
     * */
    public function view_user_partial_paid_invoices($course_url, $person_id){
        //echo $course_url;
        $data = [];
        $person_id = strtr($person_id,array('.' => '+', '-' => '=', '~' => '/'));
        $person_id = $this->encryption->decrypt($person_id);
        
        //Get all payment ID by logged IN person ID
        $payment_id = $this->payment_model->get_partial_payment_id($person_id, $course_url);
        //Get all Due Payment information
        $data['due_payment'] = $this->get_due_amount_for_course($person_id);
        // Remove session Data
        $this->utility_model->remove_session_data('invoice_start_date', 'invoice_end_date', 'invoice_payment_status', 'invoice_page_number');
        
        //Get invoice information by all payment ID
        $data['invoice_info'] = $this->invoice_model
                        ->set_payment_id($payment_id)->get_info_by_payment_id()->get_result();
        // get Invoice Data type=>1[Page_number]
        $invoice_data = $this->get_data_for_view_invoices($data, 1);
        
        // get right side data
        $right_data = $this->get_right_side_data($invoice_data, 'invoice');
        
        $right_data['main_content'] = $this->load->view('user/payment/all_invoice', $right_data, TRUE);
        $this->load->view('user/master', $right_data);
    }


    /**
     * @Description         : view all invoice by search (dateTime and payment Status)
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-11-2016 11:55 AM   
     * */
    function view_invoices_by_search() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $date = $session_data = [];
        $start_date = $this->input->post('start_date', TRUE);
        $end_date = $this->input->post('end_date', TRUE);
        $payment_status = $this->input->post('payment_status', TRUE);

        $session_data['invoice_start_date'] = $date['invoice_start_date'] = (empty($start_date)) ? $this->session->invoice_start_date : $start_date;
        $session_data['invoice_end_date'] = $date['invoice_end_date'] = (empty($end_date)) ? $this->session->invoice_end_date : $end_date;
        $session_data['invoice_payment_status'] = (empty($payment_status)) ? $this->session->invoice_payment_status : $payment_status;
        set_session($session_data);

        // get limit value
        $input_page_number = $this->input->post('page_number', TRUE);
        $page_number = (empty($input_page_number)) ? 1 : $input_page_number;
        $limit = ($page_number * 10) - 10;

        $person_id = $this->session->person_id;
        //Get all payment ID by logged IN person ID
        $payment_id = $this->payment_model->set_person_id($person_id)->get_all_id_by_person_id();
        //Get all Due Payment information
        $data['due_payment'] = $this->get_due_amount_for_course($person_id);
        //Get invoice information by all payment ID
        $data['invoice_info'] = $this->invoice_model
                        ->set_payment_id(explode(',', $payment_id))->set_date(array_filter($date))
                        ->set_status($session_data['invoice_payment_status'])->set_limit($limit)->get_info_by_payment_id()->get_result();
        // get Invoice Data type=>1[Page_number]
        $invoice_data = $this->get_data_for_view_invoices($data, $page_number);

        //view final invoice
        $ajax_data['view_page'] = $this->load->view('user/payment/ajax/all_invoice', $invoice_data, TRUE);
        echo json_encode($ajax_data);
    }

    /**
     * @Description         : get data for view Invoices
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-11-2016 04:41 PM   
     * */
    function get_data_for_view_invoices($data, $page_number) {
       
       
        foreach ($data['invoice_info'] as $value) {
            $temp_invoice_id = $this->utility_model
                            ->get_table_information('random_number', 'tbl_random', ['random_type' => 1, 'random_type_id' => $value->invoice_id])->random_number;
            $data['random_id'][$value->invoice_id] = $this->tt_random_number->set_random_number($temp_invoice_id)->filter_number('45')->get_filter_number();
            $data['invoice_payment_info'][$value->invoice_id] = $this->utility_model
                    ->get_table_information('*', 'tbl_invoice_payment', ['invoice_id' => $value->invoice_id]);
            
            //$data['inv_id'] = $this->payment_model->generate_paid_amount_payment_id();

        }

        $total_rows = $this->invoice_model->total_invoice();
        $params = array('url' => '', 'div_id' => 'invoicePagination', 'total_row' => $total_rows, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['paginzation_link'] = $this->tt_pagination->view_pagination_link($params);
        return $data;
    }

    /**
     * @Description         : delete invoice by invoice ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-11-2016 10:00 AM   
     * */
    function delete_invoice() {
        if ($this->input->is_ajax_request()) {
            $temp_invoice_id = $this->input->post('random_id', TRUE);

            // set random ID and process for random information
            $random_info = $this->random_number_model->set_temp_random_id($temp_invoice_id)->process()->get_info();

            try {
                if ($random_info) {
                    // get payment ID by invoice ID
                    $payment_id = $this->utility_model
                                    ->set_single_row_info('payment_id', 'tbl_invoice', ['invoice_id' => $random_info->random_type_id])
                                    ->get_single_row_info()->payment_id;

                    try {
                        if ($payment_id) {
                            // get payment information by payment ID #person_id=>[payment created ID] ,#payment_type=>[Course=1,Video_course=2], #payment_type_id=>course/video course ID
                            $payment_info = $this->utility_model
                                    ->set_single_row_info('person_id,payment_type,payment_type_id', 'tbl_payment', ['payment_id' => $payment_id])
                                    ->get_single_row_info();

                            // get student ID #person_id, #student_type=>[Course=1,Video_course=2], #student_type_id=>course/video course ID
                            $student_id = $this->utility_model
                                            ->set_single_row_info('student_id', 'tbl_student', ['person_id' => $payment_info->person_id, 'student_type' => $payment_info->payment_type, 'student_type_id' => $payment_info->payment_type_id])
                                            ->get_single_row_info()->student_id;

                            try {
                                if ($student_id) {
                                    // Delete Student Information
                                    $this->student_model->set_student_id($student_id)->delete();
                                }
                            } catch (Exception $exc) {
//                                echo $exc->getTraceAsString();
                            } finally {
                                // Delete Payment information
                                $this->payment_model->set_payment_id($payment_id)->delete();
                            }


                            // get notification info
                            $notification_info = $this->notification_model
                                            ->set_data(8, $payment_info->payment_type_id, $payment_info->person_id)->get_data();

                            try {
                                if ($notification_info) {
                                    // Delete Noticfication information
                                    $this->notification_model->set_notification_id($notification_info->notification_id)
                                            ->delete();

                                    // Delete Noticfication type information
                                    $this->notification_model->set_notification_type_info_id($notification_info->notification_type_info_id)
                                            ->delete_type_info();
                                }
                            } catch (Exception $exc) {
//                                echo $exc->getTraceAsString();
                            }
                        }
                    } catch (Exception $exc) {
//                        echo $exc->getTraceAsString();
                    } finally {
                        // Delete invoice from invoice tbl
                        $this->invoice_model->set_invoice_id($random_info->random_type_id)->delete();

                        // Delete Random from invoice tbl
                        $this->random_number_model->set_random_id($random_info->random_id)->delete();
                    }
                }
            } catch (Exception $exc) {
//                echo $exc->getTraceAsString();
            }
        } else {
            redirect('');
        }
    }

    /**
     * @Description         : refund request for payment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-01-2016 12:38 PM   
     * */
    function payment_refund_request_invoice() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $temp_invoice_random_id = $this->input->post('invoice_random_id', TRUE);

        // set random ID and process for random information
        $random_info = $this->random_number_model->set_temp_random_id($temp_invoice_random_id)->process()->get_info();
        // get payment ID by invoice ID
        $payment_id = $this->utility_model
                        ->set_single_row_info('payment_id', 'tbl_invoice', ['invoice_id' => $random_info->random_type_id])
                        ->get_single_row_info()->payment_id;
        
        // update payment status
        $this->payment_model->set_payment_id($payment_id);
        $this->payment_model->payment_status = 7;
        $this->payment_model->update();
    }

    /*
      -----------@@@End@ View All Invoice----------------------------------
     */


    /*
      -----------@Start -- Earning Invoice----------------------------------
     */

    /**
     * @Description         : view payment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-12-2016 02:58 PM   
     * */
    function view_payment() {
        redirect('user/invoice');
    }


    /**
     * @Description         : view earning amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 09-12-2016 03:15 PM   
     * */
//    function view_earning_invoice($url) {
//        $earning_invoice_data = [];
//        $data = $this->get_right_side_data($earning_invoice_data, 'earning');
//        // Remove session Data
//        $this->utility_model->remove_session_data('earning_invoice_start_date', 'earning_invoice_end_date', 'earning_invoice_payment_status');
//        $course_info = $this->course_model->set_url($url)->set_field_name('course_id')->set_info_by_url()->get_result();
//
//        if ($course_info) {
//            $payment_info = $this->payment_model->set_type(1)->set_type_id($course_info->course_id)->set_all_id_by_type_id()->get_info();
//
//            $payment_in_array = ($payment_info) ? explode(',', $payment_info->id) : [];
//            $data['invoice_info'] = $this->invoice_model->set_payment_id($payment_in_array)->set_limit(0)->get_info_by_payment_id()->get_result();
//
//            $invoice_data = $this->get_data_for_earning_invoices($data, 1);
//        } else {
//            redirect();
//        }
//        $invoice_data['main_content'] = $this->load->view('user/payment/earning_invoice', $invoice_data, true);
//        $this->load->view('user/master', $invoice_data);
//    }
//
//    /**
//     * @Description         : view earning Invoice
//     * @Developed By        : MD Jaherul Islam
//     * @Start DateTime      : 10-12-2016 03:51 PM   
//     * */
//    function get_data_for_earning_invoices($data, $page_number) {
//        // get earning invoice data
//        $invoice_data = $this->get_earning_invoice_data($data);
//
//        // get data with pagination
//        return $this->get_data_with_pagination($invoice_data, $page_number);
//    }
//
//    /**
//     * @Description         : get earning invoice DATA
//     * @Developed By        : MD Jaherul Islam
//     * @Start DateTime      : 12-12-2016 10:11 AM   
//     * */
//    function get_earning_invoice_data($data) {
//        foreach ($data['invoice_info'] as $value) {
//            $temp_invoice_id = $this->utility_model
//                            ->get_table_information('random_number', 'tbl_random', ['random_type' => 1, 'random_type_id' => $value->invoice_id])->random_number;
//            $data['random_id'][$value->invoice_id] = $this->tt_random_number->set_random_number($temp_invoice_id)->filter_number('45')->get_filter_number();
//            $data['invoice_payment_info'][$value->invoice_id] = $this->utility_model
//                    ->get_table_information('*', 'tbl_invoice_payment', ['invoice_id' => $value->invoice_id]);
//            $data['payment_info'][$value->invoice_id] = $this->utility_model
//                    ->get_table_information('person_id,payment_status', 'tbl_payment', ['payment_id' => $value->payment_id]);
//            $data['student_info'][$value->invoice_id] = $this->person_model->set_person_id($data['payment_info'][$value->invoice_id]->person_id)
//                            ->set_field_name('person_first_name,person_last_name,url')->set_info_with_url_by_id()->get_info();
//        }
//        return $data;
//    }
//
//    /**
//     * @Description         : get data with pagination
//     * @Developed By        : MD Jaherul Islam
//     * @Start DateTime      : 12-12-2016 10:09 AM   
//     * */
//    function get_data_with_pagination($data, $page_number) {
//        $total_rows = $this->invoice_model->total_invoice();
//        $params = array('url' => '', 'div_id' => 'earningInvoicePagination', 'total_row' => $total_rows, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
//        $data['paginzation_link'] = $this->tt_pagination->view_pagination_link($params);
//        return $data;
//    }
//
//    /**
//     * @Description         : view single payment invoice
//     * @Developed By        : MD Jaherul Islam
//     * @Start DateTime      : 10-12-2016 06:15 PM   
//     * */
//    function view_single_payment_invoice() {
//        if (empty($this->input->is_ajax_request())) {
//            redirect();
//        }
//        $data = [];
//        $temp_invoice_id = $this->input->post('invoice_id', TRUE);
//        // set random ID and process for random information
//        $random_info = $this->random_number_model->set_temp_random_id($temp_invoice_id)->process()->get_info();
//
//        // get payment ID by invoice ID
//        $invoice_info = $this->utility_model
//                        ->set_single_row_info('payment_id', 'tbl_invoice', ['invoice_id' => $random_info->random_type_id])->get_single_row_info();
//
//        // get all invoice information by payment ID
//        $data['invoice_info'] = $this->invoice_model->set_payment_id($invoice_info->payment_id)->set_all_invoice_info_by_payment_id()->get_result();
//        // get earning invoice data
//        $invoice_data = $this->get_earning_invoice_data($data);
//
//        // echo view pages
//        $data['view_page'] = $this->load->view('user/payment/ajax/earning_invoice', $invoice_data, TRUE);
//        echo json_encode($data);
//    }
//
//    /**
//     * @Description         : search earning invoice
//     * @Developed By        : MD Jaherul Islam
//     * @Start DateTime      : 12-12-2016 11:07 AM   
//     * */
//    private $page_number;
//
//    function search_earning_invoice() {
//        if (empty($this->input->is_ajax_request())) {
//            redirect();
//        }
//        $data = [];
//        $course_url = $this->input->post('course_url', TRUE);
//
//        // get course information by course URL
//        $course_info = $this->course_model->set_url($course_url)->set_field_name('course_id')->set_info_by_url()->get_result();
//        if ($course_info) {
//            // assign value for earning invoice
//            $this->assigned_earning_invoice_value();
//
//            // get payment information by course ID
//            $payment_info = $this->payment_model->set_type(1)->set_type_id($course_info->course_id)->set_all_id_by_type_id()->get_info();
//            // generate all payment array
//            $payment_in_array = ($payment_info) ? explode(',', $payment_info->id) : [];
//
//            // get all invoice information by multiple payment ID
//            $data['invoice_info'] = $this->invoice_model
//                            ->set_payment_id($payment_in_array)->get_info_by_payment_id()->get_result();
//
//            // set page number
//            $data['page_number'] = $this->page_number;
//            // get earning invoice data
//            $invoice_data = $this->get_earning_invoice_data($data);
//
//            // get data with pagination
//            $invoice_data_with_pagination = $this->get_data_with_pagination($invoice_data, $this->page_number);
//
//            // echo view pages
//            $data['view_page'] = $this->load->view('user/payment/ajax/earning_invoice', $invoice_data_with_pagination, TRUE);
//            echo json_encode($data);
//        }
//    }
//
//    /**
//     * @Description         : assign value into variable for earning invoive
//     * @Developed By        : MD Jaherul Islam
//     * @Start DateTime      : 12-12-2016 02:46 PM   
//     * */
//    function assigned_earning_invoice_value() {
//        $date = $session_data = [];
//        $start_date = $this->input->post('start_data', TRUE);
//        $end_date = $this->input->post('end_date', TRUE);
//        $payment_status = $this->input->post('payment_status', TRUE);
//
//        $session_data['earning_invoice_start_date'] = $date['invoice_start_date'] = (empty($start_date)) ? $this->session->earning_invoice_start_date : $start_date;
//        $session_data['earning_invoice_end_date'] = $date['invoice_end_date'] = (empty($end_date)) ? $this->session->earning_invoice_end_date : $end_date;
//        $session_data['earning_invoice_payment_status'] = ($payment_status == 'undefine') ? '' :
//                ((empty($payment_status)) ? $this->session->earning_invoice_payment_status : $payment_status);
//        set_session($session_data);
//
//        // get page number
//        $input_page_number = $this->input->post('page_number', TRUE);
//        $this->page_number = (empty($input_page_number)) ? 1 : $input_page_number;
//        $limit = ($this->page_number * 10) - 10;
//
//        $this->invoice_model->set_date(array_filter($date))
//                ->set_status($session_data['earning_invoice_payment_status'])->set_limit($limit);
//    }

    /*
      ------------------------------@End -- Earning Invoice---------------------------------------------------------------
     * 
     */

    /*
      ------------------------------@Start -- Payment method---------------------------------------------------------------
     * 
     */

    /**
     * @Description         : view and add/update payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-12-2016 05:35 PM   
     * */
    public function payment_method() {
        $data = $this->get_right_side_data([], 'earning');
        $data['person_info'] = $this->person_model->set_person_id($this->session->person_id)
                        ->set_field_name('person_first_name,person_last_name,person_country,url')->set_info_with_url_by_id()->get_info();

        $data['all_bank'] = $this->utility_model->set_single_row_info('*', 'tbl_bank', ['bank_status' => 1])->get_all_data();

        $data['payment_method_info'] = $this->utility_model
                        ->set_single_row_info('*', 'tbl_person_bkash_payment_info', ['person_id' => $this->session->person_id])->get_single_row_info();
        $data['payment_type'] = 1;
        if (empty($data['payment_method_info'])) {
            $data['payment_method_info'] = $this->utility_model
                            ->set_single_row_info('*', 'tbl_person_check_payment_info', ['person_id' => $this->session->person_id])->get_single_row_info();

            if ($data['payment_method_info']) {
                $data['bank_branch_info'] = $this->utility_model
                                ->set_single_row_info('bank_id,bank_branch_name', 'tbl_bank_branch', ['bank_branch_id' => $data['payment_method_info']->bank_branch_id])->get_single_row_info();
                $data['bank_info'] = $this->utility_model
                                ->set_single_row_info('bank_name', 'tbl_bank', ['bank_id' => $data['bank_branch_info']->bank_id])->get_single_row_info();
            }

            $data['payment_type'] = 2;
            if (empty($data['payment_method_info'])) {
                $data['payment_method_info'] = $this->utility_model
                                ->set_single_row_info('*', 'tbl_person_paypal_payment_info', ['person_id' => $this->session->person_id])->get_single_row_info();
                $data['payment_type'] = 3;
            }
        }


        $data['main_content'] = $this->load->view('user/payment/payment_method', $data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Description         : view bank branch name by bank ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 12:39 PM   
     * */
    function view_bank_branch_name() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $bank_id = $this->input->post('bank_id', TRUE);
        $bank_branchs = $this->bank_branch_model->set_bank_id($bank_id)->set_branch_name_by_bank_id()->get_result();
        echo json_encode($bank_branchs);
    }

    /**
     * @Description         : get all bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 03:05 PM   
     * */
    function get_all_bank_name() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $all_bank = $this->utility_model->set_single_row_info('bank_name', 'tbl_bank', ['bank_status' => 1])->get_all_data();
        echo json_encode($all_bank);
    }

    /**
     * @Description         : cehck bank account number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-12-2016 10:03 AM   
     * */
    function check_bank_account_number() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $bank_id = $this->input->post('bank_id', TRUE);
        $branch_info = $this->bank_branch_model->set_bank_id($bank_id)->set_all_bank_branch_id_by_bank_id()->get_result();

        if (!empty($branch_info)) {
            $account_number_info = $this->bank_branch_model->set_field_name('person_account_number')
                            ->set_bank_branch_id(explode(',', $branch_info->id))
                            ->set_check_payment_info_by_all_branch_id()->get_result();

            echo json_encode($account_number_info);
        } else {
            echo json_encode([]);
        }
    }

    /**
     * @Description         : save check payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 03:52 PM   
     * */
    private $bank_id;
    private $bank_branch_id;
    private $payment_method_id;
    private $payment_method_messgae;

    function save_check_payment_method() {
        $this->form_validation->set_rules('bank_id', 'Bank Name', 'required|callback_check_other_bank_name');
        $this->form_validation->set_rules('bank_branch_id', 'Bank Branch Name', 'required|trim|callback_check_other_bank_branch_name');
        $this->form_validation->set_rules('person_account_number', 'Account number', 'required|callback_check_account_number');
        if ($this->form_validation->run() == FALSE) {
            $data = [];
            $data['check_type'] = 3; // for save payment information
            $data['bank_id_value'] = set_value('bank_id');
            $data['validation_error'] = validation_errors();
            $this->session->set_userdata($data);

            redirect('user/payment-method');
        } else {
            $this->save_bank_branch_information();
            // save check payment information
            $this->save_check_payment_information();

            // send mail for add payment method
            $this->send_notification_for_payment()->save_notification();
            // send mail for add payment method
//            $this->send_email_for_add_payment_method();
            // redirect payment method
            redirect('user/payment-method');
        }
    }

    /**
     * @Description         : cehck other bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-12-2016 12:18 PM   
     * */
    function check_other_bank_name($bank_id) {
        if ($bank_id == 'other') {
            $other_bank_name = $this->input->post('other_bank_name', TRUE);
            $bank_info = $this->bank_model->set_bank_name($other_bank_name)->set_bank_info_by_bank_name()->get_result();
            if ($bank_info) {
                $this->form_validation->set_message('check_other_bank_name', 'bank name already exists');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /**
     * @Description         : cehck other bank branch name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-12-2016 12:18 PM   
     * */
    function check_other_bank_branch_name($bank_branch_id) {
        if ($bank_branch_id == 'other') {
            $bank_id = $this->input->post('bank_id', TRUE);
            if ($bank_id == 'other') {
                return TRUE;
            } else {
                $branch_info = $this->bank_branch_model->set_bank_id($bank_id)
                                ->set_branch_name($this->input->post('other_bank_branch_name', TRUE))
                                ->set_bank_branch_id('')->check_bank_branch_name()->get_result();

                if ($branch_info) {
                    $this->form_validation->set_message('check_other_bank_branch_name', 'bank branch name already exists');
                    return FALSE;
                } else {
                    return TRUE;
                }
            }
        } else {
            return TRUE;
        }
    }

    /**
     * @Description         : cehck account number bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-12-2016 12:18 PM   
     * */
    function check_account_number($account_number) {
        $bank_id = $this->input->post('bank_id', TRUE);
        if ($bank_id != 'other') {
            $branch_info = $this->bank_branch_model->set_bank_id($bank_id)->set_all_bank_branch_id_by_bank_id()->get_result();
            $account_number_info = $this->bank_branch_model->set_field_name('person_account_number')
                            ->set_bank_branch_id(explode(',', $branch_info->id))->set_account_number($account_number)
                            ->set_check_payment_account_number_by_all_branch_id()->get_result();

            if ($account_number_info) {
                $this->form_validation->set_message('check_account_number', 'account number already exists');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /**
     * @Description         : save bak branch information if user select other branch
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 06:21 PM   
     * */
    function save_bank_branch_information() {
        $bank_branch_id = $this->input->post('bank_branch_id', TRUE);
        if ($bank_branch_id == 'other') {
            // Save bank information id user select other option
            $this->save_bank_information();
            $this->bank_branch_model->bank_id = $this->bank_id;
            $this->bank_branch_model->bank_branch_name = trim($this->input->post('other_bank_branch_name', TRUE));
            $this->bank_branch_model->bank_branch_status = 2;
            $this->bank_branch_id = $this->bank_branch_model->save()->set_insert_id()->get_bank_branch_id();
        } else {
            $this->bank_branch_id = $bank_branch_id;
        }
    }

    /**
     * @Description         : save bank information id user select Other
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 06:24 PM   
     * */
    function save_bank_information() {
        $bank_id = $this->input->post('bank_id', TRUE);
        // if user select other bank ID
        if ($bank_id == 'other') {
            $this->bank_model->bank_name = trim($this->input->post('other_bank_name', TRUE));
            $this->bank_model->bank_status = 2;
            $this->bank_id = $this->bank_model->save()->set_insert_id()->get_bank_id();
        } else {
            $this->bank_id = $bank_id;
        }
        return $this;
    }

    /**
     * @Description         : save check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 06:24 PM   
     * */
    function save_check_payment_information() {
        $this->payment_process_model->person_id = $this->session->person_id;
        $this->payment_process_model->bank_branch_id = $this->bank_branch_id;
        $this->payment_process_model->person_account_number = trim($this->input->post('person_account_number', TRUE));
        $this->payment_process_model->set_table_name('tbl_person_check_payment_info')->save();

        $this->payment_method_messgae = 'added cheque payment method';
        $this->payment_method_id = $this->payment_process_model->set_insert_id()->get_id();
    }

    /**
     * @Description         : save bkash payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-12-2016 04:49 PM   
     * */
    function save_bkash_payment_method() {
        $this->form_validation->set_rules('bkash_number_type', 'Bkash Number Type', 'required');
        $this->form_validation->set_rules('bkash_number', 'Bkash Number', 'required|min_length[11]|max_length[11]|numeric|callback_check_bkash_number_existence');
        if ($this->form_validation->run() == FALSE) {
            // set variable into session
            $this->set_session_for_add_bkash_payment();
            // redirect to payment method
            redirect('user/payment-method');
        } else {
            // save bkash payment number
            $this->save_bkash_payment_information();

            // send mail for add payment method
            $this->send_notification_for_payment()->save_notification();
            // redirect payment method
            redirect('user/payment-method');
        }
    }

    /**
     * @Description         : set variable into session for save bkash payment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-12-2016 03:08 PM   
     * */
    function set_session_for_add_bkash_payment() {
        $data = [];
        $data['type'] = 1;
        $data['bkash_number_type_value'] = set_value('bkash_number_type');
        $data['bkash_number_type_error'] = form_error('bkash_number_type');
        $data['bkash_number_value'] = set_value('bkash_number');
        $data['bkash_number_error'] = form_error('bkash_number');
        $this->session->set_userdata($data);
    }

    /**
     * @Description         : check baksh number existence
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-12-2016 11:21 AM   
     * */
    function check_bkash_number_existence($bkash_number) {
        $bkash_payment_info = $this->utility_model
                        ->set_single_row_info('*', 'tbl_person_bkash_payment_info', ['bkash_number' => $bkash_number])->get_single_row_info();
        if ($bkash_payment_info) {
            $this->form_validation->set_message('check_bkash_number_existence', 'bkash number already exists');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Description         : save check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 06:24 PM   
     * */
    function save_bkash_payment_information() {
        $this->payment_process_model->person_id = $this->session->person_id;
        $this->payment_process_model->bkash_number_type = $this->input->post('bkash_number_type', TRUE);
        $this->payment_process_model->bkash_number = trim($this->input->post('bkash_number', TRUE));
        $this->payment_process_model->set_table_name('tbl_person_bkash_payment_info')->save();

        $this->payment_method_messgae = 'added bkash payment method';
        $this->payment_method_id = $this->payment_process_model->set_insert_id()->get_id();
    }

    /**
     * @Description         : save paypal payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-12-2016 05:03 PM   
     * */
    function save_paypal_payment_method() {
        $this->form_validation->set_rules('paypal_email', 'Paypal Email', 'required|valid_email|is_unique[tbl_person_paypal_payment_info.paypal_email]');
        if ($this->form_validation->run() == FALSE) {
            $data = [];
            $data['paypal_type'] = 5; // for save payment information
            $data['paypal_error'] = form_error('paypal_email');
            $this->session->set_userdata($data);
            redirect('user/payment-method');
        } else {
            // save bkash payment number
            $this->save_paypal_payment_information();

            // send mail for add payment method
            $this->send_notification_for_payment()->save_notification();
            // redirect payment method
            redirect('user/payment-method');
        }
    }

    /**
     * @Description         : cehck paypal email
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-12-2016 03:44 PM   
     * */
    function check_paypal_email() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $paypal_email = $this->input->post('paypal_email', TRUE);
        $paypal_payment_info = $this->utility_model
                        ->set_single_row_info('*', 'tbl_person_paypal_payment_info', ['paypal_email' => $paypal_email])->get_single_row_info();

        echo (!empty($paypal_payment_info)) ? 1 : 2;
    }

    /**
     * @Description         : save paypal payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-12-2016 05:10 PM   
     * */
    function save_paypal_payment_information() {
        $this->payment_process_model->person_id = $this->session->person_id;
        $this->payment_process_model->paypal_email = trim($this->input->post('paypal_email', TRUE));
        $this->payment_process_model->set_table_name('tbl_person_paypal_payment_info')->save();

        $this->payment_method_messgae = 'added paypal payment method';
        $this->payment_method_id = $this->payment_process_model->set_insert_id()->get_id();
    }

    /**
     * @Description         : get bkash payment info
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 10:12 AM   
     * */
    function get_bkash_payment_info() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $bkash_payment_id = $this->input->post('bkash_payment_id', TRUE);
        $bkash_payment_info = $this->utility_model
                        ->set_single_row_info('*', 'tbl_person_bkash_payment_info', ['person_bkash_payment_info_id' => $bkash_payment_id])->get_single_row_info();

        echo json_encode($bkash_payment_info);
    }

    /**
     * @Description         : check bkash number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-12-2016 10:30 AM   
     * */
    function check_bkash_number() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $all_bkash_number = $this->utility_model->set_single_row_info('bkash_number', 'tbl_person_bkash_payment_info', [])->get_all_data();
        echo json_encode($all_bkash_number);
    }

    /**
     * @Description         : get bkash payment info
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 10:12 AM   
     * */
    function update_bkash_payment_method() {
        $this->payment_method_id = $this->input->post('bkash_payment_id', TRUE);
        $bkash_number_info = $this->utility_model
                ->set_single_row_info('bkash_number', 'tbl_person_bkash_payment_info', ['person_bkash_payment_info_id' => $this->payment_method_id])
                ->get_single_row_info();

        if (empty($bkash_number_info)) {
            redirect('user/payment-method');
        }

        $this->form_validation->set_rules('edit_bkash_number_type', 'Bkash Number Type', 'required');
        // if previous number does not and new number same then check validation
        if (trim($this->input->post('edit_bkash_number', TRUE)) != $bkash_number_info->bkash_number) {
            $this->form_validation->set_rules('edit_bkash_number', 'Bkash Number', 'required|min_length[11]|max_length[11]|numeric|callback_check_bkash_number_existence');
        }

        if ($this->form_validation->run() == FALSE) {
            // set variable into session
            $this->set_session_for_update_bkash_payment();
            // refirect to payment method
            redirect('user/payment-method');
        } else {
            // update bkash payment number
            $this->update_bkash_payment_information();
            // send mail for add payment method
            $this->send_notification_for_payment()->save_notification();
            // redirect payment method
            redirect('user/payment-method');
        }
    }

    /**
     * @Description         : set variable into session for update bkash payment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-12-2016 03:08 PM   
     * */
    function set_session_for_update_bkash_payment() {
        $data = [];
        $data['type'] = 2;
        $data['bkash_payment_method_id'] = $this->payment_method_id;
        $data['bkash_number_type_value'] = set_value('edit_bkash_number_type');
        $data['bkash_number_type_error'] = form_error('edit_bkash_number_type');
        $data['bkash_number_value'] = set_value('edit_bkash_number');
        $data['bkash_number_error'] = form_error('edit_bkash_number');
        $this->session->set_userdata($data);
    }

    /**
     * @Description         : save check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 06:24 PM   
     * */
    function update_bkash_payment_information() {
        $this->payment_process_model->bkash_number_type = $this->input->post('edit_bkash_number_type', TRUE);
        $this->payment_process_model->bkash_number = trim($this->input->post('edit_bkash_number', TRUE));
        $this->payment_process_model->set_primary_key('person_bkash_payment_info_id')
                ->set_primary_key_value($this->payment_method_id)->set_table_name('tbl_person_bkash_payment_info')->update();

        // set notification type [for update bkash payment method]
        $this->payment_method_messgae = 'updated bkash payment method';
    }

    /**
     * @Description         : delete bkash payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-12-2016 03:24 PM   
     * */
    function delete_bkash_payment_method() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $this->payment_process_model->set_primary_key('person_bkash_payment_info_id')
                ->set_primary_key_value($this->input->post('bkash_payment_id', TRUE))->set_table_name('tbl_person_bkash_payment_info')->delete();
    }

    /**
     * @Description         : get check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 03:32 PM   
     * */
    function get_check_payment_info() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }

        $data = [];
        $check_payment_id = $this->input->post('check_payment_id', TRUE);
        $data['check_payment_info'] = $this->utility_model
                ->set_single_row_info('*', 'tbl_person_check_payment_info', ['person_check_payment_info_id' => $check_payment_id])
                ->get_single_row_info();
        $data['branch_info'] = $this->utility_model
                ->set_single_row_info('*', 'tbl_bank_branch', ['bank_branch_id' => $data['check_payment_info']->bank_branch_id])
                ->get_single_row_info();
        $data['bank_info'] = $this->utility_model
                ->set_single_row_info('*', 'tbl_bank', ['bank_id' => $data['branch_info']->bank_id])
                ->get_single_row_info();
        echo json_encode($data);
    }

    /**
     * @Description         : update check payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 04:32 PM   
     * */
    function update_check_payment_method() {
        $this->form_validation->set_rules('bank_id', 'Bank Name', 'required');
        $this->form_validation->set_rules('bank_branch_id', 'Bank Branch Name', 'required|trim');
        $this->form_validation->set_rules('person_account_number', 'Account number', 'required');
        if ($this->form_validation->run() == FALSE) {
            redirect('user/payment-method');
        } else {
            // update bank information
            $this->update_bank_information();
            // update bank branch information
            $this->update_bank_branch_information();
            // save check payment information
            $this->update_check_payment_information();
            // send notification for add payment method
            $this->send_notification_for_payment()->save_notification();
            // redirect payment method
            redirect('user/payment-method');
        }
    }

    /**
     * @Description         : update bank branch information if user select other branch
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 04:39 PM   
     * */
    function update_bank_branch_information() {
        $bank_branch_id = $this->input->post('edit_bank_branch_id', TRUE);
        if ($bank_branch_id == 'other') {
            $this->bank_branch_model->bank_id = $this->bank_id;
            $this->bank_branch_model->bank_branch_name = trim($this->input->post('edit_other_bank_branch_name', TRUE));
            $this->bank_branch_model->bank_branch_status = 2;
            $this->bank_branch_id = $this->bank_branch_model->save()->set_insert_id()->get_bank_branch_id();
        } else {
            $this->bank_branch_id = $bank_branch_id;
        }
    }

    /**
     * @Description         : update bank information id user select Other
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 04:39 PM   
     * */
    function update_bank_information() {
        $bank_id = $this->input->post('edit_bank_id', TRUE);
        // if user select other bank ID
        if ($bank_id == 'other') {
            $edit_update_bank_id = $this->input->post('edit_update_bank_id', TRUE);

            if (empty($edit_update_bank_id)) {
                $this->bank_model->bank_name = trim($this->input->post('edit_other_bank_name', TRUE));
                $this->bank_model->bank_status = 2;
                $this->bank_id = $this->bank_model->save()->set_insert_id()->get_bank_id();
            } else {
                $this->bank_model->bank_name = trim($this->input->post('edit_other_bank_name', TRUE));
                $this->bank_model->bank_status = 2;
                $this->bank_model->set_bank_id($edit_update_bank_id)->update();
                $this->bank_id = $edit_update_bank_id;
            }
        } else {
            $this->bank_id = $bank_id;
        }
        return $this;
    }

    /**
     * @Description         : update check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 05:05 PM   
     * */
    function update_check_payment_information() {
        $this->payment_method_id = $this->input->post('check_payment_id', TRUE);
        $this->payment_process_model->bank_branch_id = $this->bank_branch_id;
        $this->payment_process_model->person_account_number = trim($this->input->post('edit_person_account_number', TRUE));
        $this->payment_process_model->set_primary_key('person_check_payment_info_id')
                ->set_primary_key_value($this->payment_method_id)->set_table_name('tbl_person_check_payment_info')->update();

        $this->payment_method_messgae = 'updated cheque payment method';
    }

    /**
     * @Description         : update check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 05:05 PM   
     * */
    function get_paypal_payment_info() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }

        $payment_method_id = $this->input->post('payment_method_id', TRUE);
        $paypal_payment_info = $this->utility_model
                ->set_single_row_info('*', 'tbl_person_paypal_payment_info', ['person_paypal_payment_info_id' => $payment_method_id])
                ->get_single_row_info();

        echo json_encode($paypal_payment_info);
    }

    /**
     * @Description         : update check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 06:17 PM   
     * */
    function update_paypal_payment_method() {
        $this->payment_method_id = $this->input->Post('paypal_method_id', TRUE);
        $previous_email = $this->utility_model
                        ->set_single_row_info('paypal_email', 'tbl_person_paypal_payment_info', ['person_paypal_payment_info_id' => $this->payment_method_id])
                        ->get_single_row_info()->paypal_email;

        if ($previous_email != trim($this->input->post('edit_paypal_email'))) {
            $this->form_validation->set_rules('edit_paypal_email', 'Paypal Email', 'required|valid_email|is_unique[tbl_person_paypal_payment_info.paypal_email]');
        }

        if ($this->form_validation->run() == FALSE) {
            $data = [];
            $data['paypal_type'] = 6; // for save payment information
            $data['paypal_email_value'] = set_value('edit_paypal_email'); // for save payment information
            $data['paypal_error'] = form_error('edit_paypal_email');
            $this->session->set_userdata($data);
            redirect('user/payment-method');
        } else {
            // save bkash payment number
            $this->update_paypal_payment_information();

            // send mail for add payment method
            $this->send_notification_for_payment()->save_notification();
            // redirect payment method
            redirect('user/payment-method');
        }
    }

    /**
     * @Description         : update paypal payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 06:24 PM   
     * */
    function update_paypal_payment_information() {
        $this->payment_process_model->paypal_email = trim($this->input->post('edit_paypal_email', TRUE));
        $this->payment_process_model->set_primary_key('person_paypal_payment_info_id')
                ->set_primary_key_value($this->payment_method_id)->set_table_name('tbl_person_paypal_payment_info')->update();

        $this->payment_method_messgae = 'updated paypal payment method';
    }

    /**
     * @Description         : delete paypal payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-12-2016 04:55 PM   
     * */
    function delete_paypal_payment_method() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $this->payment_process_model->set_primary_key('person_paypal_payment_info_id')
                ->set_primary_key_value($this->input->post('paypal_payment_id', TRUE))->set_table_name('tbl_person_paypal_payment_info')->delete();
    }

    /**
     * @Description         : delete check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-12-2016 05:06 PM   
     * */
    function delete_check_payment_method() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $this->payment_process_model->set_primary_key('person_check_payment_info_id')
                ->set_primary_key_value($this->input->post('check_payment_id', TRUE))->set_table_name('tbl_person_check_payment_info')->delete();
    }

    /**
     * @Description         : save notification for payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 11:23 AM   
     * */
    private $notify_to;
    private $notify_by;
    private $notification_type;
    private $notification_type_id;
    private $notification_description;

    function send_notification_for_payment() {
        $notification_description = [];
        $person_info = $this->person_model->set_person_id($this->session->person_id)->set_field_name('person_first_name,person_last_name')->set_info_by_id()->get_info();
        $notification_description[1] = '<strong>' . $person_info->person_first_name . ' ' . $person_info->person_last_name . '</strong> ' . $this->payment_method_messgae . '';
        $notification_description[$this->session->person_id] = '<strong>You</strong> ' . $this->payment_method_messgae . '';

        $this->notify_by = $this->session->person_id;
        $this->notify_to = implode(',', array_keys($notification_description));
        $this->notification_type = 7;
        $this->notification_description = serialize($notification_description);
        $this->notification_type_id = $this->payment_method_id;
        return $this;
    }

    /**
     * @Description         : save notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-01-2016 06:40 PM   
     * */
    function save_notification() {
        // save notification information
        $this->notification_model
                ->set_notify_by($this->notify_by)
                ->set_notify_to($this->notify_to)
                ->set_notification_description($this->notification_description)
                ->set_notification_type($this->notification_type)
                ->save();

        // save notification type 
        $this->notification_model->set_insert_id()
                ->set_notification_type_info_id($this->notification_type_id)
                ->save_type_info();
        return $this;
    }

    /*
      -----------@@@RIPON@ End view payment Part----------------------------------
     */

    public function pay_payment() {
        // Right Sidebar Content Information
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'my_billing';

        $person_id = $this->session->userdata('user_id');
        $data['student_info'] = $this->profile_model->student_info_by_id($person_id);
        $data['main_content'] = $this->load->view('user/profile_view/dashboard/due_payment', $data, true);
        $this->load->view('user/master', $data);
    }

    public function total_expense() {
        // Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'my_billing';
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['student_info'] = $this->profile_model->student_info_by_id($person_id);
        $data['main_content'] = $this->load->view('user/profile_view/dashboard/total_expense', $data, true);
        $this->load->view('user/master', $data);
    }

    public function earning_invoice() {
        // Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'my_billing';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['student_info'] = $this->profile_model->student_info_by_id($person_id);
        $data['main_content'] = $this->load->view('user/profile_view/dashboard/earning_invoice', $data, true);
        $this->load->view('user/master', $data);
    }

    function set_data_for_view_earning($value) {
        $this->earning_data['course_data'][$value->payment_type_id] = $this->utility_model
                        ->set_single_row_info('course_name,url_id', 'tbl_course', ['course_id' => $value->payment_type_id])->get_single_row_info();

        if ($value->payment_currency == 1) {
            $this->earning_data['course_price'][$value->payment_type_id] = $value->unit_price;
        }
        if ($value->payment_currency == 2) {
            $this->earning_data['course_price'][$value->payment_type_id] = $this->tt_currency->set($value->unit_price, 'USD', 'BDT')->convert_currency()->get();
        }

        $this->earning_data['currency_sign'][$value->payment_type_id] = '&nbsp;&#x9f3;';
        $this->earning_data['url'][$value->payment_type_id] = $this->utility_model
                        ->set_single_row_info('url', 'tbl_url', ['url_id' => $this->earning_data['course_data'][$value->payment_type_id]->url_id])->get_single_row_info();
        $this->earning_data['total_student'][$value->payment_type_id] = $this->student_model->set_type($value->payment_type)->set_type_id($value->payment_type_id)->set_total_student_by_course_id()->get_result();
    }
    
    public function selected_user_total_payment_details() {
        // Right Sidebar Content Information

        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'my_billing';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;

        $person_id = $this->session->userdata('user_id');
        $data['student_info'] = $this->profile_model->student_info_by_id($person_id);
        $data['main_content'] = $this->load->view('user/profile_view/dashboard/student_total_payment_details', $data, true);
        $this->load->view('user/master', $data);
    }

    public function selected_user_total_payment_invoice_details() {
        // Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'my_billing';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['student_info'] = $this->profile_model->student_info_by_id($person_id);
        $data['main_content'] = $this->load->view('user/profile_view/dashboard/student_payment_details', $data, true);
        $this->load->view('user/master', $data);
    }

    public function course_student_list() {
        // Right Sidebar Content Information

        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'my_billing';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['student_info'] = $this->profile_model->student_info_by_id($person_id);
        $data['main_content'] = $this->load->view('user/profile_view/dashboard/student_list', $data, true);
        $this->load->view('user/master', $data);
    }

    /*
      -----------@@@RIPON@ Start view payment Part----------------------------------
     */

    /**
     * @Function            : my_billing 
     * @Used IN             : @function-'Self'     
     * @Description         : get earning videw
     * @Developed By        : Mahabub -A- Mawla
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 05-03-2016 04:28 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function my_earning() {
        // Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'my_billing';
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['main_content'] = $this->load->view('user/profile_view/dashboard/my_earning', $data, true);
        $this->load->view('user/master', $data);
    }

    /*
      -----------@@@RIPON@ End view Payment Part----------------------------------
     */
}
