<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of author
 *
 * @Md Mashqur Ul ALam
 * 
 * @for link functionality.
 */
class My_link extends CI_Controller {

//put your code here
    public function __construct() {
        parent::__construct();
        $this->load->model('map_model');
        $this->load->model('my_link_model');
    }

    /*
     * @Function            : get_link_detail- @function 
     * @Used IN             : @function-'/profile'  
     * @Description         : getting the linked user and pending request detail
      for profile My Link
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 23-10-2016 04:00 PM 
     * @Modified By         : Md. Delwar Hossain
     * @Modified DateTime   : 14-05-2017 12:30 PM   
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function get_link_detail() {
        if ($this->input->is_ajax_request()) {
            $profile_url = $this->input->post('profile_url');
            $person_id = $this->map_model->model_person_id_by_url($profile_url);
            if($this->session->person_id == $person_id){
                $data['logged_in_user'] = 'yes';
            }else{
                $data['logged_in_user'] = 'no';
            }
            if (isset($person_id)) {
                $pending_request_status = 3;
                $linked_request_status = 1;
                $pending_id_str = $this->my_link_model->get_pending_link_model($person_id, $pending_request_status);
                $linked_id_str = $this->my_link_model->get_linked_user_model($person_id, $linked_request_status);
                if (isset($pending_id_str)) {
                    $pending_id = array_unique(explode(',', $pending_id_str));
                    $pending_id_detail = $this->map_model->get_link_suggestion_details_model($pending_id);
                    $pending_requests = $this->organize_link_detail($pending_id_detail);
                    $data['sorted_pending_request'] = $this->sort_detail_by_recent($pending_id, $pending_requests);
                }
                if (isset($linked_id_str) && !empty($linked_id_str)) {
                    $linked_id = array_unique(explode(',', $linked_id_str));
                    $linked_id_detail = $this->map_model->get_link_suggestion_details_model($linked_id);
                    $linked_users = $this->organize_link_detail($linked_id_detail);
                    $data['sorted_linked_user'] = $this->sort_detail_by_recent($linked_id, $linked_users);
                }
                echo json_encode($data);
            } else {
                redirect('profile');
            }
        } else {
            redirect('profile');
        }
    }

    /*
     * @Function            : organize_link_detail @function 
     * @Used IN             : @function-'get_link_detail'  
     * @Description         : Organizes the details for link
     *                        based on provided link detail
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 23-11-16 12.23 AM
     * @Parameter           : $suggestion_detail
     * @Return              : Null   
     * @Status              : available      
     */

    public function organize_link_detail($suggestion_detail) {
        $suggestion = [];
        foreach ($suggestion_detail['person_name'] as $name_value) {
            $array_key = $name_value->person_id;
            $suggestion[$array_key]['person_id'] = $name_value->person_id;
            //$first_name = $name_value->person_first_name . ' ' . $name_value->person_last_name;
            $first_name = $name_value->person_first_name;
            $last_name = $name_value->person_last_name;
            if(strlen($first_name) && strlen($last_name) < 40){
                $name = $first_name . ' ' . $last_name;                
            }
            else{
                $name = substr($first_name, 0, 30).' '.substr($last_name, 0, 20);                
            }           
            $suggestion[$array_key]['person_full_name'] = $name;
            $suggestion[$array_key]['person_image'] = $name_value->person_image_thumb;
            //iterate through the url info for person url
            foreach ($suggestion_detail['url_info'] as $url_value) {
                if ($url_value->url_id == $name_value->url_id) {
                    $suggestion[$array_key]['person_url'] = $url_value->url;
                }
            }

            // Checks person work detail exist or not
            if ($suggestion_detail['person_work']) {
                foreach ($suggestion_detail['person_work'] as $work_value) {
                    // checking work details exist for the certain id or not
                    if ($work_value->person_id == $array_key) {
                        //checking currently work here status
                        if ($work_value->work_currently_here == 2) {
                            $suggestion[$array_key]['current_company_name'] = $work_value->company_name;
                            $suggestion[$array_key]['current_designation'] = $work_value->designation;
                        } else {
                            $suggestion[$array_key]['company_name'] = $work_value->company_name;
                            $suggestion[$array_key]['designation'] = $work_value->designation;
                        }
                    }
                }
            }
            if ($suggestion_detail['person_education']) {
                foreach ($suggestion_detail['person_education'] as $education_value) {
                    // checking education details exist for the certain id or not
                    if ($education_value->person_id == $array_key) {
                        //checking currrent education institute
                        if ($education_value->person_current_education_instute == 1) {
                            $edu_ins_id = $education_value->education_institute_id;
                            foreach ($suggestion_detail['education_institute'] as $edu_ins_value) {
                                if ($edu_ins_value->education_institute_id == $edu_ins_id) {
                                    $suggestion[$array_key]['current_edu_ins'] = $edu_ins_value->education_institute_name;
                                }
                            }
                        } else {
                            $edu_ins_id = $education_value->education_institute_id;
                            foreach ($suggestion_detail['education_institute'] as $edu_ins_value) {
                                if ($edu_ins_value->education_institute_id == $edu_ins_id) {
                                    $suggestion[$array_key]['edu_ins'] = $edu_ins_value->education_institute_name;
                                }
                            }
                        }
                    }
                }
            }
        }
        return $suggestion;
    }

    /*
     * @Function            : check_suggestion @function 
     * @Used IN             : @function-'sort_detail_by_recent'  
     * @Description         : checks data for current education and work info
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 28-11-16 01.48 PM
     * @Parameter           : $suggestion_sorted
     * @Return              : Null   
     * @Status              : available      
     */

    public function check_suggestion($suggestion_sorted) {        
        $suggestion = array_values($suggestion_sorted);
        $output = [];
        $max_key = count($suggestion);
        for ($i = 0; $i < $max_key; $i++) {
            $output[$i]['person_id'] = $suggestion[$i]['person_id'];
            $output[$i]['person_full_name'] = $suggestion[$i]['person_full_name'];
            $output[$i]['person_image'] = $suggestion[$i]['person_image'];
            $output[$i]['person_url'] = $suggestion[$i]['person_url'];

            if (isset($suggestion[$i]['current_company_name'])) {
                $output[$i]['organization_name'] = $suggestion[$i]['current_company_name'];
                $output[$i]['designation'] = $suggestion[$i]['current_designation'];
            } elseif (isset($suggestion[$i]['company_name'])) {
                $output[$i]['organization_name'] = $suggestion[$i]['company_name'];
                $output[$i]['designation'] = $suggestion[$i]['designation'];
            } elseif (isset($suggestion[$i]['current_edu_ins'])) {
                $output[$i]['organization_name'] = $suggestion[$i]['current_edu_ins'];
                $output[$i]['designation'] = 'Student';
            } elseif (isset($suggestion[$i]['edu_ins'])) {
                $output[$i]['organization_name'] = $suggestion[$i]['edu_ins'];
                $output[$i]['designation'] = 'Student';
            }
        }        
        return $output;
    }

    /*
     * @Function            : sort_detail_by_recent @function 
     * @Used IN             : @function-'get_link_detail'  
     * @Description         : sort array according to another array value
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 23-11-16 02.30 PM
     * @Parameter           : $sorted_id, $detail_array
     * @Return              : Null   
     * @Status              : available      
     */

    public function sort_detail_by_recent($sorted_id, $detail_array) {
        if((isset($sorted_id) && !empty($sorted_id)) && (isset($detail_array) && !empty($detail_array))){
            foreach ($sorted_id as $key_value) {
                if(array_key_exists($key_value, $detail_array)){
                    $suggestion_sorted[$key_value] = $detail_array[$key_value];
                }
            } 
        }
        $output = $this->check_suggestion($suggestion_sorted);        
        return $output;
    }

    /*
     * @Function            : delete_link @function 
     * @Used IN             : delete-link [routes]  
     * @Description         : delete or unlink link
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 24-11-16 04.30 PM
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function delete_link() {
        if ($this->input->is_ajax_request()) {
            $link_status = 2;
            $requested_person_id = $this->session->person_id;
            $profile_url = $this->input->post('profile_url');
            $person_id = $this->map_model->model_person_id_by_url($profile_url);
            if (isset($person_id) && isset($requested_person_id)) {
                $this->my_link_model->model_change_link_status($requested_person_id, $person_id, $link_status);
            }
        } else {
            redirect('profile');
        }
    }

    /*
     * @Function            : block_link @function 
     * @Used IN             : block-link [routes]  
     * @Description         : Block Link
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 24-11-16 05.30 PM
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function block_link() {
        if ($this->input->is_ajax_request()) {
            $link_status = 5;
            $requested_person_id = $this->session->person_id;
            $profile_url = $this->input->post('profile_url');
            $person_id = $this->map_model->model_person_id_by_url($profile_url);
            if (isset($person_id) && isset($requested_person_id)) {
                $this->my_link_model->model_change_link_status($requested_person_id, $person_id, $link_status);
            }
        } else {
            redirect('profile');
        }
    }

    /*
     * @Function            : accept_link_request @function 
     * @Used IN             : block-link [routes]  
     * @Description         : Block Link
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 24-11-16 05.30 PM
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function accept_link_request() {
        if ($this->input->is_ajax_request()) {
            $link_status = 1;
            $person_id = $this->session->person_id;
            $profile_url = $this->input->post('profile_url');
            $requested_person_id = $this->map_model->model_person_id_by_url($profile_url);
            if (isset($person_id) && isset($requested_person_id)) {
                $link_request_id = $this->my_link_model->model_change_link_status($requested_person_id, $person_id, $link_status);
                $this->notification_dashboard_model->save_accept_request_notification($person_id, $requested_person_id, $link_request_id);
            }
        } else {
            redirect('profile');
        }
    }

    /*
     * @Function            : my_link_suggestion @function 
     * @Used IN             : My Link  
     * @Description         : gets the suggested link for my link
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 26-11-16 11.57 AM
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function my_link_suggestion() {
        if ($this->input->is_ajax_request()) {
            $person_id = $this->session->person_id;
            $link_id = $this->map_model->get_link_requested_id_model($person_id);
            if (isset($link_id)) {
                foreach ($link_id as $value) {
                    if ($value->person_id !== $person_id) {
                        $linked_person[] = $value->person_id;
                    }
                    if ($value->requested_person_id) {
                        $linked_person[] = $value->requested_person_id;
                    }
                }
                if(isset($linked_person)){
                    $escape_id = array_unique($linked_person);
                }else{
                    $linked_person = [];
                    $escape_id = array_unique($linked_person);
                }
            }

            $work = $this->my_link_model->get_edu_work_info_model('tbl_person_work_details', 'company_name', $person_id);
            $edu = $this->my_link_model->get_edu_work_info_model('tbl_person_education_details', 'education_institute_id', $person_id);
            $work_id = $this->my_link_model->get_all_edu_work_suggestion_id('tbl_person_work_details', 'company_name', explode(',', $work), $person_id);
            $edu_id = $this->my_link_model->get_all_edu_work_suggestion_id('tbl_person_education_details', 'education_institute_id', explode(',', $edu), $person_id);
            $temp_suggestion = array_unique(array_merge(explode(',', $work_id), explode(',', $edu_id)));
            $suggestion_id = array_diff($temp_suggestion, $escape_id);
            if(isset($suggestion_id) && !empty($suggestion_id)){
                $suggestion_detail = $this->map_model->get_link_suggestion_details_model($suggestion_id);
            }
            if (isset($suggestion_detail) && is_array($suggestion_detail)) {
                $suggestion = array_values($this->organize_link_detail($suggestion_detail));
                $output = $this->check_suggestion($suggestion);
                echo json_encode($output);
            } else {
                echo json_encode('');
            }
        } else {
            redirect('profile');
        }
    }

}
