<?php

/**
 * Description of Migrate
 *
 * @author User
 */
class Migrate extends CI_Controller {

    public function __construct() {
        parent::__construct();

        // can only be called from the command line
//        if (!$this->input->is_cli_request()) {
//            exit('Direct access is not allowed. This is a command line tool, use the terminal');
//        }

        $this->load->dbforge();
        $this->load->library('migration');
    }

    /**
     * @Description         : view message
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-01-2017 11:19 AM   
     * */
    public function message($to = 'World') {
        echo "Hello {$to}!" . PHP_EOL;
    }

    /**
     * @Description         : create new migrate file for create table 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-01-2017 11:20 AM   
     * @Parameter           : $tbl_name (pass parameter as table name)
     * */
    public function make_migration($tbl_name) {
        $date = new DateTime();
        $timestamp = $date->format('YmdHis');
        $table_name = strtolower($tbl_name);

        if (empty($this->db->table_exists($tbl_name))) {
            $path = APPPATH . 'migrations' . '/' . $timestamp . "_" . "$table_name.php";

            if (!file_exists($path)) {
                $my_migration = fopen($path, "w") or die("Unable to create migration file!");
                $txt = $this->file_data($table_name);
                fwrite($my_migration, $txt);
                fclose($my_migration);
                echo 'Migration file created successfully';
            } else {
                echo 'Migration file already exists';
            }
        } else {
            echo 'Migration file "' . $table_name . '" already exists';
        }
    }

    /**
     * @Description         : run migration file 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-01-2017 11:35 AM   
     * @Parameter           : $version (check version for create/rollback/update)
     * */
    private $migration_tbl_error;
    private $migration_field_error = [];

    function run_migration() {
        // get all migration file which is created by DB table name
        $all_migration_file = $this->migration->find_migrations();
        foreach ($all_migration_file as $key => $value) {
            // get table name from migrate file path
            $tbl_name = str_replace($key . '_', '', pathinfo(basename($value), PATHINFO_FILENAME));
            // if table does not exists then create new table
            if (empty($this->db->table_exists($tbl_name))) {
                $this->update_table_into_database($tbl_name);
            }

            // if table does exists then Update this table
            if (!empty($this->db->table_exists($tbl_name))) {
                $this->update_field_into_table($tbl_name);
            }
        }

        // print all message
        $this->print_message();
    }

    /**
     * @Description         : print migration status message
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-01-2017 01:02 AM   
     * */
    function print_message() {
        echo '<pre>';
        print_r($this->migration_tbl_error);
        echo '<pre>';
        print_r($this->migration_field_error);
    }

    /**
     * @Description         : update table in database
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-01-2017 12:02 AM   
     * */
    function update_table_into_database($tbl_name) {
        if ($this->migration->latest() === FALSE) {
            $this->migration_tbl_error = $this->migration->error_string();
        } else {
            $this->migration_tbl_error = 'Table : "' . $tbl_name . '" Created successfully' . PHP_EOL;
        }
    }

    /**
     * @Description         : update field into table 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-01-2017 12:02 PM   
     * */
    function update_field_into_table($tbl_name) {
        if ($this->migration->current() === FALSE) {
            $this->migration_field_error[] = $this->migration->error_string();
        } else {
            $this->migration_field_error[] = 'Table : "' . $tbl_name . '" Updated successfully' . PHP_EOL;
        }
    }

    /**
     * @Description         : view migration class
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-01-2017 05:03 PM   
     * */
    function file_data($table_name) {
        $tbl_name = ucfirst($table_name);
        return "<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_$tbl_name extends TT_migration {
const table_name = '$table_name';

    public function up() {}
    
    public function down() {}
}";
    }

}
