<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of author
 *
 * @Monower Jahan
 * 
 * @for map functions.
 */
//session_start();

class Map extends TT_user_login {

//put your code here
    public function __construct() {
        parent::__construct();        
        $this->load->model('map_model');        
    }
    

    /*
     * @Function            : change_current_location- @function 
     * @Used IN             : @function-'/change-current-location'  
     * @Description         : updating the current location of user
     * @Developed By        : Md Mashqur Ul Alam  
     * @Start DateTime      : 23-10-2016 04:00 PM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function change_current_location() {
        if ($this->input->is_ajax_request()) {
            //$person_id = $this->session->person_id;
            $person_url = $this->input->post('profile_url');
            $person_id = $this->map_model->model_person_id_by_url($person_url);
            if (isset($person_id)) {
                $current_geo_info = $this->map_model->get_current_geo_location_model($person_id);

                $current_lat_lng = $current_geo_info->person_current_latitude_longitude;
                $new_lat_lng = $this->input->post('geoLocation');

                if (!$current_lat_lng) {
                    $this->map_model->update_profile_location_model($person_id);
                    echo '<i class="fa fa-check text-success" aria-hidden="true"> Your Current Location is saved successfully !</i>';
                } else if ($current_lat_lng == $new_lat_lng) {
                    echo '<i class="fa fa-bell text-success" aria-hidden="true"> This Location is Already Your Current Location !</i>';
                } else {
                    $this->map_model->update_profile_location_model($person_id);
                    //echo '<i class="fa fa-check text-info" aria-hidden="true"> Your Current Location is Updated successfully !</i>';
                }
            }
        } else {
            redirect('profile');
        }
    }

    /*
     * @Function            : get_current_location- @function 
     * @Used IN             : @function-'/get-current-location'  
     * @Description         : getting the existing current location of user
     * @Developed By        : Md Mashqur Ul Alam  
     * @Start DateTime      : 24-10-2016 09:30 AM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    function get_current_location() {
        if ($this->input->is_ajax_request()) {
            //$person_id = $this->session->userdata('person_id');
            $person_url = $this->input->post('profile_url');
            $person_id = $this->map_model->model_person_id_by_url($person_url);
            if (isset($person_id)) {
                $current_geo_info = $this->map_model->get_current_geo_location_model($person_id);
                echo json_encode($current_geo_info);
            } else {
                redirect('profile');
            }
        } else {
            redirect('profile');
        }
    }



    /*
     * @Function            : get_travel_location- @function 
     * @Used IN             : @function-'/travels'  
     * @Description         : getting the travel location info of user
     * @Developed By        : Md Mashqur Ul Alam  
     * @Start DateTime      : 31-10-2016 09:30 AM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function get_travel_location() {
        if ($this->input->is_ajax_request()) {
            //$person_id = $this->session->userdata('person_id');
            $person_url = $this->input->post('profile_url');
            $person_id = $this->map_model->model_person_id_by_url($person_url);
            if (isset($person_id)) {
                $geo_info_id = $this->map_model->get_geo_info_model($person_id);
                if ($geo_info_id) {
                    $geo_travel = explode(',', $geo_info_id->geo_information_id);
                    $travel_location['locations'] = $this->map_model->get_travel_location_model($geo_travel);
                    $travel_location['user_logged_in'] = ($person_id === $this->session->person_id)? 'yes' : 'no';
                    echo json_encode($travel_location);
                }
            }
        } else {
            redirect('profile');
        }
    }

    /*
     * @Function            : add_travel_location- @function 
     * @Used IN             : @function-'/add_current_location'  
     * @Description         : add new travel location of a user
     * @Developed By        : Md Mashqur Ul Alam  
     * @Start DateTime      : 31-10-2016 09:30 AM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function add_travel_location() {
        if ($this->input->is_ajax_request()) {
            //$person_id = $this->session->userdata('person_id');
            $person_url = $this->input->post('profile_url');
            $person_id = $this->map_model->model_person_id_by_url($person_url);
            if (isset($person_id)) {
                $geo_information_id = $this->map_model->add_new_geo_info_model();

                $user_geo_info_ids = $this->map_model->get_geo_info_model($person_id);

                if ($user_geo_info_ids) {
                    $existing_ids = $user_geo_info_ids->geo_information_id;
                }

                if ($user_geo_info_ids && $geo_information_id) {
                    $travel_location = array_unique(explode(',', $existing_ids));
                    if (in_array($geo_information_id, $travel_location)) {

                        //echo '<i class="fa fa-bell text-danger" aria-hidden="true"> Please Add New Travel Location!</i>';
                    } else {
                        $travel_location[] = $geo_information_id;
                        $updated_geo_info_id = implode(',', $travel_location);
                        $this->map_model->add_travel_location_model($person_id, $updated_geo_info_id);

                        echo '<i class="fa fa-check text-success" aria-hidden="true"> Your Travel Locations Updated successfully !</i>';
                    }
                } else if (!$user_geo_info_ids && $geo_information_id) {
                    $this->map_model->add_travel_location_model($person_id, $geo_information_id);

                    echo '<i class="fa fa-check text-success" aria-hidden="true"> Your Travel Location Saved successfully !</i>';
                }
            }
        } else {
            redirect('profile');
        }
    }

    /*
     * @Function            : remove_travel_location @function 
     * @Used IN             : @function-'/remove-travel-location'  
     * @Description         : removes the selected travel location of a user
     * @Developed By        : Md Mashqur Ul Alam  
     * @Start DateTime      : 02-11-2016 05:02 PM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function remove_travel_location() {
        if ($this->input->is_ajax_request()) {
            //$person_id = $this->session->userdata('person_id');
            $person_url = $this->input->post('profile_url');
            $person_id = $this->map_model->model_person_id_by_url($person_url);
            if (isset($person_id)) {
                $remove_geo_id[] = $this->input->post('geoId');
                $geo_info_id = $this->map_model->get_geo_info_model($person_id);
                if ($geo_info_id) {
                    $geo_travel = explode(',', $geo_info_id->geo_information_id);
                    $geo_information_id = array_diff($geo_travel, $remove_geo_id);
                    $updated_geo_id = implode(',', $geo_information_id);

                    $this->map_model->add_travel_location_model($person_id, $updated_geo_id);

                    echo 'Status Ok';
                }
            }
        } else {
            redirect('profile');
        }
    }

   

    /*
     * @Function            : get_link_location @function 
     * @Used IN             : @function-'get-link-location'  
     * @Description         : gets the locations of the user linked with
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 07-11-16 11.00AM
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function get_link_location() {
        if ($this->input->is_ajax_request()) {
            $linked_person = [];
            //$person_id = $this->session->userdata('person_id');
            $person_url = $this->input->post('profile_url');
            $person_id = $this->map_model->model_person_id_by_url($person_url);
            $linked_person_ids = $this->map_model->get_linked_users_id_model($person_id);
            if (isset($linked_person_ids)) {
                foreach ($linked_person_ids as $value) {
                    if ($value->person_id != $person_id) {
                        $linked_person[] = $value->person_id;
                    }
                    if ($value->requested_person_id != $person_id) {
                        $linked_person[] = $value->requested_person_id;
                    }
                }
                $result = $this->map_model->get_linked_locations_model(array_unique($linked_person));
                echo json_encode($result);
            }
        } else {
            redirect('/profile');
        }
    }

    /*
     * @Function            : organize_suggestion @function 
     * @Used IN             : @function-'get-link-suggestion_A, get-link-suggestion_B'  
     * @Description         : Organizes the suggestions for link suggestion
     *                        based on provided suggestion detail
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 10-11-16 11.10 AM
     * @Parameter           : $suggestion_detail
     * @Return              : Null   
     * @Status              : available      
     */

    public function organize_suggestion($suggestion_detail) {
        foreach ($suggestion_detail['person_name'] as $name_value) {
            $array_key = $name_value->person_id;
            $suggestion[$array_key]['person_id'] = $name_value->person_id;
            $suggestion[$array_key]['person_full_name'] = $name_value->person_first_name . ' ' . $name_value->person_last_name;
            $suggestion[$array_key]['person_image'] = $name_value->person_image_thumb;
            //iterate through the url info for person url
            foreach ($suggestion_detail['url_info'] as $url_value) {
                if ($url_value->url_id == $name_value->url_id) {
                    $suggestion[$array_key]['person_url'] = $url_value->url;
                }
            }

            // Checks person work detail exist or not
            if ($suggestion_detail['person_work']) {
                foreach ($suggestion_detail['person_work'] as $work_value) {
                    // checking work details exist for the certain id or not
                    if ($work_value->person_id == $array_key) {
                        //checking currently work here status
                        if ($work_value->work_currently_here == 2) {
                            $suggestion[$array_key]['current_company_name'] = $work_value->company_name;
                            $suggestion[$array_key]['current_designation'] = $work_value->designation;
                        } else {
                            $suggestion[$array_key]['company_name'] = $work_value->company_name;
                            $suggestion[$array_key]['designation'] = $work_value->designation;
                        }
                    }
                }
            }
            // Checks person education detail exist or not
            if ($suggestion_detail['person_education']) {
                foreach ($suggestion_detail['person_education'] as $education_value) {
                    // checking education details exist for the certain id or not
                    if ($education_value->person_id == $array_key) {
                        //checking currrent education institute
                        if ($education_value->person_current_education_instute == 1) {
                            $edu_ins_id = $education_value->education_institute_id;
                            foreach ($suggestion_detail['education_institute'] as $edu_ins_value) {
                                if ($edu_ins_value->education_institute_id == $edu_ins_id) {
                                    $suggestion[$array_key]['current_edu_ins'] = $edu_ins_value->education_institute_name;
                                }
                            }
                        } else {
                            $edu_ins_id = $education_value->education_institute_id;
                            foreach ($suggestion_detail['education_institute'] as $edu_ins_value) {
                                if ($edu_ins_value->education_institute_id == $edu_ins_id) {
                                    $suggestion[$array_key]['edu_ins'] = $edu_ins_value->education_institute_name;
                                }
                            }
                        }
                    }
                }
            }
        }

        // limiting the maximum randon suggestion to 24
        $suggestion_k_sort = array_values($suggestion);
        $length = count($suggestion_k_sort) - 1;

        for ($i = 0; $i < 24; $i++) {
            $s_key = rand(0, $length);
            $f_suggestion[$i] = $suggestion_k_sort[$s_key];
        }
        // gets the unique array element in multidimensional array
        $output = array_map("unserialize", array_unique(array_map("serialize", $f_suggestion)));

        return $output;
    }

    /*
     * @Function            : get_link_suggestion_current_location @function 
     * @Used IN             : @function-'get-link-suggestion'  
     * @Description         : creates suggestion based on current location
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 08-11-16 09.30AM
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function get_link_suggestion_current_location() {
        //$person_id = $this->session->userdata('person_id');
        $person_url = $this->input->post('profile_url');
        $person_id = $this->map_model->model_person_id_by_url($person_url);
        //get the person current city using person id
        $person_current_location = $this->map_model->get_current_geo_location_model($person_id);
        $person_city = $person_current_location->person_city;
        //get the ids of persons who are in link or requested link
        $link_id = $this->map_model->get_link_requested_id_model($person_id);
        foreach ($link_id as $value) {
            $linked_person[] = $value->person_id;
            $linked_person[] = $value->requested_person_id;
        }
        if (isset($linked_person)) {
            $escape_id = array_unique($linked_person);
        } else {
            $escape_id[] = $person_id;
        }
        //gets the list of ids which are going to be in suggestion list based on person current city
        $suggestion_id = $this->map_model->get_suggestion_id_model($person_city);
        foreach ($suggestion_id as $value) {
            $suggestion_id_list[] = $value->person_id;
        }

        if (isset($suggestion_id_list) && isset($escape_id)) {
            $suggestion_A_id = array_diff($suggestion_id_list, $escape_id);
        } else {
            $suggestion_A_id = $suggestion_id_list;
        }

        if (isset($suggestion_A_id)) {
            return $suggestion_A_id;
        } else {
            $output = [];
            return $output;
        }
    }

    /*
     * @Function            : get_link_suggestion_travel_location @function 
     * @Used IN             : @function-'get-link-suggestion'  
     * @Description         : creates suggestion based on travel locations
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 09-11-16 03.00PM
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available
     */

    public function get_link_suggestion_travel_location() {
        // geting the travel Locations of the user
        //$person_id = $this->session->userdata('person_id');
        $person_url = $this->input->post('profile_url');
        $person_id = $this->map_model->model_person_id_by_url($person_url);
        $geo_info_id = $this->map_model->get_geo_info_model($person_id);
        if ($geo_info_id) {
            $geo_travel = explode(',', $geo_info_id->geo_information_id);
            $travel_location = $this->map_model->get_travel_location_model($geo_travel);
            //get the person current city using person id
            $person_current_location = $this->map_model->get_current_geo_location_model($person_id);
            $person_city = $person_current_location->person_city;
            //creating array list of travel city
            foreach ($travel_location as $travel_value) {
                if ($travel_value->geo_city_name != $person_city) {
                    $travel_city[] = $travel_value->geo_city_name;
                }
            }

            //get the ids of persons who are in link or requested link
            $link_id = $this->map_model->get_link_requested_id_model($person_id);
            foreach ($link_id as $value) {
                $linked_person[] = $value->person_id;
                $linked_person[] = $value->requested_person_id;
            }
            if (isset($linked_person)) {
                $escape_id = array_unique($linked_person);
            } else {
                $escape_id[] = $person_id;
            }

            //get users id for suggestion based on travel city
            $suggestion_id = $this->map_model->get_suggestion_id_model($travel_city);
            foreach ($suggestion_id as $value) {
                $suggestion_id_list[] = $value->person_id;
            }

            if (isset($suggestion_id_list) && isset($escape_id)) {
                $suggestion_B_id = array_diff($suggestion_id_list, $escape_id);
            } else {
                $suggestion_B_id = $suggestion_id_list;
            }

            if (isset($suggestion_B_id)) {
                return $suggestion_B_id;
            } else {
                $output = [];
                return $output;
            }
        }
    }

    /*
     * @Function            : get_link_suggestion @function 
     * @Used IN             : @function-'blockPersonLink'  
     * @Description         : creates suggestion based on travel locations
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 09-11-16 05.33PM
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available
     */

    public function get_link_suggestion() {
        if ($this->input->is_ajax_request()) {

            $output = [];
            $suggestion_id = array_merge($this->get_link_suggestion_current_location(), $this->get_link_suggestion_travel_location());
            $suggestion_detail = $this->map_model->get_link_suggestion_details_model($suggestion_id);
            $suggestion = array_values($this->organize_suggestion($suggestion_detail));


            $max_key = count($suggestion);

            for ($i = 0; $i < $max_key; $i++) {

                $output[$i]['person_id'] = $suggestion[$i]['person_id'];
                $output[$i]['person_full_name'] = $suggestion[$i]['person_full_name'];
                $output[$i]['person_image'] = $suggestion[$i]['person_image'];
                $output[$i]['person_url'] = $suggestion[$i]['person_url'];

                if (isset($suggestion[$i]['current_company_name'])) {
                    $output[$i]['organization_name'] = $suggestion[$i]['current_company_name'];
                    $output[$i]['designation'] = $suggestion[$i]['current_designation'];
                } elseif (isset($suggestion[$i]['company_name'])) {
                    $output[$i]['organization_name'] = $suggestion[$i]['company_name'];
                    $output[$i]['designation'] = $suggestion[$i]['designation'];
                } elseif (isset($suggestion[$i]['current_edu_ins'])) {
                    $output[$i]['organization_name'] = $suggestion[$i]['current_edu_ins'];
                    $output[$i]['designation'] = 'Student';
                } elseif (isset($suggestion[$i]['edu_ins'])) {
                    $output[$i]['organization_name'] = $suggestion[$i]['edu_ins'];
                    $output[$i]['designation'] = 'Student';
                }
            }
            echo json_encode($output);
        } else {
            redirect('profile');
        }
    }

    /*
     * @Function            : block_person_link @function 
     * @Used IN             : @function-'get-link-suggestion'  
     * @Description         : Block a person from link suggestion
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 11-11-16 05.00PM
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available
     */

    public function block_person_link() {
        if ($this->input->is_ajax_request()) {
            //$person_id = $this->input->post('person_id');
            $person_url = $this->input->post('profile_url');
            $person_id = $this->map_model->model_person_id_by_url($person_url);
            $resquest_person_id = $this->session->userdata('person_id');
            if ($person_id && $resquest_person_id) {
                $this->map_model->block_person_link_model($person_id, $resquest_person_id);
            }
        } else {
            redirect('/link_location');
        }
    }

    /*
     * @Function            : connect_connectivity_suggested_user
     * @Used IN             : @function-'connect-connectivity-suggested-user'  
     * @Description         : Block a person from link suggestion
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 11-11-16 05.00PM
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available
     */

    public function connect_suggested_user() {

        if ($this->input->is_ajax_request()) {
            //$person_id = $this->input->post('request_to_person_id');
            $requested_person_id = $this->session->userdata('person_id');            
            $person_url = $this->input->post('profile_url');
            $person_id = $this->map_model->model_person_id_by_url($person_url);

            $data['person_id'] = $person_id;
            $data['requested_person_id'] = $requested_person_id;            
            $time = date('Y/m/d H:i:s', (time()));
            $data['add_link_requested_date_time'] = $time;
            $data['add_link_request_status'] = 3;
            $link_request_id = $this->map_model->send_link_request($data);
            $this->notification_dashboard_model->save_send_link_request_notification($person_id, $requested_person_id, $link_request_id);
        } else {
            redirect('/link_location');
        }
    }   

}
