<?php 

/**
 * Description of Manage Video Meta
 *
 * @author User
 */
class Manage_video_course_meta extends TT_admin_login {

    public function __construct() {
        parent::__construct();
        $this->load->model('manage_video_course_meta_model');
    }
   /*
     * @Author              : Kazol
     * @CreatedDate         : 16-09-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : manage-video-course-meta/(.+)
     * @Description         : This function is used for viewing the add_meta form and manage all meta
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : 
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function add_video_course_meta($video_course_id){
        $data = array();
        $data['active_menu'] = 'video_course_back_end';
        $data['active_sub_menu'] = 'manage_video_course_back_end';
        $this->manage_video_course_meta_model->add_video_course_meta_info($video_course_id);
        redirect('manage-video-course-meta/'.$video_course_id);
        
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 16-09-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : manage-video-course-meta/(.+)
     * @Description         : This function is used for getting all meta information
     * @view                : video_course/video_course_back_end/view_add_meta_back_end
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : 
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function manage_video_course_meta($video_course_id){
        $data = array();
        $data['active_menu'] = 'video_course_back_end';
        $data['active_sub_menu'] = 'manage_video_course_back_end';
        $data['video_course_id'] = $video_course_id;
        $data['meta_information'] = $this->manage_video_course_meta_model->manage_video_course_meta_info($video_course_id);
        $data['main_content'] = $this->load->view('manage_video_course_meta/add_video_course_meta', $data, true);
        $this->load->view('admin/admin_master', $data);
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 16-09-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : edit-video-course-meta/(.+)
     * @Description         : This function is used for edit video course meta information
     * @view                : manage_video_course_meta/edit_video_course_meta
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : 
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function edit_video_course_meta($video_course_id){
        $data = array();
        $data['active_menu'] = 'video_course_back_end';
        $data['active_sub_menu'] = 'manage_video_course_back_end';
        $data['video_course_id'] = $video_course_id;
        $data['meta_information'] = $this->manage_video_course_meta_model->edit_video_course_meta_info($video_course_id);
        $data['meta_keywords'] = $this->manage_video_course_meta_model->get_meta_keywords_for_edit_meta($video_course_id);
        //$this->cf->dd($data['meta_keywords']);
        $data['main_content'] = $this->load->view('manage_video_course_meta/edit_video_course_meta', $data, true);
        $this->load->view('admin/admin_master', $data);
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 16-09-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : update-video-course-meta/(.+)
     * @Description         : This function is used for update video course meta information
     * @view                : manage_video_course_meta/edit_video_course_meta
     * @redirect            : manage-video-course-meta/'.$video_course_id
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : 
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function update_video_course_meta($video_course_id){
        $data = array();
        $data['active_menu'] = 'video_course_back_end';
        $data['active_sub_menu'] = 'manage_video_course_back_end';
        $data['video_course_id'] = $video_course_id;
        $this->manage_video_course_meta_model->update_video_course_meta_info($video_course_id);
        redirect('manage-video-course-meta/'.$video_course_id);
        
    }
    
 
}




