<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Manage_section
 *
 * @author Talha Training
 */
class Manage_section extends TT_admin_login {
    public function __construct() {
        parent::__construct();
        $this->load->model('Manage_video_section_model');
        $this->load->model('manage_admin_video_model');
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 27-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for manage section
 * @view                : manage_video_section/add_video_section
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $video_course_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function manage_video_section($video_course_id){
        $data = array();
        $data['active_menu'] = 'video_course_back_end';
        $data['active_sub_menu'] = 'manage_video_course_back_end';
        
        //$data['all_section_info'] = $this->Manage_video_section_model->manage_video_section_info($video_course_id);
        //$this->cf->dd($data['all_section_info']);
        $data['video_course_id'] = $video_course_id;
        $data['main_content'] = $this->load->view('manage_video_section/add_video_section', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 27-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for add section
 * @view                : manage_video_section/ajax_page/manage_video_section
 * @redirect            : manage-video-section
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $video_course_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function add_video_section(){
        if($this->input->is_ajax_request()){
            $data['section_name'] = $this->input->post('section_name');
            if($data['section_name'] == ''){
                echo 'no_section';
            }else{
                $video_course_id = $this->input->post('video_course_id');
                $section_name_found = $this->Manage_video_section_model->check_video_section_exist($data['section_name'], $video_course_id);
                if($section_name_found == 'Table not exits'){
                    echo 'no_table';
                }else{
                    if($section_name_found){
                        echo 'section_name_exist';
                    }else{
                        $data['person_id'] = $this->input->post('person_id');
                        $data['section_name'] = $this->input->post('section_name');
                        $data['section_type'] = 1;
                        $data['section_type_id'] = $this->input->post('video_course_id');
                        $sdata['serial'] = 0;
                        $sdata['page_number'] = 1;
                        $page_number = 1;
                        $limit_offset = NULL;
                        $this->Manage_video_section_model->add_video_section_info($data);
                        $sdata['all_data'] = $this->Manage_video_section_model->manage_video_section_info($data['section_type_id'], $limit_offset);
                        $total_row = $sdata['all_data']['count_data'];
                        $params = array('url' => '', 'div_id' => 'video_course_section_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
                        $sdata['video_course_section_pagination'] = $this->tt_pagination->view_pagination_link($params);
                        echo $this->load->view('manage_video_section/ajax_page/manage_video_section', $sdata, TRUE);
                    }
                }
                
            }
        }else{
            redirect('manage-video-section');
        }
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 05-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for edit section
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function edit_video_section(){
        if($this->input->is_ajax_request()){
            $section_id = $this->input->post('section_id');
            $section_info = $this->Manage_video_section_model->edit_video_section_info($section_id);
            if($section_info == 'Table not exits'){
                echo 'no_table';
            }else{
            //$this->cf->dd($section_info);
            $result = json_encode($section_info);
            echo $result;
            }
        }
        
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 06-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for selecting all section for managing by ajax 
 * @view                : manage_video_section/ajax_page/manage_video_section
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function manage_video_section_by_ajax(){
        if($this->input->is_ajax_request()){
            $video_course_id = $this->input->post('video_course_id');
            $data['video_course_id'] = $video_course_id;
            $data['serial'] = 0;
            $limit_offset = 0;
            $page_number = 1;
            $data['page_number'] = $page_number;
            $data['all_data'] = $this->Manage_video_section_model->manage_video_section_info($video_course_id, $limit_offset);
            if($data['all_data'] == 'Table not exits'){
                echo 'no_table';
            }else{
                $total_row = $data['all_data']['count_data'];
                $params = array('url' => '', 'div_id' => 'video_course_section_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
                $data['video_course_section_pagination'] = $this->tt_pagination->view_pagination_link($params);
                echo $this->load->view('manage_video_section/ajax_page/manage_video_section', $data, TRUE);
            }
        }
    }
  /*
 * @Author              : Kazol 
 * @CreatedDate         : 06-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for update video course section
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function update_video_section(){
        if($this->input->is_ajax_request()){
            $section_name = $this->input->post('section_name');
            if($section_name == ''){
                echo 'no_section';
            }else{
                $section_id = $this->input->post('section_id');
                $video_course_id = $this->input->post('video_course_id');
                $result = $this->Manage_video_section_model->check_edit_section_exist($section_name, $section_id, $video_course_id);
                if($result == 'Table not exits'){
                    echo 'no_table';
                }else{
                    if($result){
                    $this->other_section_data($section_name, $section_id, $video_course_id);
                    }else{
                        $section_id = $this->input->post('section_id');
                        $video_course_id = $this->input->post('video_course_id');
                        $result = $this->Manage_video_section_model->check_video_section_exist($section_name, $video_course_id);
                        if($result){
                            echo 'found';
                        }else{
                            $this->other_section_data($section_name, $section_id, $video_course_id);
                        }
                    }
                }
                
            }
        }
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 07-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for update video course section because it is used in 
  *                       update_video_section function
 * @view                : manage_video_section/ajax_page/manage_video_section
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function other_section_data($section_name, $section_id, $video_course_id) {
        $search_value = $this->input->post('search_input');
        $page_number = $this->input->post('page_number');

        $limit_offset = ($page_number*10)-10;
        $data['page_number'] = $page_number;
        $data['serial'] = $limit_offset;
        $sdata['section_name'] = $section_name;
        $this->Manage_video_section_model->update_video_section_info($section_id, $sdata);
        if($search_value != ''){
            $data['all_data'] = $this->Manage_video_section_model->search_video_section_info($search_value, $video_course_id, $limit_offset);
        }else{
            $data['all_data'] = $this->Manage_video_section_model->manage_video_section_info($video_course_id, $limit_offset);
        }
        $total_row = $data['all_data']['count_data'];
        $params = array('url' => '', 'div_id' => 'video_course_section_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['video_course_section_pagination'] = $this->tt_pagination->view_pagination_link($params);
        echo $this->load->view('manage_video_section/ajax_page/manage_video_section', $data, TRUE); 
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 06-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for paginating video section
 * @view                : manage_video_section/ajax_page/manage_video_section
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_name, $section_id, $video_course_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function pagination_video_section(){
        if($this->input->is_ajax_request()){
            $video_course_id = $this->input->post('video_course_id');
            $page_number = $this->input->post('page_number');
            $data['page_number'] = $page_number;
            $limit_offset = ($page_number*10)-10;
            $data['serial'] = $limit_offset;
            $data['all_data'] = $this->Manage_video_section_model->manage_video_section_info($video_course_id, $limit_offset);
            $total_row = $data['all_data']['count_data'];
            $params = array('url' => '', 'div_id' => 'video_course_section_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['video_course_section_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('manage_video_section/ajax_page/manage_video_section', $data, TRUE);
        }
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 06-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for pagination of search video course section
 * @view                : manage_video_section/ajax_page/search_video_section_pagination
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function search_video_section(){
        if($this->input->is_ajax_request()){
            $search_value = $this->input->post('search_input');
            $video_course_id = $this->input->post('video_course_id');
            
            $page = $this->input->post('page_number', TRUE);
            $page_number = isset($page) ? $page : 1 ;
            $limit_offset = ($page_number - 1) * 10;
            $data['page_number'] = $page_number;
            
            $data['serial'] = $limit_offset;
            $data['all_data'] = $this->Manage_video_section_model->search_video_section_info($search_value, $video_course_id, $limit_offset);
            $total_row = $data['all_data']['count_data'];
            $params = array('url' => '', 'div_id' => 'video_course_section_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['video_course_section_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('manage_video_section/ajax_page/search_video_section_pagination', $data, TRUE);
        }
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 08-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for load the videos which is not assign to any section
 * @view                : manage_video_section/assign_admin_video_to_section
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $video_course_id, $section_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function assign_admin_video_to_section($video_course_id, $section_id){
        $data = array();
        $data['active_menu'] = 'video_course_back_end';
        $data['active_sub_menu'] = 'manage_video_course_back_end';
        $data['section_id'] = $section_id;
        $data['video_course_id'] = $video_course_id;
        
        $data['serial'] = 0;
        $data['assign_admin_video_info'] = $this->Manage_video_section_model->assign_admin_video_to_section();
        //$this->cf->dd($data['assign_admin_video_info']);
        $data['main_content'] = $this->load->view('manage_video_section/assign_admin_video_to_section', $data, TRUE);
        $this->load->view('admin/admin_master', $data);    
    }
/*
 * @Author              : Kazol 
 * @CreatedDate         : 08-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for add video to section
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $video_course_id, $section_id, $manage_video_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function add_video_to_section(){
        if($this->input->is_ajax_request()){
            $vdata['section_id'] = $this->input->post('section_id');
            $vdata['manage_video_id'] = $this->input->post('manage_video_id');
            $video_course_id = $this->input->post('video_course_id');
            
            $section_video_check = $this->Manage_video_section_model->check_section_video_exist($vdata['section_id']);
            if(isset($section_video_check) && !empty($section_video_check)){
                $data['manage_video_id'] = $this->input->post('manage_video_id');
                $data['video_course_id'] = $this->input->post('video_course_id');
                $data['section_id'] = $this->input->post('section_id');
                $data['serial'] = 0;
                $data['assign_admin_video_info'] = $this->Manage_video_section_model->assign_admin_video_to_section();
                echo $this->load->view('manage_video_section/ajax_page/assign_video_for_have_video_section', $data, TRUE);
            }else{
                $vdata['section_video_order'] = 1;
                $this->Manage_video_section_model->save_assign_video_information($vdata);
                
                $this->move_video_and_workfile_to_another_folder($vdata['section_id'], $vdata['manage_video_id']);
                
                $data['video_course_id'] = $this->input->post('video_course_id');
                $data['section_id'] = $this->input->post('section_id');
                $data['serial'] = 0;
                $data['assign_admin_video_info'] = $this->Manage_video_section_model->assign_admin_video_to_section();
                echo $this->load->view('manage_video_section/ajax_page/assign_video_for_no_video_section', $data, TRUE);
            }
            
        }
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 08-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for viewing single section video
 * @view                : manage_video_section/single_section_videos
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function section_total_video($section_id){
        $data = array();
        $data['active_menu'] = 'video_course_back_end';
        $data['active_sub_menu'] = 'manage_video_course_back_end';
        
        $limit_offset = 0;
        $page_number = 1;
        
        $data['section_id'] = $section_id;
        $data['serial'] = 0;
        $data['indivisual_section_video_info'] = $this->Manage_video_section_model->section_total_video_info($section_id, $limit_offset);
        
        $total_row = $data['indivisual_section_video_info']['count_all_video'];
        //$this->cf->dd($total_row);
        $params = array('url' => '', 'div_id' => 'manage_section_video_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['manage_section_video_pagination'] = $this->tt_pagination->view_pagination_link($params);
        
        $data['main_content'] = $this->load->view('manage_video_section/single_section_videos', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 09-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : order-video-section-when-video-exist
 * @Description         : This function is used for viewing the video when one section have more than one video
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function order_video_section_when_video_exist(){
        if($this->input->is_ajax_request()){
            $section_id = $this->input->post('section_id');
            $manage_video_id = $this->input->post('manage_video_id');
            $all_manage_video_info = $this->Manage_video_section_model->order_video_section_when_video_exist_info($section_id, $manage_video_id);
            foreach ($all_manage_video_info as $value) {
                $manage_video_info['video_id'][] = $value->manage_video_id;
                $manage_video_info['video_name'][] = $value->manage_video_title;
            }
            echo json_encode($manage_video_info);
        }
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 09-08-2017  
 * @ModifiedDate        : 10-08-2017 
 * @ModifiedBy          : Kazol
 * @Route               : add-section-video-order
 * @Description         : This function is used for add video with ordering
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function add_section_video_order($section_id, $manage_video_id){
        $vdata['section_id'] = $section_id;
        $vdata['manage_video_id'] = $manage_video_id;
        $toal_video_in_section = $this->Manage_video_section_model->count_total_video_in_a_section($vdata['section_id']);
        $order = $this->input->post('video_order', TRUE);
        
        if($order == 1){
            
            $this->Manage_video_section_model->update_assign_video_information($section_id);
            $vdata['section_video_order'] = 1;
            $this->Manage_video_section_model->save_assign_video_information($vdata);
        }
        if($order == 2){
            $manage_video_id_for_after = $this->input->post('selected_video_ordering', TRUE);
            $video_section_id = $this->Manage_video_section_model->get_section_video_id_by_manage_video_id_for_after($manage_video_id_for_after);
            $video_section = $this->Manage_video_section_model->get_video_information_by_section_id($section_id, $moved_video_order, $subtract_value);
            
            foreach($video_section as $video_sec){
                if($video_section_id->section_video_order < $video_sec->section_video_order){
                    $data['section_video_id'][] = $video_sec->section_video_id;
                    $data['section_video_order'][$video_sec->section_video_id] = $video_sec->section_video_order + 1;
                }
            }
            $this->Manage_video_section_model->update_value_after_specific_row($data);
            $vdata['section_video_order'] = $video_section_id->section_video_order+1;
            $this->Manage_video_section_model->save_assign_video_information($vdata);
        }
        if($order == 3){
           $vdata['section_video_order'] = ++$toal_video_in_section;
           $this->Manage_video_section_model->save_assign_video_information($vdata);
         }
        $this->move_video_and_workfile_to_another_folder($section_id, $manage_video_id);
        redirect('section-total-video/'.$section_id);
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 19-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : add-section-video-order
 * @Description         : This function is used for move video and work file in another folder when add video to section
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id, $manage_video_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function move_video_and_workfile_to_another_folder($section_id, $manage_video_id){
        $video_course_id = $this->Manage_video_section_model->get_video_course_id_by_section_id($section_id);
        $video_course_url = $this->Manage_video_section_model->get_video_course_url($video_course_id);
        $video_location = $this->Manage_video_section_model->get_video_location_for_assign_video($manage_video_id);

        foreach($video_location['manage_video_location'] as $manage_video){
            $old_video_location = substr(strrchr($manage_video->manage_video_location, '/'), 1);
            $new_video_location = 'content-library/talhatraining/my-video/'.$video_course_url->url.'/'.$old_video_location;
            rename($manage_video->manage_video_location,$new_video_location);
            $vmdata['manage_video_location'] = $new_video_location;
            $this->Manage_video_section_model->update_video_location($manage_video_id, $manage_video->manage_video_location_id, $vmdata);
        }
        foreach($video_location['manage_video_workfile'] as $manage_workfile){
            $old_workfile_location = substr(strrchr($manage_workfile->work_file_location, '/'), 1);
            $new_workfile_location = 'content-library/talhatraining/my-video/'.$video_course_url->url.'/'.$old_workfile_location;
            rename($manage_workfile->work_file_location,$new_workfile_location);
            $wmdata['work_file_location'] = $new_workfile_location;
            $this->Manage_video_section_model->update_workfile_location($manage_video_id, $wmdata);
        }
    }
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 16-08-2017  
 * @ModifiedDate        : 17-08-2017 
 * @ModifiedBy          : Kazol
 * @Route               : section-video-move
 * @Description         : This function is used for ordering the videos by moving videos
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function move_video_of_a_section($section_id){
        $manage_video_id = $this->input->post('move_video_by_manage_video_id');
        $order = $this->input->post('video_order', TRUE);
        
        $toal_video_in_section = $this->Manage_video_section_model->count_total_video_in_a_section($section_id);
        $video_section_id = $this->Manage_video_section_model->get_section_video_id_by_manage_video_id_for_after($manage_video_id);
        if($order == 1){
            $video_section = $this->Manage_video_section_model->get_video_information_by_section_id($section_id);
            $updated_value = 1;
            foreach($video_section as $video_sec){
                if($video_section_id->section_video_order > $video_sec->section_video_order){
                    $data['section_video_id'][] = $video_sec->section_video_id;
                    $data['section_video_order'][$video_sec->section_video_id] = $video_sec->section_video_order + 1;
                }
            }
         }
        if($order == 2){
            $manage_video_id_for_after = $this->input->post('selected_video_ordering', TRUE);
            $move_video = $this->Manage_video_section_model->get_section_video_id_by_move_video_id_for_after($manage_video_id_for_after);
            $updated_value = $move_video->section_video_order;
            
            if($move_video->section_video_order > $video_section_id->section_video_order){
                $limit_section_video_order = $video_section_id->section_video_order;
                $video_section = $this->Manage_video_section_model->get_all_video_information_when_video_order_upper_to_lower($section_id, $limit_section_video_order,$updated_value);
                foreach($video_section as $video_sec){
                    if($video_section_id->section_video_order < $video_sec->section_video_order){
                        $data['section_video_id'][] = $video_sec->section_video_id;
                        $data['section_video_order'][$video_sec->section_video_id] = $video_sec->section_video_order - 1;
                    }
                }
            }else{
                $limit_section_video_order = $move_video->section_video_order;
                $video_section = $this->Manage_video_section_model->get_all_video_information_when_video_order_lower_to_upper($section_id, $limit_section_video_order, $video_section_id->section_video_order);
                foreach($video_section as $video_sec){
                    if($video_section_id->section_video_order > $video_sec->section_video_order){
                        $data['section_video_id'][] = $video_sec->section_video_id;
                        $data['section_video_order'][$video_sec->section_video_id] = $video_sec->section_video_order + 1;
                    }
                }
            }
        }
        if($order == 3){
            $video_section = $this->Manage_video_section_model->get_video_information_by_section_id($section_id);
            $updated_value = $toal_video_in_section;
            foreach($video_section as $video_sec){
                if($video_section_id->section_video_order < $video_sec->section_video_order){
                    $data['section_video_id'][] = $video_sec->section_video_id;
                    $data['section_video_order'][$video_sec->section_video_id] = $video_sec->section_video_order - 1;
                }
            }
        }
        $this->Manage_video_section_model->update_move_video_information($section_id, $manage_video_id, $updated_value);
        //$this->cf->dd($data);
        $this->Manage_video_section_model->update_value_after_specific_row($data);
        redirect('section-total-video/'.$section_id);
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 17-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : delete-single-section-video
 * @Description         : This function is used for delete a video of a section
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id, $manage_video_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function delete_single_section_video(){
        if($this->input->is_ajax_request()){
            $manage_video_id = $this->input->post('manage_video_id');
            $section_id = $this->input->post('section_id');
            $manage_video_info = $this->manage_admin_video_model->get_admin_video_information_by_manage_video_id($manage_video_id);
            foreach($manage_video_info as $video_info){
                $file_path = $video_info->manage_video_location;
                if (file_exists($file_path)) {
                    unlink($file_path);
                }
            }
            $work_file = $this->manage_admin_video_model->get_admin_workfile_information_by_work_file_type_id($manage_video_id);
            if(isset($work_file)){
               $workfile_path = $work_file->work_file_location;
               if (file_exists($workfile_path)) {
                    unlink($workfile_path);
                }
            }
            $this->manage_admin_video_model->delete_admin_video_info($manage_video_id);
            $this->Manage_video_section_model->delete_single_section_video_info($manage_video_id);
        }
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 17-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : delete-section
 * @Description         : This function is used for delete a section and its contains all videos and workfiles
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function delete_single_section(){
        if($this->input->is_ajax_request()){
            $section_id = $this->input->post('section_id');
            $video_course_id = $this->input->post('video_course_id');
            
            $manage_video_info = $this->Manage_video_section_model->get_video_information($section_id);
            foreach($manage_video_info as $video_info){
                $file_path = $video_info->manage_video_location;
                if (file_exists($file_path)) {
                    unlink($file_path);
                }
            }
            $work_file = $this->Manage_video_section_model->get_workfile_information($section_id);
            if(isset($work_file)){
                foreach($work_file as $v_work_file){
                   $workfile_path = $v_work_file->work_file_location;
                    if (file_exists($workfile_path)) {
                         unlink($workfile_path);
                    } 
                }
            }
            $this->Manage_video_section_model->delete_section_video_info($section_id);
            $this->Manage_video_section_model->delete_single_section_with_contains($section_id, $video_course_id);
        }
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 22-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : pagination-section-video
 * @Description         : This function is used for pagination single section video
 * @view                : manage_video_section/ajax_page/search_and_pagination_section_video
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function pagination_section_video(){
        if ($this->input->is_ajax_request()) {
            $page_number = $this->input->post('page_number');
            $section_id = $this->input->post('section_id');
            
            $limit_offset = ($page_number * 10) - 10;
            $data['serial'] = $limit_offset;
            $data['section_id'] = $section_id;
            $data['indivisual_section_video_info'] = $this->Manage_video_section_model->section_total_video_info($section_id, $limit_offset);

            $total_row = $data['indivisual_section_video_info']['count_all_video'];
            //$this->cf->dd($total_row);
            $params = array('url' => '', 'div_id' => 'manage_section_video_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['manage_section_video_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('manage_video_section/ajax_page/search_and_pagination_section_video', $data, true);
        } else {
            redirect('manage-admin-video');
        }
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 22-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : search-section-video
 * @Description         : This function is used for searching section video
 * @view                : manage_video_section/ajax_page/search_and_pagination_section_video
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function search_section_video(){
        if ($this->input->is_ajax_request()) {
            $search_value = $this->input->post('search_value', TRUE);
            $manage_admin_video_status = $this->input->post('manage_admin_video_status', TRUE);
            $section_id = $this->input->post('section_id', TRUE);
            
            $page = $this->input->post('page_number', TRUE);
            $page_number = isset($page) ? $page : 1 ;
            $limit_offset = ($page_number - 1) * 10;
            $data['serial'] = $limit_offset;
            $data['section_id'] = $section_id;
            
            $data['indivisual_section_video_info'] = $this->Manage_video_section_model->search_section_video_info($search_value, $manage_admin_video_status, $section_id, $limit_offset);
            $total_row = $data['indivisual_section_video_info']['count_all_video'];
            $params = array('url' => '', 'div_id' => 'manage_section_video_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['manage_section_video_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('manage_video_section/ajax_page/search_and_pagination_section_video', $data, TRUE);
        } else {
            redirect('manage-admin-video');
        }
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 23-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          :
 * @Route               : delete-section-single-resolution-video
 * @Description         : This function is used for delete a single resolution video of a single video of a section
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function delete_section_single_resolution_video(){
        if($this->input->is_ajax_request()){
            $manage_video_location_id = $this->input->post('manage_video_location_id');
            //$this->cf->dd($manage_video_location_id);
            $manage_video_location_info = $this->Manage_video_section_model->select_section_video_location_info($manage_video_location_id);
            $manage_video_info = $this->Manage_video_section_model->select_section_video_info($manage_video_location_info->manage_video_id);
            
            $file_path = $manage_video_location_info->manage_video_location;
            if (file_exists($file_path)) {
                unlink($file_path);
            }
            
            if(count($manage_video_info) > 1){
                $this->Manage_video_section_model->delete_section_single_resolution_video($manage_video_location_id);
            }
            else{
                $work_file = $this->Manage_video_section_model->get_section_video_workfile_information_by_work_file_type_id($manage_video_location_info->manage_video_id);
                if(isset($work_file)){
                   $workfile_path = $work_file->work_file_location;
                   if (file_exists($workfile_path)) {
                        unlink($workfile_path);
                    }
                }
                $this->manage_admin_video_model->delete_admin_video_info($manage_video_location_info->manage_video_id);
            }
        }
    }
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 23-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          :
 * @Route               : delete-section-video-workfile
 * @Description         : This function is used for delete workfile of a single video of a section
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function delete_section_video_workfile(){
        if($this->input->is_ajax_request()){
            $work_file_type_id = $this->input->post('work_file_type_id');
            $work_files = $this->Manage_video_section_model->get_section_video_workfile_information_by_work_file_type_id($work_file_type_id);
            $file_path = $work_files->work_file_location;
            if (file_exists($file_path)) {
                unlink($file_path);
            }
            $this->Manage_video_section_model->delete_section_video_workfile($work_file_type_id);
        }
    }
 }
