<?php
/**
 * Description of Manage_language
 *
 * @author Talha Training
 */
class Manage_language extends TT_admin_login {
    
     public function __construct() {
        parent::__construct();
        $this->load->model('Manage_language_model');
    }
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 10-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : language
 * @Description         : The first loading page by this function when click manage language 
 * @view                : language/manage_language, admin/admin_master
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function manage_language(){
        $data = array();
        $data['active_menu'] = 'language';
        $data['active_sub_menu'] = 'manage_language';

        $data['main_content'] = $this->load->view('language/manage_language', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 11-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : language-page 
 * @Description         : This function is used for paginating all the language
 * @view                : language/ajax_view/view_language
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function pagination_language(){
        if ($this->input->is_ajax_request()){
            $data = array();
            $data['active_menu'] = 'language';
            $data['active_sub_menu'] = 'manage_language';
            
            $page_number = $this->input->post('page_number', TRUE);
            $limit_offset = ($page_number * 10) - 10;
            $data['page_number'] = $page_number;
            $total_row = count($this->Manage_language_model->select_all_language_info());
            $data['all_language'] = $this->Manage_language_model->select_limited_language_info($limit_offset);

            $params = array('url' => '', 'div_id' => 'language_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['language_pagination'] = $this->tt_pagination->view_pagination_link($params);

            echo $this->load->view('language/ajax_view/pagination_language', $data, TRUE);
            
        }else{
            redirect('language');
        }
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 10-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : language/add-language
 * @Description         : This function is used for adding the language
 * @view                : language/ajax_view/manage_language
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    //keep function between 20 lines/ if more lines needed then break this function in two different function
        public function add_language(){
        if ($this->input->is_ajax_request()) {
        $data['language_name'] = $this->input->post('add_language_name',true);
        $language_name= $data['language_name'];
        if($language_name== ''){
            echo 'empty';
        }
        else{
            if(strlen($language_name) < 3 || strlen($language_name) > 20 ){
                echo 'length_error';
            }else{
            $result = $this->Manage_language_model->check_language_name_exit($language_name);
            if($result == 'Table not exits'){
                echo 'no_table';
            }else{
                if($result == ''){

                    //$this->form_validation->set_rules('add_language_name', 'course Name', 'required|trim|mun_length[3]|max_length[20]');
                        if($data['language_name']){
                            $this->Manage_language_model->add_language_info($data);
                        }
                        $page_number = 1;
                        $total_row = count($this->Manage_language_model->select_all_language_info());
                        $data['all_language'] = $this->Manage_language_model->select_limited_language_info(0);
                        $data['page_number'] = 1;
                        $params = array('url' => '', 'div_id' => 'language_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
                        $data['language_pagination'] = $this->tt_pagination->view_pagination_link($params);
                        //$data['all_language'] = $this->Manage_language_model->select_all_language_info();
                        echo $this->load->view('language/ajax_view/manage_language', $data, true);
                        }
                        else{
                            echo 'no';
                           }
                    }
                }
            }
        }
        
        else{
            redirect('language');
        }
    }
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 10-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : language/edit-language
 * @Description         : This function is used for edit the language
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function edit_language(){
       
        if ($this->input->is_ajax_request()) {
            $language_id = $this->input->post('language_ID',true);
            $data = $this->Manage_language_model->select_language_by_id($language_id);
            
            $result = json_encode($data);
           echo $result;
        } else {
            redirect('language');
        }
    
    }
     /*
 * @Author              : Kazol 
 * @CreatedDate         : 11-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : language/update-language
 * @Description         : This function is used for update the language
 * @view                : language/ajax_view/manage_language
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    //keep function between 20 lines/ if more lines needed then break this function in two different function
    public function update_language(){
        if($this->input->is_ajax_request()){
        $data['language_name'] = $this->input->post('language_name',true);
        $language_name = $data['language_name'];
        $language_id = $this->input->post('language_id',true);
        if($language_name== ''){
            echo 'empty';
        }else{
            if(strlen($language_name) < 3 || strlen($language_name) > 20 ){
                echo 'length_error';
            }else{
                $result = $this->Manage_language_model->check_language_name_exit($language_name);
                    if($result == 'Table not exits'){
                    echo 'no_table';
                }else{
                    if($result == ''){
                        $this->Manage_language_model->update_language_info($data,$language_id);
                        $page_number = $this->input->post('page_number');

                        $limit_offset = ($page_number*10)-10;
                        $data['page_number'] = $page_number;
                        $total_row = count($this->Manage_language_model->select_all_language_info());
                        $data['all_language'] = $this->Manage_language_model->select_limited_language_info($limit_offset);

                        $params = array('url' => '', 'div_id' => 'language_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
                        $data['language_pagination'] = $this->tt_pagination->view_pagination_link($params);
                        //$data['all_language'] = $this->Manage_language_model->select_all_language_info();
                        echo $this->load->view('language/ajax_view/manage_language', $data, true);
                        }
                        else{
                            $result = $this->Manage_language_model->check_language_id_exit($language_name);
                            $result_id = $result->language_id;
                                if($result_id == $language_id){
                                   $this->Manage_language_model->update_language_info($data,$language_id); 
                                   $page_number = $this->input->post('page_number');

                                    $limit_offset = ($page_number*10)-10;
                                    $data['page_number'] = $page_number;
                                    $total_row = count($this->Manage_language_model->select_all_language_info());
                                    $data['all_language'] = $this->Manage_language_model->select_limited_language_info($limit_offset);

                                    $params = array('url' => '', 'div_id' => 'language_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
                                    $data['language_pagination'] = $this->tt_pagination->view_pagination_link($params);
                                    //$data['all_language'] = $this->Manage_language_model->select_all_language_info();
                                    echo $this->load->view('language/ajax_view/manage_language', $data, true);
                                }else{
                                    echo 'no';
                                }
                        }
                    }
                }
            }
        }
        else{
        redirect('language');
        }
    }
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 10-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : language/delete-language
 * @Description         : This function is used for delete the language
 * @view                : language/ajax_view/manage_language
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function delete_language(){
        if ($this->input->is_ajax_request()) {
            $language_id = $this->input->post('language_id');
            $page_number = $this->input->post('page_number');
            $limit_offset = 0;
            if($page_number == ''){
                $this->Manage_language_model->delete_language_info($language_id);
            }else{
                $this->Manage_language_model->delete_language_info($language_id);
                $limit_offset = ($page_number*10)-10;
             }
            
            $data['page_number'] = $page_number;
            $total_row = count($this->Manage_language_model->select_all_language_info());
            $data['all_language'] = $this->Manage_language_model->select_limited_language_info($limit_offset);
            $params = array('url' => '', 'div_id' => 'language_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['language_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('language/ajax_view/manage_language', $data, true);
        } else {
            redirect('language');
        }
    }
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 11-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : language/view-all-language
 * @Description         : This function is used for searching language
 * @view                : language/ajax_view/language_search
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function search_language(){
        if ($this->input->is_ajax_request()) {
           $condition = [];
            $search_text = $this->input->post('language_name', true);
            $page_number = 1;
            $limit_offset = 0;
            if (isset($condition) || isset($search_text)) {
                $output['all_language_name'] = $this->Manage_language_model->pagination_language_info($condition, $search_text,$limit_offset);
                $total_row = count($this->Manage_language_model->search_language_info( $search_text,$condition));
            }
            
            $params = array('url' => '', 'div_id' => 'search_language_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $output['search_language_pagination'] = $this->tt_pagination->view_pagination_link($params);
            $view_page = $this->load->view('language/ajax_view/language_search', $output, true);

            echo $view_page;
        } else {
            redirect('language');
        }
    }
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 12-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : search-language-page
 * @Description         : This function is used for paginating the searching language
 * @view                : language/ajax_view/language_search_ajax
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function search_language_pagination(){
        if ($this->input->is_ajax_request()) {
            $condition = [];
            $search_text = $this->input->post('language_name', true);
            $current_page = $this->input->post('currentPage', true);
            $page_number = $this->input->post('page_number', true);
            $limit_offset = ($page_number*10)-10;
            if (isset($condition) || isset($search_text)) {
                $output['all_language_name'] = $this->Manage_language_model->pagination_language_info($condition, $search_text,$limit_offset);
                $total_row = count($this->Manage_language_model->search_language_info($search_text,$condition));
            }
            
            
            $params = array('url' => '', 'div_id' => 'search_language_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $output['search_language_pagination'] = $this->tt_pagination->view_pagination_link($params);
            $view_page = $this->load->view('language/ajax_view/language_search_ajax', $output, true);

            echo $view_page;
        } else {
            redirect('language');
        }
    }
/*
 * @Author              : Kazol 
 * @CreatedDate         : 11-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : language/manage-language-ajax
 * @Description         : This function is used for loading the view in the first time loading page by ajax
 * @view                : language/ajax_view/manage_language
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
        public function manage_language_ajax(){
        if($this->input->is_ajax_request()){
        $data['page_number'] = 1;
        $total_row = count($this->Manage_language_model->select_all_language_info());
        $data['all_language'] = $this->Manage_language_model->select_limited_language_info(0);
        
        $params = array('url' => '', 'div_id' => 'language_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $data['page_number'], 'total_link' => 10);
        $data['language_pagination'] = $this->tt_pagination->view_pagination_link($params);
        echo $this->load->view('language/ajax_view/manage_language', $data, true);
        }else {
            redirect('language');
        }
        
        
    }
}
