<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Manage_admin_video_course extends TT_admin_login {

    public function __construct() {
        parent::__construct();
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 20-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : add-admin-video-course
     * @Description         : This function is used for add video course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function add_admin_video_course() {
        $data = array();
        $data['active_menu'] = 'video_course_back_end';
        $data['active_sub_menu'] = 'add_video_course_back_end';
        
        $data['parent_topic'] = $this->Manage_admin_video_course_model->select_all_parent_topic_if_child_exists();
        $data['resource_person'] = $this->Manage_admin_video_course_model->select_all_resource_person();
        $data['all_language_info'] = $this->Manage_admin_video_course_model->select_all_language();
        $data['main_content'] = $this->load->view('manage_admin_video_course/add_admin_video_course', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 20-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for view the child topic of the parent topic
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function view_child_topic() {

        $topic_type = $this->input->post('parent_topic_id');
        $topic_info['child_topic'] = $this->Manage_admin_video_course_model->get_all_child_topic_by_parent_topic_id($topic_type);
        echo $this->load->view('manage_admin_video_course/ajax_page/video_course_child_topic', $topic_info, true);
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 22-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for view the child topic of the parent topic
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function search_admin_video_course_language() {
        if ($this->input->is_ajax_request()) {
            $search_text = $this->input->post('language_name', true);

            if (isset($search_text)) {
                $output['all_language_name'] = $this->Manage_admin_video_course_model->search_admin_video_course_language_info($search_text);
            }

            if ($output['all_language_name']) {
                //$result = json_encode($output['all_language_name']);
                echo $view_page = $this->load->view('video_course/video_course_back_end/admin_video_course/ajax_page/video_course_language_search', $output, true);
            } else {
                echo 'no_data';
            }
        } else {
            redirect('super-admin');
        }
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 23-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for save the video course information
     * @view                : 
     * @redirect            : add-admin-video-course
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function save_admin_video_course() {
        $this->save_video_course_validation();
        if($this->form_validation->run() == FALSE) {
            $data = array();
            $data['active_menu'] = 'video_course_back_end';
            $data['active_sub_menu'] = 'add_video_course_back_end';

            $data['parent_topic'] = $this->Manage_admin_video_course_model->select_all_parent_topic_if_child_exists();
            $data['resource_person'] = $this->Manage_admin_video_course_model->select_all_resource_person();
            $data['all_language_info'] = $this->Manage_admin_video_course_model->select_all_language();
            $data['main_content'] = $this->load->view('manage_admin_video_course/add_admin_video_course', $data, TRUE);
            $this->load->view('admin/admin_master', $data);
        }else{
            
            ($this->input->post('video_course_title', true)) ? $data['video_course_title'] = $this->input->post('video_course_title', true) : $data['video_course_title'] = '';
            $url_name = $this->input->post('video_course_url', true);
            $url_id = $this->Manage_admin_video_course_model->save_video_course_url($url_name, 8);
            ($url_id) ? $data['url_id'] = $url_id : $data['url_id'] = '';
            $data['person_id'] = $this->session->userdata('person_id');
            $data['topic_id'] = $this->save_topic_parent_topic($data['person_id']);
            ($this->input->post('resource_person_id')) ? $data['resource_person_id'] = $this->input->post('resource_person_id') : $data['resource_person_id'] = $this->input->post('resource_person_id');
            ($this->input->post('search_language_id')) ? $data['language_id'] = $this->input->post('search_language_id') : $data['language_id'] = '';
            $data['video_course_description'] =  ($this->input->post('video_course_description')) ? $this->input->post('video_course_description') : '';
            ($this->input->post('video_course_skill_level')) ? $data['video_course_skill_level'] = $this->input->post('video_course_skill_level') : $data['video_course_skill_level'] = '';
            ($this->input->post('video_course_access_level')) ? $data['video_course_access_level'] = $this->input->post('video_course_access_level') : $data['video_course_access_level'] = '';
            ($this->input->post('video_course_publication_status')) ? $data['video_course_publication_status'] = $this->input->post('video_course_publication_status') : $data['video_course_publication_status'] = '';
            ($this->input->post('video_course_payment_type')) ? $data['video_course_payment_type'] = $this->input->post('video_course_payment_type') : $data['video_course_payment_type'] = '';
            ($this->input->post('video_course_upload_video_type')) ? $data['video_course_upload_video_type'] = $this->input->post('video_course_upload_video_type') : $data['video_course_upload_video_type'] = '';
            $video_course_id = $this->Manage_admin_video_course_model->add_admin_video_course_info($data);
            $folder = 'content-library/'.'talhatraining/'.'my-video/'.$url_name.'/';
            mkdir($folder,0777,true);
            $video_course_price = ($this->input->post('video_course_price')) ? $this->input->post('video_course_price') : '';
            
            if($data['video_course_payment_type'] == 2){
                $this->save_video_course_price($video_course_id,$video_course_price);
            }
            $sData['video_course_id'] = $video_course_id;
            $sData['add_edit_video_course_highlight'] = 'highlight';
            $this->session->set_userdata($sData);
            redirect('manage-admin-video-course');
        }
     }
    /*
     * @Author              : Kazol 
     * @CreatedDate         : 29-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is a sub function save_admin_video_course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
     public function save_topic_parent_topic($person_id){
         
         if ($person_id) {
                $mdata['other_topic_id'] = $this->input->post('other_topic_id');
                if ($mdata['other_topic_id']) {
                    $tdata['topic_name'] = $this->input->post('other_topic_id');
                    $tdata['person_id'] = $this->session->userdata('person_id');
                    $tdata['parent_topic_id'] = $this->input->post('parent_topic_id');
                    $tdata['topic_status'] = 1;
                    $data['topic_id'] = $this->Manage_admin_video_course_model->save_other_topic_when_add_video_course($tdata);
                } else if ($this->input->post('topic_id')) {
                    $data['topic_id'] = $this->input->post('topic_id');
                } else {
                    $data['topic_id'] = $this->input->post('parent_topic_id');
                }
                return $data['topic_id'];
            }
     }
     /*
     * @Author              : Kazol 
     * @CreatedDate         : 29-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is a sub function save_admin_video_course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
     public function save_video_course_price($video_course_id,$video_course_price){
        
            $pdata['price_currency'] = 1;
            $pdata['price'] = $video_course_price;
            $pdata['price_type'] = 2;
            $pdata['price_type_id'] = $video_course_id;
            //$this->cf->dd($pdata);
            $this->Manage_admin_video_course_model->save_video_course_price_info($pdata);
            
    }
    /*
     * @Author              : Kazol 
     * @CreatedDate         : 27-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for validation video course information
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function save_video_course_validation(){
        $this->form_validation->set_rules('video_course_title', 'Video Course Title', 'required|trim');
        $this->form_validation->set_rules('video_course_url', 'Video Course Url', 'required|callback_check_url_exist');
        $this->form_validation->set_rules('parent_topic_id', 'Parent Topic id', 'required');
        
        $this->form_validation->set_rules('resource_person_id', 'Resource Person id', 'required');
        $this->form_validation->set_rules('video_course_skill_level', 'Video Course Skill Level', 'required');
        $this->form_validation->set_rules('video_course_payment_type', 'Video Course Payment Type', 'required');
        //$this->form_validation->set_rules('video_course_price', 'Video Course Price', 'required');
        $this->form_validation->set_rules('video_course_description', 'Video Course Description', 'required|trim');
        $this->form_validation->set_rules('search_language_id', 'language id', 'required');
        $this->form_validation->set_rules('video_course_access_level', 'Video Course Access Level', 'required');
        $this->form_validation->set_rules('video_course_publication_status', 'Video Course publication Status', 'required');
    }
    /*
     * @Author              : Kazol 
     * @CreatedDate         : 27-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for checking for video course url
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $url
     * @Return              : TRUE or FALSE     
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function check_url_exist($url){
        //$this->cf->dd($url);
        if($url){
            $url = $this->Manage_admin_video_course_model->check_url($url);
            if($url){
                $this->form_validation->set_message('check_url_exist', "Url Alrady Exist");
                return FALSE;
            }else {
                return TRUE;
            }
        }else{
            $this->form_validation->set_message('check_url_exist', "The Video Course Url field is required.");
        }
        
    }
    /*
     * @Author              : Kazol 
     * @CreatedDate         : 29-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for checking for video course url by ajax
     * @view                : 
     * @redirect            : manage-admin-video-course
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :     
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function check_video_course_url(){
        if($this->input->is_ajax_request()){
            $video_url = $this->input->post('video_course_url');
            if($video_url){
                $result = $this->Manage_admin_video_course_model->check_url($video_url);
            //$this->cf->dd($result);
                if($result){
                    echo 'found';
                }else{
                    echo 'not_found';
                }
            }else{
                echo 'not_found';
            }
            
        }else{
            redirect('manage-admin-video-course');
        }
    }
    /*
     * @Author              : Kazol 
     * @CreatedDate         : 24-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for manage the video course
     * @view                : manage_admin_video_course/manage_admin_video_course
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function manage_admin_video_course($arg = NULL) {
        $data = array();
        $data['active_menu'] = 'video_course_back_end';
        $data['active_sub_menu'] = 'manage_video_course_back_end';
        
        if($arg != NULL){
            if($arg == 'asc' || $arg == 'desc'){
                $s_data['sess_course_sort_by'] = $arg;
                $this->session->set_userdata($s_data);
            }
        }else{
            $this->session->unset_userdata('sess_course_sort_by');
        }
        $data['sort_by'] = $this->session->userdata('sess_course_sort_by');
        
        $video_course_highlight = $this->session->userdata('add_edit_video_course_highlight');
        $course_highlight['add_edit_video_course_highlight'] = ($video_course_highlight != '') ? $video_course_highlight : '';
        
        $limit_offset = 0;
        $page_number = 1;
        $data['all_video_course'] = $this->Manage_admin_video_course_model->manage_limit_admin_video_course_info($limit_offset,$data['sort_by']);
        //$this->cf->dd($data['all_video_course']);
        $total_row = count($this->Manage_admin_video_course_model->manage_admin_video_course_info());
        $params = array('url' => '', 'div_id' => 'video_course_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['video_course_pagination'] = $this->tt_pagination->view_pagination_link($params);
        $data['main_content'] = $this->load->view('manage_admin_video_course/manage_admin_video_course', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 24-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for delete admin video course
     * @view                : manage_admin_video_course/manage_admin_video_course
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function delete_admin_video_course($video_course_id) {
        $this->Manage_admin_video_course_model->delete_admin_video_course_info($video_course_id);
        //redirect('manage-admin-video-course');
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 25-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for edit admin video course
     * @view                : manage_admin_video_course/edit_admin_video_course
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function edit_admin_video_course($video_course_id) {
        
        $data = array();
        $data['active_menu'] = 'video_course_back_end';
        $data['active_sub_menu'] = 'manage_video_course_back_end';

        $data['edit_video_course_info'] = $this->Manage_admin_video_course_model->edit_admin_video_course_info($video_course_id);
        //$this->cf->dd($data);
        $parent_topic_id = $data['edit_video_course_info']->parent_topic_id;
        $data['child_topic'] = $this->Manage_admin_video_course_model->get_all_child_topic_by_parent_topic_id($parent_topic_id);
        $data['parent_topic'] = $this->Manage_admin_video_course_model->select_all_parent_topic_if_child_exists();
        $data['resource_person'] = $this->Manage_admin_video_course_model->select_all_resource_person();
        $data['all_language_info'] = $this->Manage_admin_video_course_model->select_all_language();
        $data['video_course_price'] = $this->Manage_admin_video_course_model->select_video_course_price($video_course_id);
        $data['main_content'] = $this->load->view('manage_admin_video_course/edit_admin_video_course', $data, true);
        $this->load->view('admin/admin_master', $data);
    }
     /*
     * @Author              : Kazol 
     * @CreatedDate         : 27-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for validation edit video course information
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function edit_video_course_validation(){
        $this->form_validation->set_rules('video_course_title', 'Video Course Title', 'required|trim');
        //$this->form_validation->set_rules('video_course_url', 'Video Course Url', 'required|callback_check_url_exist');
        $this->form_validation->set_rules('parent_topic_id', 'Parent Topic id', 'required');
        
        $this->form_validation->set_rules('resource_person_id', 'Resource Person id', 'required');
        $this->form_validation->set_rules('video_course_skill_level', 'Video Course Skill Level', 'required');
        $this->form_validation->set_rules('video_course_payment_type', 'Video Course Payment Type', 'required');
        //$this->form_validation->set_rules('video_course_price', 'Video Course Price', 'required');
        $this->form_validation->set_rules('video_course_description', 'Video Course Description', 'required|trim');
        $this->form_validation->set_rules('search_language_id', 'language id', 'required');
        $this->form_validation->set_rules('video_course_access_level', 'Video Course Access Level', 'required');
        $this->form_validation->set_rules('video_course_publication_status', 'Video Course publication Status', 'required');
    }
    /*
     * @Author              : Kazol 
     * @CreatedDate         : 25-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for update admin video course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function update_admin_video_course($video_course_id) {
        $this->edit_video_course_validation();
        if($this->form_validation->run() == FALSE){
            $this->edit_admin_video_course($video_course_id);
        }else{
            ($this->input->post('video_course_title')) ? $data['video_course_title'] = $this->input->post('video_course_title') : $data['video_course_title'] = '';
            $data['person_id'] = $this->session->userdata('person_id');
            $data['topic_id'] = $this->save_edit_topic_parent_topic($data['person_id']);
            ($this->input->post('resource_person_id')) ? $data['resource_person_id'] = $this->input->post('resource_person_id') : $data['resource_person_id'] = $this->input->post('resource_person_id');
            ($this->input->post('search_language_id')) ? $data['language_id'] = $this->input->post('search_language_id') : $data['language_id'] = '';
            ($this->input->post('video_course_description')) ? $data['video_course_description'] = $this->input->post('video_course_description') : $data['video_course_description'] = '';
            ($this->input->post('video_course_skill_level')) ? $data['video_course_skill_level'] = $this->input->post('video_course_skill_level') : $data['video_course_skill_level'] = '';
            ($this->input->post('video_course_access_level')) ? $data['video_course_access_level'] = $this->input->post('video_course_access_level') : $data['video_course_access_level'] = '';
            ($this->input->post('video_course_publication_status')) ? $data['video_course_publication_status'] = $this->input->post('video_course_publication_status') : $data['video_course_publication_status'] = '';
            ($this->input->post('video_course_payment_type')) ? $data['video_course_payment_type'] = $this->input->post('video_course_payment_type') : $data['video_course_payment_type'] = '';
            ($this->input->post('video_course_upload_video_type')) ? $data['video_course_upload_video_type'] = $this->input->post('video_course_upload_video_type') : $data['video_course_upload_video_type'] = '';
            $this->Manage_admin_video_course_model->update_admin_video_course_info($video_course_id, $data);
            if ($data['video_course_payment_type'] == 2) {
                $pdata['price_currency'] = 1;
                $pdata['price'] = $this->input->post('video_course_price');
                $pdata['price_type'] = 2;
                $pdata['price_type_id'] = $video_course_id;
                $this->Manage_admin_video_course_model->update_video_course_price_info($pdata, $video_course_id);
            }
            $sData['video_course_id'] = $video_course_id;
            $sData['add_edit_video_course_highlight'] = 'highlight';
            $this->session->set_userdata($sData);
            redirect('manage-admin-video-course');
        }
    }
    /*
     * @Author              : Kazol 
     * @CreatedDate         : 29-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is a sub function update_admin_video_course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function save_edit_topic_parent_topic($person_id){
        
        if ($person_id) {
            $mdata['other_topic_id'] = $this->input->post('other_topic_id');
            if ($mdata['other_topic_id']) {
                $tdata['topic_name'] = $this->input->post('other_topic_id');
                $tdata['person_id'] = $this->session->userdata('person_id');
                $tdata['parent_topic_id'] = $this->input->post('parent_topic_id');
                $tdata['topic_status'] = 1;
                $data['topic_id'] = $this->Manage_admin_video_course_model->save_other_topic_when_add_video_course($tdata);
            } else if ($this->input->post('topic_id')) {
                $data['topic_id'] = $this->input->post('topic_id');
            } else {
                $data['topic_id'] = $this->input->post('parent_topic_id');
            }
            return $data['topic_id'];
        }
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 26-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for search video course by video course title
     * @view                : manage_admin_video_course/ajax_page/search_admin_video_course
     * @redirect            : manage-admin-video-course
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function search_admin_video_course() {
        if ($this->input->is_ajax_request()) {
            
            $video_course_name = $this->input->post('video_course_name', TRUE);
            $video_course_publication_status = $this->input->post('video_course_publication_status', TRUE);
            $video_course_payment_type = $this->input->post('video_course_payment_type', TRUE);
            
            $page = $this->input->post('page_number', TRUE);
            $page_number = isset($page) ? $page : 1 ;
            $limit_offset = ($page_number - 1) * 10;
            
            $data['search_video_course'] = $this->Manage_admin_video_course_model->search_admin_video_course_info($video_course_name, $video_course_publication_status, $video_course_payment_type, $limit_offset);
            
            $total_row = $data['search_video_course']['count_all_video_course'];
            $params = array('url' => '', 'div_id' => 'video_course_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['video_course_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('manage_admin_video_course/ajax_page/search_admin_video_course', $data, true);
        } else {
            redirect('manage-admin-video-course');
        }
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 26-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for pagiantion video course 
     * @view                : manage_admin_video_course/ajax_page/pagination_admin_video_course
     * @redirect            : manage-admin-video-course
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function pagination_admin_video_course() {
        if ($this->input->is_ajax_request()) {
            $page_number = $this->input->post('page_number');
            $sort_by = $this->input->post('sort_by');
            $limit_offset = ($page_number * 10) - 10;
            $data['all_video_course'] = $this->Manage_admin_video_course_model->manage_limit_admin_video_course_info($limit_offset, $sort_by);
            $total_row = count($this->Manage_admin_video_course_model->manage_admin_video_course_info());
            //$this->cf->dd($data['all_video_course']);
            $params = array('url' => '', 'div_id' => 'video_course_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
            $data['video_course_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('manage_admin_video_course/ajax_page/pagination_admin_video_course', $data, true);
        } else {
            redirect('manage-admin-video-course');
        }
    }
    /*
     * @Author              : Kazol 
     * @CreatedDate         : 26-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for view single video course 
     * @view                : manage_admin_video_course/view_single_video_course,manage_admin_video/admin_video_master
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_url
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function view_single_video_course($video_course_url){
        $data[]=array();
        $data['single_video_course_info'] = $this->Manage_admin_video_course_model->view_single_video_course_info($video_course_url);
        $data['main_content'] = $this->load->view('manage_admin_video_course/view_single_video_course',$data,TRUE);
        $this->load->view('manage_admin_video/admin_video_master', $data); 
    }
    /*
     * @Author              : Kazol 
     * @CreatedDate         : 23-08-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : video-course-status-change
     * @Description         : This function is used for changing the video course status
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function video_course_status_change(){
        if($this->input->is_ajax_request()){
            $video_course_id = $this->input->post('video_course_id', TRUE);
            $status = $this->input->post('change_status', TRUE);
            $this->Manage_admin_video_course_model->change_video_course_status($video_course_id, $status);
        }
    }
}
