<?php

/**
 * Description of Earning
 *
 * @author Md Jaherul Islam
 */
class Earning extends TT_user_login {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Description         : view right side information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 06:06 PM   
     * */
    function get_right_side_data($data, $payment_sub_menu) {
        $data['active_menu'] = 'dashboard';
        $data['active_sub_menu'] = 'payment';
        $data['payment_sub_menu'] = $payment_sub_menu;
        $data['left_side'] = 1;
        $data['left_side_menu_view'] = 1;
        return $data;
    }

    /**
     * @Description         : view earning amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 09-12-2016 03:15 PM   
     * */
    private $person_info;
    private $earning_data;

    function view_earning() {
        $data = [];
        $this->earning_data = $this->get_right_side_data($data, 'earning');

        $person_id = $this->session->person_id;
        $this->person_info = $this->person_model->set_person_id($person_id)->set_field_name('person_country')->set_info_by_id()->get_info();
        $this->earning_data['course_id'] = $this->course_model->set_person_id($person_id)->set_course_id_for_payment()->get_result();

        if (!empty($this->earning_data['course_id'])) {
            $this->earning_data['earning_info'] = $this->payment_model
                            ->set_field_name('payment_type,payment_type_id,payment_currency,unit_price')->set_type(1)
                            ->set_type_id(explode(',', $this->earning_data['course_id']))->set_limit(0)->set_earning_info()->get_info();

            foreach ($this->earning_data['earning_info'] as $value) {

                // set data for view earning
                $this->set_data_for_view_earning($value);
            }
        }

        $this->earning_data['main_content'] = $this->load->view('user/payment/view_earning', $this->earning_data, TRUE);
        $this->load->view('user/master', $this->earning_data);
    }

    /**
     * @Description         : set data for earning 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-02-2017 02:21 PM   
     * */
    function set_data_for_view_earning($value) {
        $this->earning_data['course_data'][$value->payment_type_id] = $this->utility_model
                        ->set_single_row_info('course_name,url_id', 'tbl_course', ['course_id' => $value->payment_type_id])->get_single_row_info();

        if ($this->person_info->person_country == 'BD') {
            if ($value->payment_currency == 1) {
                $this->earning_data['course_price'][$value->payment_type_id] = $value->unit_price;
                $this->earning_data['currency_sign'][$value->payment_type_id] = '&nbsp;&#x9f3;';
            }
            if ($value->payment_currency == 2) {
                $this->earning_data['currency_sign'][$value->payment_type_id] = '&nbsp;&#x9f3;';
                $this->earning_data['course_price'][$value->payment_type_id] = $this->tt_currency->set($value->unit_price, 'USD', 'BDT')->convert_currency()->get();
            }
        } else {
            if ($value->payment_currency == 1) {
                $this->earning_data['currency_sign'][$value->payment_type_id] = '&nbsp;&#x24;';
                $this->earning_data['course_price'][$value->payment_type_id] = $this->tt_currency->set($value->unit_price, 'BDT', 'USD')->convert_currency()->get();
            }
            if ($value->payment_currency == 2) {
                $this->earning_data['currency_sign'][$value->payment_type_id] = '&nbsp;&#x24;';
                $this->earning_data['course_price'][$value->payment_type_id] = $value->unit_price;
            }
        }

        $this->earning_data['url'][$value->payment_type_id] = $this->utility_model
                        ->set_single_row_info('url', 'tbl_url', ['url_id' => $this->earning_data['course_data'][$value->payment_type_id]->url_id])->get_single_row_info();
        $this->earning_data['total_student'][$value->payment_type_id] = $this->student_model->set_type($value->payment_type)->set_type_id($value->payment_type_id)->set_total_student_by_course_id()->get_result();
    }

    /**
     * @Description         : View student invoice information for earning 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-01-2017 11:35 AM   
     * */
    private $earning_student_data;

    function earning_view_student_invoice($course_url) {
        $course_info = $this->course_model->set_field_name('course_id')->set_url($course_url)->set_info_by_url()->get_result();

        if (empty($course_info)) {
            redirect();
        }

        $data = [];
        $person_id = $this->session->person_id;
        $this->person_info = $this->person_model->set_person_id($person_id)->set_field_name('person_country')->set_info_by_id()->get_info();
        $this->earning_student_data = $this->get_right_side_data($data, 'earning');

        $this->earning_student_data['student_info'] = $this->student_model->set_type(1)->set_type_id($course_info->course_id)
                        ->set_student_info_by_type_id()->get_result();


        foreach ($this->earning_student_data['student_info'] as $value) {
            $this->earning_student_data['person_info'][$value->student_id] = $this->person_model
                            ->set_field_name('person_id,person_first_name,person_last_name,url')
                            ->set_person_id($value->person_id)
                            ->set_info_with_url_by_id()->get_info();

            $this->earning_student_data['payment_info'][$value->student_id] = $this->payment_model
                            ->set_field_name('*')
                            ->set_person_id($value->person_id)
                            ->set_type($value->student_type)
                            ->set_type_id($value->student_type_id)
                            ->set_payment_info_by_person_id()->get_result();

            $this->earning_student_data['encrypt_payment_id'][$value->student_id] = $this->encryption->encrypt($this->earning_student_data['payment_info'][$value->student_id]->payment_id);

            // set payable amount
            $this->set_payable_amount_for_earning_view_student_invoice($value);

            // set Paid and Due amount
            $this->set_paid_amount_for_earning_view_student_invoice($value);
        }
        $this->earning_student_data['main_content'] = $this->load->view('user/payment/view_earning_students', $this->earning_student_data, TRUE);
        $this->load->view('user/master', $this->earning_student_data);
    }

    /**
     * @Description         : view total earning by course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-02-2017 03:57 PM
     * @Updated By          : Md. Mashqur Ul Alam [27-04-17]   
     * */
    function earning_view_earning_by_course($course_url) {

        $course_info = $this->course_model->set_field_name('course_id')->set_url($course_url)->set_info_by_url()->get_result();

        if (empty($course_info)) {
            redirect();
        }

        $data = [];
        $person_id = $this->session->person_id;
        $this->person_info = $this->person_model->set_person_id($person_id)->set_field_name('person_country')->set_info_by_id()->get_info();
        $this->earning_student_data = $this->get_right_side_data($data, 'earning');

        $this->earning_student_data['student_info'] = $this->student_model->set_type(1)->set_type_id($course_info->course_id)
                        ->set_student_info_by_type_id()->get_result();
        $this->earning_student_data['currency_sign'] = '';
        $this->earning_student_data['total_payable_amount'] = 0;
        $this->earning_student_data['total_due_amount'] = 0;
        $this->earning_student_data['total_paid_amount'] = 0;
        $this->earning_student_data['total_user_amount'] = 0;
        $this->earning_student_data['total_tt_amount'] = 0;
        $payment_request_id = '';

        foreach ($this->earning_student_data['student_info'] as $value) {
            $this->earning_student_data['person_info'][$value->student_id] = $this->person_model
                            ->set_field_name('person_id,person_first_name,person_last_name,url')
                            ->set_person_id($value->person_id)
                            ->set_info_with_url_by_id()->get_info();

            $this->earning_student_data['payment_info'][$value->student_id] = $this->payment_model
                            ->set_field_name('*')
                            ->set_person_id($value->person_id)
                            ->set_type($value->student_type)
                            ->set_type_id($value->student_type_id)
                            ->set_payment_info_by_person_id()->get_result();
            $this->earning_student_data['encrypt_payment_id'][$value->student_id] = $this->encryption->encrypt($this->earning_student_data['payment_info'][$value->student_id]->payment_id);

            if ($this->earning_student_data['payment_info'][$value->student_id]->payment_status == 1) {
                $payment_request_id .= $this->earning_student_data['payment_info'][$value->student_id]->payment_id . ',';
                // set payable amount
                $this->set_payable_amount_for_earning_view_student_invoice($value);

                // set Paid and Due amount
                $this->set_paid_amount_for_earning_view_student_invoice($value);

                // set total payable amount
                $this->earning_student_data['currency_sign'] = $this->earning_student_data['payment_currency_sign'][$value->student_id];
                $this->earning_student_data['total_payable_amount'] += $this->earning_student_data['payable_amount'][$value->student_id];
                $this->earning_student_data['total_due_amount'] += $this->earning_student_data['due_amount'][$value->student_id];
                $this->earning_student_data['total_paid_amount'] += $this->earning_student_data['paid_amount'][$value->student_id];
                $this->earning_student_data['total_user_amount'] += $this->earning_student_data['user_amount'][$value->student_id];
                $this->earning_student_data['total_tt_amount'] += $this->earning_student_data['tt_amount'][$value->student_id];
            }
        }
        $sdata['payment_request_id'] = rtrim($payment_request_id, ',');
        $this->session->set_userdata($sdata);
        $this->earning_student_data['existing_payment_request'] = $this->payment_model->check_payment_request_exist($course_info->course_id);
        $this->earning_student_data['course_url'] = $course_url;
        $this->earning_student_data['main_content'] = $this->load->view('user/payment/view_course_earning', $this->earning_student_data, TRUE);
        $this->load->view('user/master', $this->earning_student_data);
    }

    /**
     * @Description         : set payable amount for earning invoice student
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-02-2017 03:14 PM   
     * */
    function set_payable_amount_for_earning_view_student_invoice($value) {
        if ($this->person_info->person_country == 'BD') {
            if ($this->earning_student_data['payment_info'][$value->student_id]->payment_currency == 1) {
                $this->earning_student_data['payment_currency_sign'][$value->student_id] = '&nbsp;&#x9f3;';
                $this->earning_student_data['payable_amount'][$value->student_id] = $this->earning_student_data['payment_info'][$value->student_id]->unit_price - $this->earning_student_data['payment_info'][$value->student_id]->discounted_price;
            }

            if ($this->earning_student_data['payment_info'][$value->student_id]->payment_currency == 2) {
                $this->earning_student_data['payment_currency_sign'][$value->student_id] = '&nbsp;&#x9f3;';
                $payable_amount = $this->earning_student_data['payment_info'][$value->student_id]->unit_price - $this->earning_student_data['payment_info'][$value->student_id]->discounted_price;
                $this->earning_student_data['payable_amount'][$value->student_id] = $this->tt_currency->set($payable_amount, 'USD', 'BDT')->convert_currency()->get();
            }
        } else {
            if ($this->earning_student_data['payment_info'][$value->student_id]->payment_currency == 1) {
                $this->earning_student_data['payment_currency_sign'][$value->student_id] = '&nbsp;&#x24;';
                $payable_amount = $this->earning_student_data['payment_info'][$value->student_id]->unit_price - $this->earning_student_data['payment_info'][$value->student_id]->discounted_price;
                $this->earning_student_data['payable_amount'][$value->student_id] = $this->tt_currency->set($payable_amount, 'BDT', 'USD')->convert_currency()->get();
            }

            if ($this->earning_student_data['payment_info'][$value->student_id]->payment_currency == 2) {
                $this->earning_student_data['payment_currency_sign'][$value->student_id] = '&nbsp;&#x24;';
                $this->earning_student_data['payable_amount'][$value->student_id] = $this->earning_student_data['payment_info'][$value->student_id]->unit_price - $this->earning_student_data['payment_info'][$value->student_id]->discounted_price;
            }
        }
    }

    /**
     * @Description         : set paid and due amount for earning invoice student
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-02-2017 03:14 PM   
     * */
    function set_paid_amount_for_earning_view_student_invoice($value) {
        $paid_amount = $this->payment_model
                        ->set_payment_id($this->earning_student_data['payment_info'][$value->student_id]->payment_id)
                        ->generate_paid_amount()->get_total_paid_amount();
        $paid_currency = $this->invoice_payment_model->set_currency_info()->get_result();

        if ($this->person_info->person_country == 'BD') {
            if (!empty($paid_amount)) {
                if ($paid_currency->currency_type == 1) {
                    $this->earning_student_data['paid_currency_sign'][$value->student_id] = '&nbsp;&#x9f3;';
                    $this->earning_student_data['paid_amount'][$value->student_id] = $paid_amount;
                }

                if ($paid_currency->currency_type == 2) {
                    $this->earning_student_data['paid_currency_sign'][$value->student_id] = '&nbsp;&#x9f3;';
                    $this->earning_student_data['paid_amount'][$value->student_id] = $this->tt_currency->set($paid_amount, 'USD', 'BDT')->convert_currency()->get();
                }
            } else {
                $this->earning_student_data['paid_currency_sign'][$value->student_id] = '&nbsp;&#x9f3;';
                $this->earning_student_data['paid_amount'][$value->student_id] = 0;
            }
        } else {
            if (!empty($paid_amount)) {
                if ($paid_currency->currency_type == 1) {
                    $this->earning_student_data['paid_currency_sign'][$value->student_id] = '&nbsp;&#x24;';
                    $this->earning_student_data['paid_amount'][$value->student_id] = $this->tt_currency->set($paid_amount, 'BDT', 'USD')->convert_currency()->get();
                }

                if ($paid_currency->currency_type == 2) {
                    $this->earning_student_data['paid_currency_sign'][$value->student_id] = '&nbsp;&#x24;';
                    $this->earning_student_data['paid_amount'][$value->student_id] = $paid_amount;
                }
            } else {
                $this->earning_student_data['paid_currency_sign'][$value->student_id] = '&nbsp;&#x24;';
                $this->earning_student_data['paid_amount'][$value->student_id] = 0;
            }
        }
        $this->earning_student_data['due_amount'][$value->student_id] = $this->earning_student_data['payable_amount'][$value->student_id] - $this->earning_student_data['paid_amount'][$value->student_id];
        $this->earning_student_data['user_amount'][$value->student_id] = (($this->earning_student_data['paid_amount'][$value->student_id] * 90) / 100);
        $this->earning_student_data['tt_amount'][$value->student_id] = (($this->earning_student_data['paid_amount'][$value->student_id] * 10) / 100);
    }

    /**
     * @Description         : View all invoice for earning 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-01-2017 05:46 PM    
     * */
    private $invoice_data = [];

    function earning_view_all_invoice() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $person_id = $this->session->person_id;
        $this->person_info = $this->person_model->set_person_id($person_id)->set_field_name('person_country')->set_info_by_id()->get_info();
        $payment_id = $this->encryption->decrypt($this->input->post('payment_id', TRUE));

        if (!empty($payment_id)) {
            $this->invoice_data['invoice_info'] = $this->invoice_model
                            ->set_payment_id($payment_id)
                            ->set_all_invoice_info_by_payment_id()->get_result();

            foreach ($this->invoice_data['invoice_info'] as $value) {
                $this->invoice_data['invoice_payment_info'][$value->invoice_id] = $this->utility_model
                        ->get_table_information('*', 'tbl_invoice_payment', ['invoice_id' => $value->invoice_id]);

                // set paid amount for all earning invoice
                $this->set_paid_amount_for_earning_view_all_invoice($value);

                $temp_invoice_id = $this->utility_model
                                ->get_table_information('random_number', 'tbl_random', ['random_type' => 1, 'random_type_id' => $value->invoice_id])->random_number;
                $this->invoice_data['random_id'][$value->invoice_id] = $this->tt_random_number->set_random_number($temp_invoice_id)->filter_number('45')->get_filter_number();
            }
        } else {
            $this->invoice_data['invoice_info'] = [];
        }
        $view_page = $this->load->view('user/payment/ajax/view_earning_invoice', $this->invoice_data, TRUE);
        echo json_encode($view_page);
    }

    /**
     * @Description         : set paid amount for all earining all invoice
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-02-2017 03:31 PM    
     * */
    function set_paid_amount_for_earning_view_all_invoice($value) {
        if ($this->invoice_data['invoice_payment_info'][$value->invoice_id]) {
            if ($this->person_info->person_country == 'BD') {
                if ($this->invoice_data['invoice_payment_info'][$value->invoice_id]->currency_type == 1) {
                    $this->invoice_data['paid_currency_sign'][$value->invoice_id] = '&nbsp;&#x9f3;';
                    $this->invoice_data['paid_amount'][$value->invoice_id] = $this->invoice_data['invoice_payment_info'][$value->invoice_id]->paid_amount;
                }
                if ($this->invoice_data['invoice_payment_info'][$value->invoice_id]->currency_type == 2) {
                    $this->invoice_data['paid_currency_sign'][$value->invoice_id] = '&nbsp;&#x9f3;';
                    $this->invoice_data['paid_amount'][$value->invoice_id] = $this->tt_currency->set($this->invoice_data['invoice_payment_info'][$value->invoice_id]->paid_amount, 'USD', 'BDT')->convert_currency()->get();
                }
            } else {
                if ($this->invoice_data['invoice_payment_info'][$value->invoice_id]->currency_type == 1) {
                    $this->invoice_data['paid_currency_sign'][$value->invoice_id] = '&nbsp;&#x24;';
                    $this->invoice_data['paid_amount'][$value->invoice_id] = $this->tt_currency->set($this->invoice_data['invoice_payment_info'][$value->invoice_id]->paid_amount, 'BDT', 'USD')->convert_currency()->get();
                }
                if ($this->invoice_data['invoice_payment_info'][$value->invoice_id]->currency_type == 2) {
                    $this->invoice_data['paid_currency_sign'][$value->invoice_id] = '&nbsp;&#x24;';
                    $this->invoice_data['paid_amount'][$value->invoice_id] = $this->invoice_data['invoice_payment_info'][$value->invoice_id]->paid_amount;
                }
            }
        }
    }

    private $data = [];

    public function total_earning() {
        $person_id = $this->session->userdata('user_id');
        // Displaying Side Menu 
        $this->data = $this->get_right_side_data($this->data, 'earning');

        $this->data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $this->data['course_id'] = $this->course_model->get_user_paid_all_course_id($person_id);        
        
        if (isset($this->data['course_id'])) {            
            $this->account_get_total_payment_amount($person_id, $this->data['course_id']);
        }
        $this->data['net_earning'] = $this->get_organization_net_earning($person_id);
        
        $data['main_content'] = $this->load->view('user/profile_view/dashboard/total_earning', $this->data, true);
        $this->load->view('user/master', $data);
    }

    /**
     * @Function            : account_get_total_payment_amount 
     * @Used IN             : route[user/total-earning]
     * @Description         : Get User Total Payment Amount
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 18-4-17 11.30AM     
     * @Parameter           : $person_id, $course_id
     * @Status              : Available       
     * */
    function account_get_total_payment_amount($person_id, $course_id) {
        // calculate total course amount
        $this->account_calculate_total_amount($course_id);
        // calculate total paid amount
        $this->account_calculate_paid_amount($course_id);
        $this->data['tt_amount'] = (($this->data['paid_amount'] * 10) / 100);
        $this->data['revenue_amount'] = ($this->data['paid_amount'] - $this->data['tt_amount']);
    }

    /**
     * @Function            : account_calculate_total_amount 
     * @Used IN             : account_get_total_payment_amount
     * @Description         : Calculated User Total Payment Amount
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 18-4-17 12.20PM     
     * @Parameter           : $person_id, $course_id
     * @Status              : Available       
     * */
    function account_calculate_total_amount($course_id) {
        $this->data['total_amount'] = 0;        
        $payment_info = $this->payment_model->set_field_name('payment_currency,unit_price')
                        ->set_type(1)->set_type_id(explode(',', $course_id))->set_status([1, 2, 3, 9])
                        ->set_payment_info_by_payment_type_id()->get_result();
                
        foreach ($payment_info as $value) {
            if ($value->payment_currency == 2) {
                $unit_price = $this->tt_currency->set($value->unit_price, 'USD', 'BDT')->convert_currency()->get();
            } else {
                $unit_price = $value->unit_price;
            }
            $this->data['total_amount'] += $unit_price;
        }
    }

    /**
     * @Function            : account_calculate_paid_amount 
     * @Description         : Calculated User Total Paid Amount based on course_id
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 27-04-17
     * @Parameter           : $course_id
     * @Status              : Available       
     * */
    function account_calculate_paid_amount($course_id) {
        $this->data['paid_amount'] = 0;
        $all_payment_id = $this->payment_model->set_type(1)
                        ->set_type_id(explode(',', $course_id))->set_status([1, 2, 3, 9])
                        ->set_payment_id_by_payment_type_id()->get_result();
        if (!empty($all_payment_id)) {
            $all_invoice_id = $this->invoice_model->set_payment_id(explode(',', $all_payment_id->id))
                            ->set_all_invoice_id_by_payment_id()->get_result();
        }
        if (!empty($all_invoice_id)) {
            $payment_invoice_info = $this->invoice_payment_model->set_field_name('currency_type,paid_amount')
                            ->set_invoice_id(explode(',', $all_invoice_id->id))
                            ->get_invoice_payment_info_by_multiple_invoice_id()->get_result();

            foreach ($payment_invoice_info as $value) {
                if ($value->currency_type == 2) {
                    $paid_price = $this->tt_currency->set($value->paid_amount, 'USD', 'BDT')->convert_currency()->get();
                } else {
                    $paid_price = $value->paid_amount;
                }
                $this->data['paid_amount'] += $paid_price;
            }
        }
    }

    /**
     * @Function            : earning_payment_request_by_course 
     * @Description         : Process Users Payment Request
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 27-04-17
     * @Parameter           : $course_url
     * @Status              : Available       
     * */
    function earning_payment_request_by_course($course_url) {
        $person_id = $this->session->person_id;
        $payment_method = $this->payment_model->get_user_payment_method_info($person_id);

        if (isset($payment_method['bkash_info'])) {
            $this->make_payment_request($course_url, $payment_method['bkash_info']->person_bkash_payment_info_id, 1);
        } elseif (isset($payment_method['check_info'])) {
            $this->make_payment_request($course_url, $payment_method['check_info']->person_check_payment_info_id, 2);
        } else {
            redirect('user/payment-method');
        }
    }

    /**
     * @Function            : make_payment_request 
     * @Description         : Inserts payment request in database
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 27-04-17
     * @Parameter           : $course_url, $payment_method_id, $payment_method
     * @Status              : Available       
     * */
    public function make_payment_request($course_url, $payment_method_id, $payment_method) {
        $course_info = $this->course_model->set_field_name('course_id')->set_url($course_url)->set_info_by_url()->get_result();
        $payment_request_status = $this->payment_model->check_payment_request_exist($course_info->course_id);
        if ($payment_request_status == 0) {
            $data['person_id'] = $this->session->person_id;
            $payment_detail = $this->payment_model->set_field_name('*')->set_type(1)->set_type_id($course_info->course_id)->set_status(1)->set_payment_info_by_payment_type_id()->get_result();
            $data['payment_type_id'] = $course_info->course_id;
            $data['payment_amount'] = $this->get_total_payment_request_amount($payment_detail);
            $data['payment_date'] = date('Y-m-d h:i:s', (time() - $this->session->time_offset));
            $data['payment_receive_type'] = $payment_method;
            $data['payment_receive_type_id'] = $payment_method_id;
            $data['person_payment_request_status'] = 1;
            $this->payment_model->send_payment_request($data);
            $this->payment_model->update_payment_status(explode(',', $this->session->payment_request_id));
            $this->session->unset_userdata('payment_request_id');
            redirect('user/total-earning');
        } else {
            $this->session->set_userdata('payment_error_message', 'You have already made a payment request!');
            redirect('/user/view-course-earning/' . $course_url);
        }
    }

//    public function get_payment_id_for_payment_request($payment_detail) {
//        // $this->cf->dd($this->session->payment_request_id);
//        $valid_request_id = explode(',', $this->session->payment_request_id);
//        $id = '';
//        foreach ($payment_detail AS $payment) {
//            if(in_array($payment->payment_id, $valid_request_id)){
//                $id .= $payment->payment_id . ',';
//            }
//        }
//        return rtrim($id, ',');
//    }

    /**
     * @Function            : get_total_payment_request_amount 
     * @Description         : Calculates the total Payment Request Amount
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 27-04-17
     * @Parameter           : $payment_detail
     * @Status              : Available       
     * */
    public function get_total_payment_request_amount($payment_detail) {
        $valid_request_id = explode(',', $this->session->payment_request_id);
        $total_payment = 0;
        foreach ($payment_detail AS $payment) {
            if (in_array($payment->payment_id, $valid_request_id)) {
                $total_payment += $payment->total_price;
            }
        }
        $final_payment = $total_payment - ($total_payment * 0.1);
        return $final_payment;
    }

    /**
     * @Function            : get_organization_net_earning 
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 30-04-17
     * @Parameter           : $org_person_id
     * @Status              : Available       
     * */
    function get_organization_net_earning($org_person_id) {
        $confirmed_payment_detail = $this->payment_model->get_confirmed_payment_by_person_id($org_person_id);
        $total_net_earning = 0;
        foreach ($confirmed_payment_detail as $payment) {
            $total_net_earning += $payment->payment_amount;
        }
        return $total_net_earning;
    }

        /**
     * @Function            : view_users_all_payment_request
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 30-04-17
     * @Status              : Available       
     * */
    function view_users_all_payment_request() {
        if ($this->input->is_ajax_request()) {
            $person_id = $this->session->person_id;
            $data['payment_request_info'] = $this->payment_model->get_all_payment_request_by_user_id($person_id);
            foreach ($data['payment_request_info'] AS $payment) {
                $data['course_name'][$payment->payment_type_id] = $this->course_model->set_course_id($payment->payment_type_id)
                                ->set_field_name('course_name')->set_course_info_by_course_id()->get_result();
            }
            $view_page = $this->load->view('user/profile_view/dashboard/dashboard_ajax_view/total_earning_detail', $data, TRUE);
            echo json_encode($view_page);
        }
    }

}
