<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of course
 *
 * @author User
 */
class Course extends CI_Controller {

    public function __construct() {
        parent::__construct();
    }

    /*
      -----------@@@RIPON@ Start Course Public View Part(17-08-16)----------------------------------
     */

    /**
     * @Function            : view_course- @function 
     * @Used IN             : @function-'/course'  
     * @Description         : View all course for all kind of user (Login or after login)
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 17-08-2016 10:35 AM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     * */
    function view_course() {
        $person_id = $this->session->userdata('person_id');
        $data = $this->welcome_model->generate_menu();
        $data['right_content_variation'] = $data['course_value_for_search'] = $data['all_course_status'] = 1;
        $data['content_variable'] = 'course_view_content';
        $data['limit'] = 0;
        $data['search_input'] = '';
        $this->utility_model->remove_session_data('search_input', 'all_course_status', 'child_topic_id', 'course_upcomming', 'skill_level_id', 'course_type', 'course_priority', 'course_rating');
        $course_sidebar_data = $this->course_model->get_course_left_sidebar_data($data);

        $course_data = $this->course_model->view_course_information($course_sidebar_data);

        $params = array('url' => '', 'div_id' => 'pagination', 'total_row' => $course_data['total_course'], 'per_page' => 10, 'current_page' => 1, 'total_link' => 10);
        $course_data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        $course_data['main_content'] = $this->load->view('front_end/course', $course_data, TRUE);
        if ($person_id) {
            $this->load->view('user/master', $course_data);
        } else {
            $this->load->view('front_end/master', $course_data);
        }
    }

    /**
     * @Function            : view_all_courses- @function 
     * @Used IN             : @function-'/course'  
     * @Description         : View all course using ajax request
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 22-08-2016 10:21 AM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     * */
    function view_all_courses() {
        if ($this->input->is_ajax_request()) {
            $course_data = json_decode(file_get_contents("php://input"));
            $cData['all_course_status'] = $sData['all_course_status'] = $course_data->all_course;
            $cData['child_topic_id'] = $sData['child_topic_id'] = $this->course_model->get_child_topic_id($course_data->child_topic_id, $course_data->other_topic_id, $course_data->other_parent_topic);
            $cData['course_upcomming'] = $sData['course_upcomming'] = $course_data->course_upcomming;
            $cData['skill_level_id'] = $sData['skill_level_id'] = ($course_data->skill_level_id) ? implode(',', $course_data->skill_level_id) : '';
            $cData['course_type'] = $sData['course_type'] = $course_data->course_type;
            $cData['course_priority'] = $sData['course_priority'] = $course_data->course_priority;
            $cData['course_rating'] = $sData['course_rating'] = $course_data->course_rating;
            $cData['limit'] = ($course_data->page_number - 1) * 10;
            $cData['search_input'] = ($this->session->userdata('search_input') != '') ? $this->session->userdata('search_input') : '';
            $this->session->set_userdata($sData);

            $data = $this->course_model->view_course_information($cData);
            $params = array('url' => '', 'div_id' => 'pagination', 'total_row' => $data['total_course'], 'per_page' => 10, 'current_page' => $course_data->page_number, 'total_link' => 10);
            $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('front_end/ajax_page/view_courses', $data, TRUE);
        } else {
            redirect('course');
        }
    }

    /**
     * @Function            : view_course_by_search
     * @Used IN             : @function-'/course'  
     * @Description         : view course by search
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 24-08-2016 06:20 PM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     * */
    function view_course_by_search() {
        if ($this->input->is_ajax_request()) {
            $data = Array();
            $data['limit'] = 0;
            $data['all_course_status'] = $this->session->userdata('all_course_status');
            $data['child_topic_id'] = $this->session->userdata('child_topic_id');
            $data['course_upcomming'] = $this->session->userdata('course_upcomming');
            $data['skill_level_id'] = $this->session->userdata('skill_level_id');
            $data['course_type'] = $this->session->userdata('course_type');
            $data['course_priority'] = $this->session->userdata('course_priority');
            $data['course_rating'] = $this->session->userdata('course_rating');
            $course_info = json_decode(file_get_contents("php://input"));
            $data['search_input'] = $course_info->course_input;
            $this->session->set_userdata($data);

            $course_data = $this->course_model->view_course_information($data);

            $params = array('url' => '', 'div_id' => 'pagination', 'total_row' => $course_data['total_course'], 'per_page' => 10, 'current_page' => 1, 'total_link' => 10);
            $course_data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('front_end/ajax_page/view_courses', $course_data, TRUE);
        } else {
            redirect('course');
        }
    }

    /**
     * @Function            : save_course_rating
     * @Used IN             : @function-'/course'  
     * @Description         : Save course rating
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 18-08-2016 05:01 PM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     * */
    function save_course_rating() {
        if ($this->input->is_ajax_request()) {
            $person_id = $this->session->userdata('person_id');
            $rating_info = json_decode(file_get_contents("php://input"));
            $course_info = $this->user_course_model->get_course_information_with_url_by_course_url($rating_info->course_url);
            $this->rating_model->update_rating_infomation($person_id, 1, $course_info->course_id, $rating_info->rating_value);
        } else {
            redirect('course');
        }
    }

    /**
     * @Function            : more_child_topic
     * @Used IN             : @function-'/course'  
     * @Description         : more child topic information
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 20-08-2016 11:57 PM    
     * @Parameter           : $parent_topic_id[INTEGER], $total_child_topic[INTEGER]
     * @Return              : $topic_info[ARRAY]   
     * @Status              : available      
     * */
    function more_child_topic($parent_topic_id, $total_child_topic) {
        if ($this->input->is_ajax_request()) {
            $data = Array();
            $active_status = '1,5';
            $topic_data = $this->course_model->get_assign_course_child_topic($data, $parent_topic_id, $active_status, $total_child_topic);
            echo json_encode($topic_data);
        } else {
            redirect('course');
        }
    }

    /*
      -----------@@@RIPON@ End Course Public View Part(17-08-16)----------------------------------
     */






    /*
      -----------@@@RIPON@ Start Course Registration Part (27-08-18)----------------------------------
     */

    /**
     * @Function            : enroll_course 
     * @Used IN             : @function-'user/front_end/course_details.php'
     * @Description         : Course registration if course are free or paid
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-08-2016 06:06 PM  
     * @Parameter           : $course_url[STRING]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function enroll_course($course_url) {
        $data = Array();
        $person_id = $this->session->userdata('person_id');
        $data['course_info'] = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        if (!$data['course_info']) {
            redirect();
        }

        if ($person_id) {
            $this->course_registration($person_id, $data);
        } else {
            $url = base_url() . 'course/' . $course_url . '/registration';
            $this->tt_redirect->redirect_sign_in_view($url);
        }
    }

    /**
     * @Function            : course_registration 
     * @Used IN             : @function-'enroll_course'  this[@Controller]
     * @Description         : Course registration process
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-09-2016 11:54 AM  
     * @Parameter           : $person_id=>registered ID, $data=?Course Information
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function course_registration($person_id, $data) {
        $result = $this->course_model->check_course_authentication_for_public_view($person_id, $data['course_info']->course_creator_id, $data['course_info']->resource_person_id, $data['course_info']->course_status);
        if ($result == 2) {
            $course_register_student = array_filter(explode(',', $this->student_model->get_all_concat_student_list_by_course_id(1, $data['course_info']->course_id)));
            if (in_array($person_id, $course_register_student)) { // if person already register this course
                $this->tt_message->course_registration_error($data['course_info']->url);
            }

            $this->student_model->student_registration(1, $data['course_info']->course_id);
            $notification_id = $this->notification_course_model->save_course_registration_notification($person_id, $data['course_info']);
            // get notification information and course information
            $notification_info = $this->notification_model->select_notification_info_by_notification_id($notification_id);
            $course_info = $this->user_course_model->get_course_information_with_url_by_course_id($notification_info->notification_type_id);


            if ($data['course_info']->course_type == 1) {
                // set notification ID and course ID into session
                $this->session->set_userdata('sess_notification_id', $notification_id);
                redirect('user/course/save-payment/' . $data['course_info']->course_id);
            } else {
                // send mail to user
                $this->mailer_model->send_email_for_course_registration($notification_info, $course_info);
                $sData['sess_course_id'] = $data['course_info']->course_id;
                $sData['learner_tab_session'] = 'free';
                $this->session->set_userdata($sData);
                redirect('course/learner');
            }
        } else {
            $person_info = $this->person_model->select_backend_active_person_information_by_user_id($person_id);
            if ($person_info) {
                $this->tt_message->course_registration_invalid_access_by_backend_user($data['course_info']->url);
            } else {
                $this->tt_message->course_registration_invalid_access($data['course_info']->url);
            }
        }
    }

    /**
     * @Description         : download course work file
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 16-11-2016 10:45 AM
     * @Parameter           : $id=> work file ID      
     * */
    function download_work_file($id) {
        $random_number = $this->tt_random_number->set_random_number($id)->filter_number('TT')->get_filter_number();
        $work_file_id = $this->utility_model->get_table_information('random_type_id', 'tbl_random', ['random_number' => $random_number])->random_type_id;
        $work_file_info = $this->utility_model->get_table_information('work_file_folder_id,work_file_type_id,work_file_name', 'tbl_work_files', ['work_file_id' => $work_file_id]);
        $folder_name = $this->utility_model->get_table_information('random_number', 'tbl_random', ['random_type' => 2, 'random_type_id' => $work_file_info->work_file_folder_id])->random_number;

        $this->load->helper('download');
        $file_name = $work_file_info->work_file_name;
        $url = 'content-library/' . $this->url_model->course_creator_url($work_file_info->work_file_type_id) . '/my-work-file/' . $folder_name . '/' . $random_number . '.' . pathinfo($file_name, PATHINFO_EXTENSION);
        $data = file_get_contents($url);
        force_download($file_name, $data);
    }

    /*
      -----------@@@RIPON@ End Course Registration Part (27-08-18)----------------------------------
     */

    function get_upcomming_course_for_right_content() {
        $counter = $this->input->post('counter', TRUE);
        $data['upcomming_course'] = $this->course_model->get_upcomming_course($counter + 3);
        $data['total_upcomming_course'] = $this->course_model->get_total_upcomming_course();
        echo $this->load->view('user/course/ajax_page/upcomming_course.php', $data, TRUE);
    }

}
