<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Client_admin extends TT_user_login {

    public function __construct() {
        parent::__construct();

        $this->load->model('f_end_model', 'f_model');
        $this->load->model('client_admin_model');
        $this->load->model('add_teacher_organization_model');
    }

    //This function is for generate Profile ID using First name and Last name field
    //update by tania 08-08-2016
    /**
     * @Function            : check_profile_id_existance2 
     * @Used IN             :      
     * @Description         : 
     * @developed By        : Tania Akter
     * @Update Date         : 08-08-2016
     * @Parameter           : none
     * @Return              : none
     * @Status              : Available        
     * */
    function check_profile_id_existance2() {
        $profile_id = $this->input->post('profileID', TRUE);
        $forbidden_url = $this->url_model->check_forbidden_exists($profile_id);
        if ($forbidden_url) {
            echo $url = $this->url_model->check_url_exists($forbidden_url);
        } else {
            echo $forbidden_url;
        }
    }

    public function check_user_email_by_person_id($user_email_address, $person_id) {
        $result = $this->client_admin_model->check_user_email_by_person_id($user_email_address, $person_id);
        if ($result) {
            echo '1';
        } else {
            echo '2';
        }
    }

    public function email_check() {
        $person_email = $this->input->post('person_email', TRUE);
        $sp = '/^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/';
        if (preg_match($sp, $person_email)) {
            $email_result = $this->sign_up_model->check_user_email_info($person_email);
            if ($email_result) {
                $this->form_validation->set_message('email_check', "<p style='color:red;'> Email Already Exits</p>");
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $this->form_validation->set_message('email_check', "Invalid email address");
            return FALSE;
        }
    }

//tania 07-08-2016
    /**
     * @Function            : email_check_edit 
     * @Used IN             :      
     * @Description         : 
     * @developed By        : Unknown
     * @update by           : tania
     * @Update Date         : 07-08-2016
     * @Parameter           : none
     * @Return              : none
     * @Status              : Available        
     * */
    function email_check_edit() {
        $person_previous_email = $this->input->post('person_previous_email', TRUE);
        $person_email = $this->input->post('person_email', TRUE);
        if ($person_previous_email != $person_email) {
            $sp = '/^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/';
            if (preg_match($sp, $person_email)) {
                $email_result = $this->add_teacher_organization_model->check_user_email_info($person_email);
                $forbidden_email = $this->sign_up_model->check_exist_sign_up_forbidden($person_email, 4);
                if ($email_result) {
                    $this->form_validation->set_message('email_check_edit', get_message("email_exist"));
                    return FALSE;
                } else if ($forbidden_email) {
                    $this->form_validation->set_message('email_check_edit', get_message("forbidden_email"));
                    return FALSE;
                } else {
                    return TRUE;
                }
            } else {
                $this->form_validation->set_message('email_check_edit', get_message("email_invalid"));
                return FALSE;
            }
        } else {
            return TRUE;
        }
    }

    public function check_user_email_for_edit($user_email_address, $old_email) {
        if ($old_email == $user_email_address) {
            echo '2';
        } else {
            $result = $this->client_admin_model->check_user_email_info($user_email_address);
            if ($result) {
                echo '1';
            } else {
                echo '2';
            }
        }
    }

    public function check_profile_url_existance_for_edit($url, $old_url) {
        if ($old_url == $url) {
            echo '2';
        } else {
            $result = $this->client_admin_model->check_url($url);
            if ($result) {
                echo '1';
            } else {
                echo '2';
            }
        }
    }

    //This function is for Profile ID field
    //tania
    /**
     * @Function            : profile_url_existance 
     * @Used IN             :      
     * @Description         : 
     * @developed By        : Unknown
     * @update by           : tania
     * @Update Date         : 08-08-2016
     * @Parameter           : none
     * @Return              : none
     * @Status              : Available        
     * */
    function profile_url_existance() {
        $url = $this->input->post('given_text', TRUE);
        $result = $this->client_admin_model->check_url($url);
        if ($result) {
            echo '1';
        } else {
            echo '2';
        }
    }

    //This function is for Profile ID field
    public function check_profile_id_existance($url) {
        $result = $this->client_admin_model->check_url($url);
        if ($result) {
            echo '1';
        } else {
            echo '2';
        }
    }

    public function manage_teacher() {
        $person_id = $this->session->userdata('user_id');
        $organization_info = $this->organization_model->select_single_organization_info_by_person_id($person_id);
        $organization_id = $organization_info->organization_id;
        $data['resource_person1'] = Array();

        // Right Sidebar Content Information
        $sdata = array();
        $data['active_menu'] = $sdata['active_menu'] = 'organization';
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = 'teacher';
        $this->session->set_userdata($sdata);
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        if ($this->session->userdata('person_role') != 4) {
            redirect();
        }
        $data['role_name'] = 'manage_teacher';
        $data['role_id'] = 3;
        $sdata['role_id'] = $role_id = 3;
        $sdata['role_name'] = $role_name = 'teacher';
        $this->session->set_userdata($sdata);
        /*
         * collecting data from session
         * role name, role id, status, limit, starting point 
         */
        $status = $this->session->userdata('status');
        $short = $this->session->userdata('short');
        $limit = $this->session->userdata('per_page');

        $data['user_role'] = $role_name;
        $data['role_id'] = $role_id;
        $data['status'] = $status;
        $data['active'] = $role_name . '_User';
        /*
         * accessing user database depending on role_id, starting point, limit and status
         */
        $page_number = 1;

        $total_count = count($this->client_admin_model->select_teacher($organization_id));
        $data['resource_person'] = $this->client_admin_model->select_teacher($organization_id, 10);
        foreach ($data['resource_person'] as $v_resource_person) {
            $data['person_info'][$v_resource_person->person_id] = $this->profile_model->person_info_by_id($v_resource_person->person_id);
        }

        $params = array('url' => '', 'div_id' => 'teacher_pagination', 'total_row' => $total_count, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);

        $data['main_content'] = $this->load->view('user/teacher/manage_teacher', $data, true);
        $this->load->view('user/master', $data);
    }

    public function manage_teacher_ajax() {
        if ($this->input->is_ajax_request()) {
            $person_id = $this->session->userdata('user_id');
            $organization_info = $this->organization_model->select_single_organization_info_by_person_id($person_id);
            $organization_id = $organization_info->organization_id;

            $page_number = $this->input->post('page_number', TRUE);
            $limit_offset = ($page_number * 10) - 10;
            $total_count = count($this->client_admin_model->select_teacher($organization_id));
            $data['resource_person'] = $this->client_admin_model->select_teacher($organization_id, 10, $limit_offset);
            foreach ($data['resource_person'] as $v_resource_person) {
                $data['person_info'][$v_resource_person->person_id] = $this->profile_model->person_info_by_id($v_resource_person->person_id);
            }

            $params = array('url' => '', 'div_id' => 'teacher_pagination', 'total_row' => $total_count, 'per_page' => 10, 'current_page' => $page_number, 'total_link' =>10 );
            $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);

            echo $this->load->view('user/teacher/teacher_ajax_pages/manage_teacher_ajax', $data, true);
        }
    }

    /**
     * @Function            : add_teacher
     * @Used IN             : @function-'self'  
     * @Description         : Add Organization teacher
     * @                    : @Update1 - remove feature issue
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 01-03-2016 06:35 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function add_teacher() {
// Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_info = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if ($person_info->person_role != 4) {
            redirect();
        }

        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_rules('person_email', 'Email', 'required|trim|max_length[256]|callback_email_check');
        $this->form_validation->set_rules('person_password', 'Password', 'required|min_length[6]|callback_password_check');
        $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|min_length[6]|callback_password_check');
        $this->form_validation->set_rules('person_first_name', 'First Name', 'required|trim|max_length[100]|callback_check_name');
        $this->form_validation->set_rules('person_last_name', 'Last Name', 'trim|max_length[100]|callback_check_name');
        $this->form_validation->set_rules('profile_url', 'Profile URL', 'required|trim|callback_profile_url_check');
        $this->form_validation->set_rules('person_gender', 'Gender', 'required');
        $this->form_validation->set_rules('country_code', 'Country Code ', 'trim');
        $this->form_validation->set_rules('hidden_country_code', 'Country code', 'required|trim');
        $this->form_validation->set_rules('person_contact_number', 'Person Contact Number', 'required|numeric|max_length[16]|trim');
        $this->form_validation->set_rules('person_country', 'Country', 'required');
        $this->form_validation->set_rules('person_city', 'City', 'required');
        $this->form_validation->set_rules('person_address', 'Address');
        $this->form_validation->set_rules('person_zip', 'Zip', 'required');
        $this->form_validation->set_rules('person_image', 'Image', 'callback_image_validation');
        $this->form_validation->set_rules('person_status', 'Status', 'required');
        $this->form_validation->set_rules('image_path', 'path');

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/teacher/add_teacher', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $person_id = $this->client_admin_model->save_person_information($person_info);
            redirect('manage-teacher');
        }
    }

    /**
     * @Function            : url_check (Callback function)
     * @Developed By        : Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> | 
     * @DevelopeDateTime    : 02-05-2015 05:00 PM   | 
     * @Updated Date Time   : 05-06-2015 03:00 PM   | dd-mm-yyyy hh:mm AM   |
     * @Updated By          : Mahabub-A-Mawla       | Name                  |
     * @parameter           : string $url
     * @return              : true/false
     * @redirect            : no
     * */
    public function profile_url_check($url) {
        $result = $this->super_admin_model->check_menu_url($url);
        if ($result) {
            $this->form_validation->set_message('profile_url_check', "URL Already Exist");
            return false;
        } else {
            $sp = '/[^A-Za-z0-9 -]/';
            if (preg_match($sp, $url)) {
                $this->form_validation->set_message('profile_url_check', "URL Cann't contain any '/[!@#$%&*()^,._;:]/'  if need use '-', Don't use Space");
                return FALSE;
            } else if (strstr($url, ' ')) {
                $this->form_validation->set_message('profile_url_check', " Don't use Space if need use '-', alse URL Cann't contain any special carecter like '/[!@#$%&*()^,._;:-]/'");
                return FALSE;
            } else {
                $this->form_validation->set_message('profile_url_check', "OK");
                return TRUE;
            }
        }
    }

    public function profile_url_check_for_edit($url, $url_edit_date) {
        $url_change_different = '';
        if ($url_edit_date != '') {
            $current_date = date('Y-m-d', strtotime(gmdate('Y-m-d H:i:s')) - $this->session->userdata('time_offset'));
            $url_change_different = $this->cf->dateDifference($current_date, $url_edit_date);
        }
        $old_url = $this->input->post('old_url', TRUE);
        if ($old_url != $url) {
            $result = $this->super_admin_model->check_menu_url_for_public_view($url);
            if ($result) {
                $this->form_validation->set_message('profile_url_check_for_edit', get_message("url_exist"));
                return false;
            } else {
                $sp = '/[^A-Za-z0-9 -]/';
                if (preg_match($sp, $url)) {
                    $this->form_validation->set_message('profile_url_check_for_edit', get_message("url_character"));
                    return FALSE;
                } else if (strstr($url, ' ')) {
                    $this->form_validation->set_message('profile_url_check_for_edit', get_message("url_character_hypen"));
                    return FALSE;
                } else if ($url_change_different != '') {
                    if ($url_change_different < 1) {
                        $this->form_validation->set_message('profile_url_check_for_edit', get_message("url_change_duration"));
                        return FALSE;
                    }
                } else {
                    return TRUE;
                }
            }
        } else {
            return TRUE;
        }
    }

    public function check_name($str) {
        $person_first_name = $this->input->post('person_first_name', TRUE);
        $person_last_name = $this->input->post('person_last_name', TRUE);

        $sp = '/[^A-Za-z0-9 \- \.]/';
        if (!preg_match($sp, $str)) {
            return TRUE;
        } else {
            $this->form_validation->set_message('check_name', get_message("name_character"));
            return FALSE;
        }
    }

    public function password_check($str) {
        $person_password = $this->input->post('person_password', TRUE);
        $confirm_password = $this->input->post('confirm_password', TRUE);
        $sp = '/[~`!@#$%^&*()-_+=,<.>\/?;:\'"-]|/';
        if (preg_match('#[0-9]#', $str) && preg_match('#[a-z]#', $str) && preg_match('#[A-Z]#', $str) && preg_match($sp, $str)) {
            if ($person_password == $confirm_password) {
                return TRUE;
            } else {
                $this->form_validation->set_message('password_check', 'Password Not Matched with Confirm Password !!!');
                return FALSE;
            }
        } else {
            $this->form_validation->set_message('password_check', 'password Must be contain minimum one Capital, one small letter, one number and one special charecter (minimum length 6)');
            return FALSE;
        }
    }

    public function password_check_for_edit($str) {
        $person_password = $this->input->post('person_password', TRUE);
        $confirm_password = $this->input->post('confirm_password', TRUE);
        if ($person_password != '' && $confirm_password != '') {
            $sp = '/[~`!@#$%^&*()-_+=,<.>\/?;:\'"-]|/';
            if (preg_match('#[0-9]#', $str) && preg_match('#[a-z]#', $str) && preg_match('#[A-Z]#', $str) && preg_match($sp, $str)) {
                if ($person_password == $confirm_password) {
                    return TRUE;
                } else {
                    $this->form_validation->set_message('password_check_for_edit', get_message("password_match"));
                    return FALSE;
                }
            } else {
                $this->form_validation->set_message('password_check_for_edit', get_message("password_character"));
                return FALSE;
            }
        } else {
            return TRUE;
        }
    }

    public function image_validation() {
        $allowed_type = array('jpeg', 'gif', 'png', 'bmp', 'JPEG', 'GIF', 'PNG', 'BMP');
        $selected_file_type = explode('/', $_FILES['person_image']['type']);
        if ($_FILES['person_image']['name']) {
            if (in_array($selected_file_type[1], $allowed_type)) {
                if ($_FILES['person_image']['size'] <= 2097152) {
                    return TRUE;
                } else {
                    $this->form_validation->set_message('image_validation', "Image Format will be JPG,PNG,GIF,BMP");
                    return FALSE;
                }
            } else {
                $this->form_validation->set_message('image_validation', "Image Format will be JPG,PNG,GIF,BMP");
                return FALSE;
            }
        } else {
            return TRUE;
        }
    }

    function image_validation_edit() {
        $allowed_type = array('jpeg', 'gif', 'png', 'bmp', 'JPEG', 'GIF', 'PNG', 'BMP');
        $selected_file_type = explode('/', $_FILES['person_new_image']['type']);
        if ($_FILES['person_new_image']['name']) {
            if (in_array($selected_file_type[1], $allowed_type)) {
                if ($_FILES['person_new_image']['size'] <= 2097152) {
                    return TRUE;
                } else {
                    $this->form_validation->set_message('image_validation_edit', get_message("image_size"));
                    return FALSE;
                }
            } else {
                $this->form_validation->set_message('image_validation_edit', get_message("image_formate"));
                return FALSE;
            }
        } else {
            return TRUE;
        }
    }

    public function edit_teacher($teacher_url) {
        $sdata['teacher_url'] = $teacher_url;
        $this->session->set_userdata($sdata);
        redirect('edit-teacher-information');
    }

    public function edit_teacher_information() {
        $teacher_person_url1 = $this->input->post('teacher_url');
        $teacher_person_url2 = str_replace("%F2", "/", $teacher_person_url1);
        $teacher_person_url = $this->encrypt->decode($teacher_person_url2);
        if (!$teacher_person_url) {
            $teacher_person_url1 = $this->session->userdata('teacher_url');
            $teacher_person_url2 = str_replace("%F2", "/", $teacher_person_url1);
            $teacher_person_url = $this->encrypt->decode($teacher_person_url2);
        }
        if (!$teacher_person_url) {
            redirect('manage-teacher');
        }


        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');


        $data['organization_info'] = $this->organization_model->select_single_organization_info_by_person_id($person_id);
        $data['resource_person_info'] = $this->person_model->get_single_person_information_by_person_url($teacher_person_url);
        $teacher_person_id = $data['resource_person_info']->person_id;

        if ($this->session->userdata('person_role') != 4) {
            redirect();
        }

        if ($data['resource_person_info']->person_last_change_url_date) {
            $user_date = $data['resource_person_info']->person_last_change_url_date;
            $current_date = date('Y-m-d', time() - $this->session->userdata('time_offset'));
            $data['url_change_different'] = $this->cf->dateDifference($current_date, $user_date);
        }
        $this->form_validation->set_rules('person_email', 'email', 'required|trim|max_length[256]|callback_email_check_edit');
        $this->form_validation->set_rules('person_password', 'password', 'min_length[6]|callback_password_check_for_edit');
        $this->form_validation->set_rules('confirm_password', 'confirm password', 'min_length[6]|callback_password_check_for_edit');
        $this->form_validation->set_rules('person_first_name', 'first Name', 'required|trim|max_length[100]|callback_check_name');
        $this->form_validation->set_rules('person_last_name', 'last Name', 'required|trim|max_length[100]|callback_check_name');
        $this->form_validation->set_rules('profile_url', 'profile URL', 'required|trim|max_length[100]|callback_profile_url_check_for_edit[' . $data['resource_person_info']->person_last_change_url_date . ']');
        $this->form_validation->set_rules('person_gender', 'gender', 'required');
        $this->form_validation->set_rules('hidden_country_code', 'country code', 'required|trim');
        $this->form_validation->set_rules('person_contact_number', 'person contact number', 'required|numeric|max_length[16]|trim');
        $this->form_validation->set_rules('person_country', 'country', 'required');
        $this->form_validation->set_rules('person_city', 'city', 'required');
        $this->form_validation->set_rules('person_address', 'address');
        $this->form_validation->set_rules('person_zip', 'zip', 'required');
        $this->form_validation->set_rules('person_image', 'image', 'callback_image_validation_edit');
        $this->form_validation->set_rules('person_status', 'status');
        $this->form_validation->set_rules('image_path', 'path');

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/teacher/edit_teacher', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->client_admin_model->update_user_information($teacher_person_id);
            redirect('manage-teacher');
        }
    }

    function add_teacher_education($teacher_person_url) {
        $data = array();
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['teacher_personal_info'] = $this->profile_model->person_info_by_url($teacher_person_url);
        $data['organization_info'] = $this->f_end_model->organization_info_by_id($person_id);

        $this->form_validation->set_rules('attended_for', 'Attended', 'required|trim');
        $this->form_validation->set_rules('education_institution_country', 'Education Institution Country ', 'required|trim');
        $this->form_validation->set_rules('education_institution_city', 'Education Institution City', 'required|trim');
        $this->form_validation->set_rules('education_institution_id', 'Education Institution Id', 'required|trim');
        $this->form_validation->set_rules('other_institute', 'Other Institute', 'trim');
        $this->form_validation->set_rules('start_time_period', 'Start Time Period', 'required|trim');
        $this->form_validation->set_rules('end_time_period', 'end_time_period', 'required|trim');
        $this->form_validation->set_rules('educational_description', 'Educational Description', 'required|trim');
        $this->form_validation->set_rules('person_education_view_status', 'Person Education View Status', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/teacher/add_education', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->client_admin_model->save_teacher_education($data['teacher_personal_info']->person_id);
            redirect('add-teacher-work-experience/' . $teacher_person_url);
        }
    }

    public function select_institute_by_country_city($country, $city, $attended_for) {

        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['institute_info'] = $this->client_admin_model->select_institute($country, $city, $attended_for);
        echo $this->load->view('user/teacher/country_city_institute', $data);
    }

    public function add_teacher_work_experience($teacher_person_url) {
        $data = array();
// Right Sidebar Content Information
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['organization_info'] = $this->f_end_model->organization_info_by_id($person_id);
        $data['teacher_personal_info'] = $this->profile_model->person_info_by_url($teacher_person_url);
        $organization_name = $data['organization_info']->organization_name;

        $this->form_validation->set_rules('user_new_company_name', 'User New Company Name', 'required|trim');
        $this->form_validation->set_rules('user_new_designation', 'User New designation', 'required|trim');
        $this->form_validation->set_rules('user_new_address', 'User New Address', 'required|trim');
        $this->form_validation->set_rules('user_new_responsibility', 'User Responcibility', 'required|trim');
        $this->form_validation->set_rules('user_new_job_start_date', 'Job Start Date', 'required|trim');
        $this->form_validation->set_rules('work_current_here', 'Work Current Here', 'required|trim');
        $this->form_validation->set_rules('user_new_job_end_date', 'Job End Date');
        $this->form_validation->set_rules('person_new_work_view_status', 'Work View Status', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/teacher/add_work_experience', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->client_admin_model->save_teacher_work_experience($data['teacher_personal_info']->person_id);
            redirect('manage-teacher');
        }
    }

    public function edit_teacher_education($person_url) {
        // Right Sidebar Content Information


        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');

        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $data['resource_person_info'] = $this->profile_model->person_info_by_url($person_url);
        $data['organization_info'] = $this->f_end_model->organization_info_by_id($person_id);
        $teacher_person_id = $data['resource_person_info']->person_id;
        $data['teacher_edication_information'] = $this->client_admin_model->select_teacher_education_information($teacher_person_id);

        $this->form_validation->set_rules('attended_for', 'Attended', 'required|trim');
        $this->form_validation->set_rules('education_institution_country', 'Education Institution Country ', 'required|trim');
        $this->form_validation->set_rules('education_institution_city', 'Education Institution City', 'required|trim');
        $this->form_validation->set_rules('education_institution_id', 'Education Institution Id', 'required|trim');
        $this->form_validation->set_rules('other_institute', 'Other Institute', 'trim');
        $this->form_validation->set_rules('start_time_period', 'Start Time Period', 'required|trim');
        $this->form_validation->set_rules('end_time_period', 'end_time_period', 'required|trim');
        $this->form_validation->set_rules('educational_description', 'Educational Description', 'required|trim');
        $this->form_validation->set_rules('person_education_view_status', 'Person Education View Status', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/teacher/edit_education', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->client_admin_model->update_teacher_education($teacher_person_id);

            redirect('edit-teacher-work-experience/' . $person_url);
        }
    }

    public function edit_teacher_work_experience() {
        $data = array();
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['organization_info'] = $this->f_end_model->organization_info_by_id($person_id);
        $data['teacher_personal_info'] = $this->profile_model->person_info_by_id($teacher_person_id);
        $organization_name = $data['organization_info']->organization_name;

        $this->form_validation->set_rules('user_new_company_name', 'User New Company Name', 'required|trim');
        $this->form_validation->set_rules('user_new_designation', 'User New designation', 'required|trim');
        $this->form_validation->set_rules('user_new_address', 'User New Address', 'required|trim');
        $this->form_validation->set_rules('user_new_responsibility', 'User Responcibility', 'required|trim');
        $this->form_validation->set_rules('user_new_job_start_date', 'Job Start Date', 'required|trim');
        $this->form_validation->set_rules('work_current_here', 'Work Current Here', 'required|trim');
        $this->form_validation->set_rules('user_new_job_end_date', 'Job End Date');
        $this->form_validation->set_rules('person_new_work_view_status', 'Work View Status', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/teacher/add_work_experience', $data, true);
            $this->load->view('user/master', $data);
        } else {
            $this->client_admin_model->save_teacher_work_experience($data['teacher_personal_info']->person_id);
            redirect('manage-teacher');
        }
    }

    public function make_account_active($person_url) {
        $person_url = str_replace("%F2", "/", $person_url);
        $person_url = $this->encrypt->decode($person_url);

        $data['person_info'] = $this->profile_model->person_info_by_url($person_url);
        $this->client_admin_model->make_account_active($data['person_info']->person_id);
        $data['person_info'] = $this->profile_model->person_info_by_url($person_url);
        echo $this->load->view('user/teacher/manage_teacher_actions', $data, TRUE);
    }

    public function make_account_inactive($person_url) {
        $person_url = str_replace("%F2", "/", $person_url);
        $person_url = $this->encrypt->decode($person_url);

        $data['person_info'] = $this->profile_model->person_info_by_url($person_url);
        $this->client_admin_model->make_account_inactive($data['person_info']->person_id);
        $data['person_info'] = $this->profile_model->person_info_by_url($person_url);
        echo $this->load->view('user/teacher/manage_teacher_actions', $data, TRUE);
    }

    public function make_account_archive($person_url) {
        $person_url = str_replace("%F2", "/", $person_url);
        $person_url = $this->encrypt->decode($person_url);
        $data['person_info'] = $this->profile_model->person_info_by_url($person_url);
        $this->client_admin_model->make_account_archive($data['person_info']->person_id);
        $data['person_info'] = $this->profile_model->person_info_by_url($person_url);
    }

}
