<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of course
 *
 * @author User
 */
class All_video_course extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('All_video_course_model');
    }
    /*
     * @Author              : Delwar Sumon
     * @CreatedDate         : Unknown
     * @ModifiedDate        : 30-08-2017
     * @ModifiedBy          : Kazol
     * @Route               : all-video-course
     * @Description         : This function is used for getting all video course
     * @view                : all_video_course/all_video_course
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              : 
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function all_video_course() {
        $data[] = array();
        $person_id = $this->session->userdata('person_id');
        $data = $this->welcome_model->generate_menu();
        $data['content_variable'] = 'all_video_course_view';
        $data['course_value_for_search'] = 5;
        
        $limit_offset = 0;
        $page_number = 1;
        $data['video_course_info'] = $this->All_video_course_model->all_video_course_info($limit_offset);
        $data['topic_info'] = $this->All_video_course_model->all_video_course_by_topic_info();
        $total_row = $data['video_course_info']['total_row'];
        $resource_person = $data['video_course_info']['resource_person'];
        $data['resource_person_info'] = $this->All_video_course_model->all_video_course_resource_person_by_resourcePerson_id($resource_person, 3);
        $data['total_resource_person_info'] = count($this->All_video_course_model->all_video_course_resource_person_by_resourcePerson_id($resource_person));
//$this->cf->dd($data['total_resource_person_info']);
        $params = array('url' => '', 'div_id' => 'all_video_course_pagination', 'total_row' => $total_row, 'per_page' => 15, 'current_page' => $page_number, 'total_link' => 10);
        $data['all_video_course_pagination'] = $this->tt_pagination->view_pagination_link($params);
        
        $data['main_content'] = $this->load->view('all_video_course/all_video_course',$data,TRUE);
        if ($person_id) {
            $this->load->view('user/master', $data);
        } else {
            $this->load->view('front_end/master', $data);
        }
    }
    /*
     * @Author              : Kazol 
     * @CreatedDate         : 28-08-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : pagination-all-video-course
     * @Description         : This function is used for paginating all video course
     * @view                : all_video_course/ajax_view/all_video_course_pagination_view
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              : 
     * @value               : $page_number (value got from all_video_course.js file)
     * @Status              : active
     * @version             : v2.1        
     */
    public function pagination_all_video_course(){
        if($this->input->is_ajax_request()){
            $page_number = $this->input->post('page_number');
            $limit_offset = ($page_number*15) - 15;
            
            $data['video_course_info'] = $this->All_video_course_model->all_video_course_info($limit_offset);
            $data['topic_info'] = $this->All_video_course_model->all_video_course_by_topic_info();
            $total_row = $data['video_course_info']['total_row'];

            $params = array('url' => '', 'div_id' => 'all_video_course_pagination', 'total_row' => $total_row, 'per_page' => 15, 'current_page' => $page_number, 'total_link' => 10);
            $data['all_video_course_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('all_video_course/ajax_view/all_video_course_pagination_view',$data,TRUE);
        }
    }
    /*
     * @Author              : Kazol 
     * @CreatedDate         : 28-08-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : search-all-video-course
     * @Description         : This function is used for search all video course
     * @view                : all_video_course/ajax_view/all_video_course_pagination_view
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              : 
     * @value               : $page_number, $search_text(value got from all_video_course.js file)
     * @Status              : active
     * @version             : v2.1        
     */
    public function search_all_video_course(){
        if($this->input->is_ajax_request()){
            $search_text = $this->input->post('search_input');
            $page_number = $this->input->post('page_number');
            $page_number = isset($page_number) ? $page_number : 1 ;
            $limit_offset = ($page_number - 1) * 15;
            $data['video_course_info'] = $this->All_video_course_model->search_all_video_course_info($search_text, $limit_offset);
            $data['topic_info'] = $this->All_video_course_model->all_video_course_by_topic_info();
            $total_row = $data['video_course_info']['total_row'];

            $params = array('url' => '', 'div_id' => 'all_video_course_pagination', 'total_row' => $total_row, 'per_page' => 15, 'current_page' => $page_number, 'total_link' => 10);
            $data['all_video_course_pagination'] = $this->tt_pagination->view_pagination_link($params);
            echo $this->load->view('all_video_course/ajax_view/all_video_course_pagination_view',$data,TRUE);
        }
    }
    /*
     * @Author              : delwar Sumon
     * @CreatedDate         : unkhown
     * @ModifiedDate        : 30-08-2017
     * @ModifiedBy          : Kazol
     * @Route               : view-all-video-course
     * @Description         : This function is used for get the video course when we click in the checkbox in the left side menu
     * @view                : all_video_course/ajax_view/view_all_video_course
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              : 
     * @value               : all_video_course_status,child_topic_id,skill_level_id,course_type, resource_person
                             (value got from all_video_course.js file)
     * @Status              : active
     * @version             : v2.1        
     */
    public function view_all_video_course() {
        if($this->input->is_ajax_request()){
            $video_course_data = json_decode(file_get_contents("php://input"));
            $adata['all_video_course_status'] = $all_video_course_status = $video_course_data->all_course;
            //$this->cf->dd($adata['all_video_course_status']);
            $adata['child_topic_id'] = $this->All_video_course_model->get_child_topic_id($video_course_data->child_topic_id, $video_course_data->other_parent_topic);
            $adata['skill_level_id'] = $video_course_data->skill_level_id;
            $adata['course_type'] = $video_course_data->course_type;
            $adata['resource_person'] = $video_course_data->resource_person;
            $adata['video_course_priority_level'] = $video_course_data->video_course_priority_level;
            //$adata['search_value'] = $video_course_data->search_value;
            $this->session->set_userdata($adata);
            
            $page_number = isset($video_course_data->page_number) ? $video_course_data->page_number : 1 ;
            $limit_offset = ($page_number - 1) * 15;
            //$this->cf->dd($video_course_data);
            if($all_video_course_status != 1){
                $data['video_course_info'] = $this->All_video_course_model->all_video_course_info_by_topic_id($adata, $limit_offset);
            }else{
                $data['video_course_info'] = $this->All_video_course_model->all_video_course_info($limit_offset);
            }
            
            $total_row = $data['video_course_info']['total_row'];
            $params = array('url' => '', 'div_id' => 'all_video_course_checkbox_pagination', 'total_row' => $total_row, 'per_page' => 15, 'current_page' => $page_number, 'total_link' => 10);
            $data['all_video_course_checkbox_pagination'] = $this->tt_pagination->view_pagination_link($params);
            //$this->cf->dd($data);
            echo $this->load->view('all_video_course/ajax_view/view_all_video_course', $data, TRUE);
        }
    }
    /*
     * @Author              : Delwar Sumon
     * @CreatedDate         : Unknown
     * @ModifiedDate        : 09-09-2017
     * @ModifiedBy          : Kazol
     * @Route               : more-video-course-child-topic
     * @Description         : This function is used for get the more child topic video course
     * @view                : all_video_course/ajax_view/more_video_course_child_topic
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              : 
     * @value               : $parent_topic_id
                             (value got from all_video_course.js file)
     * @Status              : active
     * @version             : v2.1        
     */
    public function more_video_course_child_topic() {
        if($this->input->is_ajax_request()){
            $data['parent_topic_id'] = $parent_topic_id = $this->input->post('parent_topic_id');
            $total_child_topic = $this->input->post('total_child_topic');
            $active_status = '1,5';
            $total_child_topic += 3;
            //$this->cf->dd($total_child_topic);
            $topic['child_topic'][$parent_topic_id] = $this->All_video_course_model->get_video_course_assign_child_topic_info_by_topic_id($parent_topic_id, $active_status, $total_child_topic);
            $topic['total_child_topic'][$parent_topic_id] = count($this->All_video_course_model->get_video_course_assign_child_topic_info_by_topic_id($parent_topic_id, $active_status));
            $data['topic_info'] = $topic;
            
            echo $this->load->view('all_video_course/ajax_view/more_video_course_child_topic', $data, TRUE);
        }
    }
    
    public function all_video_course_search() {
        if($this->input->is_ajax_request()){
            $searchData = json_decode(file_get_contents("php://input"));
            $adata['all_video_course_status'] = $this->session->userdata('all_video_course_status');
            $adata['child_topic_id'] = $this->session->userdata('child_topic_id');
            $adata['skill_level_id'] = $this->session->userdata('skill_level_id');
            $adata['course_type'] = $this->session->userdata('course_type');
            
            $adata['search_value'] = $searchData->search_value;
            //$this->cf->dd($adata);
        }
    }
    /*
     * @Author              : 09-09-2017
     * @CreatedDate         : Kazol
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : more-video-course-resource-person
     * @Description         : This function is used for get the more resource person
     * @view                : all_video_course/ajax_view/more_resource_person
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              : 
     * @value               : $total_resource_person
                             (value got from all_video_course.js file)
     * @Status              : active
     * @version             : v2.1        
     */
    public function more_video_course_resource_person(){
        if($this->input->is_ajax_request()){
            $total_resource_person = $this->input->post('count_resource_person');
            $total_resource_person += 3;
            $data['video_course_info'] = $this->All_video_course_model->all_video_course_info();
            $resource_person = $data['video_course_info']['resource_person'];
            $data['resource_person_info'] = $this->All_video_course_model->all_video_course_resource_person_by_resourcePerson_id($resource_person, $total_resource_person);
            $data['total_resource_person_info'] = count($this->All_video_course_model->all_video_course_resource_person_by_resourcePerson_id($resource_person));
            echo $this->load->view('all_video_course/ajax_view/more_resource_person', $data, TRUE);
        }
    }

}
