<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of admin_topic
 *
 * @author MD Jaherul Islam
 */
class Admin_topic extends TT_admin_login {

    public function __construct() {
        parent::__construct();
    }

    /*
      -----------@@@RIPON@ Start Course Topic Part----------------------------------
     */

    /**
     * @Function            : add_topic 
     * @Used IN             : 'view/admin/add_topic_from.php'
     * @Description         : add topic for Course/Video Course/Quiz/Group
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 20-07-2016 10:51 AM
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : available      
     * */
    public function add_topic() {
        $this->form_validation->set_rules('parent_topic_id');
        $this->form_validation->set_rules('topic_name', 'Topic Name', 'required|trim|callback_check_topic_name_existence');
        $this->form_validation->set_rules('topic_status', 'Topic Status', 'required');
        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['active_menu'] = 'topic';
            $data['active_sub_menu'] = 'add_topic';
            $data['all_topic'] = $this->topic_model->select_all_parent_topic();
            $data['main_content'] = $this->load->view('admin/topic/add_topic_form', $data, TRUE);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->topic_model->save_topic_info();
            redirect('admin/manage-topic');
        }
    }

    /**
     * @Function            : edit_topic 
     * @Used IN             : 'view/admin/edit_topic_from.php'
     * @Description         : edit topic for Course/Video Course/Quiz/Group
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 20-07-2016 05:22 PM
     * @Parameter           : $topic_id[INTEGER]
     * @Return              : NULL    
     * @Status              : available      
     * */
    function edit_topic($topic_id) {
        $data = array();
        $data['topic_info'] = $this->topic_model->select_topic_info_by_topic_id($topic_id);

        $this->form_validation->set_rules('parent_topic_id');
        $this->form_validation->set_rules('topic_name', 'Topic Name', 'required|trim|callback_check_topic_name_existence[' . $data['topic_info']->topic_id . ']');
        $this->form_validation->set_rules('topic_status', 'Topic Status', 'required');
        if ($this->form_validation->run() == FALSE) {
            $data['active_menu'] = 'topic';
            $data['active_sub_menu'] = 'manage_topic';
            $data['all_topic'] = $this->topic_model->select_all_parent_topic($topic_id);
            $data['main_content'] = $this->load->view('admin/topic/edit_topic_form', $data, TRUE);
            $this->load->view('admin/admin_master', $data);
        } else {
            $this->topic_model->update_topic_info($data['topic_info']);
            redirect('admin/manage-topic');
        }
    }

    /**
     * @Function            : manage_topic 
     * @Used IN             : 'view/admin/view_topic.php'
     * @Description         : View topic for Course/Video Course/Quiz/Group
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 20-07-2016 12:41 PM
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : available      
     * */
    public function manage_topic() {
        $data = array();
        $data['active_menu'] = 'topic';
        $data['active_sub_menu'] = 'manage_topic';

        $topic_status = '1,2,3,4,5';
        $data['all_topic'] = $this->topic_model->select_all_topic($topic_status);
        foreach ($data['all_topic'] as $topic_value) {
            if ($topic_value->parent_topic_id != 0) {
                $data['topic_info'][$topic_value->parent_topic_id] = $this->topic_model->select_topic_info_by_topic_id($topic_value->parent_topic_id);
            }
        }

        $data['main_content'] = $this->load->view('admin/topic/manage_topic', $data, TRUE);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Function            : check_topic_name 
     * @Used IN             : 'view/admin/view_topic.php'
     * @Description         : check topic name existence
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 20-07-2016 12:41 PM
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : available      
     * */
    function check_topic_name($topic_id, $parent_topic_id, $topic_name1) {
        $topic_name = preg_replace('/\s+/', ' ', urldecode(strtolower($topic_name1)));
        $result = $this->topic_model->check_topic_name($topic_id, $parent_topic_id, $topic_name);
        echo ($result) ? 1 : 2; // if name exists = 1 OR not exists = 2
    }

    /**
     * @Function            : check_topic_name_existence 
     * @Used IN             : @function-'add_topic'  admin_topic[@controller],
     * @Description         : check topic name existence
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 20-07-2016 05:01 PM
     * @Parameter           : $topic_name1[STRING]
     * @Return              : TRUE/FALSE    
     * @Status              : available      
     * */
    function check_topic_name_existence($topic_name1, $topic_id1 = NULl) {
        $parent_topic_id1 = $this->input->post('parent_topic_id', TRUE);
        $topic_id = $topic_id1 != '' ? $topic_id1 : 0;
        $parent_topic_id = $parent_topic_id1 != '' ? $parent_topic_id1 : 0;
        $topic_name = preg_replace('/\s+/', ' ', urldecode(strtolower($topic_name1)));
        $result = $this->topic_model->check_topic_name($topic_id, $parent_topic_id, $topic_name);
        if ($result) { // if name exists = FALSE OR not exists = TRUE
            $this->form_validation->set_message('check_topic_name_existence', "Topic Name Already Exist");
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            : change_topic_status 
     * @Used IN             : 'view/admin/manage_topic.php'
     * @Description         : change topic status
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 21-07-2016 01:10 PM
     * @Parameter           : $topic_id[INTEGER], $status[STRING]
     * @Return              : NULL 
     * @Status              : available      
     * */
    function change_topic_status($topic_id, $status) {
        $this->topic_model->change_topic_status($topic_id, $status);
        if ($status != 'Delete') {
            $topic_info = $this->topic_model->select_topic_info_by_topic_id($topic_id);
            echo json_encode($topic_info);
        } else {
            echo 'Delete';
        }
    }

    /*
      -----------@@@RIPON@ End Topic Part----------------------------------
     */
}
