<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of admin_notification
 *
 * @author Ripon
 */
class Admin_notification extends TT_admin_login {

    public function __construct() {
        parent::__construct();
        $this->load->model('admin_notification_model');
    }

    /**
     * @Description         : view payment notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-09-2016 12:33 PM 
     * @Update DateTime     : 02-10-2016 12:17 PM  
     * @Updated By          : MD Jaherul Islam 
     * */
    function view_course_notification() {
        $data = Array();
        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $this->session->unset_userdata('sess_selected_date');
        $data['main_content'] = $this->load->view('admin/notification/view_course_notification', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Description         : view payment notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-01-2017 10:17 AM   
     * */
    function view_payment_notification() {
        $data = [];
        $data['active_menu'] = '';
        $data['active_sub_menu'] = '';
        $this->session->unset_userdata('sess_selected_date');
        $data['main_content'] = $this->load->view('admin/notification/view_payment_notification', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /**
     * @Description         : view payment notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-09-2016 12:50 PM   
     * @Update DateTime     : 02-10-2016 11:26 AM  
     * @Updated By          : MD Jaherul Islam 
     * */
    function view_notification() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $data = [];
        $notification_type = $this->input->post('notification_type', TRUE);
        $limit = (($this->input->post('limit', TRUE) * 5) - 5);
        $selected_date = $this->session->sess_selected_date;
        $this->admin_notification_model->set_date($selected_date)->set_limit($limit);

        // get notification data for ajax view
        echo $this->get_notification_data($data, $notification_type);
    }

    /**
     * @Description         : get notification data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-01-2017 03:40 AM   
     * */
    function get_notification_data($data, $notification_type) {
        switch ($notification_type) {
            case 1: // for view course notification
                $view_page = $this->get_course_notification_data($data);
                break;
            case 2:  // for view payment notification
                $view_page = $this->get_payment_notification_data($data);
                break;
        }
        return json_encode($view_page);
    }

    /**
     * @Description         : get course notification data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-01-2017 12:49 PM   
     * */
    function get_course_notification_data($data) {
        $notification_data = $this->admin_notification_model->set_notification_type(6)->get_course_notification_data($data);
        return $this->load->view('admin/notification/ajax/view_course_notification', $notification_data, TRUE);
    }

    /**
     * @Description         : get payment notification data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-01-2017 12:49 PM   
     * */
    function get_payment_notification_data($data) {
        $notification_data = $this->admin_notification_model->set_notification_type([7, 8])->get_payment_notification_data($data);
        return $this->load->view('admin/notification/ajax/view_payment_notification', $notification_data, TRUE);
    }

    /**
     * @Description         : view payment notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-09-2016 10:55 AM
     * @Update DateTime     : 02-10-2016 03:38 PM  
     * @Updated By          : MD Jaherul Islam 
     * */
    function update_view_notification() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $notification_id = $this->input->post('notification_id', TRUE);
        $notification_type = $this->input->post('notification_type', TRUE);
        $this->notification_model->update_view_notification(1, $notification_id);

        // get data for view notification
        echo $this->get_data_view_notification($notification_id, $notification_type);
    }

    /**
     * @Description         : get data view notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-01-2017 12:49 PM   
     * */
    function get_data_view_notification($notification_id, $notification_type) {
        $notification_info = $this->notification_model->select_notification_info_by_notification_id($notification_id);
        switch ($notification_type) {
            case 1:
                $ajax_url = $this->get_course_data_view_notification($notification_info);
                break;

            case 2:
                $ajax_url = $this->get_payment_data_view_notification($notification_info);
                break;
        }
        return json_encode($ajax_url);
    }

    /**
     * @Description         : get course data for view notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-01-2017 03:59 PM   
     * */
    function get_course_data_view_notification($notification_info) {
        $course_info = $this->user_course_model->get_course_information_with_url_by_course_id($notification_info->notification_type_id);
        if (!empty($course_info)) {
            $this->session->set_userdata('sess_course_name_notification', $course_info->course_name);
            return base_url('admin/manage-course');
        } else {
            $this->notification_model->set_notification_id($notification_info->notification_id)->delete();
            $this->notification_model->set_notification_type_info_id($notification_info->notification_type_info_id)->delete_type_info();
            return 'error';
        }
    }

    /**
     * @Description         : get payment data for view notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-01-2017 04:00 PM   
     * */
    function get_payment_data_view_notification($notification_info) {
        $result = '';
        switch ($notification_info->notification_type) {
            case 7: // for payment method notification
                $result = $this->notification_get_payment_method_info($notification_info);
                break;
            case 8: // for invoice notification
                $result = $this->notification_get_payment_invoice_info($notification_info);
                break;
        }
        return $result;
    }

    /**
     * @Description         : get payment invoice information for notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-01-2017 04:13 PM   
     * */
    function notification_get_payment_invoice_info($notification_info) {
        $invoice_info = $this->utility_model->set_single_row_info('invoice_id', 'tbl_invoice', ['invoice_id' => $notification_info->notification_type_id])
                ->get_single_row_info();

        if ($invoice_info) {
            $random_number_info = $this->utility_model->set_single_row_info('random_number', 'tbl_random', ['random_type' => 1, 'random_type_id' => $invoice_info->invoice_id])
                    ->get_single_row_info();

            $random_number = $this->tt_random_number->set_random_number($random_number_info->random_number)
                    ->filter_number('37')
                    ->get_filter_number();
            return base_url('admin/view-invoice/' . $random_number);
        } else {
            $this->notification_model->set_notification_id($notification_info->notification_id)->delete();
            $this->notification_model->set_notification_type_info_id($notification_info->notification_type_info_id)->delete_type_info();
            return 'error';
        }
    }

    /**
     * @Description         : get payment method information for notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-01-2017 03:48 PM   
     * */
    function notification_get_payment_method_info($notification_info) {
        $payment_method = $this->admin_payment_model
                ->set_payment_method_id($notification_info->notification_type_id)
                ->set_payment_method_info()
                ->get_result();

        if (!empty($payment_method)) {
            $person_info = $this->person_model
                            ->set_person_id($payment_method->person_id)
                            ->set_field_name('url')
                            ->set_info_with_url_by_id()->get_info();
            return base_url('admin/view-payment-method/' . $person_info->url);
        } else {
            $this->notification_model->set_notification_id($notification_info->notification_id)->delete();
            $this->notification_model->set_notification_type_info_id($notification_info->notification_type_info_id)->delete_type_info();
            return 'error';
        }
    }

    /**
     * @Description         : get notification if user select date
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-01-2017 04:51 PM   
     * */
    function select_notification_by_date() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $data = $sdata = [];
        $notification_type = $this->input->post('notification_type', TRUE);
        $sdata['sess_selected_date'] = date('Y-m-d', ((strtotime($this->input->post('selected_date', TRUE))) - $this->session->time_offset));
        $this->session->set_userdata($sdata);

        // get notification data for ajax view
        $this->admin_notification_model->set_date($sdata['sess_selected_date'])->set_limit(0);
        echo $this->get_notification_data($data, $notification_type);
    }

    /**
     * @Description         : real all notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-09-2016 06:36 PM
     * @Update DateTime     : 03-01-2016 10:04 AM  
     * @Updated By          : MD Jaherul Islam 
     * */
    function mark_all_as_read($notification_type) {
        $selected_date = ($this->session->userdata('sess_selected_date') == '') ? '' : $this->session->userdata('sess_selected_date');
        $notification_data = $this->admin_notification_model->process_notification_type($notification_type)
                        ->set_date($selected_date)->set_notification_info()->get_result();

        foreach ($notification_data as $noification_value) {
            $this->notification_model->update_view_notification(1, $noification_value->notification_id);
        }

        $this->redirect_view_page($noification_value);
    }

    /**
     * @Description         : redirect view pages
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-01-2017 10:39 AM   
     * */
    function redirect_view_page($notification_type) {
        switch ($notification_type) {
            case 1:
                redirect('admin/view-course-notification');
                break;
            case 2:
                redirect('admin/view-payment-notification');
                break;
        }
    }

}
