<?php

/**
 * Description of Admin_invoice
 *
 * @Author Mohammad Jaherul Islam
 */
class Admin_invoice extends TT_admin_login {

    private $regExp = '/^[0-9a-zA-Z\-]+$/';
    private $numberRegExp = '/^[0-9]+$/';

    public function __construct() {
        parent::__construct();
        $this->load->model('payment_refund_model');
    }

    /**
     * @Description         : view all course invoice
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 08-01-2016 03:23 PM 
     * */
    function view_course_invoice($student_url, $course_url) {
        $person_info = $this->person_model->set_person_url($student_url)
                        ->set_field_name('person_id')->set_info_by_url()->get_info();
        if (empty($person_info)) {
            redirect('admin/larner-course');
        }

        $course_info = $this->course_model->set_url($course_url)
                        ->set_field_name('course_id')->set_info_by_url()->get_result();
        if (empty($course_info)) {
            redirect('admin/larner-course');
        }

        $data = [];
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'course_learner';
        $data['payment_info'] = $this->payment_model->set_person_id($person_info->person_id)->set_type(1)->set_field_name('*')
                        ->set_type_id($course_info->course_id)->set_payment_info_by_person_and_course_id()->get_info();

        // get all invoice information by payment ID
        $data['invoice_info'] = $this->invoice_model->set_payment_id($data['payment_info']->payment_id)->set_all_invoice_info_by_payment_id()->get_result();

        $counter = 0;
        foreach ($data['invoice_info'] as $value) {
            $temp_invoice_id = $this->utility_model
                            ->get_table_information('random_number', 'tbl_random', ['random_type' => 1, 'random_type_id' => $value->invoice_id])->random_number;
            $data['random_id'][$value->invoice_id] = $this->tt_random_number->set_random_number($temp_invoice_id)->filter_number('45')->get_filter_number();
            $data['invoice_payment_info'][$value->invoice_id] = $this->utility_model
                    ->get_table_information('*', 'tbl_invoice_payment', ['invoice_id' => $value->invoice_id]);

            if (!empty($data['invoice_payment_info'][$value->invoice_id])) {
                $counter++;
            }
        }

        $data['counter'] = $counter;
        $data['main_content'] = $this->load->view('admin/account/view_course_invoices', $data, true);
        $this->load->view('admin/admin_master', $data);
    }

    /*
     * ---------------------Start refund invoice--------------------------------------
     */

    /**
     * @Description         : refund invoice
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 26-01-2017 02:54 PM 
     * */
    function invoice_refund_view($temp_invoice_id) {
        // set random ID and process for random information
        $random_info = $this->random_number_model->set_temp_random_id($temp_invoice_id)->process()->get_info();

        // if does not matched random ID into database
        if (empty($random_info)) {
            redirect('admin/larner-course');
        }

        // assign data for view Invoice
        $data = $this->get_data_for_single_invoice($temp_invoice_id);

        // check paid amount data for view invoice
        $payment_data = $this->check_paid_amount_data_for_single_invoice($data);

        // get currency type if paid any payment
        $data['currency_info'] = $this->invoice_payment_model->set_currency_info()->get_result();

        // mearge invoice information and payment data
        $invoice_data = array_merge($data, $payment_data);

        $invoice_data['bkash_payment'] = $this->load->view('admin/account/modal/bkash_payment', $invoice_data, TRUE);
        $invoice_data['cash_payment'] = $this->load->view('admin/account/modal/cash_payment', $invoice_data, TRUE);
        $invoice_data['cheque_payment'] = $this->load->view('admin/account/modal/cheque_payment', $invoice_data, TRUE);
        $invoice_data['main_content'] = $this->load->view('admin/account/payment/view_refund_invoice', $invoice_data, TRUE);
        $this->load->view('admin/admin_master', $invoice_data);
    }

    /**
     * @Description         : get information for invoice refund
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 25-01-2017 04:53 PM 
     * */
    function invoice_refund_get_info() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $data = [];
        $temp_invoice_id = $this->input->post('invoice_id', TRUE);
        // set random ID and process for random information
        $random_info = $this->random_number_model->set_temp_random_id($temp_invoice_id)->process()->get_info();

        //get invoice information by invoice ID
        $invoice_info = $this->utility_model
                ->get_table_information('payment_id', 'tbl_invoice', ['invoice_id' => $random_info->random_type_id]);

        // get payment information by payment information ID
        $this->payment_model->set_payment_id($invoice_info->payment_id);

        $data['paid_amount'] = $this->payment_model->generate_paid_amount()->get_total_paid_amount();
        echo json_encode($data);
    }

    /**
     * @Description         : check cash receipt number
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 25-01-2017 04:08 PM 
     * */
    function check_cash_receipt_number() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }

        $receipt_number = $this->input->post('receipt_number', TRUE);
        $result = $this->payment_process_model->check_receipt_number($receipt_number)->get_result();

        echo ($result) ? 1 : 2;
    }

    /**
     * @Description         : save refund cash ammount
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 26-01-2017 02:51 PM 
     * */
    private $payment_id;
    private $temp_invoice_id;
    private $refund_data = [];

    function invoice_save_refund_cash() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $this->temp_invoice_id = $this->input->post('invoice_id', TRUE);
        // set random ID and process for random information
        $random_info = $this->random_number_model->set_temp_random_id($this->temp_invoice_id)->process()->get_info();

        if ($random_info) {
            $this->invoice_id = $random_info->random_type_id;
            //get invoice information by invoice ID
            $this->payment_id = $this->utility_model
                            ->get_table_information('payment_id', 'tbl_invoice', ['invoice_id' => $random_info->random_type_id])->payment_id;

            //get invoice information by invoice ID
            $payment_info = $this->utility_model
                    ->get_table_information('person_id,payment_type_id', 'tbl_payment', ['payment_id' => $this->payment_id]);

            // set course info 
            $this->course_info = $this->utility_model
                    ->get_table_information('course_name,person_id,resource_person_id,course_resource_person_view_invoice', 'tbl_course', ['course_id' => $payment_info->payment_type_id]);

            // set person info 
            $this->person_info = $this->utility_model
                    ->get_table_information('person_id,person_first_name,person_last_name,person_email', 'tbl_person', ['person_id' => $payment_info->person_id]);

            // save refund cash amount
            $this->invoice_saved_refund_cash();
        } else {
            $this->redirect_refund_invoice_error();
        }
        echo json_encode($this->refund_data);
    }

    /**
     * @Description         : save refund cash amount and check validation
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 29-01-2017 11:03 AM 
     * */
    function invoice_saved_refund_cash() {
        // Save Cheque payment Band ID and Account Number
        $this->payment_process_model->receipt_number = trim($this->input->post('receipt_number', TRUE));

        $error = $this->invoice_check_cash_validation();
        if (empty($error)) {
            //save and get cash payment insert ID
            $payment_cash_id = $this->payment_process_model
                            ->set_table_name('tbl_payment_cash')
                            ->save()
                            ->set_insert_id()->get_id();

            // save refunct amount
            $this->payment_refund_model
                    ->set_payment_id($this->payment_id)->set_refund_type(1)
                    ->set_refund_type_id($payment_cash_id)
                    ->set_refund_amount($this->input->post('paid_amount', TRUE))->save();

            //update payment Status
            $this->payment_model->set_payment_id($this->payment_id)->payment_status = 8;
            $this->payment_model->update();

            // save notification
            $this->invoice_set_notification_data_for_refund_payment()->save_notification();

            // send E-mail 
            $this->invoice_set_mail_data_for_refund()->send_mail();

            $this->refund_data['redirect_url'] = base_url() . 'admin/refund-invoice/' . $this->temp_invoice_id;
            // Set payment success message in session
            $session_data['sess_message'] = '<span style="color: green">Your payment has been refunded successfully</span>';
            set_session($session_data);
        } else {
            $this->redirect_refund_invoice_error();
        }
    }

    /**
     * @Description         : check validation for save refund cash amount
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 29-01-2017 11:03 AM 
     * */
    function invoice_check_cash_validation() {
        $error = [];
        $receipt_number = $this->payment_process_model->get('receipt_number');
        $result = $this->payment_process_model->check_receipt_number($receipt_number)->get_result();
        if (!preg_match($this->regExp, $receipt_number)) {
            $error['cash_recipt'] = 1;
        } elseif (!empty($result)) {
            $error['cash_recipt'] = 1;
        } else {
            $error['cash_recipt'] = '';
        }

        // get payment information by payment information ID
        $total_paid_amount = $this->payment_model->set_payment_id($this->payment_id)
                        ->generate_paid_amount()->get_total_paid_amount();

        $paid_amount = $this->input->post('paid_amount', TRUE);
        $error['cash_amount'] = ($total_paid_amount < $paid_amount) ? 1 : '';
        return array_filter($error);
    }

    /**
     * @Description         : save refund bkash amount
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 29-01-2017 02:37 PM 
     * */
    function invoice_save_refund_bkash() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $this->temp_invoice_id = $this->input->post('invoice_id', TRUE);
        // set random ID and process for random information
        $random_info = $this->random_number_model->set_temp_random_id($this->temp_invoice_id)->process()->get_info();

        if ($random_info) {
            $this->invoice_id = $random_info->random_type_id;
            //get invoice information by invoice ID
            $this->payment_id = $this->utility_model
                            ->get_table_information('payment_id', 'tbl_invoice', ['invoice_id' => $random_info->random_type_id])->payment_id;

            //get invoice information by invoice ID
            $payment_info = $this->utility_model
                    ->get_table_information('person_id,payment_type_id', 'tbl_payment', ['payment_id' => $this->payment_id]);

            // set course info 
            $this->course_info = $this->utility_model
                    ->get_table_information('course_name,person_id,resource_person_id,course_resource_person_view_invoice', 'tbl_course', ['course_id' => $payment_info->payment_type_id]);

            // set person info 
            $this->person_info = $this->utility_model
                    ->get_table_information('person_id,person_first_name,person_last_name,person_email', 'tbl_person', ['person_id' => $payment_info->person_id]);

            // save refund cash amount
            $this->invoice_saved_refund_bkash();
        } else {
            $this->redirect_refund_invoice_error();
        }
        echo json_encode($this->refund_data);
    }

    /**
     * @Description         : save refund bkash amount
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 29-01-2017 02:37 PM 
     * */
    function invoice_saved_refund_bkash() {
        // Save Cheque payment Band ID and Account Number
        $this->payment_process_model->bkash_mobile_number = trim($this->input->post('mobile_number', TRUE));
        $this->payment_process_model->bkash_transaction_id = trim($this->input->post('transaction_id', TRUE));

        $error = $this->invoice_check_bkash_validation();

        if (empty($error)) {
            // get bKash payment insert ID
            $payment_bkash_id = $this->payment_process_model
                    ->set_table_name('tbl_payment_bkash')
                    ->save()
                    ->set_insert_id()
                    ->get_id();

            // save refunct amount 3=> for bkash payment
            $this->payment_refund_model
                    ->set_payment_id($this->payment_id)->set_refund_type(3)
                    ->set_refund_type_id($payment_bkash_id)
                    ->set_refund_amount($this->input->post('paid_amount', TRUE))->save();

            //update payment Status
            $this->payment_model->set_payment_id($this->payment_id)->payment_status = 8;
            $this->payment_model->update();

            // save notification
            $this->invoice_set_notification_data_for_refund_payment()->save_notification();

            // send E-mail 
            $this->invoice_set_mail_data_for_refund()->send_mail();

            $this->refund_data['redirect_url'] = base_url() . 'admin/refund-invoice/' . $this->temp_invoice_id;
            // Set payment success message in session
            $session_data['sess_message'] = '<span style="color: green">Your payment has been refunded successfully</span>';
            set_session($session_data);
        } else {
            $this->redirect_refund_invoice_error();
        }
    }

    /**
     * @Description         : check bkash refund validation
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 29-01-2017 03:37 PM 
     * */
    function invoice_check_bkash_validation() {
        $mobile_number = $this->payment_process_model->get('bkash_mobile_number');
        $transaction_id = $this->payment_process_model->get('bkash_transaction_id');

        if (empty($mobile_number)) {
            $error['error_mobile_number'] = 1;
        } else if (!preg_match($this->numberRegExp, $mobile_number)) {
            $error['error_mobile_number'] = 1;
        } else {
            $error['error_mobile_number'] = '';
        }

        if (empty($transaction_id)) {
            $error['error_transaction_id'] = 1;
        } else if (!preg_match($this->numberRegExp, $transaction_id)) {
            $error['error_transaction_id'] = 1;
        } else {
            $error['error_transaction_id'] = '';
        }

        // get payment information by payment information ID
        $total_paid_amount = $this->payment_model->set_payment_id($this->payment_id)
                        ->generate_paid_amount()->get_total_paid_amount();

        $paid_amount = $this->input->post('paid_amount', TRUE);
        $error['cash_amount'] = ($total_paid_amount < $paid_amount) ? 1 : '';
        return array_filter($error);
    }

    /**
     * @Description         : save invoice refund cheque
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 29-01-2017 03:37 PM 
     * */
    function invoice_save_refund_cheque() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $this->temp_invoice_id = $this->input->post('invoice_id', TRUE);
        // set random ID and process for random information
        $random_info = $this->random_number_model->set_temp_random_id($this->temp_invoice_id)->process()->get_info();

        if ($random_info) {
            $this->invoice_id = $random_info->random_type_id;
            //get invoice information by invoice ID
            $this->payment_id = $this->utility_model
                            ->get_table_information('payment_id', 'tbl_invoice', ['invoice_id' => $random_info->random_type_id])->payment_id;

            //get invoice information by invoice ID
            $payment_info = $this->utility_model
                    ->get_table_information('person_id,payment_type_id', 'tbl_payment', ['payment_id' => $this->payment_id]);

            // set course info 
            $this->course_info = $this->utility_model
                    ->get_table_information('course_name,person_id,resource_person_id,course_resource_person_view_invoice', 'tbl_course', ['course_id' => $payment_info->payment_type_id]);

            // set person info 
            $this->person_info = $this->utility_model
                    ->get_table_information('person_id,person_first_name,person_last_name,person_email', 'tbl_person', ['person_id' => $payment_info->person_id]);

            // save refund cash amount
            $this->invoice_saved_refund_cheque();
        } else {
            $this->redirect_refund_invoice_error();
        }
        echo json_encode($this->refund_data);
    }

    /**
     * @Description         : check bkash refund validation
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 29-01-2017 03:37 PM 
     * */
    function invoice_saved_refund_cheque() {
        // Save Cheque payment Band ID and Account Number
        $this->payment_process_model->bank_branch_id = $this->input->post('bank_branch_id', TRUE);
        $this->payment_process_model->account_number = trim($this->input->post('account_number', TRUE));

        $error = $this->invoice_refund_cheque_validation();

        if (empty($error)) {
            // get bKash payment insert ID
            $payment_cheque_id = $this->payment_process_model
                            ->set_table_name('tbl_payment_cheque')
                            ->save()
                            ->set_insert_id()->get_id();

            // save refunct amount 2=> for bkash payment
            $this->payment_refund_model
                    ->set_payment_id($this->payment_id)->set_refund_type(2)
                    ->set_refund_type_id($payment_cheque_id)
                    ->set_refund_amount($this->input->post('paid_amount', TRUE))->save();

            //update payment Status
            $this->payment_model->set_payment_id($this->payment_id)->payment_status = 8;
            $this->payment_model->update();

            // save notification
            $this->invoice_set_notification_data_for_refund_payment()->save_notification();

            // send E-mail 
            $this->invoice_set_mail_data_for_refund()->send_mail();

            $this->refund_data['redirect_url'] = base_url() . 'admin/refund-invoice/' . $this->temp_invoice_id;
            // Set payment success message in session
            $session_data['sess_message'] = '<span style="color: green">Your payment has been refunded successfully</span>';
            set_session($session_data);
        } else {
            $this->redirect_refund_invoice_error();
        }
    }

    /**
     * @Description         : save cheque payment amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-11-2016 02:53 PM   
     * */
    function invoice_refund_cheque_validation() {
        $bank_branch_id = $this->payment_process_model->get('bank_branch_id');
        $account_number = $this->payment_process_model->get('account_number');
        $error['error_bank'] = (empty($bank_branch_id)) ? 1 : '';

        if (empty($account_number)) {
            $error['error_cheque'] = 1;
        } else if (!preg_match($this->regExp, $account_number)) {
            $error['error_cheque'] = 1;
        } else {
            $error['error_cheque'] = '';
        }
        // get payment information by payment information ID
        $total_paid_amount = $this->payment_model->set_payment_id($this->payment_id)
                        ->generate_paid_amount()->get_total_paid_amount();

        $paid_amount = $this->input->post('paid_amount', TRUE);
        $error['cash_amount'] = ($total_paid_amount < $paid_amount) ? 1 : '';
        return array_filter($error);
    }

    /*
     * ---------------------End refund invoice--------------------------------------
     */

    /**
     * @Description         : view all course invoice
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 08-01-2017 03:23 PM 
     * */
    function view_single_invoice($temp_invoice_id) {
        // set random ID and process for random information
        $random_info = $this->random_number_model->set_temp_random_id($temp_invoice_id)->process()->get_info();

        // if does not matched random ID into database
        if (empty($random_info)) {
            redirect('admin/larner-course');
        }

        // assign data for view Invoice
        $data = $this->get_data_for_single_invoice($temp_invoice_id);

        // check paid amount data for view invoice
        $payment_data = $this->check_paid_amount_data_for_single_invoice($data);

        // get currency type if paid any payment
        $data['currency_info'] = $this->invoice_payment_model->set_currency_info()->get_result();

        // mearge invoice information and payment data
        $invoice_data = array_merge($data, $payment_data);

        $invoice_data['bkash_payment'] = $this->load->view('admin/account/modal/bkash_payment', $invoice_data, TRUE);
        $invoice_data['cash_payment'] = $this->load->view('admin/account/modal/cash_payment', $invoice_data, TRUE);
        $invoice_data['cheque_payment'] = $this->load->view('admin/account/modal/cheque_payment', $invoice_data, TRUE);
        $invoice_data['main_content'] = $this->load->view('admin/account/payment/invoice', $invoice_data, TRUE);
        $this->load->view('admin/admin_master', $invoice_data);
    }

    /**
     * @Description         : get data for view invoice and check access validdation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-01-2017 05:24 PM   
     * */
    function get_data_for_single_invoice($temp_invoice_id) {
        $data = [];
        $data['active_menu'] = 'accounts';
        $data['active_sub_menu'] = 'course_learner';
        $data['invoice_id'] = $temp_invoice_id;
        $data['invoice_number'] = "tt-$temp_invoice_id";

        // get invoice information by invoice ID
        $data['invoice_info'] = $this->utility_model
                ->get_table_information('*', 'tbl_invoice', ['invoice_id' => $this->random_number_model->get_info()->random_type_id]);


        // get payment information by payment information ID
        $data['payment_info'] = $this->payment_model->set_payment_id($data['invoice_info']->payment_id)->set_info()->get_info();

        // get all bank information
        $data['all_bank'] = $this->admin_payment_model->get_all_bank();

        // get payment person information
        $data['person_info'] = $this->utility_model
                ->get_table_information('*', 'tbl_person', ['person_id' => $data['payment_info']->person_id]);

        // get payment invoice information
        $data['payment_invoice_info'] = $this->utility_model
                ->get_table_information('*', 'tbl_invoice_payment', ['invoice_id' => $data['invoice_info']->invoice_id]);

        // get refund payment data
        $data['refund_payment_info'] = $this->utility_model
                ->get_table_information('payment_refund_amount', 'tbl_payment_refund', ['payment_refund_id' => $data['invoice_info']->payment_id]);
        return $data;
    }

    /**
     * @Description         : check paid amount data for view invoice 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-01-2017 05:29 PM   
     * */
    function check_paid_amount_data_for_single_invoice($data) {
        // get paid amount using payment ID
        $paid_amount = $this->payment_model->generate_paid_amount()->get_total_paid_amount();
        // if paid amount not equal zer0
        if (!empty($paid_amount)) {
            // get payment currency type
            $data['currency_type'] = $this->invoice_payment_model->get_currency_type();
            // generate country code
            $country_code = ($data['currency_type'] == 1) ? 'BD' : 'BB';
            // generate all payment amount
            return $this->payment_model->set_country_code($country_code)->set_currency($data['currency_type'])
                            ->generate_invoice_payment_amount()->get_payment_amount();
        } else {
            // get currency
            $currency = ($data['person_info']->person_country == 'BD') ? 1 : 2;
            // generate all payment amount
            return $this->payment_model->set_country_code($data['person_info']->person_country)->set_currency($currency)
                            ->generate_invoice_payment_amount()->get_payment_amount();
        }
    }

    /**
     * @Description         : get payment information for invoice update
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-11-2016 02:03 PM   
     * */
    function get_payment_info() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $data = [];
        $temp_invoice_id = $this->input->post('invoice_id', TRUE);
        // set random ID and process for random information
        $random_info = $this->random_number_model->set_temp_random_id($temp_invoice_id)->process()->get_info();

        //get invoice information by invoice ID
        $invoice_info = $this->utility_model
                ->get_table_information('payment_id', 'tbl_invoice', ['invoice_id' => $random_info->random_type_id]);

        // get all recepit number
        $data['receipt_number'] = $this->payment_process_model->get_all_receipt_number();

        // get payment information by payment information ID
        $data['payment_info'] = $this->payment_model->set_payment_id($invoice_info->payment_id)->set_info()->get_info();

        // get payment person information
        $data['person_info'] = $this->utility_model
                ->get_table_information('person_country', 'tbl_person', ['person_id' => $data['payment_info']->person_id]);

        // generate paid amount using payment ID
        $this->payment_model->generate_paid_amount()->get_total_paid_amount();

//             if user are BDT and payment currency are BDT
        if ($data['person_info']->person_country == 'BD' && $data['payment_info']->payment_currency == 1) {
            $data['BTD'] = $this->payment_model->set_currency(1)->set_payment_amount_data([])->set_payment_amount()->get_payment_amount();
            $data['USD'] = $this->payment_model->set_currency(2)->set_payment_amount_data([])->convert_bdt_to_usd()->get_payment_amount();
        }

        // if user are BDT and payment currency are USD
        if ($data['person_info']->person_country == 'BD' && $data['payment_info']->payment_currency == 2) {
            $data['BTD'] = $this->payment_model->set_currency(1)->set_payment_amount_data([])->convert_usd_to_bdt()->get_payment_amount();
            $data['USD'] = $this->payment_model->set_currency(2)->set_payment_amount_data([])->set_payment_amount()->get_payment_amount();
        }

        if ($data['person_info']->person_country != 'BD' && $data['payment_info']->payment_currency == 1) {
            $data['USD'] = $this->payment_model->set_currency(2)->set_payment_amount_data([])->convert_bdt_to_usd()->get_payment_amount();
        }

        if ($data['person_info']->person_country != 'BD' && $data['payment_info']->payment_currency == 2) {
            $data['USD'] = $this->payment_model->set_currency(2)->set_payment_amount_data([])->set_payment_amount()->get_payment_amount();
        }
        echo json_encode($data);
    }

    /**
     * @Description         : pdate payment status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-01-2017 12:08 PM   
     * */
    function update_payment_status() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $data = [];
        $temp_invoice_id = $this->input->post('temp_invoice_id', TRUE);
        // set random ID and process for random information
        $random_info = $this->random_number_model->set_temp_random_id($temp_invoice_id)->process()->get_info();


        if ($random_info) {
            //get invoice information by invoice ID
            $invoice_info = $this->utility_model
                    ->get_table_information('payment_id', 'tbl_invoice', ['invoice_id' => $random_info->random_type_id]);

            // generate paid amount using payment ID
            $data['payment_status'] = $this->payment_model->set_payment_id($invoice_info->payment_id)->get_payment_amount_status();
            if ($data['payment_status'] == 1) {
                $this->payment_model->payment_status = 1;
            } else {
                $this->payment_model->payment_status = 2;
            }
            $this->payment_model->update();

            $payment_info = $this->payment_model->set_info()->get_info();
            $data['student_info'] = $this->utility_model
                    ->get_table_information('student_roll_number', 'tbl_student', ['student_type' => $payment_info->payment_type, 'student_type_id' => $payment_info->payment_type_id, 'person_id' => $payment_info->person_id]);
            echo json_encode($data);
        }
    }

    /*
      -----------@@@Start@ saved cheque payment----------------------------------
     */
    /*
      -----------@@@Start@ saved cash payment----------------------------------
     */

    /**
     * @Description         : save cash amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-11-2016 02:37 PM   
     * */
    function save_cash_amount() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $temp_invoice_id = $this->input->post('invoice_id', TRUE);
        // set random ID and process for random information
        $random_info = $this->random_number_model->set_temp_random_id($temp_invoice_id)->process()->get_info();

        if ($random_info) {
            // Saved cash amount
            $data = $this->saved_cash($random_info->random_type_id);
        } else {
            $data['error'] = 'invalid_invoice';
        }
        echo json_encode($data);
    }

    /**
     * @Description         : saved cash amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-11-2016 10:31 AM
     * @Parameter           : $invoice_ID[Primary Key], $temp_invoice_id[random invooice ID]   
     * */
    function saved_cash($invoice_id) {
        // Save Cheque payment Band ID and Account Number
        $this->payment_process_model->receipt_number = trim($this->input->post('receipt_number', TRUE));

        // check cash validation
        $error = $this->check_cash_amount_validation($invoice_id);

        if ($error) {
            return $this->redirect_error();
        } else {
            //save and get cash payment insert ID
            $payment_cash_id = $this->payment_process_model
                            ->set_table_name('tbl_payment_cash')
                            ->save()
                            ->set_insert_id()->get_id();
            // Save invoice payment, set_type=>1 [for Cash Payment]
            $this->invoice_payment_model
                    ->set_invoice_id($invoice_id)
                    ->set_type(1)
                    ->set_type_id($payment_cash_id)
                    ->set_currency_type($this->input->post('currency_type', TRUE))
                    ->set_paid_amount(trim($this->input->post('paid_amount', TRUE)))
                    ->datetime()
                    ->save();

            // Update invoice for new payment
            return $this->update_invoice_for_new_payment($invoice_id);
        }
    }

    /**
     * @Description         : check cash amount validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 11:23 AM
     * @Parameter           : $invoice_ID   
     * */
    function check_cash_amount_validation($invoice_id) {
        $receipt_number = $this->payment_process_model->get('receipt_number');
        $all_receipt_number = explode(',', $this->payment_process_model->get_all_receipt_number());

        $error = [];

        if (!preg_match($this->regExp, $receipt_number)) {
            $error['error_receipt'] = 1;
        } else if (in_array(strtolower($receipt_number), $all_receipt_number)) {
            $error['error_receipt'] = 1;
        } else {
            $error['error_receipt'] = '';
        }

        $paid_amount = $this->input->post('paid_amount', TRUE);
        $error['error_amount'] = $this->payment_process_model->check_payment_amount($invoice_id, $paid_amount);
        return array_filter($error);
    }

    /*
      -----------@@@End@ saved cash payment----------------------------------
     */

    /**
     * @Description         : save cheque payment amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 11:23 AM   
     * */
    function save_cheque_amount() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $temp_invoice_id = $this->input->post('invoice_id', TRUE);
        // set random ID and process for random information
        $random_info = $this->random_number_model->set_temp_random_id($temp_invoice_id)->process()->get_info();

        if ($random_info) {
            // saved cheque amount
            $data = $this->saved_cheque_amount($random_info->random_type_id);
        } else {
            $data['error'] = 'invalid_invoice';
        }
        echo json_encode($data);
    }

    /**
     * @Description         : save cheque payment amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-11-2016 02:50 PM   
     * */
    function saved_cheque_amount($invoice_id) {
        // Save Cheque payment Band ID and Account Number
        $this->payment_process_model->bank_branch_id = $this->input->post('bank_branch_id', TRUE);
        $this->payment_process_model->account_number = trim($this->input->post('account_number', TRUE));

        // Ckeck cheque Amount validation
        $error = $this->check_cheque_amount_validation($invoice_id);

        if ($error) {
            return $this->redirect_error();
        } else {
            // get cash payment insert ID
            $payment_cheque_id = $this->payment_process_model
                            ->set_table_name('tbl_payment_cheque')
                            ->save()
                            ->set_insert_id()->get_id();
            //  Save invoice payment, set_type => 2 [for cheque Payment]
            $this->invoice_payment_model
                    ->set_invoice_id($invoice_id)
                    ->set_type(2)
                    ->set_type_id($payment_cheque_id)
                    ->set_currency_type($this->input->post('currency_type', TRUE))
                    ->set_paid_amount($this->input->post('paid_amount', TRUE))
                    ->datetime()
                    ->save();
            //  Update invoice for new payment
            return $this->update_invoice_for_new_payment($invoice_id);
        }
    }

    /**
     * @Description         : save cheque payment amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-11-2016 02:53 PM   
     * */
    function check_cheque_amount_validation($invoice_id) {
        $bank_branch_id = $this->payment_process_model->get('bank_branch_id');
        $account_number = $this->payment_process_model->get('account_number');

        $error['error_bank'] = (empty($bank_branch_id)) ? 1 : '';

        if (empty($account_number)) {
            $error['error_cheque'] = 1;
        } else if (!preg_match($this->regExp, $account_number)) {
            $error['error_cheque'] = 1;
        } else {
            $error['error_cheque'] = '';
        }

        $paid_amount = $this->input->post('paid_amount', TRUE);
        $error['error_amount'] = $this->payment_process_model->check_payment_amount($invoice_id, $paid_amount);

        return array_filter($error);
    }

    /*
      -----------@@@End@ saved cheque payment----------------------------------
     */

    /*
      -----------@@@Start@ saved bKash payment----------------------------------
     */

    /**
     * @Description         : save bkash amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-11-2016 04:56 PM   
     * */
    function save_bkash_amount() {
        if (empty($this->input->is_ajax_request())) {
            redirect();
        }
        $temp_invoice_id = $this->input->post('invoice_id', TRUE);
        // set random ID and process for random information
        $random_info = $this->random_number_model->set_temp_random_id($temp_invoice_id)->process()->get_info();

        if ($random_info) {
            // saved cheque amount by invoice ID
            $data = $this->saved_bkash_amount($random_info->random_type_id);
        } else {
            $data['error'] = 'invalid_invoice';
        }
        echo json_encode($data);
    }

    /**
     * @Description         : save bkash amount and check validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-11-2016 04:57 PM   
     * */
    function saved_bkash_amount($invoice_id) {
        // Save Cheque payment Band ID and Account Number
        $this->payment_process_model->bkash_mobile_number = $this->input->post('mobile_number', TRUE);
        $this->payment_process_model->bkash_transaction_id = $this->input->post('transaction_id', TRUE);

        // Ckeck cheque Amount validation
        $error = $this->check_bkash_amount_validation($invoice_id);

        if ($error) {
            return $this->redirect_error();
        } else {
            // get bKash payment insert ID
            $payment_bkash_id = $this->payment_process_model
                    ->set_table_name('tbl_payment_bkash')
                    ->save()
                    ->set_insert_id()
                    ->get_id();
//            Save invoice payment, set_type => 3 [for bkash Payment]
            $this->invoice_payment_model
                    ->set_invoice_id($invoice_id)
                    ->set_type(3)
                    ->set_type_id($payment_bkash_id)
                    ->set_currency_type($this->input->post('currency_type', TRUE))
                    ->set_paid_amount($this->input->post('paid_amount', TRUE))
                    ->datetime()
                    ->save();

//            Update invoice for new payment
            return $this->update_invoice_for_new_payment($invoice_id);
        }
    }

    /**
     * @Description         : check bkash amount validation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-11-2016 05:01 PM   
     * */
    function check_bkash_amount_validation($invoice_id) {
        $mobile_number = $this->payment_process_model->get('bkash_mobile_number');
        $transaction_id = $this->payment_process_model->get('bkash_transaction_id');


        if (empty($mobile_number)) {
            $error['error_mobile_number'] = 1;
        } else if (!preg_match($this->numberRegExp, $mobile_number)) {
            $error['error_mobile_number'] = 1;
        } else {
            $error['error_mobile_number'] = '';
        }

        if (empty($transaction_id)) {
            $error['error_transaction_id'] = 1;
        } else if (!preg_match($this->numberRegExp, $transaction_id)) {
            $error['error_transaction_id'] = 1;
        } else {
            $error['error_transaction_id'] = '';
        }

        $paid_amount = $this->input->post('paid_amount', TRUE);
        $error['error_amount'] = $this->payment_process_model->check_payment_amount($invoice_id, $paid_amount);
        return array_filter($error);
    }

    /*
      -----------@@@End@ saved bKash payment----------------------------------
     */


    /*
      -----------@@@Start@ update invoice status----------------------------------
     */

    private $notification_type;
    private $invoice_info;
    private $person_info;
    private $course_info;
    private $invoice_id;

    /**
     * @Description         : update invoice for new payment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-01-2017 04:19 PM   
     * */
    function update_invoice_for_new_payment($invoice_id) {
        $data = $session_data = [];
        $this->invoice_id = $invoice_id;
        // get invoice information
        $this->invoice_info = $invoice_info = $this->utility_model->get_table_information('invoice_id,payment_id,invoice_description', 'tbl_invoice', ['invoice_id' => $invoice_id]);

        // get payment information
        $payment_info = $this->utility_model->get_table_information('person_id,payment_type,payment_type_id', 'tbl_payment', ['payment_id' => $invoice_info->payment_id]);

        // get student information
        $this->person_info = $this->utility_model->get_table_information('person_id,person_first_name,person_last_name,person_email', 'tbl_person', ['person_id' => $payment_info->person_id]);

        // get course information
        $this->course_info = $this->utility_model->get_table_information('course_name,person_id,resource_person_id,course_resource_person_view_invoice', 'tbl_course', ['course_id' => $payment_info->payment_type_id]);

        // set notification for full payment
        $this->set_notification_data_for_invoice_payment()->save_notification();
        // check payment status
        $paid_amount_status = $this->payment_model->get_payment_amount_status();

        // if paid full amount
        if ($paid_amount_status == 1) {
            //update payment Status
            $this->payment_model->set_payment_id($this->invoice_info->payment_id)->payment_status = 1;
            $this->payment_model->update();

            $data['redirect_url'] = base_url() . 'admin/view-invoice/' . $this->random_number_model->get_temp_random_id();
        } else {
            $this->create_new_invoice();
            $data['redirect_url'] = base_url() . 'admin/view-invoice/' . $this->random_number;
        }

        // Set payment success message in session
        $session_data['sess_message'] = '<span style="color: green">Your payment has been added successfully</span>';
        set_session($session_data);
        return $data;
    }

    private $random_number;

    /**
     * @Description         : create invoice for new payment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-01-2017 04:19 PM   
     * */
    function create_new_invoice() {
        //update payment Status
        $this->payment_model->set_payment_id($this->invoice_info->payment_id)->payment_status = 2;
        $this->payment_model->update();

        // Create new invoice
        $this->invoice_id = $this->invoice_model
                        ->set_payment_id($this->invoice_info->payment_id)
                        ->datetime()
                        ->set_description($this->invoice_info->invoice_description)
                        ->save()
                        ->get_insert_id()->get_id();

        // Save random information & Filter random number
        $this->tt_random_number->set_random_data(1, $this->invoice_id)->save_random_value();
        $this->random_number = $this->tt_random_number->filter_number('37')->get_filter_number();

        // save notification for create invoice
        $this->set_notification_data_for_create_invoice()->save_notification();
        // send email for create new invoice
        $this->set_mail_data_for_create_invoice()->send_mail();
        return $this;
    }

    private $notify_to;
    private $notify_by;
    private $notification_type_id;
    private $notification_description;

    /**
     * @Description         : set notificaion data for invoice payment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-01-2017 04:20 PM   
     * */
    function set_notification_data_for_invoice_payment() {
        $notification_description = [];
        $notification_description[1] = '<strong>Talha Training</strong> updated <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong> payment status for a course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong>';
        $notification_description[$this->person_info->person_id] = '<strong>Talha Training</strong> updated your payment status for a course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong>';

        if ($this->course_info->person_id != 1) {
            $notification_description[$this->person_info->person_id] = '<strong>Talha Training</strong> updated <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong> payment status for your course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong>';
        }

        if ($this->course_info->course_resource_person_view_invoice == 1) {
            $resource_person_info = $this->resource_person_model->set_resource_person_id($this->course_info->resource_person_id)
                            ->set_info_by_resource_person_id()->get_result();
            $notification_description[$resource_person_info->person_id] = '<strong>Talha Training</strong> updated <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong> payment status for your course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong>';
        }

        $this->notification_description = serialize($notification_description);
        $this->notify_by = $this->person_info->person_id;
        $this->notify_to = implode(',', array_keys($notification_description));
        $this->notification_type = 8;
        $this->notification_type_id = $this->invoice_id;
        return $this;
    }

    /**
     * @Description         : set notification data for create invoice
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-01-2016 03:52 PM   
     * */
    function set_notification_data_for_create_invoice() {
        $notification_description = [];
        $notification_description[1] = '<strong>Talha Training</strong> created a paid invoice for <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong>';
        $notification_description[$this->person_info->person_id] = '<strong>Talha Training</strong> created a paid invoice to a course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong> for <strong>you</strong>';
        if ($this->course_info->person_id != 1) {
            $notification_description[$this->course_info->person_id] = '<strong>Talha Training</strong> created a paid invoice to your course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong> for <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong>';
        }

        if ($this->course_info->course_resource_person_view_invoice == 1) {
            $resource_person_info = $this->resource_person_model
                            ->set_resource_person_id($this->course_info->resource_person_id)
                            ->set_info_by_resource_person_id()->get_result();
            $notification_description[$resource_person_info->person_id] = '<strong>Talha Training</strong> created a paid invoice to a course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong> for <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong>';
        }

        $this->notification_description = serialize($notification_description);
        $this->notify_by = $this->person_info->person_id;
        $this->notify_to = implode(',', array_keys($notification_description));
        $this->notification_type = 8;
        $this->notification_type_id = $this->invoice_id;
        return $this;
    }

    /**
     * @Description         : set notificaion data for refund invoice payment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-01-2017 05:28 PM   
     * */
    function invoice_set_notification_data_for_refund_payment() {
        $notification_description = [];
        $notification_description[1] = '<strong>Talha Training</strong> refunded <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong> payment for a course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong>';
        $notification_description[$this->person_info->person_id] = '<strong>Talha Training</strong> refunded your payment for a course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong>';

        if ($this->course_info->person_id != 1) {
            $notification_description[$this->person_info->person_id] = '<strong>Talha Training</strong> refunded <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong> payment for your course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong>';
        }

        if ($this->course_info->course_resource_person_view_invoice == 1) {
            $resource_person_info = $this->resource_person_model->set_resource_person_id($this->course_info->resource_person_id)
                            ->set_info_by_resource_person_id()->get_result();
            $notification_description[$resource_person_info->person_id] = '<strong>Talha Training</strong> refunded <strong>' . $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name . '</strong> payment for your course <strong>' . mb_substr($this->course_info->course_name, 0, 15) . '...' . '</strong>';
        }

        $this->notification_description = serialize($notification_description);
        $this->notify_by = 1;
        $this->notify_to = implode(',', array_keys($notification_description));
        $this->notification_type = 8;
        $this->notification_type_id = $this->invoice_id;
        return $this;
    }

    /**
     * @Description         : save notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-01-2017 06:40 PM   
     * */
    function save_notification() {
        // save notification information
        $this->notification_model
                ->set_notify_by($this->notify_by)
                ->set_notify_to($this->notify_to)
                ->set_notification_description($this->notification_description)
                ->set_notification_type($this->notification_type)
                ->save();

        // save notification type 
        $this->notification_model->set_insert_id()
                ->set_notification_type_info_id($this->notification_type_id)
                ->save_type_info();
        return $this;
    }

    /**
     * @Description         : set mail data for mail
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-01-2016 03:51 PM   
     * */
    private $mail_subject;
    private $mail_site_link;
    private $mail_to;
    private $mail_person_name;
    private $email_message;
    private $mail_view_page;

    function set_mail_data_for_invoice_payment() {
        $this->mail_subject = 'Updated Payment Satus';
        $this->mail_site_link = base_url() . 'user/view-invoice/' . $this->random_number_model->get_temp_random_id();
        $this->mail_to = $this->person_info->person_email;
        $this->mail_person_name = $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name;
        $this->email_message = get_message('updated_payment_invoice');
        $this->mail_view_page = 'invoice_created_view';
        return $this;
    }

    /**
     * @Description         : set mail data for create invoice
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-01-2016 03:51 PM   
     * */
    function set_mail_data_for_create_invoice() {
        $this->mail_subject = 'New Invoice';
        $this->mail_site_link = base_url() . 'user/view-invoice/' . $this->random_number;
        $this->mail_to = $this->person_info->person_email;
        $this->mail_person_name = $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name;
        $this->email_message = get_message('assign_course_invoice_message');
        $this->mail_view_page = 'invoice_created_view';
        return $this;
    }

    /**
     * @Description         : set mail data for create invoice
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-01-2017 03:51 PM   
     * */
    function invoice_set_mail_data_for_refund() {
        $this->mail_subject = 'Refund Paymenr';
        $this->mail_site_link = base_url() . 'user/view-invoice/' . $this->random_number;
        $this->mail_to = $this->person_info->person_email;
        $this->mail_person_name = $this->person_info->person_first_name . ' ' . $this->person_info->person_last_name;
        $this->email_message = get_message('refund_course_invoice_message');
        $this->mail_view_page = 'invoice_created_view';
        return $this;
    }

    /**
     * @Description         : send mail to payment person
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-01-2017 03:51 PM   
     * */
    function send_mail() {
        $mail_data = [];
        $mail_data['name'] = 'TalhaTraining Contact';
        $mail_data['from'] = 'no-reply@talhatraining.com';
        $mail_data['subject'] = $this->mail_subject;
        $mail_data['title_message'] = 'Talha Training';
        $mail_data['site_link'] = $this->mail_site_link;
        $mail_data['to'] = $this->mail_to;
        $mail_data['person_name'] = $this->mail_person_name;
        $mail_data['message'] = $this->email_message;

        $this->mailer_model->set_mail_data($mail_data)
                ->set_mail_view_page($this->mail_view_page)
                ->send_mail();
        return $this;
    }

    /**
     * @Description         : redirect error page
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-01-2017 11:24 AM   
     * */
    function redirect_error() {
        $data = [];
        $data['redirect_url'] = base_url() . 'admin/view-invoice/' . $this->random_number_model->get_temp_random_id();
        $session_data['sess_message'] = '<span style="color: red">There is some problem to update your payment!</span>';
        set_session($session_data);
        return $data;
    }

    /**
     * @Description         : redirect error page
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-01-2017 11:24 AM   
     * */
    function redirect_refund_invoice_error() {
        $this->refund_data['redirect_url'] = base_url() . 'admin/refund-invoice/' . $this->temp_invoice_id;
        $session_data['sess_message'] = '<span style="color: red">There is some problem to update your payment!</span>';
        set_session($session_data);
        return $this;
    }

    /*
      -----------@@@End@ update invoice status----------------------------------
     */
}
