<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin_forbidden extends TT_admin_login {

    function __construct() {
        parent::__construct();
        $this->load->model('admin_forbidden_model');    //here, admin_forbidden_model is loaded
    }

    /**
     * @Function            : forbidden
     * @Used IN             : @admin/admin_master.php – line 1516
     * @Description         : This function is used to load admin_forbidden_view.php in Admin/admin_master.php 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 19/04/2016  
     * @Status              : available      
     * */
    function forbidden($arg = NULL) {
        //Here, "$arg = NULL" NULL just means that in case $arg is not passed we will set it to NULL. It's just a way to make $arg optional
        $data = array(); //Here, $data=array is a data storage method , by this method i have stored some items like $data['arg']
        $data['arg'] = $arg;
        $data['active_menu'] = 'forbidden';
        $data['active_sub_menu'] = 'view_forbidden';
        $data1 = $this->forbidden_value($data);
        $person_id = $this->session->userdata('person_id');
        $data1['total_forbidden'] = $this->admin_forbidden_model->get_total_forbidden($data1['type'], $data1['search_value']);
        $data1['all_forbidden'] = $this->admin_forbidden_model->select_all_forbidden_for_manage_forbidden($data1['type'], $data1['search_value'], $data1['sort'], $data1['number']);
        $data1['manamge_forbidden_person_role'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $data1['active'] = 'forbidden';
        $data1['main_content'] = $this->load->view('admin/forbidden/admin_forbidden_view', $data1, true);
        $this->load->view('admin/admin_master', $data1);
    }

    /**
     * @Function            : forbidden_value
     * @Used IN             : @admin_forbidden.php – line 28
     * @Description         : This function is used to receive argument value and other required information
     * @Developed By        : Tania Akter
     * @Start DateTime      : 19/04/2016  
     * @Status              : available      
     * */
    function forbidden_value($data) {
        $data['page'] = 0;  //page data index varaible in here i have initialize it 0 
        $data['number'] = 0;           //number is variable . 
        $data['search_value'] = '';     //   search_value is varaiable in here have initialize to empty
        if ($data['arg'] == NULL) {
            $data['sort_by'] = '';  //sort_by data index varaible in here have initialize it to empty 
            $this->session->unset_userdata('sort_forbidden_session');   //it is in initial stage , argument not passed even, we will unset session
            $this->session->unset_userdata('type_forbidden_session');
        } elseif ($data['arg'] == 'asc' || $data['arg'] == 'desc') {                  // if clicked for ascending or decending argument is passed as a 'asc' or 'desc'.
            $data['sort_by'] = $data['arg'];                                // $data['sort_by'] varaible store $arg that was passed like 'asc' or 'desc'.
            $sData['sort_forbidden_session'] = $data['arg'];
            $this->session->set_userdata($sData);                   // set session
        } else {
            $data['sort_by'] = $this->session->userdata('sort_forbidden_session');
            $data['page'] = $data['arg'];                               //if clicked on page number(like 1, 2, 3)for pagination $arg will be clicked page number and $arg stored on $data['sort_by'] array varaible.
            $data['number'] = $data['arg'] * 10 - 10;                           //$number is variable calculated depend on $arg
        }
        $data['sort'] = $this->session->userdata('sort_forbidden_session');   //set session
        $data['type'] = $this->session->userdata('type_forbidden_session');   // set session 
        return $data;
    }

    /**
     * @Function            : add_forbidden
     * @Used IN             : @admin/forbidden/add_forbidden_view.php
     * @Description         : To add forbidden URL, Name, Organization
     * @Developed By        : Tania Akter
     * @Start DateTime      : 19/04/2016  
     * @Status              : available      
     * */
    function add_forbidden() {
        $this->admin_forbidden_model->save_add_forbidden_info();
        redirect('forbidden'); //after save forbidden info it back to admin_forbidden/forbidden page
    }

    /**
     * @Function            : check_forbidden
     * @Used IN             : @admin/forbidden/add_forbidden_view.php
     * @Description         : To check forbidden URL, Name, Organization exist in database
     * @Developed By        : Tania Akter
     * @Start DateTime      : 19/04/2016  
     * @Status              : available      
     * */
    function check_forbidden() {
        $result = $this->admin_forbidden_model->check_forbidden_exist();
        if ($result) {
            echo '1'; //super admin/admin typed in input field to add url/name/organization if that are already exists in database then it echo 1;
        } else {
            echo '2'; //super admin/admin typed in input field to add url/name/organization if that are not  exists in database then it echo 2;
        }
    }

    /**
     * @Function            : forbidden_info_by_id
     * @Used IN             : @admin/forbidden/admin_forbidden_view.php
     * @Description         : To retrieve forbidden information by forbidden id
     * @Developed By        : Tania Akter
     * @Start DateTime      : 19/04/2016  
     * @Status              : available      
     * */
    function forbidden_info_by_id() {
        $data['forbidden_info_by_id'] = $this->admin_forbidden_model->select_forbidden_info_by_id();
        echo $this->load->view('admin/forbidden/admin_forbidden_update_view', $data, true);
    }

    /**
     * @Function            : get_forbidden_edit_manage
     * @Used IN             : forbidden.js     line---129
     * @Description         : It is used to manage edit information
     * @Developed By        : Tania Akter
     * @Start DateTime      : 19/04/2016  
     * @Status              : available      
     * */
    function get_forbidden_edit_manage() {
        $data = array();
        $data['page'] = 0;
        $person_id = $this->session->userdata('person_id');
        $data['manamge_forbidden_person_role'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $data['forbidden_edit_manage'] = $this->admin_forbidden_model->get_forbidden_manage_info();
        $data['total_forbidden'] = $this->admin_forbidden_model->get_total_forbidden_manage_info();
        echo $this->load->view('admin/forbidden/admin_forbidden_manage_edit_view', $data, true);
    }

    /**
     * @Function            : update_forbidden
     * @Used IN             : @admin/forbidden/admin_forbidden_update_view.php
     * @Description         : To update forbidden information by forbidden id
     * @Developed By        : Tania Akter
     * @Start DateTime      : 19/04/2016  
     * @Status              : available      
     * */
    function update_forbidden() {
        $this->admin_forbidden_model->update_forbidden_info();
        redirect('forbidden'); ////after update forbidden info it back to admin_forbidden/forbidden page
    }

    /**
     * @Function            : update_forbidden_exist
     * @Used IN             : @admin/forbidden/admin_forbidden_update_view.php
     * @Description         : To check forbidden URL/Name/Organization exists in database before updating these to a database.
     * @Developed By        : Tania Akter
     * @Start DateTime      : 19/04/2016 
     * @Status              : available      
     * */
    function update_forbidden_exist() {
        $result = $this->admin_forbidden_model->update_forbidden_exist_info();
        if ($result) {
            echo '1'; //super admin typed in input field to update url/name/organization if that are already exists in database then it echo 1;
        } else {
            echo '2'; //super admin typed in input field to update url/name/organization if that are not exist in database then it echo 2;
        }
    }

    /**
     * @Function            : delete_forbidden_by_id
     * @Used IN             : @admin/forbidden/add_forbidden_view.php   line number --169
     * @Description         : To delete forbidden URL, Name, Organization
     * @Developed By        : Tania Akter
     * @Start DateTime      : 19/04/2016  
     * @Status              : available      
     * */
    function delete_forbidden_by_id() {
        $this->admin_forbidden_model->delete_forbidden_info_by_id();
    }

    /**
     * @Function            : search_forbidden
     * @Used IN             : @admin/forbidden/add_forbidden_view.php   line number --
     * @Description         : This function is used to find  search forbidden value
     * @Developed By        : Tania Akter
     * @Start DateTime      : 20/04/2016  
     * @Status              : available      
     * */
    function search_forbidden() {
        $data = array();
        $data['page'] = 0;
        $data1 = $this->search_forbidden_value($data);
        $person_id = $this->session->userdata('person_id');
        $data['total_forbidden'] = $this->admin_forbidden_model->get_total_forbidden($data1['type'], $data1['search_forbidden']);
        $data['all_forbidden'] = $this->admin_forbidden_model->select_all_forbidden_for_manage_forbidden($data1['type'], $data1['search_forbidden'], $data1['sort'], $data1['page']);
        $data['manamge_forbidden_person_role'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        echo $this->load->view('admin/forbidden/admin_forbidden_manage_search_view', $data, true);
    }

    /**
     * @Function            : search_forbidden_value
     * @Used IN             : @function'search_forbidden' @controller'admin_forbidden'   line number --
     * @Description         : this function is used to receive search forbidden value and set required values.
     * @Developed By        : Tania Akter
     * @Start DateTime      : 20/04/2016  
     * @Status              : available      
     * */
    function search_forbidden_value($data) {
        $data['search_forbidden'] = $this->input->post('searchForbidden', true);
        if ($data['search_forbidden'] != 'null') { //if we have search value the condition will be true and  block statement executed
            $data['type'] = $this->session->userdata('type_forbidden_session');
            $data['sort'] = $this->session->userdata('sort_forbidden_session');
            $data['page'] = 0;
        } else {
            $data['type'] = $this->session->userdata('type_forbidden_session');
            $data['sort'] = $this->session->userdata('sort_forbidden_session');
            $data['page'] = 0;
            $data['search_forbidden'] = '';
        }
        return $data;
    }

    /**
     * @Function            : get_forbidden_value_by_type
     * @Used IN             : @  line number -- admin_forbidden_view  -----line43
     * @Description         : This function is used to find forbidden according to forbidden type
     * @Developed By        : Tania Akter
     * @Start DateTime      : 20/04/2016  
     * @Status              : available      
     * */
    function get_forbidden_value_by_type() {
        $data = array();
        $data1 = $this->search_forbidden_value_type($data);
        $person_id = $this->session->userdata('person_id');
        $data['total_forbidden'] = $this->admin_forbidden_model->get_total_forbidden($data1['type'], $data1['search_forbidden']);
        $data['all_forbidden'] = $this->admin_forbidden_model->select_all_forbidden_for_manage_forbidden($data1['type'], $data1['search_forbidden'], $data1['sort'], $data1['page']);
        $data['manamge_forbidden_person_role'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        echo $this->load->view('admin/forbidden/admin_forbidden_manage_search_view', $data, true);
    }

    /**
     * @Function            : search_forbidden_value_type
     * @Used IN             : @  line number -- admin_forbidden_view  -----line43
     * @Description         : This function is used to receive search forbidden type and set others required values
     * @Developed By        : Tania Akter
     * @Start DateTime      : 20/04/2016  
     * @Status              : available      
     * */
    function search_forbidden_value_type($data) {
        $data['type'] = $this->input->post('searchForbiddenType', true);
        if ($data['type'] != 'null') {        //if selected search type, then $type != 'null' condition will be true
            $data['sort'] = $this->session->userdata('sort_forbidden_session');
            $sData['type_forbidden_session'] = $data['type'];
            $this->session->set_userdata($sData);
            $data['search_forbidden'] = '';
            $data['page'] = 0;          //page data index varaible in here i have initialize it to 0
        } else {
            $data['type'] = '';         //initialize to empty means not selected forbidden type
            $data['sort'] = $this->session->userdata('sort_forbidden_session');
            $sData['type_forbidden_session'] = $data['type'];
            $this->session->set_userdata($sData);
            $data['page'] = 0;                  //page data index varaible in here have initialize it  0
            $data['search_forbidden'] = '';             //initialize to empty
        }
        return $data;
    }

}
