<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Add_Teacher_Organization extends TT_user_login {

    public function __construct() {
        parent::__construct();
        $this->load->model('add_teacher_organization_model');
    }

    /**
     * @Function            : add_teacher_by_organization 
     * @Used IN             : user/teacher/manage_teacher       
     * @Description         : used to add teacher by organization
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Update By           : Tania Akter
     * @Update Date         : 07-06-2016
     * @Parameter           : none
     * @Return              : none
     * @Status              : Available        
     * */
    function add_teacher_by_organization() {
        $person_id = $this->session->userdata('user_id');
        $data['active_menu'] = $this->session->userdata('active_menu');
        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        $person_info = $this->profile_model->get_single_person_information_by_person_id($person_id);
        if ($person_info->person_role != 4) {
            redirect();
        }
        $this->add_teacher_by_organization_form_validation();
        if ($this->form_validation->run() == FALSE) {
            $data['main_content'] = $this->load->view('user/teacher/add_teacher_organization_view', $data, TRUE);
            $this->load->view('user/master', $data);
        } else {
            $person_id = $this->add_teacher_organization_model->save_teacher_information_by_organization($person_info);
            $this->mailer_model->send_mail_to_org_teacher('email_to_org_teacher');
            redirect('manage-teacher');
        }
    }

    /**
     * @Function            : add_teacher_by_organization_form_validation 
     * @Used IN             : function[add_teacher_by_organization] controller[add_teacher_organization]       
     * @Description         : used to validate add teacher organization form
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Update By           : Tania Akter
     * @Update Date         : 07-06-2016
     * @Parameter           : none
     * @Return              : none
     * @Status              : Available        
     * */
    function add_teacher_by_organization_form_validation() {
        $this->form_validation->set_rules('person_email', 'email', 'required|trim|max_length[256]|callback_email_check|callback_check_email_forbidden_exist');
        $this->form_validation->set_rules('person_password', 'password', 'required|min_length[6]|callback_password_check');
        $this->form_validation->set_rules('confirm_password', 'confirm Password', 'required|min_length[6]|callback_password_check');
        $this->form_validation->set_rules('person_first_name', 'first Name', 'required|trim|max_length[100]|callback_check_name|callback_check_name_forbidden_exist');
        $this->form_validation->set_rules('person_last_name', 'last Name', 'required|trim|max_length[100]|callback_check_name');
        $this->form_validation->set_rules('profile_url', 'profile URL', 'required|trim|callback_profile_url_check');
        $this->form_validation->set_rules('person_gender', 'gender', 'required');
        $this->form_validation->set_rules('country_code', 'country code ', 'trim');
        $this->form_validation->set_rules('hidden_country_code', 'country code', 'required|trim');
        $this->form_validation->set_rules('person_contact_number', 'person contact number', 'required|numeric|max_length[16]|trim');
        $this->form_validation->set_rules('person_country', 'country', 'required');
        $this->form_validation->set_rules('person_city', 'city', 'required');
        $this->form_validation->set_rules('person_address', 'address');
        $this->form_validation->set_rules('person_zip', 'zip', 'required');
        $this->form_validation->set_rules('person_image', 'image', 'callback_image_validation');
        $this->form_validation->set_rules('person_status', 'status', 'required');
        $this->form_validation->set_rules('image_path', 'path');
    }

    /**
     * @Function            : email_check 
     * @Used IN             : function[add_teacher_by_organization_form_validation] controller[add_teacher_organization]   
     * @Description         : used to check for email validation
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Parameter           : none
     * @Return              : true, false
     * @Status              : Available        
     * */
    function email_check() {
        $person_email = $this->input->post('person_email', TRUE);
        $sp = '/^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/';
        if (preg_match($sp, $person_email)) {
            $email_result = $this->sign_up_model->check_user_email_info($person_email);
            if ($email_result) {
                $this->form_validation->set_message('email_check', get_message("email_exist"));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $this->form_validation->set_message('email_check', get_message("email_invalid"));
            return FALSE;
        }
    }

    /**
     * @Function            : check_email_forbidden_exist 
     * @Used IN             : function[add_teacher_by_organization_form_validation] controller[add_teacher_organization]         
     * @Description         : used to check email exist in forbidden table
     * @Developed By        : Tania Akter
     * @Start DateTime      : 08-06-2016
     * @Parameter           : $person_email
     * @Return              : true, false
     * @Status              : Available        
     * */
    function check_email_forbidden_exist($person_email) {
        $person_email_exist = $this->sign_up_model->check_exist_sign_up_forbidden($person_email, 4);
        if ($person_email_exist) {
                   $this->form_validation->set_message('check_email_forbidden_exist', get_message("forbidden_email"));
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            : password_check 
     * @Used IN             : function[add_teacher_by_organization_form_validation] controller[add_teacher_organization]      
     * @Description         : used to check password for validation
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Parameter           : none
     * @Return              : none
     * @Status              : Available        
     * */
    function password_check($str) {
        $person_password = $this->input->post('person_password', TRUE);
        $confirm_password = $this->input->post('confirm_password', TRUE);
        $sp = '/[~`!@#$%^&*()-_+=,<.>\/?;:\'"-]|/';
        if (preg_match('#[0-9]#', $str) && preg_match('#[a-z]#', $str) && preg_match('#[A-Z]#', $str) && preg_match($sp, $str)) {
            if ($person_password == $confirm_password) {
                return TRUE;
            } else {
             $this->form_validation->set_message('password_check', get_message("password_match"));
                return FALSE;
            }
        } else {
            $this->form_validation->set_message('password_check', get_message("password_character"));
            return FALSE;
        }
    }

    /**
     * @Function            : check_name 
     * @Used IN             : function[add_teacher_by_organization_form_validation] controller[add_teacher_organization]     
     * @Description         : used for name validation
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Parameter           : $str (person name)
     * @Return              : true, false
     * @Status              : Available        
     * */
    function check_name($str) {
      $sp = '/[^A-Za-z0-9 \- \.]/';
      if (!preg_match($sp, $str)) {
         return TRUE;
      } else {
        $this->form_validation->set_message('check_name', get_message("name_character"));
        return FALSE;
        }
    }

    /**
     * @Function            : check_name_forbidden_exist 
     * @Used IN             : function[add_teacher_by_organization_form_validation] controller[add_teacher_organization]      
     * @Description         : used to check name exist in forbidden table
     * @Developed By        : Tania Akter
     * @Start DateTime      : 08-06-2016
     * @Parameter           : $str (person name)
     * @Return              : true, false
     * @Status              : Available        
     * */
    function check_name_forbidden_exist($str) {
        $org_teacher_name = $this->create_org_teacher_name($str);
        $check_org_teacher_name = $this->sign_up_model->check_exist_sign_up_forbidden($org_teacher_name, 2);
        if ($check_org_teacher_name) {
                    $this->form_validation->set_message('check_name_forbidden_exist', get_message("forbidden_name"));
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /**
     * @Function            : create_org_teacher_name 
     * @Used IN             : function[check_name_forbidden_exist] controller[add_teacher_organization]      
     * @Description         : crea full name using first name and last name
     * @Developed By        : Tania Akter
     * @Start DateTime      : 08-06-2016
     * @Parameter           : $str(person name)
     * @Return              : teacher full name
     * @Status              : Available        
     * */
    function create_org_teacher_name($str) {
        $org_teacher_first_name = str_replace(' ', '', $str);
        $org_teacher_name = preg_replace('/[^A-Za-z0-9 -]/', '', $org_teacher_first_name);
        $org_teacher_last_name = preg_replace('/[^A-Za-z0-9 -]/', '', $this->input->post('person_last_name', TRUE));
        if ($org_teacher_last_name) {
            $org_teacher_name = $org_teacher_first_name . ' ' . $org_teacher_last_name;
        }
        return $org_teacher_name;
    }

    /**
     * @Function            : profile_url_check
     * @Used In             : function[add_teacher_by_organization_form_validation] controller[add_teacher_organization]
     * @Developed By        : Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> | 
     * @DevelopeDateTime    : 02-05-2015 05:00 PM   | 
     * @Updated Date Time   : 05-06-2015 03:00 PM   | dd-mm-yyyy hh:mm AM   |
     * @Updated By          : Mahabub-A-Mawla       | Name                  |
     * @parameter           : string $url
     * @return              : true/false
     * @redirect            : no
     * */
    function profile_url_check($url) {
        $result = $this->add_teacher_organization_model->check_url($url);
        if ($result) {
                $this->form_validation->set_message('profile_url_check', get_message("url_exist"));
            return false;
        } else {
            $sp = '/[^A-Za-z0-9 -]/';
            if (preg_match($sp, $url)) {
                $this->form_validation->set_message('profile_url_check', get_message("url_character"));                                   
                return FALSE;
            } else if (strstr($url, ' ')) {
                $this->form_validation->set_message('profile_url_check', get_message("url_character_hypen"));                
                return FALSE;
            } else {
                $this->form_validation->set_message('profile_url_check', get_message("ok"));
                return TRUE;
            }
        }
    }

    /**
     * @Function            : image_validation 
     * @Used IN             : function[add_teacher_by_organization_form_validation] controller[add_teacher_organization]      
     * @Description         : used for image validation
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Update By           : Tania Akter
     * @Update Date         : 07-06-2016
     * @Parameter           : none
     * @Return              : true, false
     * @Status              : Available        
     * */
    function image_validation() {
        $allowed_type = array('jpeg', 'gif', 'png', 'bmp', 'JPEG', 'GIF', 'PNG', 'BMP');
        $selected_file_type = explode('/', $_FILES['person_image']['type']);
        if ($_FILES['person_image']['name']) {
            if (!in_array($selected_file_type[1], $allowed_type)) {
                $this->form_validation->set_message('image_validation', get_message("image_formate"));
                return FALSE;
            } else if ($_FILES['person_image']['size'] >= 2097152) {
                $this->form_validation->set_message('image_validation', get_message("image_size"));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $this->form_validation->set_message('image_validation', get_message("required_image"));
            return FALSE;
        }
    }

    /**
     * @Function            : check_user_email 
     * @Used IN             : function[email_check] controller[add_teacher_organization]     
     * @Description         : used to check user email address already exist
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Update By           : Tania Akter
     * @Update Date         : 09-06-2016
     * @Parameter           : none
     * @Return              : true, false
     * @Status              : Available        
     * */
    function check_user_email() {
        $user_email_address = $this->input->post('useremail', TRUE);
        $result = $this->add_teacher_organization_model->check_user_email_info($user_email_address);
        $person_email_exist = $this->sign_up_model->check_exist_sign_up_forbidden($user_email_address, 4);
        if ($result) {
            echo '1';
        } else {
            if ($person_email_exist) {
                echo '1';
            } else {
                echo '2';
            }
        }
    }
    /**
     * @Function            : make_org_teacher_url_existance 
     * @Used IN             : user/teacher/add_teacher_organization_view        
     * @Description         : used to check url exists in forbidden and url table if exist it return url with concate number
     * @Developed By        : Tania Akter
     * @Developed Date      : 11-06-2016
     * @Parameter           : none
     * @Return              : none
     * @Status              : Available        
     * */

//tania 06-08-2016
    function make_org_teacher_url_existance() {
        $profile_id = $this->input->post('profileID', TRUE);        
        $forbidden_url = $this->url_model->check_forbidden_exists($profile_id);
        if ($forbidden_url) {
            echo $url = $this->url_model->check_url_exists($forbidden_url);
        } else {
            echo $forbidden_url;
        }
    }
   /**
     * @Function            : check_org_teacher_url_existance 
     * @Used IN             : user/teacher/add_teacher_organization_view      
     * @Description         : used to check url exists in forbidden and url table
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Update By           : Tania Akter
     * @Update Date         : 11-06-2016
     * @Parameter           : none
     * @Return              : none
     * @Status              : Available        
     * */
    function check_org_teacher_url_existance() {
        $url = $this->input->post('profileID', TRUE);
        $result = $this->add_teacher_organization_model->check_url($url);
        $person_forbidden_exist = $this->sign_up_model->check_exist_sign_up_forbidden($url, 1);
        if ($result) {
            echo '1';
        } else {
            if ($person_forbidden_exist) {
                echo '1';
            } else {
                echo '2';
            }
        }
    }
   /**
     * @Function            : check_add_teacher_forbidden_exist 
     * @Used IN             :      
     * @Description         : 
     * @developed By        : Tania Akter
     * @Update Date         : 
     * @Parameter           : none
     * @Return              : none
     * @Status              : Available        
     * */    
    
    function check_add_teacher_forbidden_exist(){
        $first_name = preg_replace('/[^A-Za-z0-9 -]/', '', $this->input->post('first_name', TRUE));
        $last_name = preg_replace('/[^A-Za-z0-9 -]/', '', $this->input->post('last_name', TRUE));
        $create_name = $this->create_teacher_name($first_name, $last_name);
        $check_name = $this->sign_up_model->check_exist_sign_up_forbidden($create_name, 2);
        $check_first_name = $this->sign_up_model->check_exist_sign_up_forbidden($first_name, 2);
        $check_last_name = $this->sign_up_model->check_exist_sign_up_forbidden($last_name, 2);
        if ($check_name) {
            echo "1"; // if person name exist in forbidden table
        } 
        else if($check_first_name){
           echo "1"; // if person name exist in forbidden table 
        }
        else if ($check_last_name) {
            echo "1"; // if person name exist in forbidden table  
        } else {
            echo "2"; // if person name not exist in forbidden
        }        
    }
  /**
     * @Function            : create_sign_up_name 
     * @Used IN             :      
     * @Description         : 
     * @developed By        : Tania Akter
     * @Update Date         : 
     * @Parameter           : none
     * @Return              : none
     * @Status              : Available        
     * */    
    
    function create_teacher_name($person_first_name, $person_last_name) {
        $first_name = str_replace(' ', '', $person_first_name);
        $create_name = preg_replace('/[^A-Za-z0-9 -]/', '', $person_first_name);
        $last_name = preg_replace('/[^A-Za-z0-9 -]/', '', $person_last_name);
        if ($last_name) {
            $create_name = $first_name . ' ' . $last_name;
        }
        return $create_name;        //person name
    }

}
