<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/*
  | -------------------------------------------------------------------
  | AUTO-LOADER
  | -------------------------------------------------------------------
  | This file specifies which systems should be loaded by default.
  |
  | In order to keep the framework as light-weight as possible only the
  | absolute minimal resources are loaded by default. For example,
  | the database is not connected to automatically since no assumption
  | is made regarding whether you intend to use it.  This file lets
  | you globally define which systems you would like loaded with every
  | request.
  |
  | -------------------------------------------------------------------
  | Instructions
  | -------------------------------------------------------------------
  |
  | These are the things you can load automatically:
  |
  | 1. Packages
  | 2. Libraries
  | 3. Drivers
  | 4. Helper files
  | 5. Custom config files
  | 6. Language files
  | 7. Models
  |
 */

/*
  | -------------------------------------------------------------------
  |  Auto-load Packages
  | -------------------------------------------------------------------
  | Prototype:
  |
  |  $autoload['packages'] = array(APPPATH.'third_party', '/usr/local/shared');
  |
 */
$autoload['packages'] = array();

/*
  | -------------------------------------------------------------------
  |  Auto-load Libraries
  | -------------------------------------------------------------------
  | These are the classes located in system/libraries/ or your
  | application/libraries/ directory, with the addition of the
  | 'database' library, which is somewhat of a special case.
  |
  | Prototype:
  |
  |	$autoload['libraries'] = array('database', 'email', 'session');
  |
  | You can also supply an alternative library name to be assigned
  | in the controller:
  |
  |	$autoload['libraries'] = array('user_agent' => 'ua');
 */
$autoload['libraries'] = array(
    'database', 'session', 'xmlrpc', 'email', 'encrypt','encryption',
    'cf','general_library', 'form_validation', 'cart', 'pagination', 'image_lib',
    'tt_pagination', 'tt_message', 'tt_notification', 'tt_post',
    'tt_redirect', 'tt_files', 'tt_storage','tt_random_number','tt_currency');

/*
  | -------------------------------------------------------------------
  |  Auto-load Drivers
  | -------------------------------------------------------------------
  | These classes are located in system/libraries/ or in your
  | application/libraries/ directory, but are also placed inside their
  | own subdirectory and they extend the CI_Driver_Library class. They
  | offer multiple interchangeable driver options.
  |
  | Prototype:
  |
  |	$autoload['drivers'] = array('cache');
  |
  | You can also supply an alternative property name to be assigned in
  | the controller:
  |
  |	$autoload['drivers'] = array('cache' => 'cch');
  |
 */
$autoload['drivers'] = array();

/*
  | -------------------------------------------------------------------
  |  Auto-load Helper Files
  | -------------------------------------------------------------------
  | Prototype:
  |
  |	$autoload['helper'] = array('url', 'file');
 */
$autoload['helper'] = array('form', 'url', 'file', 'message', 'text', 'alert', 'ttsession');
date_default_timezone_set('UTC');

/*
  | -------------------------------------------------------------------
  |  Auto-load Config files
  | -------------------------------------------------------------------
  | Prototype:
  |
  |	$autoload['config'] = array('config1', 'config2');
  |
  | NOTE: This item is intended for use ONLY if you have created custom
  | config files.  Otherwise, leave it blank.
  |
 */
$autoload['config'] = array('config');

/*
  | -------------------------------------------------------------------
  |  Auto-load Language files
  | -------------------------------------------------------------------
  | Prototype:
  |
  |	$autoload['language'] = array('lang1', 'lang2');
  |
  | NOTE: Do not include the "_lang" part of your file.  For example
  | "codeigniter_lang.php" would be referenced as array('codeigniter');
  |
 */
$autoload['language'] = array();

/*
  | -------------------------------------------------------------------
  |  Auto-load Models
  | -------------------------------------------------------------------
  | Prototype:
  |
  |	$autoload['model'] = array('first_model', 'second_model');
  |
  | You can also supply an alternative model name to be assigned
  | in the controller:
  |
  |	$autoload['model'] = array('first_model' => 'first');
 */
$autoload['model'] = array('welcome_model',
    'quiz_model',
    'group_model',
    'super_admin_model',
    'user_video_model',
    'super_admin_student_model',
    'super_admin_course_model',
    'mailer_model',
    'super_admin_group_model',
    'super_admin_quiz_model',
    'super_admin_video_model',
    'classroom_model',
    'registration_model',
    'F_end_model',
    'course_model',    
    'video_model',
    'profile_model',
    'super_admin_feature_model',
    'user_course_model',
    'map_model',
    'payment_model',
    'message_model',
    'super_admin_message_model',
    'super_admin_support_model',
    'person_model',
    'utility_model',
    'super_admin_support_model',
    'notification_model',
    'application_model',
    'category_model',
    'url_model',
    'post_model',
    'super_admin_profile_model',
    'notification_dashboard_model',
    'group_notification_model',
    'notification_course_model',
    'sign_up_model',
    'topic_model',
    'price_model',
    'content_library_model',
    'tinymce_model',
    'batch_model',
    'resource_person_model',
    'organization_model',
    'image_model',
    'person_link_model',
    'rating_model',
    'super_admin_batch_model',
    'student_model',
    'work_file_model',
    'random_number_model',
    'coupon_model',
    'Manage_admin_video_course_model'
);
